/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundCustomSoundPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.phys.Vec3;

public class PlaySoundCommand {
    private static final SimpleCommandExceptionType f_138149_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.playsound.failed"));

    public static void m_138156_(CommandDispatcher<CommandSourceStack> p_138157_) {
        RequiredArgumentBuilder requiredArgumentBuilder = Commands.m_82129_("sound", ResourceLocationArgument.m_106984_()).suggests(SuggestionProviders.f_121643_);
        for (SoundSource soundSource : SoundSource.values()) {
            requiredArgumentBuilder.then(PlaySoundCommand.m_138151_(soundSource));
        }
        p_138157_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("playsound").requires(p_138159_ -> p_138159_.m_6761_(2))).then((ArgumentBuilder)requiredArgumentBuilder));
    }

    private static LiteralArgumentBuilder<CommandSourceStack> m_138151_(SoundSource p_138152_) {
        return (LiteralArgumentBuilder)Commands.m_82127_(p_138152_.m_12676_()).then(((RequiredArgumentBuilder)Commands.m_82129_("targets", EntityArgument.m_91470_()).executes(p_138180_ -> PlaySoundCommand.m_138160_((CommandSourceStack)p_138180_.getSource(), EntityArgument.m_91477_((CommandContext<CommandSourceStack>)p_138180_, "targets"), ResourceLocationArgument.m_107011_((CommandContext<CommandSourceStack>)p_138180_, "sound"), p_138152_, ((CommandSourceStack)p_138180_.getSource()).m_81371_(), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.m_82129_("pos", Vec3Argument.m_120841_()).executes(p_138177_ -> PlaySoundCommand.m_138160_((CommandSourceStack)p_138177_.getSource(), EntityArgument.m_91477_((CommandContext<CommandSourceStack>)p_138177_, "targets"), ResourceLocationArgument.m_107011_((CommandContext<CommandSourceStack>)p_138177_, "sound"), p_138152_, Vec3Argument.m_120844_((CommandContext<CommandSourceStack>)p_138177_, "pos"), 1.0f, 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.m_82129_("volume", FloatArgumentType.floatArg((float)0.0f)).executes(p_138174_ -> PlaySoundCommand.m_138160_((CommandSourceStack)p_138174_.getSource(), EntityArgument.m_91477_((CommandContext<CommandSourceStack>)p_138174_, "targets"), ResourceLocationArgument.m_107011_((CommandContext<CommandSourceStack>)p_138174_, "sound"), p_138152_, Vec3Argument.m_120844_((CommandContext<CommandSourceStack>)p_138174_, "pos"), ((Float)p_138174_.getArgument("volume", Float.class)).floatValue(), 1.0f, 0.0f))).then(((RequiredArgumentBuilder)Commands.m_82129_("pitch", FloatArgumentType.floatArg((float)0.0f, (float)2.0f)).executes(p_138171_ -> PlaySoundCommand.m_138160_((CommandSourceStack)p_138171_.getSource(), EntityArgument.m_91477_((CommandContext<CommandSourceStack>)p_138171_, "targets"), ResourceLocationArgument.m_107011_((CommandContext<CommandSourceStack>)p_138171_, "sound"), p_138152_, Vec3Argument.m_120844_((CommandContext<CommandSourceStack>)p_138171_, "pos"), ((Float)p_138171_.getArgument("volume", Float.class)).floatValue(), ((Float)p_138171_.getArgument("pitch", Float.class)).floatValue(), 0.0f))).then(Commands.m_82129_("minVolume", FloatArgumentType.floatArg((float)0.0f, (float)1.0f)).executes(p_138155_ -> PlaySoundCommand.m_138160_((CommandSourceStack)p_138155_.getSource(), EntityArgument.m_91477_((CommandContext<CommandSourceStack>)p_138155_, "targets"), ResourceLocationArgument.m_107011_((CommandContext<CommandSourceStack>)p_138155_, "sound"), p_138152_, Vec3Argument.m_120844_((CommandContext<CommandSourceStack>)p_138155_, "pos"), ((Float)p_138155_.getArgument("volume", Float.class)).floatValue(), ((Float)p_138155_.getArgument("pitch", Float.class)).floatValue(), ((Float)p_138155_.getArgument("minVolume", Float.class)).floatValue())))))));
    }

    private static int m_138160_(CommandSourceStack p_138161_, Collection<ServerPlayer> p_138162_, ResourceLocation p_138163_, SoundSource p_138164_, Vec3 p_138165_, float p_138166_, float p_138167_, float p_138168_) throws CommandSyntaxException {
        double d = Math.pow(p_138166_ > 1.0f ? (double)(p_138166_ * 16.0f) : 16.0, 2.0);
        int \u00e2\u02dc\u01922 = 0;
        for (ServerPlayer serverPlayer : p_138162_) {
            double d2 = p_138165_.f_82479_ - serverPlayer.m_20185_();
            \u00e2\u02dc\u0192 = p_138165_.f_82480_ - serverPlayer.m_20186_();
            \u00e2\u02dc\u0192 = p_138165_.f_82481_ - serverPlayer.m_20189_();
            \u00e2\u02dc\u0192 = d2 * d2 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
            Vec3 \u00e2\u02dc\u01923 = p_138165_;
            float \u00e2\u02dc\u01924 = p_138166_;
            if (\u00e2\u02dc\u0192 > d) {
                if (p_138168_ <= 0.0f) continue;
                \u00e2\u02dc\u0192 = Math.sqrt(\u00e2\u02dc\u0192);
                \u00e2\u02dc\u01923 = new Vec3(serverPlayer.m_20185_() + d2 / \u00e2\u02dc\u0192 * 2.0, serverPlayer.m_20186_() + \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192 * 2.0, serverPlayer.m_20189_() + \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192 * 2.0);
                \u00e2\u02dc\u01924 = p_138168_;
            }
            serverPlayer.f_8906_.m_141995_(new ClientboundCustomSoundPacket(p_138163_, p_138164_, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, p_138167_));
            ++\u00e2\u02dc\u01922;
        }
        if (\u00e2\u02dc\u01922 == 0) {
            throw f_138149_.create();
        }
        if (p_138162_.size() == 1) {
            p_138161_.m_81354_(new TranslatableComponent("commands.playsound.success.single", p_138163_, p_138162_.iterator().next().m_5446_()), true);
        } else {
            p_138161_.m_81354_(new TranslatableComponent("commands.playsound.success.multiple", p_138163_, p_138162_.size()), true);
        }
        return \u00e2\u02dc\u01922;
    }
}

