/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ComponentArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raider;
import net.minecraft.world.entity.raid.Raids;

public class RaidCommand {
    public static void m_180468_(CommandDispatcher<CommandSourceStack> p_180469_) {
        p_180469_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("raid").requires(p_180498_ -> p_180498_.m_6761_(3))).then(Commands.m_82127_("start").then(Commands.m_82129_("omenlvl", IntegerArgumentType.integer((int)0)).executes(p_180502_ -> RaidCommand.m_180484_((CommandSourceStack)p_180502_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_180502_, (String)"omenlvl")))))).then(Commands.m_82127_("stop").executes(p_180500_ -> RaidCommand.m_180489_((CommandSourceStack)p_180500_.getSource())))).then(Commands.m_82127_("check").executes(p_180496_ -> RaidCommand.m_180493_((CommandSourceStack)p_180496_.getSource())))).then(Commands.m_82127_("sound").then(Commands.m_82129_("type", ComponentArgument.m_87114_()).executes(p_180492_ -> RaidCommand.m_180477_((CommandSourceStack)p_180492_.getSource(), ComponentArgument.m_87117_((CommandContext<CommandSourceStack>)p_180492_, "type")))))).then(Commands.m_82127_("spawnleader").executes(p_180488_ -> RaidCommand.m_180482_((CommandSourceStack)p_180488_.getSource())))).then(Commands.m_82127_("setomen").then(Commands.m_82129_("level", IntegerArgumentType.integer((int)0)).executes(p_180481_ -> RaidCommand.m_180474_((CommandSourceStack)p_180481_.getSource(), IntegerArgumentType.getInteger((CommandContext)p_180481_, (String)"level")))))).then(Commands.m_82127_("glow").executes(p_180471_ -> RaidCommand.m_180472_((CommandSourceStack)p_180471_.getSource()))));
    }

    private static int m_180472_(CommandSourceStack p_180473_) throws CommandSyntaxException {
        Raid raid = RaidCommand.m_180466_(p_180473_.m_81375_());
        if (raid != null) {
            Set<Raider> set = raid.m_150221_();
            for (Raider raider : set) {
                raider.m_7292_(new MobEffectInstance(MobEffects.f_19619_, 1000, 1));
            }
        }
        return 1;
    }

    private static int m_180474_(CommandSourceStack p_180475_, int p_180476_) throws CommandSyntaxException {
        Raid raid = RaidCommand.m_180466_(p_180475_.m_81375_());
        if (raid != null) {
            int n = raid.m_37772_();
            if (p_180476_ > n) {
                p_180475_.m_81352_(new TextComponent("Sorry, the max bad omen level you can set is " + n));
            } else {
                \u00e2\u02dc\u0192 = raid.m_37773_();
                raid.m_150218_(p_180476_);
                p_180475_.m_81354_(new TextComponent("Changed village's bad omen level from " + \u00e2\u02dc\u0192 + " to " + p_180476_), false);
            }
        } else {
            p_180475_.m_81352_(new TextComponent("No raid found here"));
        }
        return 1;
    }

    private static int m_180482_(CommandSourceStack p_180483_) {
        p_180483_.m_81354_(new TextComponent("Spawned a raid captain"), false);
        Raider raider = EntityType.f_20513_.m_20615_(p_180483_.m_81372_());
        raider.m_33075_(true);
        raider.m_8061_(EquipmentSlot.HEAD, Raid.m_37779_());
        raider.m_6034_(p_180483_.m_81371_().f_82479_, p_180483_.m_81371_().f_82480_, p_180483_.m_81371_().f_82481_);
        raider.m_6518_(p_180483_.m_81372_(), p_180483_.m_81372_().m_6436_(new BlockPos(p_180483_.m_81371_())), MobSpawnType.COMMAND, null, null);
        p_180483_.m_81372_().m_47205_(raider);
        return 1;
    }

    private static int m_180477_(CommandSourceStack p_180478_, Component p_180479_) {
        if (p_180479_ != null && p_180479_.getString().equals("local")) {
            p_180478_.m_81372_().m_5594_(null, new BlockPos(p_180478_.m_81371_().m_82520_(5.0, 0.0, 0.0)), SoundEvents.f_12355_, SoundSource.NEUTRAL, 2.0f, 1.0f);
        }
        return 1;
    }

    private static int m_180484_(CommandSourceStack p_180485_, int p_180486_) throws CommandSyntaxException {
        ServerPlayer serverPlayer = p_180485_.m_81375_();
        BlockPos \u00e2\u02dc\u01922 = serverPlayer.m_142538_();
        if (serverPlayer.m_9236_().m_8843_(\u00e2\u02dc\u01922)) {
            p_180485_.m_81352_(new TextComponent("Raid already started close by"));
            return -1;
        }
        Raids \u00e2\u02dc\u01923 = serverPlayer.m_9236_().m_8905_();
        Raid \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.m_37963_(serverPlayer);
        if (\u00e2\u02dc\u01924 != null) {
            \u00e2\u02dc\u01924.m_150218_(p_180486_);
            \u00e2\u02dc\u01923.m_77762_();
            p_180485_.m_81354_(new TextComponent("Created a raid in your local village"), false);
        } else {
            p_180485_.m_81352_(new TextComponent("Failed to create a raid in your local village"));
        }
        return 1;
    }

    private static int m_180489_(CommandSourceStack p_180490_) throws CommandSyntaxException {
        ServerPlayer serverPlayer = p_180490_.m_81375_();
        BlockPos \u00e2\u02dc\u01922 = serverPlayer.m_142538_();
        Raid \u00e2\u02dc\u01923 = serverPlayer.m_9236_().m_8832_(\u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01923 != null) {
            \u00e2\u02dc\u01923.m_37774_();
            p_180490_.m_81354_(new TextComponent("Stopped raid"), false);
            return 1;
        }
        p_180490_.m_81352_(new TextComponent("No raid here"));
        return -1;
    }

    private static int m_180493_(CommandSourceStack p_180494_) throws CommandSyntaxException {
        Raid raid = RaidCommand.m_180466_(p_180494_.m_81375_());
        if (raid != null) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Found a started raid! ");
            p_180494_.m_81354_(new TextComponent(stringBuilder.toString()), false);
            stringBuilder = new StringBuilder();
            stringBuilder.append("Num groups spawned: ");
            stringBuilder.append(raid.m_37771_());
            stringBuilder.append(" Bad omen level: ");
            stringBuilder.append(raid.m_37773_());
            stringBuilder.append(" Num mobs: ");
            stringBuilder.append(raid.m_37778_());
            stringBuilder.append(" Raid health: ");
            stringBuilder.append(raid.m_37777_());
            stringBuilder.append(" / ");
            stringBuilder.append(raid.m_150220_());
            p_180494_.m_81354_(new TextComponent(stringBuilder.toString()), false);
            return 1;
        }
        p_180494_.m_81352_(new TextComponent("Found no started raids"));
        return 0;
    }

    @Nullable
    private static Raid m_180466_(ServerPlayer p_180467_) {
        return p_180467_.m_9236_().m_8832_(p_180467_.m_142538_());
    }
}

