/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.FloatArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic4CommandExceptionType;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Random;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.Vec2Argument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.scores.Team;

public class SpreadPlayersCommand {
    private static final int f_180523_ = 10000;
    private static final Dynamic4CommandExceptionType f_138693_ = new Dynamic4CommandExceptionType((p_138745_, p_138746_, p_138747_, p_138748_) -> new TranslatableComponent("commands.spreadplayers.failed.teams", p_138745_, p_138746_, p_138747_, p_138748_));
    private static final Dynamic4CommandExceptionType f_138694_ = new Dynamic4CommandExceptionType((p_138723_, p_138724_, p_138725_, p_138726_) -> new TranslatableComponent("commands.spreadplayers.failed.entities", p_138723_, p_138724_, p_138725_, p_138726_));

    public static void m_138696_(CommandDispatcher<CommandSourceStack> p_138697_) {
        p_138697_.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_("spreadplayers").requires(p_138701_ -> p_138701_.m_6761_(2))).then(Commands.m_82129_("center", Vec2Argument.m_120822_()).then(Commands.m_82129_("spreadDistance", FloatArgumentType.floatArg((float)0.0f)).then(((RequiredArgumentBuilder)Commands.m_82129_("maxRange", FloatArgumentType.floatArg((float)1.0f)).then(Commands.m_82129_("respectTeams", BoolArgumentType.bool()).then(Commands.m_82129_("targets", EntityArgument.m_91460_()).executes(p_138743_ -> SpreadPlayersCommand.m_138702_((CommandSourceStack)p_138743_.getSource(), Vec2Argument.m_120825_((CommandContext<CommandSourceStack>)p_138743_, "center"), FloatArgumentType.getFloat((CommandContext)p_138743_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_138743_, (String)"maxRange"), ((CommandSourceStack)p_138743_.getSource()).m_81372_().m_151558_(), BoolArgumentType.getBool((CommandContext)p_138743_, (String)"respectTeams"), EntityArgument.m_91461_((CommandContext<CommandSourceStack>)p_138743_, "targets")))))).then(Commands.m_82127_("under").then(Commands.m_82129_("maxHeight", IntegerArgumentType.integer((int)0)).then(Commands.m_82129_("respectTeams", BoolArgumentType.bool()).then(Commands.m_82129_("targets", EntityArgument.m_91460_()).executes(p_138699_ -> SpreadPlayersCommand.m_138702_((CommandSourceStack)p_138699_.getSource(), Vec2Argument.m_120825_((CommandContext<CommandSourceStack>)p_138699_, "center"), FloatArgumentType.getFloat((CommandContext)p_138699_, (String)"spreadDistance"), FloatArgumentType.getFloat((CommandContext)p_138699_, (String)"maxRange"), IntegerArgumentType.getInteger((CommandContext)p_138699_, (String)"maxHeight"), BoolArgumentType.getBool((CommandContext)p_138699_, (String)"respectTeams"), EntityArgument.m_91461_((CommandContext<CommandSourceStack>)p_138699_, "targets")))))))))));
    }

    private static int m_138702_(CommandSourceStack p_138703_, Vec2 p_138704_, float p_138705_, float p_138706_, int p_138707_, boolean p_138708_, Collection<? extends Entity> p_138709_) throws CommandSyntaxException {
        Random random = new Random();
        double \u00e2\u02dc\u01922 = p_138704_.f_82470_ - p_138706_;
        double \u00e2\u02dc\u01923 = p_138704_.f_82471_ - p_138706_;
        double \u00e2\u02dc\u01924 = p_138704_.f_82470_ + p_138706_;
        double \u00e2\u02dc\u01925 = p_138704_.f_82471_ + p_138706_;
        Position[] \u00e2\u02dc\u01926 = SpreadPlayersCommand.m_138735_(random, p_138708_ ? SpreadPlayersCommand.m_138727_(p_138709_) : p_138709_.size(), \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925);
        SpreadPlayersCommand.m_138710_(p_138704_, p_138705_, p_138703_.m_81372_(), random, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, p_138707_, \u00e2\u02dc\u01926, p_138708_);
        double \u00e2\u02dc\u01927 = SpreadPlayersCommand.m_138729_(p_138709_, p_138703_.m_81372_(), \u00e2\u02dc\u01926, p_138707_, p_138708_);
        p_138703_.m_81354_(new TranslatableComponent("commands.spreadplayers.success." + (p_138708_ ? "teams" : "entities"), \u00e2\u02dc\u01926.length, Float.valueOf(p_138704_.f_82470_), Float.valueOf(p_138704_.f_82471_), String.format(Locale.ROOT, "%.2f", \u00e2\u02dc\u01927)), true);
        return \u00e2\u02dc\u01926.length;
    }

    private static int m_138727_(Collection<? extends Entity> p_138728_) {
        HashSet hashSet = Sets.newHashSet();
        for (Entity entity : p_138728_) {
            if (entity instanceof Player) {
                hashSet.add(entity.m_5647_());
                continue;
            }
            hashSet.add(null);
        }
        return hashSet.size();
    }

    private static void m_138710_(Vec2 p_138711_, double p_138712_, ServerLevel p_138713_, Random p_138714_, double p_138715_, double p_138716_, double p_138717_, double p_138718_, int p_138719_, Position[] p_138720_, boolean p_138721_) throws CommandSyntaxException {
        int n;
        boolean \u00e2\u02dc\u01926 = true;
        double \u00e2\u02dc\u01922 = 3.4028234663852886E38;
        for (n = 0; n < 10000 && \u00e2\u02dc\u01926; ++n) {
            \u00e2\u02dc\u01926 = false;
            \u00e2\u02dc\u01922 = 3.4028234663852886E38;
            for (int i = 0; i < p_138720_.length; ++i) {
                Position position = p_138720_[i];
                int \u00e2\u02dc\u01923 = 0;
                position = new Position();
                for (int j = 0; j < p_138720_.length; ++j) {
                    if (i == j) continue;
                    Position position2 = p_138720_[j];
                    double \u00e2\u02dc\u01924 = position.m_138767_(position2);
                    \u00e2\u02dc\u01922 = Math.min(\u00e2\u02dc\u01924, \u00e2\u02dc\u01922);
                    if (!(\u00e2\u02dc\u01924 < p_138712_)) continue;
                    ++\u00e2\u02dc\u01923;
                    position.f_138749_ += position2.f_138749_ - position.f_138749_;
                    position.f_138750_ += position2.f_138750_ - position.f_138750_;
                }
                if (\u00e2\u02dc\u01923 > 0) {
                    position.f_138749_ /= (double)\u00e2\u02dc\u01923;
                    position.f_138750_ /= (double)\u00e2\u02dc\u01923;
                    double \u00e2\u02dc\u01925 = position.m_180525_();
                    if (\u00e2\u02dc\u01925 > 0.0) {
                        position.m_138752_();
                        position.m_138776_(position);
                    } else {
                        position.m_138761_(p_138714_, p_138715_, p_138716_, p_138717_, p_138718_);
                    }
                    \u00e2\u02dc\u01926 = true;
                }
                if (!position.m_138753_(p_138715_, p_138716_, p_138717_, p_138718_)) continue;
                \u00e2\u02dc\u01926 = true;
            }
            if (\u00e2\u02dc\u01926) continue;
            for (Position position : p_138720_) {
                if (position.m_138773_(p_138713_, p_138719_)) continue;
                position.m_138761_(p_138714_, p_138715_, p_138716_, p_138717_, p_138718_);
                \u00e2\u02dc\u01926 = true;
            }
        }
        if (\u00e2\u02dc\u01922 == 3.4028234663852886E38) {
            \u00e2\u02dc\u01922 = 0.0;
        }
        if (n >= 10000) {
            if (p_138721_) {
                throw f_138693_.create((Object)p_138720_.length, (Object)Float.valueOf(p_138711_.f_82470_), (Object)Float.valueOf(p_138711_.f_82471_), (Object)String.format(Locale.ROOT, "%.2f", \u00e2\u02dc\u01922));
            }
            throw f_138694_.create((Object)p_138720_.length, (Object)Float.valueOf(p_138711_.f_82470_), (Object)Float.valueOf(p_138711_.f_82471_), (Object)String.format(Locale.ROOT, "%.2f", \u00e2\u02dc\u01922));
        }
    }

    private static double m_138729_(Collection<? extends Entity> p_138730_, ServerLevel p_138731_, Position[] p_138732_, int p_138733_, boolean p_138734_) {
        double d = 0.0;
        int \u00e2\u02dc\u01922 = 0;
        HashMap \u00e2\u02dc\u01923 = Maps.newHashMap();
        for (Entity entity : p_138730_) {
            Position \u00e2\u02dc\u01925;
            if (p_138734_) {
                Team team;
                Team team2 = team = entity instanceof Player ? entity.m_5647_() : null;
                if (!\u00e2\u02dc\u01923.containsKey(team)) {
                    \u00e2\u02dc\u01923.put(team, p_138732_[\u00e2\u02dc\u01922++]);
                }
                \u00e2\u02dc\u01925 = (Position)\u00e2\u02dc\u01923.get(team);
            } else {
                \u00e2\u02dc\u01925 = p_138732_[\u00e2\u02dc\u01922++];
            }
            entity.m_20324_((double)Mth.m_14107_(\u00e2\u02dc\u01925.f_138749_) + 0.5, \u00e2\u02dc\u01925.m_138758_(p_138731_, p_138733_), (double)Mth.m_14107_(\u00e2\u02dc\u01925.f_138750_) + 0.5);
            double \u00e2\u02dc\u01924 = Double.MAX_VALUE;
            for (Position position : p_138732_) {
                if (\u00e2\u02dc\u01925 == position) continue;
                double d2 = \u00e2\u02dc\u01925.m_138767_(position);
                \u00e2\u02dc\u01924 = Math.min(d2, \u00e2\u02dc\u01924);
            }
            d += \u00e2\u02dc\u01924;
        }
        if (p_138730_.size() < 2) {
            return 0.0;
        }
        return d /= (double)p_138730_.size();
    }

    private static Position[] m_138735_(Random p_138736_, int p_138737_, double p_138738_, double p_138739_, double p_138740_, double p_138741_) {
        Position[] positionArray = new Position[p_138737_];
        for (int i = 0; i < positionArray.length; ++i) {
            Position position = new Position();
            position.m_138761_(p_138736_, p_138738_, p_138739_, p_138740_, p_138741_);
            positionArray[i] = position;
        }
        return positionArray;
    }

    static class Position {
        double f_138749_;
        double f_138750_;

        Position() {
        }

        double m_138767_(Position p_138768_) {
            double d = this.f_138749_ - p_138768_.f_138749_;
            \u00e2\u02dc\u0192 = this.f_138750_ - p_138768_.f_138750_;
            return Math.sqrt(d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
        }

        void m_138752_() {
            double d = this.m_180525_();
            this.f_138749_ /= d;
            this.f_138750_ /= d;
        }

        double m_180525_() {
            return Math.sqrt(this.f_138749_ * this.f_138749_ + this.f_138750_ * this.f_138750_);
        }

        public void m_138776_(Position p_138777_) {
            this.f_138749_ -= p_138777_.f_138749_;
            this.f_138750_ -= p_138777_.f_138750_;
        }

        public boolean m_138753_(double p_138754_, double p_138755_, double p_138756_, double p_138757_) {
            boolean bl = false;
            if (this.f_138749_ < p_138754_) {
                this.f_138749_ = p_138754_;
                bl = true;
            } else if (this.f_138749_ > p_138756_) {
                this.f_138749_ = p_138756_;
                bl = true;
            }
            if (this.f_138750_ < p_138755_) {
                this.f_138750_ = p_138755_;
                bl = true;
            } else if (this.f_138750_ > p_138757_) {
                this.f_138750_ = p_138757_;
                bl = true;
            }
            return bl;
        }

        public int m_138758_(BlockGetter p_138759_, int p_138760_) {
            BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos(this.f_138749_, (double)(p_138760_ + 1), this.f_138750_);
            boolean \u00e2\u02dc\u01922 = p_138759_.m_8055_(mutableBlockPos).m_60795_();
            mutableBlockPos.m_122173_(Direction.DOWN);
            boolean \u00e2\u02dc\u01923 = p_138759_.m_8055_(mutableBlockPos).m_60795_();
            while (mutableBlockPos.m_123342_() > p_138759_.m_141937_()) {
                mutableBlockPos.m_122173_(Direction.DOWN);
                boolean bl = p_138759_.m_8055_(mutableBlockPos).m_60795_();
                if (!bl && \u00e2\u02dc\u01923 && \u00e2\u02dc\u01922) {
                    return mutableBlockPos.m_123342_() + 1;
                }
                \u00e2\u02dc\u01922 = \u00e2\u02dc\u01923;
                \u00e2\u02dc\u01923 = bl;
            }
            return p_138760_ + 1;
        }

        public boolean m_138773_(BlockGetter p_138774_, int p_138775_) {
            BlockPos blockPos = new BlockPos(this.f_138749_, (double)(this.m_138758_(p_138774_, p_138775_) - 1), this.f_138750_);
            BlockState \u00e2\u02dc\u01922 = p_138774_.m_8055_(blockPos);
            Material \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_60767_();
            return blockPos.m_123342_() < p_138775_ && !\u00e2\u02dc\u01923.m_76332_() && \u00e2\u02dc\u01923 != Material.f_76309_;
        }

        public void m_138761_(Random p_138762_, double p_138763_, double p_138764_, double p_138765_, double p_138766_) {
            this.f_138749_ = Mth.m_14064_(p_138762_, p_138763_, p_138765_);
            this.f_138750_ = Mth.m_14064_(p_138762_, p_138764_, p_138766_);
        }
    }
}

