/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.commands.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.CompoundTagArgument;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.NbtTagArgument;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.commands.data.BlockDataAccessor;
import net.minecraft.server.commands.data.DataAccessor;
import net.minecraft.server.commands.data.EntityDataAccessor;
import net.minecraft.server.commands.data.StorageDataAccessor;
import net.minecraft.util.Mth;

public class DataCommands {
    private static final SimpleCommandExceptionType f_139352_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.data.merge.failed"));
    private static final DynamicCommandExceptionType f_139353_ = new DynamicCommandExceptionType(p_139491_ -> new TranslatableComponent("commands.data.get.invalid", p_139491_));
    private static final DynamicCommandExceptionType f_139354_ = new DynamicCommandExceptionType(p_139481_ -> new TranslatableComponent("commands.data.get.unknown", p_139481_));
    private static final SimpleCommandExceptionType f_139355_ = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.data.get.multiple"));
    private static final DynamicCommandExceptionType f_139356_ = new DynamicCommandExceptionType(p_139468_ -> new TranslatableComponent("commands.data.modify.expected_list", p_139468_));
    private static final DynamicCommandExceptionType f_139357_ = new DynamicCommandExceptionType(p_139448_ -> new TranslatableComponent("commands.data.modify.expected_object", p_139448_));
    private static final DynamicCommandExceptionType f_139358_ = new DynamicCommandExceptionType(p_139402_ -> new TranslatableComponent("commands.data.modify.invalid_index", p_139402_));
    public static final List<Function<String, DataProvider>> f_139349_ = ImmutableList.of(EntityDataAccessor.f_139505_, BlockDataAccessor.f_139291_, StorageDataAccessor.f_139531_);
    public static final List<DataProvider> f_139350_ = (List)f_139349_.stream().map(p_139450_ -> (DataProvider)p_139450_.apply("target")).collect(ImmutableList.toImmutableList());
    public static final List<DataProvider> f_139351_ = (List)f_139349_.stream().map(p_139410_ -> (DataProvider)p_139410_.apply("source")).collect(ImmutableList.toImmutableList());

    public static void m_139365_(CommandDispatcher<CommandSourceStack> p_139366_) {
        LiteralArgumentBuilder literalArgumentBuilder = (LiteralArgumentBuilder)Commands.m_82127_("data").requires(p_139381_ -> p_139381_.m_6761_(2));
        for (DataProvider dataProvider : f_139350_) {
            ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)literalArgumentBuilder.then(dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_("merge"), p_139471_ -> p_139471_.then(Commands.m_82129_("nbt", CompoundTagArgument.m_87657_()).executes(p_142857_ -> DataCommands.m_139394_((CommandSourceStack)p_142857_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142857_), CompoundTagArgument.m_87660_(p_142857_, "nbt"))))))).then(dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_("get"), p_139453_ -> p_139453_.executes(p_142849_ -> DataCommands.m_139382_((CommandSourceStack)p_142849_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142849_))).then(((RequiredArgumentBuilder)Commands.m_82129_("path", NbtPathArgument.m_99487_()).executes(p_142841_ -> DataCommands.m_139443_((CommandSourceStack)p_142841_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142841_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_142841_, "path")))).then(Commands.m_82129_("scale", DoubleArgumentType.doubleArg()).executes(p_142833_ -> DataCommands.m_139389_((CommandSourceStack)p_142833_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142833_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_142833_, "path"), DoubleArgumentType.getDouble((CommandContext)p_142833_, (String)"scale")))))))).then(dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_("remove"), p_139413_ -> p_139413_.then(Commands.m_82129_("path", NbtPathArgument.m_99487_()).executes(p_142820_ -> DataCommands.m_139385_((CommandSourceStack)p_142820_.getSource(), dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142820_), NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_142820_, "path"))))))).then(DataCommands.m_139403_((p_139368_, p_139369_) -> p_139368_.then(Commands.m_82127_("insert").then(Commands.m_82129_("index", IntegerArgumentType.integer()).then(p_139369_.m_139500_((p_142859_, p_142860_, p_142861_, p_142862_) -> {
                int n = IntegerArgumentType.getInteger((CommandContext)p_142859_, (String)"index");
                return DataCommands.m_139360_(n, p_142860_, p_142861_, p_142862_);
            })))).then(Commands.m_82127_("prepend").then(p_139369_.m_139500_((p_142851_, p_142852_, p_142853_, p_142854_) -> DataCommands.m_139360_(0, p_142852_, p_142853_, p_142854_)))).then(Commands.m_82127_("append").then(p_139369_.m_139500_((p_142843_, p_142844_, p_142845_, p_142846_) -> DataCommands.m_139360_(-1, p_142844_, p_142845_, p_142846_)))).then(Commands.m_82127_("set").then(p_139369_.m_139500_((p_142835_, p_142836_, p_142837_, p_142838_) -> p_142837_.m_99645_(p_142836_, ((Tag)Iterables.getLast((Iterable)p_142838_))::m_6426_)))).then(Commands.m_82127_("merge").then(p_139369_.m_139500_((p_142822_, p_142823_, p_142824_, p_142825_) -> {
                List<Tag> list = p_142824_.m_99640_(p_142823_, CompoundTag::new);
                int \u00e2\u02dc\u01922 = 0;
                for (Tag tag : list) {
                    CompoundTag compoundTag;
                    if (!(tag instanceof CompoundTag)) {
                        throw f_139357_.create((Object)tag);
                    }
                    CompoundTag compoundTag2 = (CompoundTag)tag;
                    compoundTag = compoundTag2.m_6426_();
                    for (Tag tag2 : p_142825_) {
                        if (!(tag2 instanceof CompoundTag)) {
                            throw f_139357_.create((Object)tag2);
                        }
                        compoundTag2.m_128391_((CompoundTag)tag2);
                    }
                    \u00e2\u02dc\u01922 += compoundTag.equals(compoundTag2) ? 0 : 1;
                }
                return \u00e2\u02dc\u01922;
            })))));
        }
        p_139366_.register(literalArgumentBuilder);
    }

    private static int m_139360_(int p_139361_, CompoundTag p_139362_, NbtPathArgument.NbtPath p_139363_, List<Tag> p_139364_) throws CommandSyntaxException {
        List<Tag> list = p_139363_.m_99640_(p_139362_, ListTag::new);
        int \u00e2\u02dc\u01922 = 0;
        for (Tag tag : list) {
            if (!(tag instanceof CollectionTag)) {
                throw f_139356_.create((Object)tag);
            }
            boolean bl = false;
            CollectionTag \u00e2\u02dc\u01923 = (CollectionTag)tag;
            int \u00e2\u02dc\u01924 = p_139361_ < 0 ? \u00e2\u02dc\u01923.size() + p_139361_ + 1 : p_139361_;
            for (Tag tag2 : p_139364_) {
                try {
                    if (!\u00e2\u02dc\u01923.m_7614_(\u00e2\u02dc\u01924, tag2.m_6426_())) continue;
                    ++\u00e2\u02dc\u01924;
                    bl = true;
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw f_139358_.create((Object)\u00e2\u02dc\u01924);
                }
            }
            \u00e2\u02dc\u01922 += bl ? 1 : 0;
        }
        return \u00e2\u02dc\u01922;
    }

    private static ArgumentBuilder<CommandSourceStack, ?> m_139403_(BiConsumer<ArgumentBuilder<CommandSourceStack, ?>, DataManipulatorDecorator> p_139404_) {
        LiteralArgumentBuilder<CommandSourceStack> literalArgumentBuilder = Commands.m_82127_("modify");
        for (DataProvider dataProvider : f_139350_) {
            dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)literalArgumentBuilder, p_139408_ -> {
                RequiredArgumentBuilder<CommandSourceStack, NbtPathArgument.NbtPath> requiredArgumentBuilder = Commands.m_82129_("targetPath", NbtPathArgument.m_99487_());
                for (DataProvider dataProvider : f_139351_) {
                    p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)requiredArgumentBuilder, p_142807_ -> dataProvider.m_7621_((ArgumentBuilder<CommandSourceStack, ?>)Commands.m_82127_("from"), p_142812_ -> p_142812_.executes(p_142830_ -> {
                        List<Tag> list = Collections.singletonList(dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142830_).m_6184_());
                        return DataCommands.m_139375_((CommandContext<CommandSourceStack>)p_142830_, dataProvider, p_142807_, list);
                    }).then(Commands.m_82129_("sourcePath", NbtPathArgument.m_99487_()).executes(p_142817_ -> {
                        DataAccessor dataAccessor = dataProvider.m_7018_((CommandContext<CommandSourceStack>)p_142817_);
                        NbtPathArgument.NbtPath \u00e2\u02dc\u01922 = NbtPathArgument.m_99498_((CommandContext<CommandSourceStack>)p_142817_, "sourcePath");
                        List<Tag> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_99638_(dataAccessor.m_6184_());
                        return DataCommands.m_139375_((CommandContext<CommandSourceStack>)p_142817_, dataProvider, p_142807_, \u00e2\u02dc\u01923);
                    }))));
                }
                p_139404_.accept((ArgumentBuilder<CommandSourceStack, ?>)requiredArgumentBuilder, p_142799_ -> Commands.m_82127_("value").then(Commands.m_82129_("value", NbtTagArgument.m_100659_()).executes(p_142803_ -> {
                    List<Tag> list = Collections.singletonList(NbtTagArgument.m_100662_(p_142803_, "value"));
                    return DataCommands.m_139375_((CommandContext<CommandSourceStack>)p_142803_, dataProvider, p_142799_, list);
                })));
                return p_139408_.then(requiredArgumentBuilder);
            });
        }
        return literalArgumentBuilder;
    }

    private static int m_139375_(CommandContext<CommandSourceStack> p_139376_, DataProvider p_139377_, DataManipulator p_139378_, List<Tag> p_139379_) throws CommandSyntaxException {
        DataAccessor dataAccessor = p_139377_.m_7018_(p_139376_);
        NbtPathArgument.NbtPath \u00e2\u02dc\u01922 = NbtPathArgument.m_99498_(p_139376_, "targetPath");
        CompoundTag \u00e2\u02dc\u01923 = dataAccessor.m_6184_();
        int \u00e2\u02dc\u01924 = p_139378_.m_139495_(p_139376_, \u00e2\u02dc\u01923, \u00e2\u02dc\u01922, p_139379_);
        if (\u00e2\u02dc\u01924 == 0) {
            throw f_139352_.create();
        }
        dataAccessor.m_7603_(\u00e2\u02dc\u01923);
        ((CommandSourceStack)p_139376_.getSource()).m_81354_(dataAccessor.m_6934_(), true);
        return \u00e2\u02dc\u01924;
    }

    private static int m_139385_(CommandSourceStack p_139386_, DataAccessor p_139387_, NbtPathArgument.NbtPath p_139388_) throws CommandSyntaxException {
        CompoundTag compoundTag = p_139387_.m_6184_();
        int \u00e2\u02dc\u01922 = p_139388_.m_99648_(compoundTag);
        if (\u00e2\u02dc\u01922 == 0) {
            throw f_139352_.create();
        }
        p_139387_.m_7603_(compoundTag);
        p_139386_.m_81354_(p_139387_.m_6934_(), true);
        return \u00e2\u02dc\u01922;
    }

    private static Tag m_139398_(NbtPathArgument.NbtPath p_139399_, DataAccessor p_139400_) throws CommandSyntaxException {
        List<Tag> list = p_139399_.m_99638_(p_139400_.m_6184_());
        Iterator \u00e2\u02dc\u01922 = list.iterator();
        Tag \u00e2\u02dc\u01923 = (Tag)\u00e2\u02dc\u01922.next();
        if (\u00e2\u02dc\u01922.hasNext()) {
            throw f_139355_.create();
        }
        return \u00e2\u02dc\u01923;
    }

    private static int m_139443_(CommandSourceStack p_139444_, DataAccessor p_139445_, NbtPathArgument.NbtPath p_139446_) throws CommandSyntaxException {
        Tag tag = DataCommands.m_139398_(p_139446_, p_139445_);
        if (tag instanceof NumericTag) {
            \u00e2\u02dc\u0192 = Mth.m_14107_(((NumericTag)tag).m_7061_());
        } else if (tag instanceof CollectionTag) {
            \u00e2\u02dc\u0192 = ((CollectionTag)tag).size();
        } else if (tag instanceof CompoundTag) {
            \u00e2\u02dc\u0192 = ((CompoundTag)tag).m_128440_();
        } else if (tag instanceof StringTag) {
            \u00e2\u02dc\u0192 = tag.m_7916_().length();
        } else {
            throw f_139354_.create((Object)p_139446_.toString());
        }
        p_139444_.m_81354_(p_139445_.m_7624_(tag), false);
        return \u00e2\u02dc\u0192;
    }

    private static int m_139389_(CommandSourceStack p_139390_, DataAccessor p_139391_, NbtPathArgument.NbtPath p_139392_, double p_139393_) throws CommandSyntaxException {
        Tag tag = DataCommands.m_139398_(p_139392_, p_139391_);
        if (!(tag instanceof NumericTag)) {
            throw f_139353_.create((Object)p_139392_.toString());
        }
        int \u00e2\u02dc\u01922 = Mth.m_14107_(((NumericTag)tag).m_7061_() * p_139393_);
        p_139390_.m_81354_(p_139391_.m_6066_(p_139392_, p_139393_, \u00e2\u02dc\u01922), false);
        return \u00e2\u02dc\u01922;
    }

    private static int m_139382_(CommandSourceStack p_139383_, DataAccessor p_139384_) throws CommandSyntaxException {
        p_139383_.m_81354_(p_139384_.m_7624_(p_139384_.m_6184_()), false);
        return 1;
    }

    private static int m_139394_(CommandSourceStack p_139395_, DataAccessor p_139396_, CompoundTag p_139397_) throws CommandSyntaxException {
        CompoundTag compoundTag = p_139396_.m_6184_();
        if (compoundTag.equals(\u00e2\u02dc\u0192 = compoundTag.m_6426_().m_128391_(p_139397_))) {
            throw f_139352_.create();
        }
        p_139396_.m_7603_(\u00e2\u02dc\u0192);
        p_139395_.m_81354_(p_139396_.m_6934_(), true);
        return 1;
    }

    public static interface DataProvider {
        public DataAccessor m_7018_(CommandContext<CommandSourceStack> var1) throws CommandSyntaxException;

        public ArgumentBuilder<CommandSourceStack, ?> m_7621_(ArgumentBuilder<CommandSourceStack, ?> var1, Function<ArgumentBuilder<CommandSourceStack, ?>, ArgumentBuilder<CommandSourceStack, ?>> var2);
    }

    static interface DataManipulator {
        public int m_139495_(CommandContext<CommandSourceStack> var1, CompoundTag var2, NbtPathArgument.NbtPath var3, List<Tag> var4) throws CommandSyntaxException;
    }

    static interface DataManipulatorDecorator {
        public ArgumentBuilder<CommandSourceStack, ?> m_139500_(DataManipulator var1);
    }
}

