/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.gui;

import com.google.common.collect.Lists;
import com.mojang.util.QueueLogAppender;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EtchedBorder;
import javax.swing.border.TitledBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import net.minecraft.DefaultUncaughtExceptionHandler;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.gui.PlayerListComponent;
import net.minecraft.server.gui.StatsComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MinecraftServerGui
extends JComponent {
    private static final Font f_139899_ = new Font("Monospaced", 0, 12);
    private static final Logger f_139900_ = LogManager.getLogger();
    private static final String f_142884_ = "Minecraft server";
    private static final String f_142885_ = "Minecraft server - shutting down!";
    private final DedicatedServer f_139901_;
    private Thread f_139902_;
    private final Collection<Runnable> f_139903_ = Lists.newArrayList();
    final AtomicBoolean f_139904_ = new AtomicBoolean();

    public static MinecraftServerGui m_139921_(final DedicatedServer p_139922_) {
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
        final JFrame jFrame = new JFrame(f_142884_);
        final MinecraftServerGui \u00e2\u02dc\u01922 = new MinecraftServerGui(p_139922_);
        jFrame.setDefaultCloseOperation(2);
        jFrame.add(\u00e2\u02dc\u01922);
        jFrame.pack();
        jFrame.setLocationRelativeTo(null);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent p_139944_) {
                if (!\u00e2\u02dc\u01922.f_139904_.getAndSet(true)) {
                    jFrame.setTitle(MinecraftServerGui.f_142885_);
                    p_139922_.m_7570_(true);
                    \u00e2\u02dc\u01922.m_139935_();
                }
            }
        });
        \u00e2\u02dc\u01922.m_139909_(jFrame::dispose);
        \u00e2\u02dc\u01922.m_139908_();
        return \u00e2\u02dc\u01922;
    }

    private MinecraftServerGui(DedicatedServer p_139907_) {
        this.f_139901_ = p_139907_;
        this.setPreferredSize(new Dimension(854, 480));
        this.setLayout(new BorderLayout());
        try {
            this.add((Component)this.m_139934_(), "Center");
            this.add((Component)this.m_139932_(), "West");
        }
        catch (Exception exception) {
            f_139900_.error("Couldn't build server GUI", (Throwable)exception);
        }
    }

    public void m_139909_(Runnable p_139910_) {
        this.f_139903_.add(p_139910_);
    }

    private JComponent m_139932_() {
        JPanel jPanel = new JPanel(new BorderLayout());
        StatsComponent \u00e2\u02dc\u01922 = new StatsComponent(this.f_139901_);
        this.f_139903_.add(\u00e2\u02dc\u01922::m_139964_);
        jPanel.add((Component)\u00e2\u02dc\u01922, "North");
        jPanel.add((Component)this.m_139933_(), "Center");
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Stats"));
        return jPanel;
    }

    private JComponent m_139933_() {
        PlayerListComponent playerListComponent = new PlayerListComponent(this.f_139901_);
        JScrollPane \u00e2\u02dc\u01922 = new JScrollPane(playerListComponent, 22, 30);
        \u00e2\u02dc\u01922.setBorder(new TitledBorder(new EtchedBorder(), "Players"));
        return \u00e2\u02dc\u01922;
    }

    private JComponent m_139934_() {
        JPanel jPanel = new JPanel(new BorderLayout());
        JTextArea \u00e2\u02dc\u01922 = new JTextArea();
        JScrollPane \u00e2\u02dc\u01923 = new JScrollPane(\u00e2\u02dc\u01922, 22, 30);
        \u00e2\u02dc\u01922.setEditable(false);
        \u00e2\u02dc\u01922.setFont(f_139899_);
        JTextField \u00e2\u02dc\u01924 = new JTextField();
        \u00e2\u02dc\u01924.addActionListener(p_139920_ -> {
            String string = \u00e2\u02dc\u01924.getText().trim();
            if (!string.isEmpty()) {
                this.f_139901_.m_139645_(string, this.f_139901_.m_129893_());
            }
            \u00e2\u02dc\u01924.setText("");
        });
        \u00e2\u02dc\u01922.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent p_139949_) {
            }
        });
        jPanel.add((Component)\u00e2\u02dc\u01923, "Center");
        jPanel.add((Component)\u00e2\u02dc\u01924, "South");
        jPanel.setBorder(new TitledBorder(new EtchedBorder(), "Log and chat"));
        this.f_139902_ = new Thread(() -> {
            String string;
            while ((string = QueueLogAppender.getNextLogEvent((String)"ServerGuiConsole")) != null) {
                this.m_139914_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, string);
            }
        });
        this.f_139902_.setUncaughtExceptionHandler(new DefaultUncaughtExceptionHandler(f_139900_));
        this.f_139902_.setDaemon(true);
        return jPanel;
    }

    public void m_139908_() {
        this.f_139902_.start();
    }

    public void m_139925_() {
        if (!this.f_139904_.getAndSet(true)) {
            this.m_139935_();
        }
    }

    void m_139935_() {
        this.f_139903_.forEach(Runnable::run);
    }

    public void m_139914_(JTextArea p_139915_, JScrollPane p_139916_, String p_139917_) {
        if (!SwingUtilities.isEventDispatchThread()) {
            SwingUtilities.invokeLater(() -> this.m_139914_(p_139915_, p_139916_, p_139917_));
            return;
        }
        Document document = p_139915_.getDocument();
        JScrollBar \u00e2\u02dc\u01922 = p_139916_.getVerticalScrollBar();
        boolean \u00e2\u02dc\u01923 = false;
        if (p_139916_.getViewport().getView() == p_139915_) {
            \u00e2\u02dc\u01923 = (double)\u00e2\u02dc\u01922.getValue() + \u00e2\u02dc\u01922.getSize().getHeight() + (double)(f_139899_.getSize() * 4) > (double)\u00e2\u02dc\u01922.getMaximum();
        }
        try {
            document.insertString(document.getLength(), p_139917_, null);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        if (\u00e2\u02dc\u01923) {
            \u00e2\u02dc\u01922.setValue(Integer.MAX_VALUE);
        }
    }
}

