/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Queues;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFixer;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BooleanSupplier;
import java.util.function.IntFunction;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.Util;
import net.minecraft.core.SectionPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacket;
import net.minecraft.network.protocol.game.ClientboundLightUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkTaskPriorityQueue;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.PlayerMap;
import net.minecraft.server.level.ServerEntity;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.ThreadedLevelLightEngine;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.util.thread.BlockableEventLoop;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.util.thread.ProcessorMailbox;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.ImposterProtoChunk;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LightChunkGetter;
import net.minecraft.world.level.chunk.ProtoChunk;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.chunk.storage.ChunkSerializer;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.entity.ChunkStatusUpdateListener;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ChunkMap
extends ChunkStorage
implements ChunkHolder.PlayerProvider {
    private static final byte f_143034_ = -1;
    private static final byte f_143035_ = 0;
    private static final byte f_143036_ = 1;
    private static final Logger f_140128_ = LogManager.getLogger();
    private static final int f_143037_ = 200;
    private static final int f_143038_ = 3;
    public static final int f_143032_ = 33;
    public static final int f_140127_ = 33 + ChunkStatus.m_62421_();
    public static final int f_143033_ = 31;
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140129_ = new Long2ObjectLinkedOpenHashMap();
    private volatile Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140130_ = this.f_140129_.clone();
    private final Long2ObjectLinkedOpenHashMap<ChunkHolder> f_140131_ = new Long2ObjectLinkedOpenHashMap();
    private final LongSet f_140132_ = new LongOpenHashSet();
    final ServerLevel f_140133_;
    private final ThreadedLevelLightEngine f_140134_;
    private final BlockableEventLoop<Runnable> f_140135_;
    private final ChunkGenerator f_140136_;
    private final Supplier<DimensionDataStorage> f_140137_;
    private final PoiManager f_140138_;
    final LongSet f_140139_ = new LongOpenHashSet();
    private boolean f_140140_;
    private final ChunkTaskPriorityQueueSorter f_140141_;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140142_;
    private final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140143_;
    private final ChunkProgressListener f_140144_;
    private final ChunkStatusUpdateListener f_143031_;
    private final DistanceManager f_140145_;
    private final AtomicInteger f_140146_ = new AtomicInteger();
    private final StructureManager f_140147_;
    private final String f_182284_;
    private final PlayerMap f_140149_ = new PlayerMap();
    private final Int2ObjectMap<TrackedEntity> f_140150_ = new Int2ObjectOpenHashMap();
    private final Long2ByteMap f_140151_ = new Long2ByteOpenHashMap();
    private final Queue<Runnable> f_140125_ = Queues.newConcurrentLinkedQueue();
    int f_140126_;

    public ChunkMap(ServerLevel p_143040_, LevelStorageSource.LevelStorageAccess p_143041_, DataFixer p_143042_, StructureManager p_143043_, Executor p_143044_, BlockableEventLoop<Runnable> p_143045_, LightChunkGetter p_143046_, ChunkGenerator p_143047_, ChunkProgressListener p_143048_, ChunkStatusUpdateListener p_143049_, Supplier<DimensionDataStorage> p_143050_, int p_143051_, boolean p_143052_) {
        super(new File(p_143041_.m_78299_(p_143040_.m_46472_()), "region"), p_143042_, p_143052_);
        this.f_140147_ = p_143043_;
        File file = p_143041_.m_78299_(p_143040_.m_46472_());
        this.f_182284_ = file.getName();
        this.f_140133_ = p_143040_;
        this.f_140136_ = p_143047_;
        this.f_140135_ = p_143045_;
        ProcessorMailbox<Runnable> \u00e2\u02dc\u01922 = ProcessorMailbox.m_18751_(p_143044_, "worldgen");
        ProcessorHandle<Runnable> \u00e2\u02dc\u01923 = ProcessorHandle.m_18714_("main", p_143045_::m_6937_);
        this.f_140144_ = p_143048_;
        this.f_143031_ = p_143049_;
        ProcessorMailbox<Runnable> \u00e2\u02dc\u01924 = ProcessorMailbox.m_18751_(p_143044_, "light");
        this.f_140141_ = new ChunkTaskPriorityQueueSorter((List<ProcessorHandle<?>>)ImmutableList.of(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924), p_143044_, Integer.MAX_VALUE);
        this.f_140142_ = this.f_140141_.m_140604_(\u00e2\u02dc\u01922, false);
        this.f_140143_ = this.f_140141_.m_140604_(\u00e2\u02dc\u01923, false);
        this.f_140134_ = new ThreadedLevelLightEngine(p_143046_, this, this.f_140133_.m_6042_().m_63935_(), \u00e2\u02dc\u01924, this.f_140141_.m_140604_(\u00e2\u02dc\u01924, false));
        this.f_140145_ = new DistanceManager(p_143044_, p_143045_);
        this.f_140137_ = p_143050_;
        this.f_140138_ = new PoiManager(new File(file, "poi"), p_143042_, p_143052_, p_143040_);
        this.m_140167_(p_143051_);
    }

    private static double m_140226_(ChunkPos p_140227_, Entity p_140228_) {
        double d = SectionPos.m_175554_(p_140227_.f_45578_, 8);
        \u00e2\u02dc\u0192 = SectionPos.m_175554_(p_140227_.f_45579_, 8);
        \u00e2\u02dc\u0192 = d - p_140228_.m_20185_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - p_140228_.m_20189_();
        return \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
    }

    private static int m_140338_(ChunkPos p_140339_, ServerPlayer p_140340_, boolean p_140341_) {
        int \u00e2\u02dc\u01923;
        int \u00e2\u02dc\u01922;
        if (p_140341_) {
            SectionPos sectionPos = p_140340_.m_8965_();
            \u00e2\u02dc\u01922 = sectionPos.m_123170_();
            \u00e2\u02dc\u01923 = sectionPos.m_123222_();
        } else {
            \u00e2\u02dc\u01922 = SectionPos.m_123171_(p_140340_.m_146903_());
            \u00e2\u02dc\u01923 = SectionPos.m_123171_(p_140340_.m_146907_());
        }
        return ChunkMap.m_140206_(p_140339_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
    }

    private static int m_143119_(ChunkPos p_143120_, Entity p_143121_) {
        return ChunkMap.m_140206_(p_143120_, SectionPos.m_123171_(p_143121_.m_146903_()), SectionPos.m_123171_(p_143121_.m_146907_()));
    }

    private static int m_140206_(ChunkPos p_140207_, int p_140208_, int p_140209_) {
        int n = p_140207_.f_45578_ - p_140208_;
        \u00e2\u02dc\u0192 = p_140207_.f_45579_ - p_140209_;
        return Math.max(Math.abs(n), Math.abs(\u00e2\u02dc\u0192));
    }

    protected ThreadedLevelLightEngine m_140166_() {
        return this.f_140134_;
    }

    @Nullable
    protected ChunkHolder m_140174_(long p_140175_) {
        return (ChunkHolder)this.f_140129_.get(p_140175_);
    }

    @Nullable
    protected ChunkHolder m_140327_(long p_140328_) {
        return (ChunkHolder)this.f_140130_.get(p_140328_);
    }

    protected IntSupplier m_140371_(long p_140372_) {
        return () -> {
            ChunkHolder chunkHolder = this.m_140327_(p_140372_);
            if (chunkHolder == null) {
                return ChunkTaskPriorityQueue.f_140508_ - 1;
            }
            return Math.min(chunkHolder.m_140094_(), ChunkTaskPriorityQueue.f_140508_ - 1);
        };
    }

    public String m_140204_(ChunkPos p_140205_) {
        ChunkHolder chunkHolder = this.m_140327_(p_140205_.m_45588_());
        if (chunkHolder == null) {
            return "null";
        }
        String \u00e2\u02dc\u01922 = chunkHolder.m_140093_() + "\n";
        ChunkStatus \u00e2\u02dc\u01923 = chunkHolder.m_140088_();
        ChunkAccess \u00e2\u02dc\u01924 = chunkHolder.m_140089_();
        if (\u00e2\u02dc\u01923 != null) {
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922 + "St: \u00a7" + \u00e2\u02dc\u01923.m_62445_() + \u00e2\u02dc\u01923 + "\u00a7r\n";
        }
        if (\u00e2\u02dc\u01924 != null) {
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922 + "Ch: \u00a7" + \u00e2\u02dc\u01924.m_6415_().m_62445_() + \u00e2\u02dc\u01924.m_6415_() + "\u00a7r\n";
        }
        ChunkHolder.FullChunkStatus \u00e2\u02dc\u01925 = chunkHolder.m_140091_();
        \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922 + "\u00a7" + \u00e2\u02dc\u01925.ordinal() + \u00e2\u02dc\u01925;
        return \u00e2\u02dc\u01922 + "\u00a7r";
    }

    private CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> m_140210_(ChunkPos p_140211_, final int p_140212_, IntFunction<ChunkStatus> p_140213_) {
        ArrayList arrayList = Lists.newArrayList();
        final int \u00e2\u02dc\u01922 = p_140211_.f_45578_;
        final int \u00e2\u02dc\u01923 = p_140211_.f_45579_;
        for (int i = -p_140212_; i <= p_140212_; ++i) {
            for (\u00e2\u02dc\u0192 = -p_140212_; \u00e2\u02dc\u0192 <= p_140212_; ++\u00e2\u02dc\u0192) {
                \u00e2\u02dc\u0192 = Math.max(Math.abs(\u00e2\u02dc\u0192), Math.abs(i));
                final ChunkPos chunkPos = new ChunkPos(\u00e2\u02dc\u01922 + \u00e2\u02dc\u0192, \u00e2\u02dc\u01923 + i);
                long \u00e2\u02dc\u01924 = chunkPos.m_45588_();
                ChunkHolder \u00e2\u02dc\u01925 = this.m_140174_(\u00e2\u02dc\u01924);
                if (\u00e2\u02dc\u01925 == null) {
                    return CompletableFuture.completedFuture(Either.right((Object)new ChunkHolder.ChunkLoadingFailure(){

                        public String toString() {
                            return "Unloaded " + chunkPos;
                        }
                    }));
                }
                ChunkStatus \u00e2\u02dc\u01926 = p_140213_.apply(\u00e2\u02dc\u0192);
                CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> \u00e2\u02dc\u01927 = \u00e2\u02dc\u01925.m_140049_(\u00e2\u02dc\u01926, this);
                arrayList.add(\u00e2\u02dc\u01927);
            }
        }
        CompletableFuture completableFuture = Util.m_137567_(arrayList);
        return completableFuture.thenApply(p_140173_ -> {
            ArrayList arrayList = Lists.newArrayList();
            int \u00e2\u02dc\u01922 = 0;
            for (final Either either : p_140173_) {
                Optional optional = either.left();
                if (!optional.isPresent()) {
                    final int n = \u00e2\u02dc\u01922;
                    return Either.right((Object)new ChunkHolder.ChunkLoadingFailure(){

                        public String toString() {
                            return "Unloaded " + new ChunkPos(\u00e2\u02dc\u01922 + n % (p_140212_ * 2 + 1), \u00e2\u02dc\u01923 + n / (p_140212_ * 2 + 1)) + " " + either.right().get();
                        }
                    });
                }
                arrayList.add((ChunkAccess)optional.get());
                ++\u00e2\u02dc\u01922;
            }
            return Either.left((Object)arrayList);
        });
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143117_(ChunkPos p_143118_) {
        return this.m_140210_(p_143118_, 2, p_143129_ -> ChunkStatus.f_62326_).thenApplyAsync(p_143137_ -> p_143137_.mapLeft(p_143139_ -> (LevelChunk)p_143139_.get(p_143139_.size() / 2)), (Executor)this.f_140135_);
    }

    @Nullable
    ChunkHolder m_140176_(long p_140177_, int p_140178_, @Nullable ChunkHolder p_140179_, int p_140180_) {
        if (p_140180_ > f_140127_ && p_140178_ > f_140127_) {
            return p_140179_;
        }
        if (p_140179_ != null) {
            p_140179_.m_140027_(p_140178_);
        }
        if (p_140179_ != null) {
            if (p_140178_ > f_140127_) {
                this.f_140139_.add(p_140177_);
            } else {
                this.f_140139_.remove(p_140177_);
            }
        }
        if (p_140178_ <= f_140127_ && p_140179_ == null) {
            p_140179_ = (ChunkHolder)this.f_140131_.remove(p_140177_);
            if (p_140179_ != null) {
                p_140179_.m_140027_(p_140178_);
            } else {
                p_140179_ = new ChunkHolder(new ChunkPos(p_140177_), p_140178_, this.f_140133_, this.f_140134_, this.f_140141_, this);
            }
            this.f_140129_.put(p_140177_, (Object)p_140179_);
            this.f_140140_ = true;
        }
        return p_140179_;
    }

    @Override
    public void close() throws IOException {
        try {
            this.f_140141_.close();
            this.f_140138_.close();
        }
        finally {
            super.close();
        }
    }

    protected void m_140318_(boolean p_140319_) {
        if (p_140319_) {
            List list = this.f_140130_.values().stream().filter(ChunkHolder::m_140095_).peek(ChunkHolder::m_140096_).collect(Collectors.toList());
            MutableBoolean \u00e2\u02dc\u01922 = new MutableBoolean();
            do {
                \u00e2\u02dc\u01922.setFalse();
                list.stream().map(p_140420_ -> {
                    CompletableFuture<ChunkAccess> completableFuture;
                    do {
                        completableFuture = p_140420_.m_140090_();
                        this.f_140135_.m_18701_(completableFuture::isDone);
                    } while (completableFuture != p_140420_.m_140090_());
                    return completableFuture.join();
                }).filter(p_140400_ -> p_140400_ instanceof ImposterProtoChunk || p_140400_ instanceof LevelChunk).filter(this::m_140258_).forEach(p_140284_ -> \u00e2\u02dc\u01922.setTrue());
            } while (\u00e2\u02dc\u01922.isTrue());
            this.m_140353_(() -> true);
            this.m_63514_();
        } else {
            this.f_140130_.values().stream().filter(ChunkHolder::m_140095_).forEach(p_140412_ -> {
                ChunkAccess chunkAccess = p_140412_.m_140090_().getNow(null);
                if (chunkAccess instanceof ImposterProtoChunk || chunkAccess instanceof LevelChunk) {
                    this.m_140258_(chunkAccess);
                    p_140412_.m_140096_();
                }
            });
        }
    }

    protected void m_140280_(BooleanSupplier p_140281_) {
        ProfilerFiller profilerFiller = this.f_140133_.m_46473_();
        profilerFiller.m_6180_("poi");
        this.f_140138_.m_6202_(p_140281_);
        profilerFiller.m_6182_("chunk_unload");
        if (!this.f_140133_.m_7441_()) {
            this.m_140353_(p_140281_);
        }
        profilerFiller.m_7238_();
    }

    private void m_140353_(BooleanSupplier p_140354_) {
        LongIterator longIterator = this.f_140139_.iterator();
        int \u00e2\u02dc\u01922 = 0;
        while (longIterator.hasNext() && (p_140354_.getAsBoolean() || \u00e2\u02dc\u01922 < 200 || this.f_140139_.size() > 2000)) {
            long l = longIterator.nextLong();
            ChunkHolder \u00e2\u02dc\u01923 = (ChunkHolder)this.f_140129_.remove(l);
            if (\u00e2\u02dc\u01923 != null) {
                this.f_140131_.put(l, (Object)\u00e2\u02dc\u01923);
                this.f_140140_ = true;
                ++\u00e2\u02dc\u01922;
                this.m_140181_(l, \u00e2\u02dc\u01923);
            }
            longIterator.remove();
        }
        while ((p_140354_.getAsBoolean() || this.f_140125_.size() > 2000) && (\u00e2\u02dc\u0192 = this.f_140125_.poll()) != null) {
            \u00e2\u02dc\u0192.run();
        }
    }

    private void m_140181_(long p_140182_, ChunkHolder p_140183_) {
        CompletableFuture<ChunkAccess> completableFuture = p_140183_.m_140090_();
        ((CompletableFuture)completableFuture.thenAcceptAsync(p_140309_ -> {
            CompletableFuture<ChunkAccess> completableFuture = p_140183_.m_140090_();
            if (completableFuture != completableFuture) {
                this.m_140181_(p_140182_, p_140183_);
                return;
            }
            if (this.f_140131_.remove(p_140182_, (Object)p_140183_) && p_140309_ != null) {
                if (p_140309_ instanceof LevelChunk) {
                    ((LevelChunk)p_140309_).m_62913_(false);
                }
                this.m_140258_((ChunkAccess)p_140309_);
                if (this.f_140132_.remove(p_140182_) && p_140309_ instanceof LevelChunk) {
                    LevelChunk levelChunk = (LevelChunk)p_140309_;
                    this.f_140133_.m_8712_(levelChunk);
                }
                this.f_140134_.m_9330_(p_140309_.m_7697_());
                this.f_140134_.m_9409_();
                this.f_140144_.m_5511_(p_140309_.m_7697_(), null);
            }
        }, this.f_140125_::add)).whenComplete((p_140303_, p_140304_) -> {
            if (p_140304_ != null) {
                f_140128_.error("Failed to save chunk {}", (Object)p_140183_.m_140092_(), p_140304_);
            }
        });
    }

    protected boolean m_140324_() {
        if (!this.f_140140_) {
            return false;
        }
        this.f_140130_ = this.f_140129_.clone();
        this.f_140140_ = false;
        return true;
    }

    public CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140292_(ChunkHolder p_140293_, ChunkStatus p_140294_) {
        ChunkPos chunkPos = p_140293_.m_140092_();
        if (p_140294_ == ChunkStatus.f_62314_) {
            return this.m_140417_(chunkPos);
        }
        if (p_140294_ == ChunkStatus.f_62323_) {
            this.f_140145_.m_140792_(TicketType.f_9446_, chunkPos, 33 + ChunkStatus.m_62370_(ChunkStatus.f_62323_), chunkPos);
        }
        if ((\u00e2\u02dc\u0192 = p_140293_.m_140049_(p_140294_.m_62482_(), this).getNow(ChunkHolder.f_139995_).left()).isPresent() && ((ChunkAccess)\u00e2\u02dc\u0192.get()).m_6415_().m_62427_(p_140294_)) {
            CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> completableFuture = p_140294_.m_62364_(this.f_140133_, this.f_140147_, this.f_140134_, p_143132_ -> this.m_140383_(p_140293_), (ChunkAccess)\u00e2\u02dc\u0192.get());
            this.f_140144_.m_5511_(chunkPos, p_140294_);
            return completableFuture;
        }
        return this.m_140360_(p_140293_, p_140294_);
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140417_(ChunkPos p_140418_) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                this.f_140133_.m_46473_().m_6174_("chunkLoad");
                CompoundTag compoundTag = this.m_140427_(p_140418_);
                if (compoundTag != null) {
                    boolean bl = \u00e2\u02dc\u0192 = compoundTag.m_128425_("Level", 10) && compoundTag.m_128469_("Level").m_128425_("Status", 8);
                    if (\u00e2\u02dc\u0192) {
                        ProtoChunk protoChunk = ChunkSerializer.m_63457_(this.f_140133_, this.f_140147_, this.f_140138_, p_140418_, compoundTag);
                        this.m_140229_(p_140418_, protoChunk.m_6415_().m_62494_());
                        return Either.left((Object)protoChunk);
                    }
                    f_140128_.error("Chunk file at {} is missing level data, skipping", (Object)p_140418_);
                }
            }
            catch (ReportedException reportedException) {
                Throwable throwable = reportedException.getCause();
                if (throwable instanceof IOException) {
                    f_140128_.error("Couldn't load chunk {}", (Object)p_140418_, (Object)throwable);
                }
                this.m_140422_(p_140418_);
                throw reportedException;
            }
            catch (Exception exception) {
                f_140128_.error("Couldn't load chunk {}", (Object)p_140418_, (Object)exception);
            }
            this.m_140422_(p_140418_);
            return Either.left((Object)new ProtoChunk(p_140418_, UpgradeData.f_63320_, this.f_140133_));
        }, this.f_140135_);
    }

    private void m_140422_(ChunkPos p_140423_) {
        this.f_140151_.put(p_140423_.m_45588_(), (byte)-1);
    }

    private byte m_140229_(ChunkPos p_140230_, ChunkStatus.ChunkType p_140231_) {
        return this.f_140151_.put(p_140230_.m_45588_(), p_140231_ == ChunkStatus.ChunkType.PROTOCHUNK ? (byte)-1 : 1);
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140360_(ChunkHolder p_140361_, ChunkStatus p_140362_) {
        ChunkPos chunkPos = p_140361_.m_140092_();
        CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> \u00e2\u02dc\u01922 = this.m_140210_(chunkPos, p_140362_.m_62488_(), p_140346_ -> this.m_140262_(p_140362_, p_140346_));
        this.f_140133_.m_46473_().m_6525_(() -> "chunkGenerate " + p_140362_.m_62467_());
        Executor \u00e2\u02dc\u01923 = p_143148_ -> this.f_140142_.m_6937_(ChunkTaskPriorityQueueSorter.m_140642_(p_140361_, p_143148_));
        return \u00e2\u02dc\u01922.thenComposeAsync(p_143083_ -> (CompletionStage)p_143083_.map(p_143089_ -> {
            try {
                CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> completableFuture = p_140362_.m_156212_(\u00e2\u02dc\u01923, this.f_140133_, this.f_140136_, this.f_140147_, this.f_140134_, p_143113_ -> this.m_140383_(p_140361_), (List<ChunkAccess>)p_143089_);
                this.f_140144_.m_5511_(chunkPos, p_140362_);
                return completableFuture;
            }
            catch (Exception exception) {
                exception.getStackTrace();
                CrashReport crashReport = CrashReport.m_127521_(exception, "Exception generating new chunk");
                CrashReportCategory \u00e2\u02dc\u01922 = crashReport.m_127514_("Chunk to be generated");
                \u00e2\u02dc\u01922.m_128159_("Location", String.format("%d,%d", p_180959_.f_45578_, p_180959_.f_45579_));
                \u00e2\u02dc\u01922.m_128159_("Position hash", ChunkPos.m_45589_(p_180959_.f_45578_, p_180959_.f_45579_));
                \u00e2\u02dc\u01922.m_128159_("Generator", this.f_140136_);
                throw new ReportedException(crashReport);
            }
        }, p_143074_ -> {
            this.m_140375_(chunkPos);
            return CompletableFuture.completedFuture(Either.right((Object)p_143074_));
        }), \u00e2\u02dc\u01923);
    }

    protected void m_140375_(ChunkPos p_140376_) {
        this.f_140135_.m_6937_(Util.m_137474_(() -> this.f_140145_.m_140823_(TicketType.f_9446_, p_140376_, 33 + ChunkStatus.m_62370_(ChunkStatus.f_62323_), p_140376_), () -> "release light ticket " + p_140376_));
    }

    private ChunkStatus m_140262_(ChunkStatus p_140263_, int p_140264_) {
        ChunkStatus chunkStatus = p_140264_ == 0 ? p_140263_.m_62482_() : ChunkStatus.m_156185_(ChunkStatus.m_62370_(p_140263_) + p_140264_);
        return chunkStatus;
    }

    private static void m_143064_(ServerLevel p_143065_, List<CompoundTag> p_143066_) {
        if (!p_143066_.isEmpty()) {
            p_143065_.m_143327_(EntityType.m_147045_(p_143066_, p_143065_));
        }
    }

    private CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> m_140383_(ChunkHolder p_140384_) {
        CompletableFuture<Either<ChunkAccess, ChunkHolder.ChunkLoadingFailure>> completableFuture = p_140384_.m_140047_(ChunkStatus.f_62326_.m_62482_());
        return completableFuture.thenApplyAsync(p_143060_ -> {
            ChunkStatus chunkStatus = ChunkHolder.m_140074_(p_140384_.m_140093_());
            if (!chunkStatus.m_62427_(ChunkStatus.f_62326_)) {
                return ChunkHolder.f_139995_;
            }
            return p_143060_.mapLeft(p_143057_ -> {
                LevelChunk levelChunk;
                ChunkPos chunkPos = p_140384_.m_140092_();
                ProtoChunk \u00e2\u02dc\u01922 = (ProtoChunk)p_143057_;
                if (\u00e2\u02dc\u01922 instanceof ImposterProtoChunk) {
                    levelChunk = ((ImposterProtoChunk)\u00e2\u02dc\u01922).m_62768_();
                } else {
                    levelChunk = new LevelChunk(this.f_140133_, \u00e2\u02dc\u01922, p_143098_ -> ChunkMap.m_143064_(this.f_140133_, \u00e2\u02dc\u01922.m_63293_()));
                    p_140384_.m_140052_(new ImposterProtoChunk(levelChunk));
                }
                levelChunk.m_62879_(() -> ChunkHolder.m_140083_(p_140384_.m_140093_()));
                levelChunk.m_62952_();
                if (this.f_140132_.add(chunkPos.m_45588_())) {
                    levelChunk.m_62913_(true);
                    levelChunk.m_156369_();
                }
                return levelChunk;
            });
        }, p_143144_ -> this.f_140143_.m_6937_(ChunkTaskPriorityQueueSorter.m_140624_(p_143144_, p_140384_.m_140092_().m_45588_(), p_140384_::m_140093_)));
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143053_(ChunkHolder p_143054_) {
        ChunkPos chunkPos = p_143054_.m_140092_();
        CompletableFuture<Either<List<ChunkAccess>, ChunkHolder.ChunkLoadingFailure>> \u00e2\u02dc\u01922 = this.m_140210_(chunkPos, 1, p_143108_ -> ChunkStatus.f_62326_);
        CompletionStage \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.thenApplyAsync(p_143125_ -> p_143125_.flatMap(p_143127_ -> {
            LevelChunk levelChunk = (LevelChunk)p_143127_.get(p_143127_.size() / 2);
            levelChunk.m_62812_();
            return Either.left((Object)levelChunk);
        }), p_143135_ -> this.f_140143_.m_6937_(ChunkTaskPriorityQueueSorter.m_140642_(p_143054_, p_143135_)));
        ((CompletableFuture)\u00e2\u02dc\u01923).thenAcceptAsync(p_143095_ -> p_143095_.ifLeft(p_143092_ -> {
            this.f_140146_.getAndIncrement();
            Packet[] packetArray = new Packet[2];
            this.m_5960_(chunkPos, false).forEach(p_143106_ -> this.m_140195_((ServerPlayer)p_143106_, packetArray, (LevelChunk)p_143092_));
        }), p_143116_ -> this.f_140143_.m_6937_(ChunkTaskPriorityQueueSorter.m_140642_(p_143054_, p_143116_)));
        return \u00e2\u02dc\u01923;
    }

    public CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> m_143109_(ChunkHolder p_143110_) {
        return this.m_140210_(p_143110_.m_140092_(), 1, ChunkStatus::m_156185_).thenApplyAsync(p_143100_ -> p_143100_.mapLeft(p_143102_ -> {
            LevelChunk levelChunk = (LevelChunk)p_143102_.get(p_143102_.size() / 2);
            levelChunk.m_62813_();
            return levelChunk;
        }), p_143063_ -> this.f_140143_.m_6937_(ChunkTaskPriorityQueueSorter.m_140642_(p_143110_, p_143063_)));
    }

    public int m_140368_() {
        return this.f_140146_.get();
    }

    private boolean m_140258_(ChunkAccess p_140259_) {
        this.f_140138_.m_63796_(p_140259_.m_7697_());
        if (!p_140259_.m_6344_()) {
            return false;
        }
        p_140259_.m_8092_(false);
        ChunkPos chunkPos = p_140259_.m_7697_();
        try {
            ChunkStatus chunkStatus = p_140259_.m_6415_();
            if (chunkStatus.m_62494_() != ChunkStatus.ChunkType.LEVELCHUNK) {
                if (this.m_140425_(chunkPos)) {
                    return false;
                }
                if (chunkStatus == ChunkStatus.f_62314_ && p_140259_.m_6633_().values().stream().noneMatch(StructureStart::m_73603_)) {
                    return false;
                }
            }
            this.f_140133_.m_46473_().m_6174_("chunkSave");
            CompoundTag \u00e2\u02dc\u01922 = ChunkSerializer.m_63454_(this.f_140133_, p_140259_);
            this.m_63502_(chunkPos, \u00e2\u02dc\u01922);
            this.m_140229_(chunkPos, chunkStatus.m_62494_());
            return true;
        }
        catch (Exception exception) {
            f_140128_.error("Failed to save chunk {},{}", (Object)chunkPos.f_45578_, (Object)chunkPos.f_45579_, (Object)exception);
            return false;
        }
    }

    private boolean m_140425_(ChunkPos p_140426_) {
        byte by = this.f_140151_.get(p_140426_.m_45588_());
        if (by != 0) {
            return by == 1;
        }
        try {
            CompoundTag compoundTag = this.m_140427_(p_140426_);
            if (compoundTag == null) {
                this.m_140422_(p_140426_);
                return false;
            }
        }
        catch (Exception exception) {
            f_140128_.error("Failed to read chunk {}", (Object)p_140426_, (Object)exception);
            this.m_140422_(p_140426_);
            return false;
        }
        ChunkStatus.ChunkType chunkType = ChunkSerializer.m_63485_(compoundTag);
        return this.m_140229_(p_140426_, chunkType) == 1;
    }

    protected void m_140167_(int p_140168_) {
        int n = Mth.m_14045_(p_140168_ + 1, 3, 33);
        if (n != this.f_140126_) {
            \u00e2\u02dc\u0192 = this.f_140126_;
            this.f_140126_ = n;
            this.f_140145_.m_140777_(this.f_140126_);
            for (ChunkHolder chunkHolder : this.f_140129_.values()) {
                ChunkPos chunkPos = chunkHolder.m_140092_();
                Packet[] \u00e2\u02dc\u01922 = new Packet[2];
                this.m_5960_(chunkPos, false).forEach(p_143071_ -> {
                    int n = ChunkMap.m_140338_(chunkPos, p_143071_, true);
                    boolean \u00e2\u02dc\u01922 = n <= \u00e2\u02dc\u0192;
                    boolean \u00e2\u02dc\u01923 = n <= this.f_140126_;
                    this.m_140186_((ServerPlayer)p_143071_, chunkPos, \u00e2\u02dc\u01922, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
                });
            }
        }
    }

    protected void m_140186_(ServerPlayer p_140187_, ChunkPos p_140188_, Packet<?>[] p_140189_, boolean p_140190_, boolean p_140191_) {
        ChunkHolder chunkHolder;
        if (p_140187_.f_19853_ != this.f_140133_) {
            return;
        }
        if (p_140191_ && !p_140190_ && (chunkHolder = this.m_140327_(p_140188_.m_45588_())) != null) {
            LevelChunk levelChunk = chunkHolder.m_140085_();
            if (levelChunk != null) {
                this.m_140195_(p_140187_, p_140189_, levelChunk);
            }
            DebugPackets.m_133676_(this.f_140133_, p_140188_);
        }
        if (!p_140191_ && p_140190_) {
            p_140187_.m_9088_(p_140188_);
        }
    }

    public int m_140394_() {
        return this.f_140130_.size();
    }

    protected net.minecraft.server.level.DistanceManager m_143145_() {
        return this.f_140145_;
    }

    protected Iterable<ChunkHolder> m_140416_() {
        return Iterables.unmodifiableIterable((Iterable)this.f_140130_.values());
    }

    void m_140274_(Writer p_140275_) throws IOException {
        CsvOutput csvOutput = CsvOutput.m_13619_().m_13630_("x").m_13630_("z").m_13630_("level").m_13630_("in_memory").m_13630_("status").m_13630_("full_status").m_13630_("accessible_ready").m_13630_("ticking_ready").m_13630_("entity_ticking_ready").m_13630_("ticket").m_13630_("spawning").m_13630_("block_entity_count").m_13628_(p_140275_);
        for (Long2ObjectMap.Entry entry : this.f_140130_.long2ObjectEntrySet()) {
            ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
            ChunkHolder \u00e2\u02dc\u01922 = (ChunkHolder)entry.getValue();
            Optional<ChunkAccess> \u00e2\u02dc\u01923 = Optional.ofNullable(\u00e2\u02dc\u01922.m_140089_());
            Optional<Object> \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.flatMap(p_143123_ -> p_143123_ instanceof LevelChunk ? Optional.of((LevelChunk)p_143123_) : Optional.empty());
            csvOutput.m_13624_(chunkPos.f_45578_, chunkPos.f_45579_, \u00e2\u02dc\u01922.m_140093_(), \u00e2\u02dc\u01923.isPresent(), \u00e2\u02dc\u01923.map(ChunkAccess::m_6415_).orElse(null), \u00e2\u02dc\u01924.map(LevelChunk::m_6708_).orElse(null), ChunkMap.m_140278_(\u00e2\u02dc\u01922.m_140082_()), ChunkMap.m_140278_(\u00e2\u02dc\u01922.m_140026_()), ChunkMap.m_140278_(\u00e2\u02dc\u01922.m_140073_()), this.f_140145_.m_140838_(entry.getLongKey()), !this.m_140397_(chunkPos), \u00e2\u02dc\u01924.map(p_140402_ -> p_140402_.m_62954_().size()).orElse(0));
        }
    }

    private static String m_140278_(CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> p_140279_) {
        try {
            Either either = p_140279_.getNow(null);
            if (either != null) {
                return (String)either.map(p_140380_ -> "done", p_140286_ -> "unloaded");
            }
            return "not completed";
        }
        catch (CompletionException completionException) {
            return "failed " + completionException.getCause().getMessage();
        }
        catch (CancellationException cancellationException) {
            return "cancelled";
        }
    }

    @Nullable
    private CompoundTag m_140427_(ChunkPos p_140428_) throws IOException {
        CompoundTag compoundTag = this.m_63512_(p_140428_);
        if (compoundTag == null) {
            return null;
        }
        return this.m_63507_(this.f_140133_.m_46472_(), this.f_140137_, compoundTag);
    }

    boolean m_140397_(ChunkPos p_140398_) {
        long l = p_140398_.m_45588_();
        if (!this.f_140145_.m_140847_(l)) {
            return true;
        }
        return this.f_140149_.m_8243_(l).noneMatch(p_140221_ -> !p_140221_.m_5833_() && ChunkMap.m_140226_(p_140398_, p_140221_) < 16384.0);
    }

    private boolean m_140329_(ServerPlayer p_140330_) {
        return p_140330_.m_5833_() && !this.f_140133_.m_46469_().m_46207_(GameRules.f_46146_);
    }

    void m_140192_(ServerPlayer p_140193_, boolean p_140194_) {
        boolean bl = this.m_140329_(p_140193_);
        \u00e2\u02dc\u0192 = this.f_140149_.m_8260_(p_140193_);
        int \u00e2\u02dc\u01922 = SectionPos.m_123171_(p_140193_.m_146903_());
        int \u00e2\u02dc\u01923 = SectionPos.m_123171_(p_140193_.m_146907_());
        if (p_140194_) {
            this.f_140149_.m_8252_(ChunkPos.m_45589_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923), p_140193_, bl);
            this.m_140373_(p_140193_);
            if (!bl) {
                this.f_140145_.m_140802_(SectionPos.m_123194_(p_140193_), p_140193_);
            }
        } else {
            SectionPos sectionPos = p_140193_.m_8965_();
            this.f_140149_.m_8249_(sectionPos.m_123251_().m_45588_(), p_140193_);
            if (!\u00e2\u02dc\u0192) {
                this.f_140145_.m_140828_(sectionPos, p_140193_);
            }
        }
        for (int i = \u00e2\u02dc\u01922 - this.f_140126_; i <= \u00e2\u02dc\u01922 + this.f_140126_; ++i) {
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 - this.f_140126_; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u01923 + this.f_140126_; ++\u00e2\u02dc\u0192) {
                ChunkPos chunkPos = new ChunkPos(i, \u00e2\u02dc\u0192);
                this.m_140186_(p_140193_, chunkPos, new Packet[2], !p_140194_, p_140194_);
            }
        }
    }

    private SectionPos m_140373_(ServerPlayer p_140374_) {
        SectionPos sectionPos = SectionPos.m_123194_(p_140374_);
        p_140374_.m_9119_(sectionPos);
        p_140374_.f_8906_.m_141995_(new ClientboundSetChunkCacheCenterPacket(sectionPos.m_123170_(), sectionPos.m_123222_()));
        return sectionPos;
    }

    public void m_140184_(ServerPlayer p_140185_) {
        for (TrackedEntity trackedEntity : this.f_140150_.values()) {
            if (trackedEntity.f_140472_ == p_140185_) {
                trackedEntity.m_140487_(this.f_140133_.m_6907_());
                continue;
            }
            trackedEntity.m_140497_(p_140185_);
        }
        int n = SectionPos.m_123171_(p_140185_.m_146903_());
        \u00e2\u02dc\u0192 = SectionPos.m_123171_(p_140185_.m_146907_());
        SectionPos \u00e2\u02dc\u01922 = p_140185_.m_8965_();
        SectionPos \u00e2\u02dc\u01923 = SectionPos.m_123194_(p_140185_);
        long \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_123251_().m_45588_();
        long \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.m_123251_().m_45588_();
        boolean \u00e2\u02dc\u01926 = this.f_140149_.m_8262_(p_140185_);
        boolean \u00e2\u02dc\u01927 = this.m_140329_(p_140185_);
        boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_123252_() != \u00e2\u02dc\u01923.m_123252_();
        if (\u00e2\u02dc\u0192 || \u00e2\u02dc\u01926 != \u00e2\u02dc\u01927) {
            this.m_140373_(p_140185_);
            if (!\u00e2\u02dc\u01926) {
                this.f_140145_.m_140828_(\u00e2\u02dc\u01922, p_140185_);
            }
            if (!\u00e2\u02dc\u01927) {
                this.f_140145_.m_140802_(\u00e2\u02dc\u01923, p_140185_);
            }
            if (!\u00e2\u02dc\u01926 && \u00e2\u02dc\u01927) {
                this.f_140149_.m_8256_(p_140185_);
            }
            if (\u00e2\u02dc\u01926 && !\u00e2\u02dc\u01927) {
                this.f_140149_.m_8258_(p_140185_);
            }
            if (\u00e2\u02dc\u01924 != \u00e2\u02dc\u01925) {
                this.f_140149_.m_8245_(\u00e2\u02dc\u01924, \u00e2\u02dc\u01925, p_140185_);
            }
        }
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_123170_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_123222_();
        if (Math.abs(\u00e2\u02dc\u0192 - n) <= this.f_140126_ * 2 && Math.abs(\u00e2\u02dc\u0192 - \u00e2\u02dc\u0192) <= this.f_140126_ * 2) {
            \u00e2\u02dc\u0192 = Math.min(n, \u00e2\u02dc\u0192) - this.f_140126_;
            \u00e2\u02dc\u0192 = Math.min(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192) - this.f_140126_;
            \u00e2\u02dc\u0192 = Math.max(n, \u00e2\u02dc\u0192) + this.f_140126_;
            \u00e2\u02dc\u0192 = Math.max(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192) + this.f_140126_;
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    ChunkPos chunkPos = new ChunkPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    boolean \u00e2\u02dc\u01928 = ChunkMap.m_140206_(chunkPos, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192) <= this.f_140126_;
                    boolean \u00e2\u02dc\u01929 = ChunkMap.m_140206_(chunkPos, n, \u00e2\u02dc\u0192) <= this.f_140126_;
                    this.m_140186_(p_140185_, chunkPos, new Packet[2], \u00e2\u02dc\u01928, \u00e2\u02dc\u01929);
                }
            }
        } else {
            boolean \u00e2\u02dc\u019211;
            boolean \u00e2\u02dc\u019210;
            ChunkPos chunkPos;
            int n2;
            for (n2 = \u00e2\u02dc\u0192 - this.f_140126_; n2 <= \u00e2\u02dc\u0192 + this.f_140126_; ++n2) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - this.f_140126_; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192 + this.f_140126_; ++\u00e2\u02dc\u0192) {
                    chunkPos = new ChunkPos(n2, \u00e2\u02dc\u0192);
                    \u00e2\u02dc\u019210 = true;
                    \u00e2\u02dc\u019211 = false;
                    this.m_140186_(p_140185_, chunkPos, new Packet[2], true, false);
                }
            }
            for (n2 = n - this.f_140126_; n2 <= n + this.f_140126_; ++n2) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - this.f_140126_; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192 + this.f_140126_; ++\u00e2\u02dc\u0192) {
                    chunkPos = new ChunkPos(n2, \u00e2\u02dc\u0192);
                    \u00e2\u02dc\u019210 = false;
                    \u00e2\u02dc\u019211 = true;
                    this.m_140186_(p_140185_, chunkPos, new Packet[2], false, true);
                }
            }
        }
    }

    @Override
    public Stream<ServerPlayer> m_5960_(ChunkPos p_140252_, boolean p_140253_) {
        return this.f_140149_.m_8243_(p_140252_.m_45588_()).filter(p_140257_ -> {
            int n = ChunkMap.m_140338_(p_140252_, p_140257_, true);
            if (n > this.f_140126_) {
                return false;
            }
            return !p_140253_ || n == this.f_140126_;
        });
    }

    protected void m_140199_(Entity p_140200_) {
        if (p_140200_ instanceof EnderDragonPart) {
            return;
        }
        EntityType<?> entityType = p_140200_.m_6095_();
        int \u00e2\u02dc\u01922 = entityType.m_20681_() * 16;
        if (\u00e2\u02dc\u01922 == 0) {
            return;
        }
        int \u00e2\u02dc\u01923 = entityType.m_20682_();
        if (this.f_140150_.containsKey(p_140200_.m_142049_())) {
            throw Util.m_137570_(new IllegalStateException("Entity is already tracked!"));
        }
        TrackedEntity \u00e2\u02dc\u01924 = new TrackedEntity(p_140200_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, entityType.m_20683_());
        this.f_140150_.put(p_140200_.m_142049_(), (Object)\u00e2\u02dc\u01924);
        \u00e2\u02dc\u01924.m_140487_(this.f_140133_.m_6907_());
        if (p_140200_ instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)p_140200_;
            this.m_140192_(serverPlayer, true);
            for (TrackedEntity trackedEntity : this.f_140150_.values()) {
                if (trackedEntity.f_140472_ == serverPlayer) continue;
                trackedEntity.m_140497_(serverPlayer);
            }
        }
    }

    protected void m_140331_(Entity p_140332_) {
        Object object;
        if (p_140332_ instanceof ServerPlayer) {
            object = (ServerPlayer)p_140332_;
            this.m_140192_((ServerPlayer)object, false);
            for (TrackedEntity trackedEntity : this.f_140150_.values()) {
                trackedEntity.m_140485_((ServerPlayer)object);
            }
        }
        if ((object = (TrackedEntity)this.f_140150_.remove(p_140332_.m_142049_())) != null) {
            ((TrackedEntity)object).m_140482_();
        }
    }

    protected void m_140421_() {
        ArrayList arrayList = Lists.newArrayList();
        List<ServerPlayer> \u00e2\u02dc\u01922 = this.f_140133_.m_6907_();
        for (TrackedEntity trackedEntity2 : this.f_140150_.values()) {
            TrackedEntity trackedEntity2;
            SectionPos sectionPos = trackedEntity2.f_140474_;
            \u00e2\u02dc\u0192 = SectionPos.m_123194_(trackedEntity2.f_140472_);
            if (!Objects.equals(sectionPos, \u00e2\u02dc\u0192)) {
                trackedEntity2.m_140487_(\u00e2\u02dc\u01922);
                Entity entity = trackedEntity2.f_140472_;
                if (entity instanceof ServerPlayer) {
                    arrayList.add((ServerPlayer)entity);
                }
                trackedEntity2.f_140474_ = \u00e2\u02dc\u0192;
            }
            trackedEntity2.f_140471_.m_8533_();
        }
        if (!arrayList.isEmpty()) {
            for (TrackedEntity trackedEntity2 : this.f_140150_.values()) {
                trackedEntity2.m_140487_(arrayList);
            }
        }
    }

    public void m_140201_(Entity p_140202_, Packet<?> p_140203_) {
        TrackedEntity trackedEntity = (TrackedEntity)this.f_140150_.get(p_140202_.m_142049_());
        if (trackedEntity != null) {
            trackedEntity.m_140489_(p_140203_);
        }
    }

    protected void m_140333_(Entity p_140334_, Packet<?> p_140335_) {
        TrackedEntity trackedEntity = (TrackedEntity)this.f_140150_.get(p_140334_.m_142049_());
        if (trackedEntity != null) {
            trackedEntity.m_140499_(p_140335_);
        }
    }

    private void m_140195_(ServerPlayer p_140196_, Packet<?>[] p_140197_, LevelChunk p_140198_) {
        ArrayList arrayList;
        if (p_140197_[0] == null) {
            p_140197_[0] = new ClientboundLevelChunkPacket(p_140198_);
            p_140197_[1] = new ClientboundLightUpdatePacket(p_140198_.m_7697_(), this.f_140134_, null, null, true);
        }
        p_140196_.m_9090_(p_140198_.m_7697_(), p_140197_[0], p_140197_[1]);
        DebugPackets.m_133676_(this.f_140133_, p_140198_.m_7697_());
        ArrayList arrayList2 = Lists.newArrayList();
        arrayList = Lists.newArrayList();
        for (Object object : this.f_140150_.values()) {
            Entity entity = ((TrackedEntity)object).f_140472_;
            if (entity == p_140196_ || !entity.m_146902_().equals(p_140198_.m_7697_())) continue;
            ((TrackedEntity)object).m_140497_(p_140196_);
            if (entity instanceof Mob && ((Mob)entity).m_21524_() != null) {
                arrayList2.add(entity);
            }
            if (entity.m_20197_().isEmpty()) continue;
            arrayList.add(entity);
        }
        if (!arrayList2.isEmpty()) {
            for (Object object : arrayList2) {
                p_140196_.f_8906_.m_141995_(new ClientboundSetEntityLinkPacket((Entity)object, ((Mob)object).m_21524_()));
            }
        }
        if (!arrayList.isEmpty()) {
            for (Object object : arrayList) {
                p_140196_.f_8906_.m_141995_(new ClientboundSetPassengersPacket((Entity)object));
            }
        }
    }

    protected PoiManager m_140424_() {
        return this.f_140138_;
    }

    public String m_182285_() {
        return this.f_182284_;
    }

    public CompletableFuture<Void> m_140270_(LevelChunk p_140271_) {
        return this.f_140135_.m_18707_(() -> p_140271_.m_62823_(this.f_140133_));
    }

    void m_143075_(ChunkPos p_143076_, ChunkHolder.FullChunkStatus p_143077_) {
        this.f_143031_.m_156794_(p_143076_, p_143077_);
    }

    class DistanceManager
    extends net.minecraft.server.level.DistanceManager {
        protected DistanceManager(Executor p_140459_, Executor p_140460_) {
            super(p_140459_, p_140460_);
        }

        @Override
        protected boolean m_7009_(long p_140462_) {
            return ChunkMap.this.f_140139_.contains(p_140462_);
        }

        @Override
        @Nullable
        protected ChunkHolder m_7316_(long p_140469_) {
            return ChunkMap.this.m_140174_(p_140469_);
        }

        @Override
        @Nullable
        protected ChunkHolder m_7288_(long p_140464_, int p_140465_, @Nullable ChunkHolder p_140466_, int p_140467_) {
            return ChunkMap.this.m_140176_(p_140464_, p_140465_, p_140466_, p_140467_);
        }
    }

    class TrackedEntity {
        final ServerEntity f_140471_;
        final Entity f_140472_;
        private final int f_140473_;
        SectionPos f_140474_;
        private final Set<ServerPlayerConnection> f_140475_ = Sets.newIdentityHashSet();

        public TrackedEntity(Entity p_140478_, int p_140479_, int p_140480_, boolean p_140481_) {
            this.f_140471_ = new ServerEntity(ChunkMap.this.f_140133_, p_140478_, p_140480_, p_140481_, this::m_140489_);
            this.f_140472_ = p_140478_;
            this.f_140473_ = p_140479_;
            this.f_140474_ = SectionPos.m_123194_(p_140478_);
        }

        public boolean equals(Object p_140506_) {
            if (p_140506_ instanceof TrackedEntity) {
                return ((TrackedEntity)p_140506_).f_140472_.m_142049_() == this.f_140472_.m_142049_();
            }
            return false;
        }

        public int hashCode() {
            return this.f_140472_.m_142049_();
        }

        public void m_140489_(Packet<?> p_140490_) {
            for (ServerPlayerConnection serverPlayerConnection : this.f_140475_) {
                serverPlayerConnection.m_141995_(p_140490_);
            }
        }

        public void m_140499_(Packet<?> p_140500_) {
            this.m_140489_(p_140500_);
            if (this.f_140472_ instanceof ServerPlayer) {
                ((ServerPlayer)this.f_140472_).f_8906_.m_141995_(p_140500_);
            }
        }

        public void m_140482_() {
            for (ServerPlayerConnection serverPlayerConnection : this.f_140475_) {
                this.f_140471_.m_8534_(serverPlayerConnection.m_142253_());
            }
        }

        public void m_140485_(ServerPlayer p_140486_) {
            if (this.f_140475_.remove(p_140486_.f_8906_)) {
                this.f_140471_.m_8534_(p_140486_);
            }
        }

        public void m_140497_(ServerPlayer p_140498_) {
            if (p_140498_ == this.f_140472_) {
                return;
            }
            Vec3 vec3 = p_140498_.m_20182_().m_82546_(this.f_140471_.m_8540_());
            int \u00e2\u02dc\u01922 = Math.min(this.m_140496_(), (ChunkMap.this.f_140126_ - 1) * 16);
            boolean bl = \u00e2\u02dc\u0192 = vec3.f_82479_ >= (double)(-\u00e2\u02dc\u01922) && vec3.f_82479_ <= (double)\u00e2\u02dc\u01922 && vec3.f_82481_ >= (double)(-\u00e2\u02dc\u01922) && vec3.f_82481_ <= (double)\u00e2\u02dc\u01922 && this.f_140472_.m_6459_(p_140498_);
            if (\u00e2\u02dc\u0192) {
                if (this.f_140475_.add(p_140498_.f_8906_)) {
                    this.f_140471_.m_8541_(p_140498_);
                }
            } else if (this.f_140475_.remove(p_140498_.f_8906_)) {
                this.f_140471_.m_8534_(p_140498_);
            }
        }

        private int m_140483_(int p_140484_) {
            return ChunkMap.this.f_140133_.m_142572_().m_7186_(p_140484_);
        }

        private int m_140496_() {
            int n = this.f_140473_;
            for (Entity entity : this.f_140472_.m_146897_()) {
                int n2 = entity.m_6095_().m_20681_() * 16;
                if (n2 <= n) continue;
                n = n2;
            }
            return this.m_140483_(n);
        }

        public void m_140487_(List<ServerPlayer> p_140488_) {
            for (ServerPlayer serverPlayer : p_140488_) {
                this.m_140497_(serverPlayer);
            }
        }
    }
}

