/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.mojang.datafixers.util.Either;
import it.unimi.dsi.fastutil.longs.Long2ByteMap;
import it.unimi.dsi.fastutil.longs.Long2ByteOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2IntMap;
import it.unimi.dsi.fastutil.longs.Long2IntMaps;
import it.unimi.dsi.fastutil.longs.Long2IntOpenHashMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Nullable;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ChunkHolder;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ChunkTaskPriorityQueueSorter;
import net.minecraft.server.level.ChunkTracker;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.SortedArraySet;
import net.minecraft.util.thread.ProcessorHandle;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class DistanceManager {
    static final Logger f_140758_ = LogManager.getLogger();
    private static final int f_143205_ = 2;
    static final int f_140759_ = 33 + ChunkStatus.m_62370_(ChunkStatus.f_62326_) - 2;
    private static final int f_143206_ = 4;
    final Long2ObjectMap<ObjectSet<ServerPlayer>> f_140760_ = new Long2ObjectOpenHashMap();
    final Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> f_140761_ = new Long2ObjectOpenHashMap();
    private final ChunkTicketTracker f_140762_ = new ChunkTicketTracker();
    private final FixedPlayerDistanceChunkTracker f_140763_ = new FixedPlayerDistanceChunkTracker(8);
    private final PlayerTicketTracker f_140764_ = new PlayerTicketTracker(33);
    final Set<ChunkHolder> f_140765_ = Sets.newHashSet();
    final ChunkTaskPriorityQueueSorter f_140766_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Message<Runnable>> f_140767_;
    final ProcessorHandle<ChunkTaskPriorityQueueSorter.Release> f_140768_;
    final LongSet f_140769_ = new LongOpenHashSet();
    final Executor f_140770_;
    private long f_140771_;

    protected DistanceManager(Executor p_140774_, Executor p_140775_) {
        ProcessorHandle<Runnable> processorHandle = ProcessorHandle.m_18714_("player ticket throttler", p_140775_::execute);
        this.f_140766_ = \u00e2\u02dc\u0192 = new ChunkTaskPriorityQueueSorter((List<ProcessorHandle<?>>)ImmutableList.of(processorHandle), p_140774_, 4);
        this.f_140767_ = \u00e2\u02dc\u0192.m_140604_(processorHandle, true);
        this.f_140768_ = \u00e2\u02dc\u0192.m_140567_(processorHandle);
        this.f_140770_ = p_140775_;
    }

    protected void m_140776_() {
        ++this.f_140771_;
        ObjectIterator objectIterator = this.f_140761_.long2ObjectEntrySet().fastIterator();
        while (objectIterator.hasNext()) {
            Long2ObjectMap.Entry entry = (Long2ObjectMap.Entry)objectIterator.next();
            if (((SortedArraySet)entry.getValue()).removeIf(p_140822_ -> p_140822_.m_9434_(this.f_140771_))) {
                this.f_140762_.m_140715_(entry.getLongKey(), DistanceManager.m_140797_((SortedArraySet)entry.getValue()), false);
            }
            if (!((SortedArraySet)entry.getValue()).isEmpty()) continue;
            objectIterator.remove();
        }
    }

    private static int m_140797_(SortedArraySet<Ticket<?>> p_140798_) {
        return !p_140798_.isEmpty() ? p_140798_.m_14262_().m_9433_() : ChunkMap.f_140127_ + 1;
    }

    protected abstract boolean m_7009_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7316_(long var1);

    @Nullable
    protected abstract ChunkHolder m_7288_(long var1, int var3, @Nullable ChunkHolder var4, int var5);

    public boolean m_140805_(ChunkMap p_140806_) {
        this.f_140763_.m_6410_();
        this.f_140764_.m_6410_();
        int n = Integer.MAX_VALUE - this.f_140762_.m_140877_(Integer.MAX_VALUE);
        boolean bl = \u00e2\u02dc\u0192 = n != 0;
        if (\u00e2\u02dc\u0192) {
            // empty if block
        }
        if (!this.f_140765_.isEmpty()) {
            this.f_140765_.forEach(p_140809_ -> p_140809_.m_143003_(p_140806_, this.f_140770_));
            this.f_140765_.clear();
            return true;
        }
        if (!this.f_140769_.isEmpty()) {
            LongIterator longIterator = this.f_140769_.iterator();
            while (longIterator.hasNext()) {
                long l = longIterator.nextLong();
                if (!this.m_140857_(l).stream().anyMatch(p_140791_ -> p_140791_.m_9428_() == TicketType.f_9444_)) continue;
                ChunkHolder \u00e2\u02dc\u01922 = p_140806_.m_140174_(l);
                if (\u00e2\u02dc\u01922 == null) {
                    throw new IllegalStateException();
                }
                CompletableFuture<Either<LevelChunk, ChunkHolder.ChunkLoadingFailure>> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_140073_();
                \u00e2\u02dc\u01923.thenAccept(p_140789_ -> this.f_140770_.execute(() -> this.f_140768_.m_6937_(ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, l, false))));
            }
            this.f_140769_.clear();
        }
        return \u00e2\u02dc\u0192;
    }

    void m_140784_(long p_140785_, Ticket<?> p_140786_) {
        SortedArraySet<Ticket<?>> sortedArraySet = this.m_140857_(p_140785_);
        int \u00e2\u02dc\u01922 = DistanceManager.m_140797_(sortedArraySet);
        Ticket<?> \u00e2\u02dc\u01923 = sortedArraySet.m_14253_(p_140786_);
        \u00e2\u02dc\u01923.m_9429_(this.f_140771_);
        if (p_140786_.m_9433_() < \u00e2\u02dc\u01922) {
            this.f_140762_.m_140715_(p_140785_, p_140786_.m_9433_(), true);
        }
    }

    void m_140818_(long p_140819_, Ticket<?> p_140820_) {
        SortedArraySet<Ticket<?>> sortedArraySet = this.m_140857_(p_140819_);
        if (sortedArraySet.remove(p_140820_)) {
            // empty if block
        }
        if (sortedArraySet.isEmpty()) {
            this.f_140761_.remove(p_140819_);
        }
        this.f_140762_.m_140715_(p_140819_, DistanceManager.m_140797_(sortedArraySet), false);
    }

    public <T> void m_140792_(TicketType<T> p_140793_, ChunkPos p_140794_, int p_140795_, T p_140796_) {
        this.m_140784_(p_140794_.m_45588_(), new Ticket<T>(p_140793_, p_140795_, p_140796_));
    }

    public <T> void m_140823_(TicketType<T> p_140824_, ChunkPos p_140825_, int p_140826_, T p_140827_) {
        Ticket<T> ticket = new Ticket<T>(p_140824_, p_140826_, p_140827_);
        this.m_140818_(p_140825_.m_45588_(), ticket);
    }

    public <T> void m_140840_(TicketType<T> p_140841_, ChunkPos p_140842_, int p_140843_, T p_140844_) {
        this.m_140784_(p_140842_.m_45588_(), new Ticket<T>(p_140841_, 33 - p_140843_, p_140844_));
    }

    public <T> void m_140849_(TicketType<T> p_140850_, ChunkPos p_140851_, int p_140852_, T p_140853_) {
        Ticket<T> ticket = new Ticket<T>(p_140850_, 33 - p_140852_, p_140853_);
        this.m_140818_(p_140851_.m_45588_(), ticket);
    }

    private SortedArraySet<Ticket<?>> m_140857_(long p_140858_) {
        return (SortedArraySet)this.f_140761_.computeIfAbsent(p_140858_, p_140867_ -> SortedArraySet.m_14246_(4));
    }

    protected void m_140799_(ChunkPos p_140800_, boolean p_140801_) {
        Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.f_9445_, 31, p_140800_);
        if (p_140801_) {
            this.m_140784_(p_140800_.m_45588_(), ticket);
        } else {
            this.m_140818_(p_140800_.m_45588_(), ticket);
        }
    }

    public void m_140802_(SectionPos p_140803_, ServerPlayer p_140804_) {
        long l = p_140803_.m_123251_().m_45588_();
        ((ObjectSet)this.f_140760_.computeIfAbsent(l, p_140863_ -> new ObjectOpenHashSet())).add((Object)p_140804_);
        this.f_140763_.m_140715_(l, 0, true);
        this.f_140764_.m_140715_(l, 0, true);
    }

    public void m_140828_(SectionPos p_140829_, ServerPlayer p_140830_) {
        long l = p_140829_.m_123251_().m_45588_();
        ObjectSet \u00e2\u02dc\u01922 = (ObjectSet)this.f_140760_.get(l);
        \u00e2\u02dc\u01922.remove((Object)p_140830_);
        if (\u00e2\u02dc\u01922.isEmpty()) {
            this.f_140760_.remove(l);
            this.f_140763_.m_140715_(l, Integer.MAX_VALUE, false);
            this.f_140764_.m_140715_(l, Integer.MAX_VALUE, false);
        }
    }

    protected String m_140838_(long p_140839_) {
        SortedArraySet sortedArraySet = (SortedArraySet)this.f_140761_.get(p_140839_);
        String \u00e2\u02dc\u01922 = sortedArraySet == null || sortedArraySet.isEmpty() ? "no_ticket" : ((Ticket)sortedArraySet.m_14262_()).toString();
        return \u00e2\u02dc\u01922;
    }

    protected void m_140777_(int p_140778_) {
        this.f_140764_.m_140912_(p_140778_);
    }

    public int m_140816_() {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.size();
    }

    public boolean m_140847_(long p_140848_) {
        this.f_140763_.m_6410_();
        return this.f_140763_.f_140886_.containsKey(p_140848_);
    }

    public String m_140837_() {
        return this.f_140766_.m_140558_();
    }

    private void m_143207_(String p_143208_) {
        try (FileOutputStream fileOutputStream = new FileOutputStream(new File(p_143208_));){
            for (Long2ObjectMap.Entry entry : this.f_140761_.long2ObjectEntrySet()) {
                ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
                for (Ticket ticket : (SortedArraySet)entry.getValue()) {
                    fileOutputStream.write((chunkPos.f_45578_ + "\t" + chunkPos.f_45579_ + "\t" + ticket.m_9428_() + "\t" + ticket.m_9433_() + "\t\n").getBytes(StandardCharsets.UTF_8));
                }
            }
        }
        catch (IOException iOException) {
            f_140758_.error((Object)iOException);
        }
    }

    class ChunkTicketTracker
    extends ChunkTracker {
        public ChunkTicketTracker() {
            super(ChunkMap.f_140127_ + 2, 16, 256);
        }

        @Override
        protected int m_7031_(long p_140883_) {
            SortedArraySet sortedArraySet = (SortedArraySet)DistanceManager.this.f_140761_.get(p_140883_);
            if (sortedArraySet == null) {
                return Integer.MAX_VALUE;
            }
            if (sortedArraySet.isEmpty()) {
                return Integer.MAX_VALUE;
            }
            return ((Ticket)sortedArraySet.m_14262_()).m_9433_();
        }

        @Override
        protected int m_6172_(long p_140885_) {
            ChunkHolder chunkHolder;
            if (!DistanceManager.this.m_7009_(p_140885_) && (chunkHolder = DistanceManager.this.m_7316_(p_140885_)) != null) {
                return chunkHolder.m_140093_();
            }
            return ChunkMap.f_140127_ + 1;
        }

        @Override
        protected void m_7351_(long p_140880_, int p_140881_) {
            ChunkHolder chunkHolder = DistanceManager.this.m_7316_(p_140880_);
            int n = \u00e2\u02dc\u0192 = chunkHolder == null ? ChunkMap.f_140127_ + 1 : chunkHolder.m_140093_();
            if (\u00e2\u02dc\u0192 == p_140881_) {
                return;
            }
            if ((chunkHolder = DistanceManager.this.m_7288_(p_140880_, p_140881_, chunkHolder, \u00e2\u02dc\u0192)) != null) {
                DistanceManager.this.f_140765_.add(chunkHolder);
            }
        }

        public int m_140877_(int p_140878_) {
            return this.m_75588_(p_140878_);
        }
    }

    class FixedPlayerDistanceChunkTracker
    extends ChunkTracker {
        protected final Long2ByteMap f_140886_;
        protected final int f_140887_;

        protected FixedPlayerDistanceChunkTracker(int p_140891_) {
            super(p_140891_ + 2, 16, 256);
            this.f_140886_ = new Long2ByteOpenHashMap();
            this.f_140887_ = p_140891_;
            this.f_140886_.defaultReturnValue((byte)(p_140891_ + 2));
        }

        @Override
        protected int m_6172_(long p_140901_) {
            return this.f_140886_.get(p_140901_);
        }

        @Override
        protected void m_7351_(long p_140893_, int p_140894_) {
            byte by = p_140894_ > this.f_140887_ ? this.f_140886_.remove(p_140893_) : this.f_140886_.put(p_140893_, (byte)p_140894_);
            this.m_8002_(p_140893_, by, p_140894_);
        }

        protected void m_8002_(long p_140895_, int p_140896_, int p_140897_) {
        }

        @Override
        protected int m_7031_(long p_140899_) {
            return this.m_140902_(p_140899_) ? 0 : Integer.MAX_VALUE;
        }

        private boolean m_140902_(long p_140903_) {
            ObjectSet objectSet = (ObjectSet)DistanceManager.this.f_140760_.get(p_140903_);
            return objectSet != null && !objectSet.isEmpty();
        }

        public void m_6410_() {
            this.m_75588_(Integer.MAX_VALUE);
        }

        private void m_143212_(String p_143213_) {
            try (FileOutputStream fileOutputStream = new FileOutputStream(new File(p_143213_));){
                for (Long2ByteMap.Entry entry : this.f_140886_.long2ByteEntrySet()) {
                    ChunkPos chunkPos = new ChunkPos(entry.getLongKey());
                    String \u00e2\u02dc\u01922 = Byte.toString(entry.getByteValue());
                    fileOutputStream.write((chunkPos.f_45578_ + "\t" + chunkPos.f_45579_ + "\t" + \u00e2\u02dc\u01922 + "\n").getBytes(StandardCharsets.UTF_8));
                }
            }
            catch (IOException iOException) {
                f_140758_.error((Object)iOException);
            }
        }
    }

    class PlayerTicketTracker
    extends FixedPlayerDistanceChunkTracker {
        private int f_140905_;
        private final Long2IntMap f_140906_;
        private final LongSet f_140907_;

        protected PlayerTicketTracker(int p_140910_) {
            super(p_140910_);
            this.f_140906_ = Long2IntMaps.synchronize((Long2IntMap)new Long2IntOpenHashMap());
            this.f_140907_ = new LongOpenHashSet();
            this.f_140905_ = 0;
            this.f_140906_.defaultReturnValue(p_140910_ + 2);
        }

        @Override
        protected void m_8002_(long p_140915_, int p_140916_, int p_140917_) {
            this.f_140907_.add(p_140915_);
        }

        public void m_140912_(int p_140913_) {
            for (Long2ByteMap.Entry entry : this.f_140886_.long2ByteEntrySet()) {
                byte by = entry.getByteValue();
                long \u00e2\u02dc\u01922 = entry.getLongKey();
                this.m_140918_(\u00e2\u02dc\u01922, by, this.m_140932_(by), by <= p_140913_ - 2);
            }
            this.f_140905_ = p_140913_;
        }

        private void m_140918_(long p_140919_, int p_140920_, boolean p_140921_, boolean p_140922_) {
            if (p_140921_ != p_140922_) {
                Ticket<ChunkPos> ticket = new Ticket<ChunkPos>(TicketType.f_9444_, f_140759_, new ChunkPos(p_140919_));
                if (p_140922_) {
                    DistanceManager.this.f_140767_.m_6937_(ChunkTaskPriorityQueueSorter.m_140624_(() -> DistanceManager.this.f_140770_.execute(() -> {
                        if (this.m_140932_(this.m_6172_(p_140919_))) {
                            DistanceManager.this.m_140784_(p_140919_, ticket);
                            DistanceManager.this.f_140769_.add(p_140919_);
                        } else {
                            DistanceManager.this.f_140768_.m_6937_(ChunkTaskPriorityQueueSorter.m_140628_(() -> {}, p_140919_, false));
                        }
                    }), p_140919_, () -> p_140920_));
                } else {
                    DistanceManager.this.f_140768_.m_6937_(ChunkTaskPriorityQueueSorter.m_140628_(() -> DistanceManager.this.f_140770_.execute(() -> DistanceManager.this.m_140818_(p_140919_, ticket)), p_140919_, true));
                }
            }
        }

        @Override
        public void m_6410_() {
            super.m_6410_();
            if (!this.f_140907_.isEmpty()) {
                LongIterator longIterator = this.f_140907_.iterator();
                while (longIterator.hasNext()) {
                    long l = longIterator.nextLong();
                    int \u00e2\u02dc\u01922 = this.f_140906_.get(l);
                    if (\u00e2\u02dc\u01922 == (\u00e2\u02dc\u0192 = this.m_6172_(l))) continue;
                    DistanceManager.this.f_140766_.m_6250_(new ChunkPos(l), () -> this.f_140906_.get(l), \u00e2\u02dc\u0192, p_140928_ -> {
                        if (p_140928_ >= this.f_140906_.defaultReturnValue()) {
                            this.f_140906_.remove(l);
                        } else {
                            this.f_140906_.put(l, p_140928_);
                        }
                    });
                    this.m_140918_(l, \u00e2\u02dc\u0192, this.m_140932_(\u00e2\u02dc\u01922), this.m_140932_(\u00e2\u02dc\u0192));
                }
                this.f_140907_.clear();
            }
        }

        private boolean m_140932_(int p_140933_) {
            return p_140933_ <= this.f_140905_ - 2;
        }
    }
}

