/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.protocol.game.ClientboundMoveEntityPacket;
import net.minecraft.network.protocol.game.ClientboundRemoveEntitiesPacket;
import net.minecraft.network.protocol.game.ClientboundRotateHeadPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityDataPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityLinkPacket;
import net.minecraft.network.protocol.game.ClientboundSetEntityMotionPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateAttributesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.MapItem;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerEntity {
    private static final Logger f_8508_ = LogManager.getLogger();
    private static final int f_143241_ = 1;
    private final ServerLevel f_8509_;
    private final Entity f_8510_;
    private final int f_8511_;
    private final boolean f_8512_;
    private final Consumer<Packet<?>> f_8513_;
    private long f_8514_;
    private long f_8515_;
    private long f_8516_;
    private int f_8517_;
    private int f_8518_;
    private int f_8519_;
    private Vec3 f_8520_ = Vec3.f_82478_;
    private int f_8521_;
    private int f_8522_;
    private List<Entity> f_8523_ = Collections.emptyList();
    private boolean f_8524_;
    private boolean f_8525_;

    public ServerEntity(ServerLevel p_8528_, Entity p_8529_, int p_8530_, boolean p_8531_, Consumer<Packet<?>> p_8532_) {
        this.f_8509_ = p_8528_;
        this.f_8513_ = p_8532_;
        this.f_8510_ = p_8529_;
        this.f_8511_ = p_8530_;
        this.f_8512_ = p_8531_;
        this.m_8544_();
        this.f_8517_ = Mth.m_14143_(p_8529_.m_146908_() * 256.0f / 360.0f);
        this.f_8518_ = Mth.m_14143_(p_8529_.m_146909_() * 256.0f / 360.0f);
        this.f_8519_ = Mth.m_14143_(p_8529_.m_6080_() * 256.0f / 360.0f);
        this.f_8525_ = p_8529_.m_20096_();
    }

    public void m_8533_() {
        List<Entity> list = this.f_8510_.m_20197_();
        if (!list.equals(this.f_8523_)) {
            this.f_8523_ = list;
            this.f_8513_.accept(new ClientboundSetPassengersPacket(this.f_8510_));
        }
        if (this.f_8510_ instanceof ItemFrame && this.f_8521_ % 10 == 0) {
            ItemFrame itemFrame = (ItemFrame)this.f_8510_;
            ItemStack \u00e2\u02dc\u01922 = itemFrame.m_31822_();
            if (\u00e2\u02dc\u01922.m_41720_() instanceof MapItem && (\u00e2\u02dc\u0192 = MapItem.m_151128_((Integer)(\u00e2\u02dc\u01923 = MapItem.m_151131_(\u00e2\u02dc\u01922)), this.f_8509_)) != null) {
                for (ServerPlayer serverPlayer : this.f_8509_.m_6907_()) {
                    \u00e2\u02dc\u0192.m_77918_(serverPlayer, \u00e2\u02dc\u01922);
                    Packet<?> packet = \u00e2\u02dc\u0192.m_164796_((Integer)\u00e2\u02dc\u01923, serverPlayer);
                    if (packet == null) continue;
                    serverPlayer.f_8906_.m_141995_(packet);
                }
            }
            this.m_8543_();
        }
        if (this.f_8521_ % this.f_8511_ == 0 || this.f_8510_.f_19812_ || this.f_8510_.m_20088_().m_135352_()) {
            int n;
            if (this.f_8510_.m_20159_()) {
                n = Mth.m_14143_(this.f_8510_.m_146908_() * 256.0f / 360.0f);
                \u00e2\u02dc\u0192 = Mth.m_14143_(this.f_8510_.m_146909_() * 256.0f / 360.0f);
                boolean bl = \u00e2\u02dc\u0192 = Math.abs(n - this.f_8517_) >= 1 || Math.abs(\u00e2\u02dc\u0192 - this.f_8518_) >= 1;
                if (\u00e2\u02dc\u0192) {
                    this.f_8513_.accept(new ClientboundMoveEntityPacket.Rot(this.f_8510_.m_142049_(), (byte)n, (byte)\u00e2\u02dc\u0192, this.f_8510_.m_20096_()));
                    this.f_8517_ = n;
                    this.f_8518_ = \u00e2\u02dc\u0192;
                }
                this.m_8544_();
                this.m_8543_();
                this.f_8524_ = true;
            } else {
                boolean bl;
                double d;
                ++this.f_8522_;
                n = Mth.m_14143_(this.f_8510_.m_146908_() * 256.0f / 360.0f);
                \u00e2\u02dc\u0192 = Mth.m_14143_(this.f_8510_.m_146909_() * 256.0f / 360.0f);
                Object \u00e2\u02dc\u01923 = this.f_8510_.m_20182_().m_82546_(ClientboundMoveEntityPacket.m_132515_(this.f_8514_, this.f_8515_, this.f_8516_));
                boolean \u00e2\u02dc\u01924 = ((Vec3)\u00e2\u02dc\u01923).m_82556_() >= 7.62939453125E-6;
                Packet<ClientGamePacketListener> \u00e2\u02dc\u01925 = null;
                boolean \u00e2\u02dc\u01926 = \u00e2\u02dc\u01924 || this.f_8521_ % 60 == 0;
                boolean bl2 = bl = Math.abs(n - this.f_8517_) >= 1 || Math.abs(\u00e2\u02dc\u0192 - this.f_8518_) >= 1;
                if (this.f_8521_ > 0 || this.f_8510_ instanceof AbstractArrow) {
                    long l = ClientboundMoveEntityPacket.m_132511_(((Vec3)\u00e2\u02dc\u01923).f_82479_);
                    \u00e2\u02dc\u0192 = ClientboundMoveEntityPacket.m_132511_(((Vec3)\u00e2\u02dc\u01923).f_82480_);
                    \u00e2\u02dc\u0192 = ClientboundMoveEntityPacket.m_132511_(((Vec3)\u00e2\u02dc\u01923).f_82481_);
                    boolean bl3 = \u00e2\u02dc\u0192 = l < -32768L || l > 32767L || \u00e2\u02dc\u0192 < -32768L || \u00e2\u02dc\u0192 > 32767L || \u00e2\u02dc\u0192 < -32768L || \u00e2\u02dc\u0192 > 32767L;
                    if (\u00e2\u02dc\u0192 || this.f_8522_ > 400 || this.f_8524_ || this.f_8525_ != this.f_8510_.m_20096_()) {
                        this.f_8525_ = this.f_8510_.m_20096_();
                        this.f_8522_ = 0;
                        \u00e2\u02dc\u01925 = new ClientboundTeleportEntityPacket(this.f_8510_);
                    } else if (\u00e2\u02dc\u01926 && bl || this.f_8510_ instanceof AbstractArrow) {
                        \u00e2\u02dc\u01925 = new ClientboundMoveEntityPacket.PosRot(this.f_8510_.m_142049_(), (short)l, (short)\u00e2\u02dc\u0192, (short)\u00e2\u02dc\u0192, (byte)n, (byte)\u00e2\u02dc\u0192, this.f_8510_.m_20096_());
                    } else if (\u00e2\u02dc\u01926) {
                        \u00e2\u02dc\u01925 = new ClientboundMoveEntityPacket.Pos(this.f_8510_.m_142049_(), (short)l, (short)\u00e2\u02dc\u0192, (short)\u00e2\u02dc\u0192, this.f_8510_.m_20096_());
                    } else if (bl) {
                        \u00e2\u02dc\u01925 = new ClientboundMoveEntityPacket.Rot(this.f_8510_.m_142049_(), (byte)n, (byte)\u00e2\u02dc\u0192, this.f_8510_.m_20096_());
                    }
                }
                if ((this.f_8512_ || this.f_8510_.f_19812_ || this.f_8510_ instanceof LivingEntity && ((LivingEntity)this.f_8510_).m_21255_()) && this.f_8521_ > 0 && ((d = (\u00e2\u02dc\u0192 = this.f_8510_.m_20184_()).m_82557_(this.f_8520_)) > 1.0E-7 || d > 0.0 && \u00e2\u02dc\u0192.m_82556_() == 0.0)) {
                    this.f_8520_ = \u00e2\u02dc\u0192;
                    this.f_8513_.accept(new ClientboundSetEntityMotionPacket(this.f_8510_.m_142049_(), this.f_8520_));
                }
                if (\u00e2\u02dc\u01925 != null) {
                    this.f_8513_.accept(\u00e2\u02dc\u01925);
                }
                this.m_8543_();
                if (\u00e2\u02dc\u01926) {
                    this.m_8544_();
                }
                if (bl) {
                    this.f_8517_ = n;
                    this.f_8518_ = \u00e2\u02dc\u0192;
                }
                this.f_8524_ = false;
            }
            n = Mth.m_14143_(this.f_8510_.m_6080_() * 256.0f / 360.0f);
            if (Math.abs(n - this.f_8519_) >= 1) {
                this.f_8513_.accept(new ClientboundRotateHeadPacket(this.f_8510_, (byte)n));
                this.f_8519_ = n;
            }
            this.f_8510_.f_19812_ = false;
        }
        ++this.f_8521_;
        if (this.f_8510_.f_19864_) {
            this.m_8538_(new ClientboundSetEntityMotionPacket(this.f_8510_));
            this.f_8510_.f_19864_ = false;
        }
    }

    public void m_8534_(ServerPlayer p_8535_) {
        this.f_8510_.m_6452_(p_8535_);
        p_8535_.f_8906_.m_141995_(new ClientboundRemoveEntitiesPacket(this.f_8510_.m_142049_()));
    }

    public void m_8541_(ServerPlayer p_8542_) {
        this.m_8536_(p_8542_.f_8906_::m_141995_);
        this.f_8510_.m_6457_(p_8542_);
    }

    public void m_8536_(Consumer<Packet<?>> p_8537_) {
        Object object;
        if (this.f_8510_.m_146910_()) {
            f_8508_.warn("Fetching packet for removed entity {}", (Object)this.f_8510_);
        }
        Packet<?> packet = this.f_8510_.m_5654_();
        this.f_8519_ = Mth.m_14143_(this.f_8510_.m_6080_() * 256.0f / 360.0f);
        p_8537_.accept(packet);
        if (!this.f_8510_.m_20088_().m_135388_()) {
            p_8537_.accept(new ClientboundSetEntityDataPacket(this.f_8510_.m_142049_(), this.f_8510_.m_20088_(), true));
        }
        boolean \u00e2\u02dc\u01922 = this.f_8512_;
        if (this.f_8510_ instanceof LivingEntity) {
            object = ((LivingEntity)this.f_8510_).m_21204_().m_22170_();
            if (!object.isEmpty()) {
                p_8537_.accept(new ClientboundUpdateAttributesPacket(this.f_8510_.m_142049_(), (Collection<AttributeInstance>)object));
            }
            if (((LivingEntity)this.f_8510_).m_21255_()) {
                \u00e2\u02dc\u01922 = true;
            }
        }
        this.f_8520_ = this.f_8510_.m_20184_();
        if (\u00e2\u02dc\u01922 && !(packet instanceof ClientboundAddMobPacket)) {
            p_8537_.accept(new ClientboundSetEntityMotionPacket(this.f_8510_.m_142049_(), this.f_8520_));
        }
        if (this.f_8510_ instanceof LivingEntity) {
            object = Lists.newArrayList();
            for (EquipmentSlot equipmentSlot : EquipmentSlot.values()) {
                ItemStack itemStack = ((LivingEntity)this.f_8510_).m_6844_(equipmentSlot);
                if (itemStack.m_41619_()) continue;
                object.add(Pair.of((Object)((Object)equipmentSlot), (Object)itemStack.m_41777_()));
            }
            if (!object.isEmpty()) {
                p_8537_.accept(new ClientboundSetEquipmentPacket(this.f_8510_.m_142049_(), (List<Pair<EquipmentSlot, ItemStack>>)object));
            }
        }
        if (this.f_8510_ instanceof LivingEntity) {
            object = (LivingEntity)this.f_8510_;
            for (MobEffectInstance mobEffectInstance : ((LivingEntity)object).m_21220_()) {
                p_8537_.accept(new ClientboundUpdateMobEffectPacket(this.f_8510_.m_142049_(), mobEffectInstance));
            }
        }
        if (!this.f_8510_.m_20197_().isEmpty()) {
            p_8537_.accept(new ClientboundSetPassengersPacket(this.f_8510_));
        }
        if (this.f_8510_.m_20159_()) {
            p_8537_.accept(new ClientboundSetPassengersPacket(this.f_8510_.m_20202_()));
        }
        if (this.f_8510_ instanceof Mob && ((Mob)(object = (Mob)this.f_8510_)).m_21523_()) {
            p_8537_.accept(new ClientboundSetEntityLinkPacket((Entity)object, ((Mob)object).m_21524_()));
        }
    }

    private void m_8543_() {
        SynchedEntityData synchedEntityData = this.f_8510_.m_20088_();
        if (synchedEntityData.m_135352_()) {
            this.m_8538_(new ClientboundSetEntityDataPacket(this.f_8510_.m_142049_(), synchedEntityData, false));
        }
        if (this.f_8510_ instanceof LivingEntity) {
            Set<AttributeInstance> set = ((LivingEntity)this.f_8510_).m_21204_().m_22145_();
            if (!set.isEmpty()) {
                this.m_8538_(new ClientboundUpdateAttributesPacket(this.f_8510_.m_142049_(), set));
            }
            set.clear();
        }
    }

    private void m_8544_() {
        this.f_8514_ = ClientboundMoveEntityPacket.m_132511_(this.f_8510_.m_20185_());
        this.f_8515_ = ClientboundMoveEntityPacket.m_132511_(this.f_8510_.m_20186_());
        this.f_8516_ = ClientboundMoveEntityPacket.m_132511_(this.f_8510_.m_20189_());
    }

    public Vec3 m_8540_() {
        return ClientboundMoveEntityPacket.m_132515_(this.f_8514_, this.f_8515_, this.f_8516_);
    }

    private void m_8538_(Packet<?> p_8539_) {
        this.f_8513_.accept(p_8539_);
        if (this.f_8510_ instanceof ServerPlayer) {
            ((ServerPlayer)this.f_8510_).f_8906_.m_141995_(p_8539_);
        }
    }
}

