/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.level;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.SectionPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddVibrationSignalPacket;
import net.minecraft.network.protocol.game.ClientboundBlockDestructionPacket;
import net.minecraft.network.protocol.game.ClientboundBlockEventPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelEventPacket;
import net.minecraft.network.protocol.game.ClientboundLevelParticlesPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSoundEntityPacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.TicketType;
import net.minecraft.server.level.progress.ChunkProgressListener;
import net.minecraft.server.players.SleepStatus;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagContainer;
import net.minecraft.util.CsvOutput;
import net.minecraft.util.Mth;
import net.minecraft.util.ProgressListener;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.animal.horse.SkeletonHorse;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EnderDragon;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.raid.Raids;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.BlockEventData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.ForcedChunksSavedData;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerTickList;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.TickList;
import net.minecraft.world.level.TickNextTickData;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.TickingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.storage.EntityStorage;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.entity.EntityTickList;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.entity.LevelCallback;
import net.minecraft.world.level.entity.LevelEntityGetter;
import net.minecraft.world.level.entity.PersistentEntitySectionManager;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.vibrations.VibrationPath;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.portal.PortalForcer;
import net.minecraft.world.level.saveddata.maps.MapIndex;
import net.minecraft.world.level.saveddata.maps.MapItemSavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.scores.Scoreboard;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerLevel
extends Level
implements WorldGenLevel {
    public static final BlockPos f_8562_ = new BlockPos(100, 50, 0);
    private static final Logger f_8566_ = LogManager.getLogger();
    private static final int f_143242_ = 300;
    final List<ServerPlayer> f_8546_ = Lists.newArrayList();
    private final ServerChunkCache f_8547_;
    private final MinecraftServer f_8548_;
    private final ServerLevelData f_8549_;
    final EntityTickList f_143243_ = new EntityTickList();
    private final PersistentEntitySectionManager<Entity> f_143244_;
    public boolean f_8564_;
    private final SleepStatus f_143245_;
    private int f_8551_;
    private final PortalForcer f_8552_;
    private final ServerTickList<Block> f_8553_ = new ServerTickList<Block>(this, p_8711_ -> p_8711_ == null || p_8711_.m_49966_().m_60795_(), Registry.f_122824_::m_7981_, this::m_8821_);
    private final ServerTickList<Fluid> f_8554_ = new ServerTickList<Fluid>(this, p_8728_ -> p_8728_ == null || p_8728_ == Fluids.f_76191_, Registry.f_122822_::m_7981_, this::m_8700_);
    final Set<Mob> f_143246_ = new ObjectOpenHashSet();
    protected final Raids f_8565_;
    private final ObjectLinkedOpenHashSet<BlockEventData> f_8556_ = new ObjectLinkedOpenHashSet();
    private boolean f_8557_;
    private final List<CustomSpawner> f_8558_;
    @Nullable
    private final EndDragonFight f_8559_;
    final Int2ObjectMap<EnderDragonPart> f_143247_ = new Int2ObjectOpenHashMap();
    private final StructureFeatureManager f_8560_;
    private final boolean f_8561_;

    public ServerLevel(MinecraftServer p_8571_, Executor p_8572_, LevelStorageSource.LevelStorageAccess p_8573_, ServerLevelData p_8574_, ResourceKey<Level> p_8575_, DimensionType p_8576_, ChunkProgressListener p_8577_, ChunkGenerator p_8578_, boolean p_8579_, long p_8580_, List<CustomSpawner> p_8581_, boolean p_8582_) {
        super(p_8574_, p_8575_, p_8576_, p_8571_::m_129905_, false, p_8579_, p_8580_);
        this.f_8561_ = p_8582_;
        this.f_8548_ = p_8571_;
        this.f_8558_ = p_8581_;
        this.f_8549_ = p_8574_;
        boolean bl = p_8571_.m_6365_();
        DataFixer \u00e2\u02dc\u01922 = p_8571_.m_129933_();
        EntityStorage \u00e2\u02dc\u01923 = new EntityStorage(this, new File(p_8573_.m_78299_(p_8575_), "entities"), \u00e2\u02dc\u01922, bl, p_8571_);
        this.f_143244_ = new PersistentEntitySectionManager<Entity>(Entity.class, new EntityCallbacks(), \u00e2\u02dc\u01923);
        this.f_8547_ = new ServerChunkCache(this, p_8573_, \u00e2\u02dc\u01922, p_8571_.m_129909_(), p_8572_, p_8578_, p_8571_.m_6846_().m_11312_(), bl, p_8577_, this.f_143244_::m_157524_, () -> p_8571_.m_129783_().m_8895_());
        this.f_8552_ = new PortalForcer(this);
        this.m_46465_();
        this.m_46466_();
        this.m_6857_().m_61923_(p_8571_.m_6329_());
        this.f_8565_ = this.m_8895_().m_164861_(p_143314_ -> Raids.m_150235_(this, p_143314_), () -> new Raids(this), Raids.m_37968_(this.m_6042_()));
        if (!p_8571_.m_129792_()) {
            p_8574_.m_5458_(p_8571_.m_130008_());
        }
        this.f_8560_ = new StructureFeatureManager(this, p_8571_.m_129910_().m_5961_());
        this.f_8559_ = this.m_6042_().m_63965_() ? new EndDragonFight(this, p_8571_.m_129910_().m_5961_().m_64619_(), p_8571_.m_129910_().m_6564_()) : null;
        this.f_143245_ = new SleepStatus();
    }

    public void m_8606_(int p_8607_, int p_8608_, boolean p_8609_, boolean p_8610_) {
        this.f_8549_.m_6393_(p_8607_);
        this.f_8549_.m_6399_(p_8608_);
        this.f_8549_.m_6398_(p_8608_);
        this.f_8549_.m_5565_(p_8609_);
        this.f_8549_.m_5557_(p_8610_);
    }

    @Override
    public Biome m_6159_(int p_8599_, int p_8600_, int p_8601_) {
        return this.m_7726_().m_8481_().m_62218_().m_7158_(p_8599_, p_8600_, p_8601_);
    }

    public StructureFeatureManager m_8595_() {
        return this.f_8560_;
    }

    public void m_8793_(BooleanSupplier p_8794_) {
        ProfilerFiller profilerFiller = this.m_46473_();
        this.f_8557_ = true;
        profilerFiller.m_6180_("world border");
        this.m_6857_().m_61969_();
        profilerFiller.m_6182_("weather");
        boolean \u00e2\u02dc\u01922 = this.m_46471_();
        if (this.m_6042_().m_63935_()) {
            if (this.m_46469_().m_46207_(GameRules.f_46150_)) {
                int n = this.f_8549_.m_6537_();
                \u00e2\u02dc\u0192 = this.f_8549_.m_6558_();
                \u00e2\u02dc\u0192 = this.f_8549_.m_6531_();
                boolean \u00e2\u02dc\u01923 = this.f_46442_.m_6534_();
                boolean \u00e2\u02dc\u01924 = this.f_46442_.m_6533_();
                if (n > 0) {
                    --n;
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 ? 0 : 1;
                    \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 ? 0 : 1;
                    \u00e2\u02dc\u01923 = false;
                    \u00e2\u02dc\u01924 = false;
                } else {
                    if (\u00e2\u02dc\u0192 > 0) {
                        if (--\u00e2\u02dc\u0192 == 0) {
                            \u00e2\u02dc\u01923 = !\u00e2\u02dc\u01923;
                        }
                    } else {
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 ? this.f_46441_.nextInt(12000) + 3600 : this.f_46441_.nextInt(168000) + 12000;
                    }
                    if (\u00e2\u02dc\u0192 > 0) {
                        if (--\u00e2\u02dc\u0192 == 0) {
                            \u00e2\u02dc\u01924 = !\u00e2\u02dc\u01924;
                        }
                    } else {
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924 ? this.f_46441_.nextInt(12000) + 12000 : this.f_46441_.nextInt(168000) + 12000;
                    }
                }
                this.f_8549_.m_6398_(\u00e2\u02dc\u0192);
                this.f_8549_.m_6399_(\u00e2\u02dc\u0192);
                this.f_8549_.m_6393_(n);
                this.f_8549_.m_5557_(\u00e2\u02dc\u01923);
                this.f_8549_.m_5565_(\u00e2\u02dc\u01924);
            }
            this.f_46439_ = this.f_46440_;
            this.f_46440_ = this.f_46442_.m_6534_() ? (float)((double)this.f_46440_ + 0.01) : (float)((double)this.f_46440_ - 0.01);
            this.f_46440_ = Mth.m_14036_(this.f_46440_, 0.0f, 1.0f);
            this.f_46437_ = this.f_46438_;
            this.f_46438_ = this.f_46442_.m_6533_() ? (float)((double)this.f_46438_ + 0.01) : (float)((double)this.f_46438_ - 0.01);
            this.f_46438_ = Mth.m_14036_(this.f_46438_, 0.0f, 1.0f);
        }
        if (this.f_46437_ != this.f_46438_) {
            this.f_8548_.m_6846_().m_11270_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, this.f_46438_), this.m_46472_());
        }
        if (this.f_46439_ != this.f_46440_) {
            this.f_8548_.m_6846_().m_11270_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, this.f_46440_), this.m_46472_());
        }
        if (\u00e2\u02dc\u01922 != this.m_46471_()) {
            if (\u00e2\u02dc\u01922) {
                this.f_8548_.m_6846_().m_11268_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132155_, 0.0f));
            } else {
                this.f_8548_.m_6846_().m_11268_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132154_, 0.0f));
            }
            this.f_8548_.m_6846_().m_11268_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, this.f_46438_));
            this.f_8548_.m_6846_().m_11268_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, this.f_46440_));
        }
        if (this.f_143245_.m_144002_(n = this.m_46469_().m_46215_(GameRules.f_151486_)) && this.f_143245_.m_144004_(n, this.f_8546_)) {
            if (this.m_46469_().m_46207_(GameRules.f_46140_)) {
                long \u00e2\u02dc\u01925 = this.f_46442_.m_6792_() + 24000L;
                this.m_8615_(\u00e2\u02dc\u01925 - \u00e2\u02dc\u01925 % 24000L);
            }
            this.m_8804_();
            if (this.m_46469_().m_46207_(GameRules.f_46150_)) {
                this.m_8805_();
            }
        }
        this.m_46465_();
        this.m_8809_();
        profilerFiller.m_6182_("tickPending");
        if (!this.m_46659_()) {
            this.f_8553_.m_47253_();
            this.f_8554_.m_47253_();
        }
        profilerFiller.m_6182_("raid");
        this.f_8565_.m_37957_();
        profilerFiller.m_6182_("chunkSource");
        this.m_7726_().m_142483_(p_8794_);
        profilerFiller.m_6182_("blockEvents");
        this.m_8807_();
        this.f_8557_ = false;
        profilerFiller.m_7238_();
        boolean bl = \u00e2\u02dc\u0192 = !this.f_8546_.isEmpty() || !this.m_8902_().isEmpty();
        if (\u00e2\u02dc\u0192) {
            this.m_8886_();
        }
        if (\u00e2\u02dc\u0192 || this.f_8551_++ < 300) {
            profilerFiller.m_6180_("entities");
            if (this.f_8559_ != null) {
                profilerFiller.m_6180_("dragonFight");
                this.f_8559_.m_64095_();
                profilerFiller.m_7238_();
            }
            this.f_143243_.m_156910_(p_143266_ -> {
                if (p_143266_.m_146910_()) {
                    return;
                }
                if (this.m_143342_((Entity)p_143266_)) {
                    p_143266_.m_146870_();
                    return;
                }
                profilerFiller.m_6180_("checkDespawn");
                p_143266_.m_6043_();
                profilerFiller.m_7238_();
                Entity entity = p_143266_.m_20202_();
                if (entity != null) {
                    if (entity.m_146910_() || !entity.m_20363_((Entity)p_143266_)) {
                        p_143266_.m_8127_();
                    } else {
                        return;
                    }
                }
                profilerFiller.m_6180_("tick");
                this.m_46653_(this::m_8647_, p_143266_);
                profilerFiller.m_7238_();
            });
            profilerFiller.m_7238_();
            this.m_46463_();
        }
        profilerFiller.m_6180_("entityManagement");
        this.f_143244_.m_157506_();
        profilerFiller.m_7238_();
    }

    protected void m_8809_() {
        if (!this.f_8561_) {
            return;
        }
        long l = this.f_46442_.m_6793_() + 1L;
        this.f_8549_.m_6253_(l);
        this.f_8549_.m_7540_().m_82256_(this.f_8548_, l);
        if (this.f_46442_.m_5470_().m_46207_(GameRules.f_46140_)) {
            this.m_8615_(this.f_46442_.m_6792_() + 1L);
        }
    }

    public void m_8615_(long p_8616_) {
        this.f_8549_.m_6247_(p_8616_);
    }

    public void m_8799_(boolean p_8800_, boolean p_8801_) {
        for (CustomSpawner customSpawner : this.f_8558_) {
            customSpawner.m_7995_(this, p_8800_, p_8801_);
        }
    }

    private boolean m_143342_(Entity p_143343_) {
        if (!this.f_8548_.m_6998_() && (p_143343_ instanceof Animal || p_143343_ instanceof WaterAnimal)) {
            return true;
        }
        return !this.f_8548_.m_6997_() && p_143343_ instanceof Npc;
    }

    private void m_8804_() {
        this.f_143245_.m_144001_();
        this.f_8546_.stream().filter(LivingEntity::m_5803_).collect(Collectors.toList()).forEach(p_143339_ -> p_143339_.m_6145_(false, false));
    }

    public void m_8714_(LevelChunk p_8715_, int p_8716_) {
        BlockPos blockPos;
        ChunkPos chunkPos = p_8715_.m_7697_();
        boolean \u00e2\u02dc\u01922 = this.m_46471_();
        int \u00e2\u02dc\u01923 = chunkPos.m_45604_();
        int \u00e2\u02dc\u01924 = chunkPos.m_45605_();
        ProfilerFiller \u00e2\u02dc\u01925 = this.m_46473_();
        \u00e2\u02dc\u01925.m_6180_("thunder");
        if (\u00e2\u02dc\u01922 && this.m_46470_() && this.f_46441_.nextInt(100000) == 0 && this.m_46758_(blockPos = this.m_143288_(this.m_46496_(\u00e2\u02dc\u01923, 0, \u00e2\u02dc\u01924, 15)))) {
            DifficultyInstance difficultyInstance = this.m_6436_(blockPos);
            boolean bl = \u00e2\u02dc\u0192 = this.m_46469_().m_46207_(GameRules.f_46134_) && this.f_46441_.nextDouble() < (double)difficultyInstance.m_19056_() * 0.01 && !this.m_8055_(blockPos.m_7495_()).m_60713_(Blocks.f_152587_);
            if (\u00e2\u02dc\u0192) {
                SkeletonHorse skeletonHorse = EntityType.f_20525_.m_20615_(this);
                skeletonHorse.m_30923_(true);
                skeletonHorse.m_146762_(0);
                skeletonHorse.m_6034_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_());
                this.m_7967_(skeletonHorse);
            }
            LightningBolt lightningBolt = EntityType.f_20465_.m_20615_(this);
            lightningBolt.m_20219_(Vec3.m_82539_(blockPos));
            lightningBolt.m_20874_(\u00e2\u02dc\u0192);
            this.m_7967_(lightningBolt);
        }
        \u00e2\u02dc\u01925.m_6182_("iceandsnow");
        if (this.f_46441_.nextInt(16) == 0) {
            BlockPos blockPos2 = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_46496_(\u00e2\u02dc\u01923, 0, \u00e2\u02dc\u01924, 15));
            BlockPos \u00e2\u02dc\u01926 = blockPos2.m_7495_();
            Biome \u00e2\u02dc\u01927 = this.m_46857_(blockPos2);
            if (\u00e2\u02dc\u01927.m_47477_(this, \u00e2\u02dc\u01926)) {
                this.m_46597_(\u00e2\u02dc\u01926, Blocks.f_50126_.m_49966_());
            }
            if (\u00e2\u02dc\u01922) {
                if (\u00e2\u02dc\u01927.m_47519_(this, blockPos2)) {
                    this.m_46597_(blockPos2, Blocks.f_50125_.m_49966_());
                }
                BlockState blockState = this.m_8055_(\u00e2\u02dc\u01926);
                Biome.Precipitation \u00e2\u02dc\u01928 = this.m_46857_(blockPos2).m_47530_();
                if (\u00e2\u02dc\u01928 == Biome.Precipitation.RAIN && \u00e2\u02dc\u01927.m_151696_(\u00e2\u02dc\u01926)) {
                    \u00e2\u02dc\u01928 = Biome.Precipitation.SNOW;
                }
                blockState.m_60734_().m_141997_(blockState, this, \u00e2\u02dc\u01926, \u00e2\u02dc\u01928);
            }
        }
        \u00e2\u02dc\u01925.m_6182_("tickBlocks");
        if (p_8716_ > 0) {
            for (LevelChunkSection levelChunkSection : p_8715_.m_7103_()) {
                if (levelChunkSection == LevelChunk.f_62770_ || !levelChunkSection.m_63014_()) continue;
                int \u00e2\u02dc\u01929 = levelChunkSection.m_63017_();
                for (int i = 0; i < p_8716_; ++i) {
                    FluidState fluidState;
                    BlockPos blockPos3 = this.m_46496_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01929, \u00e2\u02dc\u01924, 15);
                    \u00e2\u02dc\u01925.m_6180_("randomTick");
                    BlockState \u00e2\u02dc\u019210 = levelChunkSection.m_62982_(blockPos3.m_123341_() - \u00e2\u02dc\u01923, blockPos3.m_123342_() - \u00e2\u02dc\u01929, blockPos3.m_123343_() - \u00e2\u02dc\u01924);
                    if (\u00e2\u02dc\u019210.m_60823_()) {
                        \u00e2\u02dc\u019210.m_60735_(this, blockPos3, this.f_46441_);
                    }
                    if ((fluidState = \u00e2\u02dc\u019210.m_60819_()).m_76187_()) {
                        fluidState.m_76174_(this, blockPos3, this.f_46441_);
                    }
                    \u00e2\u02dc\u01925.m_7238_();
                }
            }
        }
        \u00e2\u02dc\u01925.m_7238_();
    }

    private Optional<BlockPos> m_143248_(BlockPos p_143249_) {
        Optional<BlockPos> optional = this.m_8904_().m_148658_(p_143274_ -> p_143274_ == PoiType.f_148687_, p_143255_ -> p_143255_.m_123342_() == this.m_6018_().m_6924_(Heightmap.Types.WORLD_SURFACE, p_143255_.m_123341_(), p_143255_.m_123343_()) - 1, p_143249_, 128, PoiManager.Occupancy.ANY);
        return optional.map(p_143253_ -> p_143253_.m_6630_(1));
    }

    protected BlockPos m_143288_(BlockPos p_143289_) {
        BlockPos blockPos = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, p_143289_);
        Optional<BlockPos> \u00e2\u02dc\u01922 = this.m_143248_(blockPos);
        if (\u00e2\u02dc\u01922.isPresent()) {
            return \u00e2\u02dc\u01922.get();
        }
        AABB \u00e2\u02dc\u01923 = new AABB(blockPos, new BlockPos(blockPos.m_123341_(), this.m_151558_(), blockPos.m_123343_())).m_82400_(3.0);
        List<LivingEntity> \u00e2\u02dc\u01924 = this.m_6443_(LivingEntity.class, \u00e2\u02dc\u01923, p_143272_ -> p_143272_ != null && p_143272_.m_6084_() && this.m_45527_(p_143272_.m_142538_()));
        if (!\u00e2\u02dc\u01924.isEmpty()) {
            return \u00e2\u02dc\u01924.get(this.f_46441_.nextInt(\u00e2\u02dc\u01924.size())).m_142538_();
        }
        if (blockPos.m_123342_() == this.m_141937_() - 1) {
            blockPos = blockPos.m_6630_(2);
        }
        return blockPos;
    }

    public boolean m_8874_() {
        return this.f_8557_;
    }

    public boolean m_143333_() {
        return this.m_46469_().m_46215_(GameRules.f_151486_) <= 100;
    }

    private void m_143315_() {
        if (!this.m_143333_()) {
            return;
        }
        if (this.m_142572_().m_129792_() && !this.m_142572_().m_6992_()) {
            return;
        }
        int n = this.m_46469_().m_46215_(GameRules.f_151486_);
        TranslatableComponent \u00e2\u02dc\u01922 = this.f_143245_.m_144002_(n) ? new TranslatableComponent("sleep.skipping_night") : new TranslatableComponent("sleep.players_sleeping", this.f_143245_.m_144009_(), this.f_143245_.m_144010_(n));
        for (ServerPlayer serverPlayer : this.f_8546_) {
            serverPlayer.m_5661_(\u00e2\u02dc\u01922, true);
        }
    }

    public void m_8878_() {
        if (!this.f_8546_.isEmpty() && this.f_143245_.m_144007_(this.f_8546_)) {
            this.m_143315_();
        }
    }

    @Override
    public ServerScoreboard m_6188_() {
        return this.f_8548_.m_129896_();
    }

    private void m_8805_() {
        this.f_8549_.m_6399_(0);
        this.f_8549_.m_5565_(false);
        this.f_8549_.m_6398_(0);
        this.f_8549_.m_5557_(false);
    }

    public void m_8886_() {
        this.f_8551_ = 0;
    }

    private void m_8700_(TickNextTickData<Fluid> p_8701_) {
        FluidState fluidState = this.m_6425_(p_8701_.f_47323_);
        if (fluidState.m_76152_() == p_8701_.m_47340_()) {
            fluidState.m_76163_(this, p_8701_.f_47323_);
        }
    }

    private void m_8821_(TickNextTickData<Block> p_8822_) {
        BlockState blockState = this.m_8055_(p_8822_.f_47323_);
        if (blockState.m_60713_(p_8822_.m_47340_())) {
            blockState.m_60616_(this, p_8822_.f_47323_, this.f_46441_);
        }
    }

    public void m_8647_(Entity p_8648_) {
        p_8648_.m_146867_();
        ProfilerFiller profilerFiller = this.m_46473_();
        ++p_8648_.f_19797_;
        this.m_46473_().m_6521_(() -> Registry.f_122826_.m_7981_(p_8648_.m_6095_()).toString());
        profilerFiller.m_6174_("tickNonPassenger");
        p_8648_.m_8119_();
        this.m_46473_().m_7238_();
        for (Entity entity : p_8648_.m_20197_()) {
            this.m_8662_(p_8648_, entity);
        }
    }

    private void m_8662_(Entity p_8663_, Entity p_8664_) {
        if (p_8664_.m_146910_() || p_8664_.m_20202_() != p_8663_) {
            p_8664_.m_8127_();
            return;
        }
        if (!(p_8664_ instanceof Player) && !this.f_143243_.m_156914_(p_8664_)) {
            return;
        }
        p_8664_.m_146867_();
        ++p_8664_.f_19797_;
        ProfilerFiller profilerFiller = this.m_46473_();
        profilerFiller.m_6521_(() -> Registry.f_122826_.m_7981_(p_8664_.m_6095_()).toString());
        profilerFiller.m_6174_("tickPassenger");
        p_8664_.m_6083_();
        profilerFiller.m_7238_();
        for (Entity entity : p_8664_.m_20197_()) {
            this.m_8662_(p_8664_, entity);
        }
    }

    @Override
    public boolean m_7966_(Player p_8696_, BlockPos p_8697_) {
        return !this.f_8548_.m_7762_(this, p_8697_, p_8696_) && this.m_6857_().m_61937_(p_8697_);
    }

    public void m_8643_(@Nullable ProgressListener p_8644_, boolean p_8645_, boolean p_8646_) {
        ServerChunkCache serverChunkCache = this.m_7726_();
        if (p_8646_) {
            return;
        }
        if (p_8644_ != null) {
            p_8644_.m_6309_(new TranslatableComponent("menu.savingLevel"));
        }
        this.m_8806_();
        if (p_8644_ != null) {
            p_8644_.m_6307_(new TranslatableComponent("menu.savingChunks"));
        }
        serverChunkCache.m_8419_(p_8645_);
        if (p_8645_) {
            this.f_143244_.m_157561_();
        } else {
            this.f_143244_.m_157554_();
        }
    }

    private void m_8806_() {
        if (this.f_8559_ != null) {
            this.f_8548_.m_129910_().m_5915_(this.f_8559_.m_64081_());
        }
        this.m_7726_().m_8483_().m_78151_();
    }

    public <T extends Entity> List<? extends T> m_143280_(EntityTypeTest<Entity, T> p_143281_, Predicate<? super T> p_143282_) {
        ArrayList arrayList = Lists.newArrayList();
        this.m_142646_().m_142690_(p_143281_, p_143310_ -> {
            if (p_143282_.test(p_143310_)) {
                arrayList.add(p_143310_);
            }
        });
        return arrayList;
    }

    public List<? extends EnderDragon> m_8857_() {
        return this.m_143280_(EntityType.f_20565_, LivingEntity::m_6084_);
    }

    public List<ServerPlayer> m_8795_(Predicate<? super ServerPlayer> p_8796_) {
        ArrayList arrayList = Lists.newArrayList();
        for (ServerPlayer serverPlayer : this.f_8546_) {
            if (!p_8796_.test(serverPlayer)) continue;
            arrayList.add(serverPlayer);
        }
        return arrayList;
    }

    @Nullable
    public ServerPlayer m_8890_() {
        List<ServerPlayer> list = this.m_8795_(LivingEntity::m_6084_);
        if (list.isEmpty()) {
            return null;
        }
        return list.get(this.f_46441_.nextInt(list.size()));
    }

    @Override
    public boolean m_7967_(Entity p_8837_) {
        return this.m_8872_(p_8837_);
    }

    public boolean m_8847_(Entity p_8848_) {
        return this.m_8872_(p_8848_);
    }

    public void m_143334_(Entity p_143335_) {
        this.m_8872_(p_143335_);
    }

    public void m_8622_(ServerPlayer p_8623_) {
        this.m_8853_(p_8623_);
    }

    public void m_8817_(ServerPlayer p_8818_) {
        this.m_8853_(p_8818_);
    }

    public void m_8834_(ServerPlayer p_8835_) {
        this.m_8853_(p_8835_);
    }

    public void m_8845_(ServerPlayer p_8846_) {
        this.m_8853_(p_8846_);
    }

    private void m_8853_(ServerPlayer p_8854_) {
        Entity entity = this.m_142646_().m_142694_(p_8854_.m_142081_());
        if (entity != null) {
            f_8566_.warn("Force-added player with duplicate UUID {}", (Object)p_8854_.m_142081_().toString());
            entity.m_19877_();
            this.m_143261_((ServerPlayer)entity, Entity.RemovalReason.DISCARDED);
        }
        this.f_143244_.m_157533_(p_8854_);
    }

    private boolean m_8872_(Entity p_8873_) {
        if (p_8873_.m_146910_()) {
            f_8566_.warn("Tried to add entity {} but it was marked as removed already", (Object)EntityType.m_20613_(p_8873_.m_6095_()));
            return false;
        }
        return this.f_143244_.m_157533_(p_8873_);
    }

    public boolean m_8860_(Entity p_8861_) {
        if (p_8861_.m_142428_().map(Entity::m_142081_).anyMatch(this.f_143244_::m_157550_)) {
            return false;
        }
        this.m_47205_(p_8861_);
        return true;
    }

    public void m_8712_(LevelChunk p_8713_) {
        p_8713_.m_156368_();
    }

    public void m_143261_(ServerPlayer p_143262_, Entity.RemovalReason p_143263_) {
        p_143262_.m_142687_(p_143263_);
    }

    @Override
    public void m_6801_(int p_8612_, BlockPos p_8613_, int p_8614_) {
        for (ServerPlayer serverPlayer : this.f_8548_.m_6846_().m_11314_()) {
            if (serverPlayer == null || serverPlayer.f_19853_ != this || serverPlayer.m_142049_() == p_8612_ || !((\u00e2\u02dc\u0192 = (double)p_8613_.m_123341_() - serverPlayer.m_20185_()) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = (double)p_8613_.m_123342_() - serverPlayer.m_20186_()) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = (double)p_8613_.m_123343_() - serverPlayer.m_20189_()) * \u00e2\u02dc\u0192 < 1024.0)) continue;
            serverPlayer.f_8906_.m_141995_(new ClientboundBlockDestructionPacket(p_8612_, p_8613_, p_8614_));
        }
    }

    @Override
    public void m_6263_(@Nullable Player p_8675_, double p_8676_, double p_8677_, double p_8678_, SoundEvent p_8679_, SoundSource p_8680_, float p_8681_, float p_8682_) {
        this.f_8548_.m_6846_().m_11241_(p_8675_, p_8676_, p_8677_, p_8678_, p_8681_ > 1.0f ? (double)(16.0f * p_8681_) : 16.0, this.m_46472_(), new ClientboundSoundPacket(p_8679_, p_8680_, p_8676_, p_8677_, p_8678_, p_8681_, p_8682_));
    }

    @Override
    public void m_6269_(@Nullable Player p_8689_, Entity p_8690_, SoundEvent p_8691_, SoundSource p_8692_, float p_8693_, float p_8694_) {
        this.f_8548_.m_6846_().m_11241_(p_8689_, p_8690_.m_20185_(), p_8690_.m_20186_(), p_8690_.m_20189_(), p_8693_ > 1.0f ? (double)(16.0f * p_8693_) : 16.0, this.m_46472_(), new ClientboundSoundEntityPacket(p_8691_, p_8692_, p_8690_, p_8693_, p_8694_));
    }

    @Override
    public void m_6798_(int p_8811_, BlockPos p_8812_, int p_8813_) {
        this.f_8548_.m_6846_().m_11268_(new ClientboundLevelEventPacket(p_8811_, p_8812_, p_8813_, true));
    }

    @Override
    public void m_5898_(@Nullable Player p_8684_, int p_8685_, BlockPos p_8686_, int p_8687_) {
        this.f_8548_.m_6846_().m_11241_(p_8684_, p_8686_.m_123341_(), p_8686_.m_123342_(), p_8686_.m_123343_(), 64.0, this.m_46472_(), new ClientboundLevelEventPacket(p_8685_, p_8686_, p_8687_, false));
    }

    @Override
    public int m_142475_() {
        return this.m_6042_().m_63964_();
    }

    @Override
    public void m_142346_(@Nullable Entity p_143268_, GameEvent p_143269_, BlockPos p_143270_) {
        this.m_151513_(p_143268_, p_143269_, p_143270_, p_143269_.m_157827_());
    }

    @Override
    public void m_7260_(BlockPos p_8755_, BlockState p_8756_, BlockState p_8757_, int p_8758_) {
        this.m_7726_().m_8450_(p_8755_);
        VoxelShape voxelShape = p_8756_.m_60812_(this, p_8755_);
        \u00e2\u02dc\u0192 = p_8757_.m_60812_(this, p_8755_);
        if (!Shapes.m_83157_(voxelShape, \u00e2\u02dc\u0192, BooleanOp.f_82687_)) {
            return;
        }
        for (Mob mob : this.f_143246_) {
            PathNavigation pathNavigation = mob.m_21573_();
            if (pathNavigation.m_26568_()) continue;
            pathNavigation.m_26561_(p_8755_);
        }
    }

    @Override
    public void m_7605_(Entity p_8650_, byte p_8651_) {
        this.m_7726_().m_8394_(p_8650_, new ClientboundEntityEventPacket(p_8650_, p_8651_));
    }

    @Override
    public ServerChunkCache m_7726_() {
        return this.f_8547_;
    }

    @Override
    public Explosion m_7703_(@Nullable Entity p_8653_, @Nullable DamageSource p_8654_, @Nullable ExplosionDamageCalculator p_8655_, double p_8656_, double p_8657_, double p_8658_, float p_8659_, boolean p_8660_, Explosion.BlockInteraction p_8661_) {
        Explosion explosion = new Explosion(this, p_8653_, p_8654_, p_8655_, p_8656_, p_8657_, p_8658_, p_8659_, p_8660_, p_8661_);
        explosion.m_46061_();
        explosion.m_46075_(false);
        if (p_8661_ == Explosion.BlockInteraction.NONE) {
            explosion.m_46080_();
        }
        for (ServerPlayer serverPlayer : this.f_8546_) {
            if (!(serverPlayer.m_20275_(p_8656_, p_8657_, p_8658_) < 4096.0)) continue;
            serverPlayer.f_8906_.m_141995_(new ClientboundExplodePacket(p_8656_, p_8657_, p_8658_, p_8659_, explosion.m_46081_(), explosion.m_46078_().get(serverPlayer)));
        }
        return explosion;
    }

    @Override
    public void m_7696_(BlockPos p_8746_, Block p_8747_, int p_8748_, int p_8749_) {
        this.f_8556_.add((Object)new BlockEventData(p_8746_, p_8747_, p_8748_, p_8749_));
    }

    private void m_8807_() {
        while (!this.f_8556_.isEmpty()) {
            BlockEventData blockEventData = (BlockEventData)this.f_8556_.removeFirst();
            if (!this.m_8698_(blockEventData)) continue;
            this.f_8548_.m_6846_().m_11241_(null, blockEventData.m_45538_().m_123341_(), blockEventData.m_45538_().m_123342_(), blockEventData.m_45538_().m_123343_(), 64.0, this.m_46472_(), new ClientboundBlockEventPacket(blockEventData.m_45538_(), blockEventData.m_45539_(), blockEventData.m_45540_(), blockEventData.m_45541_()));
        }
    }

    private boolean m_8698_(BlockEventData p_8699_) {
        BlockState blockState = this.m_8055_(p_8699_.m_45538_());
        if (blockState.m_60713_(p_8699_.m_45539_())) {
            return blockState.m_60677_(this, p_8699_.m_45538_(), p_8699_.m_45540_(), p_8699_.m_45541_());
        }
        return false;
    }

    public ServerTickList<Block> m_6219_() {
        return this.f_8553_;
    }

    public ServerTickList<Fluid> m_6217_() {
        return this.f_8554_;
    }

    @Override
    @Nonnull
    public MinecraftServer m_142572_() {
        return this.f_8548_;
    }

    public PortalForcer m_8871_() {
        return this.f_8552_;
    }

    public StructureManager m_8875_() {
        return this.f_8548_.m_129909_();
    }

    public void m_143283_(VibrationPath p_143284_) {
        BlockPos blockPos = p_143284_.m_157948_();
        ClientboundAddVibrationSignalPacket \u00e2\u02dc\u01922 = new ClientboundAddVibrationSignalPacket(p_143284_);
        this.f_8546_.forEach(p_143296_ -> this.m_8636_((ServerPlayer)p_143296_, false, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), \u00e2\u02dc\u01922));
    }

    public <T extends ParticleOptions> int m_8767_(T p_8768_, double p_8769_, double p_8770_, double p_8771_, int p_8772_, double p_8773_, double p_8774_, double p_8775_, double p_8776_) {
        ClientboundLevelParticlesPacket clientboundLevelParticlesPacket = new ClientboundLevelParticlesPacket(p_8768_, false, p_8769_, p_8770_, p_8771_, (float)p_8773_, (float)p_8774_, (float)p_8775_, (float)p_8776_, p_8772_);
        int \u00e2\u02dc\u01922 = 0;
        for (int i = 0; i < this.f_8546_.size(); ++i) {
            ServerPlayer serverPlayer = this.f_8546_.get(i);
            if (!this.m_8636_(serverPlayer, false, p_8769_, p_8770_, p_8771_, clientboundLevelParticlesPacket)) continue;
            ++\u00e2\u02dc\u01922;
        }
        return \u00e2\u02dc\u01922;
    }

    public <T extends ParticleOptions> boolean m_8624_(ServerPlayer p_8625_, T p_8626_, boolean p_8627_, double p_8628_, double p_8629_, double p_8630_, int p_8631_, double p_8632_, double p_8633_, double p_8634_, double p_8635_) {
        ClientboundLevelParticlesPacket clientboundLevelParticlesPacket = new ClientboundLevelParticlesPacket(p_8626_, p_8627_, p_8628_, p_8629_, p_8630_, (float)p_8632_, (float)p_8633_, (float)p_8634_, (float)p_8635_, p_8631_);
        return this.m_8636_(p_8625_, p_8627_, p_8628_, p_8629_, p_8630_, clientboundLevelParticlesPacket);
    }

    private boolean m_8636_(ServerPlayer p_8637_, boolean p_8638_, double p_8639_, double p_8640_, double p_8641_, Packet<?> p_8642_) {
        if (p_8637_.m_9236_() != this) {
            return false;
        }
        BlockPos blockPos = p_8637_.m_142538_();
        if (blockPos.m_123306_(new Vec3(p_8639_, p_8640_, p_8641_), p_8638_ ? 512.0 : 32.0)) {
            p_8637_.f_8906_.m_141995_(p_8642_);
            return true;
        }
        return false;
    }

    @Override
    @Nullable
    public Entity m_6815_(int p_8597_) {
        return this.m_142646_().m_142597_(p_8597_);
    }

    @Deprecated
    @Nullable
    public Entity m_143317_(int p_143318_) {
        Entity entity = this.m_142646_().m_142597_(p_143318_);
        if (entity != null) {
            return entity;
        }
        return (Entity)this.f_143247_.get(p_143318_);
    }

    @Nullable
    public Entity m_8791_(UUID p_8792_) {
        return this.m_142646_().m_142694_(p_8792_);
    }

    @Nullable
    public BlockPos m_8717_(StructureFeature<?> p_8718_, BlockPos p_8719_, int p_8720_, boolean p_8721_) {
        if (!this.f_8548_.m_129910_().m_5961_().m_64657_()) {
            return null;
        }
        return this.m_7726_().m_8481_().m_62161_(this, p_8718_, p_8719_, p_8720_, p_8721_);
    }

    @Nullable
    public BlockPos m_8705_(Biome p_8706_, BlockPos p_8707_, int p_8708_, int p_8709_) {
        return this.m_7726_().m_8481_().m_62218_().m_7754_(p_8707_.m_123341_(), p_8707_.m_123342_(), p_8707_.m_123343_(), p_8708_, p_8709_, p_143279_ -> p_143279_ == p_8706_, this.f_46441_, true);
    }

    @Override
    public RecipeManager m_7465_() {
        return this.f_8548_.m_129894_();
    }

    @Override
    public TagContainer m_5999_() {
        return this.f_8548_.m_129895_();
    }

    @Override
    public boolean m_7441_() {
        return this.f_8564_;
    }

    @Override
    public RegistryAccess m_5962_() {
        return this.f_8548_.m_129911_();
    }

    public DimensionDataStorage m_8895_() {
        return this.m_7726_().m_8483_();
    }

    @Override
    @Nullable
    public MapItemSavedData m_7489_(String p_8785_) {
        return this.m_142572_().m_129783_().m_8895_().m_164858_(MapItemSavedData::m_164807_, p_8785_);
    }

    @Override
    public void m_142325_(String p_143305_, MapItemSavedData p_143306_) {
        this.m_142572_().m_129783_().m_8895_().m_164855_(p_143305_, p_143306_);
    }

    @Override
    public int m_7354_() {
        return this.m_142572_().m_129783_().m_8895_().m_164861_(MapIndex::m_164762_, MapIndex::new, "idcounts").m_77880_();
    }

    public void m_8733_(BlockPos p_8734_, float p_8735_) {
        ChunkPos chunkPos = new ChunkPos(new BlockPos(this.f_46442_.m_6789_(), 0, this.f_46442_.m_6526_()));
        this.f_46442_.m_7250_(p_8734_, p_8735_);
        this.m_7726_().m_8438_(TicketType.f_9442_, chunkPos, 11, Unit.INSTANCE);
        this.m_7726_().m_8387_(TicketType.f_9442_, new ChunkPos(p_8734_), 11, Unit.INSTANCE);
        this.m_142572_().m_6846_().m_11268_(new ClientboundSetDefaultSpawnPositionPacket(p_8734_, p_8735_));
    }

    public BlockPos m_8900_() {
        BlockPos blockPos = new BlockPos(this.f_46442_.m_6789_(), this.f_46442_.m_6527_(), this.f_46442_.m_6526_());
        if (!this.m_6857_().m_61937_(blockPos)) {
            blockPos = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, new BlockPos(this.m_6857_().m_6347_(), 0.0, this.m_6857_().m_6345_()));
        }
        return blockPos;
    }

    public float m_8901_() {
        return this.f_46442_.m_6790_();
    }

    public LongSet m_8902_() {
        ForcedChunksSavedData forcedChunksSavedData = this.m_8895_().m_164858_(ForcedChunksSavedData::m_151483_, "chunks");
        return forcedChunksSavedData != null ? LongSets.unmodifiable((LongSet)forcedChunksSavedData.m_46116_()) : LongSets.EMPTY_SET;
    }

    public boolean m_8602_(int p_8603_, int p_8604_, boolean p_8605_) {
        boolean \u00e2\u02dc\u01924;
        ForcedChunksSavedData forcedChunksSavedData = this.m_8895_().m_164861_(ForcedChunksSavedData::m_151483_, ForcedChunksSavedData::new, "chunks");
        ChunkPos \u00e2\u02dc\u01922 = new ChunkPos(p_8603_, p_8604_);
        long \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_45588_();
        if (p_8605_) {
            \u00e2\u02dc\u01924 = forcedChunksSavedData.m_46116_().add(\u00e2\u02dc\u01923);
            if (\u00e2\u02dc\u01924) {
                this.m_6325_(p_8603_, p_8604_);
            }
        } else {
            \u00e2\u02dc\u01924 = forcedChunksSavedData.m_46116_().remove(\u00e2\u02dc\u01923);
        }
        forcedChunksSavedData.m_77760_(\u00e2\u02dc\u01924);
        if (\u00e2\u02dc\u01924) {
            this.m_7726_().m_6692_(\u00e2\u02dc\u01922, p_8605_);
        }
        return \u00e2\u02dc\u01924;
    }

    public List<ServerPlayer> m_6907_() {
        return this.f_8546_;
    }

    @Override
    public void m_6559_(BlockPos p_8751_, BlockState p_8752_, BlockState p_8753_) {
        Optional<PoiType> optional = PoiType.m_27390_(p_8752_);
        if (Objects.equals(optional, \u00e2\u02dc\u0192 = PoiType.m_27390_(p_8753_))) {
            return;
        }
        BlockPos \u00e2\u02dc\u01922 = p_8751_.m_7949_();
        optional.ifPresent(p_143331_ -> this.m_142572_().execute(() -> {
            this.m_8904_().m_27079_(\u00e2\u02dc\u01922);
            DebugPackets.m_133716_(this, \u00e2\u02dc\u01922);
        }));
        \u00e2\u02dc\u0192.ifPresent(p_143292_ -> this.m_142572_().execute(() -> {
            this.m_8904_().m_27085_(\u00e2\u02dc\u01922, (PoiType)p_143292_);
            DebugPackets.m_133679_(this, \u00e2\u02dc\u01922);
        }));
    }

    public PoiManager m_8904_() {
        return this.m_7726_().m_8484_();
    }

    public boolean m_8802_(BlockPos p_8803_) {
        return this.m_8736_(p_8803_, 1);
    }

    public boolean m_8762_(SectionPos p_8763_) {
        return this.m_8802_(p_8763_.m_123250_());
    }

    public boolean m_8736_(BlockPos p_8737_, int p_8738_) {
        if (p_8738_ > 6) {
            return false;
        }
        return this.m_8828_(SectionPos.m_123199_(p_8737_)) <= p_8738_;
    }

    public int m_8828_(SectionPos p_8829_) {
        return this.m_8904_().m_27098_(p_8829_);
    }

    public Raids m_8905_() {
        return this.f_8565_;
    }

    @Nullable
    public Raid m_8832_(BlockPos p_8833_) {
        return this.f_8565_.m_37970_(p_8833_, 9216);
    }

    public boolean m_8843_(BlockPos p_8844_) {
        return this.m_8832_(p_8844_) != null;
    }

    public void m_8670_(ReputationEventType p_8671_, Entity p_8672_, ReputationEventHandler p_8673_) {
        p_8673_.m_6814_(p_8671_, p_8672_);
    }

    public void m_8786_(Path p_8787_) throws IOException {
        Object object;
        ChunkMap chunkMap = this.m_7726_().f_8325_;
        try (Object \u00e2\u02dc\u01922 = Files.newBufferedWriter(p_8787_.resolve("stats.txt"), new OpenOption[0]);){
            ((Writer)\u00e2\u02dc\u01922).write(String.format("spawning_chunks: %d\n", chunkMap.m_143145_().m_140816_()));
            object = this.m_7726_().m_8485_();
            if (object != null) {
                for (Object object2 : ((NaturalSpawner.SpawnState)object).m_47148_().object2IntEntrySet()) {
                    ((Writer)\u00e2\u02dc\u01922).write(String.format("spawn_count.%s: %d\n", ((MobCategory)object2.getKey()).m_21607_(), object2.getIntValue()));
                }
            }
            ((Writer)\u00e2\u02dc\u01922).write(String.format("entities: %s\n", this.f_143244_.m_157572_()));
            ((Writer)\u00e2\u02dc\u01922).write(String.format("block_entity_tickers: %d\n", this.f_151512_.size()));
            ((Writer)\u00e2\u02dc\u01922).write(String.format("block_ticks: %d\n", ((ServerTickList)this.m_6219_()).m_142536_()));
            ((Writer)\u00e2\u02dc\u01922).write(String.format("fluid_ticks: %d\n", ((ServerTickList)this.m_6217_()).m_142536_()));
            ((Writer)\u00e2\u02dc\u01922).write("distance_manager: " + chunkMap.m_143145_().m_140837_() + "\n");
            ((Writer)\u00e2\u02dc\u01922).write(String.format("pending_tasks: %d\n", this.m_7726_().m_8480_()));
        }
        \u00e2\u02dc\u01922 = new CrashReport("Level dump", new Exception("dummy"));
        this.m_6026_((CrashReport)\u00e2\u02dc\u01922);
        object = Files.newBufferedWriter(p_8787_.resolve("example_crash.txt"), new OpenOption[0]);
        try {
            ((Writer)object).write(((CrashReport)\u00e2\u02dc\u01922).m_127526_());
        }
        finally {
            if (object != null) {
                ((Writer)object).close();
            }
        }
        object = p_8787_.resolve("chunks.csv");
        \u00e2\u02dc\u0192 = Files.newBufferedWriter((Path)object, new OpenOption[0]);
        try {
            chunkMap.m_140274_((Writer)\u00e2\u02dc\u0192);
        }
        finally {
            if (\u00e2\u02dc\u0192 != null) {
                ((Writer)\u00e2\u02dc\u0192).close();
            }
        }
        \u00e2\u02dc\u0192 = p_8787_.resolve("entity_chunks.csv");
        object2 = Files.newBufferedWriter((Path)\u00e2\u02dc\u0192, new OpenOption[0]);
        try {
            this.f_143244_.m_157548_((Writer)object2);
        }
        finally {
            if (object2 != null) {
                ((Writer)object2).close();
            }
        }
        object2 = p_8787_.resolve("entities.csv");
        \u00e2\u02dc\u0192 = Files.newBufferedWriter((Path)object2, new OpenOption[0]);
        try {
            ServerLevel.m_8781_((Writer)\u00e2\u02dc\u0192, this.m_142646_().m_142273_());
        }
        finally {
            if (\u00e2\u02dc\u0192 != null) {
                ((Writer)\u00e2\u02dc\u0192).close();
            }
        }
        \u00e2\u02dc\u0192 = p_8787_.resolve("block_entities.csv");
        try (BufferedWriter \u00e2\u02dc\u01923 = Files.newBufferedWriter((Path)\u00e2\u02dc\u0192, new OpenOption[0]);){
            this.m_143299_(\u00e2\u02dc\u01923);
        }
    }

    private static void m_8781_(Writer p_8782_, Iterable<Entity> p_8783_) throws IOException {
        CsvOutput csvOutput = CsvOutput.m_13619_().m_13630_("x").m_13630_("y").m_13630_("z").m_13630_("uuid").m_13630_("type").m_13630_("alive").m_13630_("display_name").m_13630_("custom_name").m_13628_(p_8782_);
        for (Entity entity : p_8783_) {
            Component component = entity.m_7770_();
            \u00e2\u02dc\u0192 = entity.m_5446_();
            csvOutput.m_13624_(entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_142081_(), Registry.f_122826_.m_7981_(entity.m_6095_()), entity.m_6084_(), \u00e2\u02dc\u0192.getString(), component != null ? component.getString() : null);
        }
    }

    private void m_143299_(Writer p_143300_) throws IOException {
        CsvOutput csvOutput = CsvOutput.m_13619_().m_13630_("x").m_13630_("y").m_13630_("z").m_13630_("type").m_13628_(p_143300_);
        for (TickingBlockEntity tickingBlockEntity : this.f_151512_) {
            BlockPos blockPos = tickingBlockEntity.m_142689_();
            csvOutput.m_13624_(blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), tickingBlockEntity.m_142280_());
        }
    }

    @VisibleForTesting
    public void m_8722_(BoundingBox p_8723_) {
        this.f_8556_.removeIf(p_143287_ -> p_8723_.m_71051_(p_143287_.m_45538_()));
    }

    @Override
    public void m_6289_(BlockPos p_8743_, Block p_8744_) {
        if (!this.m_46659_()) {
            this.m_46672_(p_8743_, p_8744_);
        }
    }

    @Override
    public float m_7717_(Direction p_8760_, boolean p_8761_) {
        return 1.0f;
    }

    public Iterable<Entity> m_8583_() {
        return this.m_142646_().m_142273_();
    }

    public String toString() {
        return "ServerLevel[" + this.f_8549_.m_5462_() + "]";
    }

    public boolean m_8584_() {
        return this.f_8548_.m_129910_().m_5961_().m_64669_();
    }

    @Override
    public long m_7328_() {
        return this.f_8548_.m_129910_().m_5961_().m_64619_();
    }

    @Nullable
    public EndDragonFight m_8586_() {
        return this.f_8559_;
    }

    @Override
    public Stream<? extends StructureStart<?>> m_7526_(SectionPos p_8765_, StructureFeature<?> p_8766_) {
        return this.m_8595_().m_47289_(p_8765_, p_8766_);
    }

    @Override
    public ServerLevel m_6018_() {
        return this;
    }

    @VisibleForTesting
    public String m_8590_() {
        return String.format("players: %s, entities: %s [%s], block_entities: %d [%s], block_ticks: %d, fluid_ticks: %d, chunk_source: %s", this.f_8546_.size(), this.f_143244_.m_157572_(), ServerLevel.m_143301_(this.f_143244_.m_157567_().m_142273_(), p_143346_ -> Registry.f_122826_.m_7981_(p_143346_.m_6095_()).toString()), this.f_151512_.size(), ServerLevel.m_143301_(this.f_151512_, TickingBlockEntity::m_142280_), ((ServerTickList)this.m_6219_()).m_142536_(), ((ServerTickList)this.m_6217_()).m_142536_(), this.m_46464_());
    }

    private static <T> String m_143301_(Iterable<T> p_143302_, Function<T, String> p_143303_) {
        try {
            Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
            for (T t : p_143302_) {
                String string = p_143303_.apply(t);
                object2IntOpenHashMap.addTo((Object)string, 1);
            }
            return object2IntOpenHashMap.object2IntEntrySet().stream().sorted(Comparator.comparing(Object2IntMap.Entry::getIntValue).reversed()).limit(5L).map(p_143298_ -> (String)p_143298_.getKey() + ":" + p_143298_.getIntValue()).collect(Collectors.joining(","));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static void m_8617_(ServerLevel p_8618_) {
        BlockPos blockPos = f_8562_;
        int \u00e2\u02dc\u01922 = blockPos.m_123341_();
        int \u00e2\u02dc\u01923 = blockPos.m_123342_() - 2;
        int \u00e2\u02dc\u01924 = blockPos.m_123343_();
        BlockPos.m_121976_(\u00e2\u02dc\u01922 - 2, \u00e2\u02dc\u01923 + 1, \u00e2\u02dc\u01924 - 2, \u00e2\u02dc\u01922 + 2, \u00e2\u02dc\u01923 + 3, \u00e2\u02dc\u01924 + 2).forEach(p_143323_ -> p_8618_.m_46597_((BlockPos)p_143323_, Blocks.f_50016_.m_49966_()));
        BlockPos.m_121976_(\u00e2\u02dc\u01922 - 2, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924 - 2, \u00e2\u02dc\u01922 + 2, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924 + 2).forEach(p_143260_ -> p_8618_.m_46597_((BlockPos)p_143260_, Blocks.f_50080_.m_49966_()));
    }

    @Override
    protected LevelEntityGetter<Entity> m_142646_() {
        return this.f_143244_.m_157567_();
    }

    public void m_143311_(Stream<Entity> p_143312_) {
        this.f_143244_.m_157552_(p_143312_);
    }

    public void m_143327_(Stream<Entity> p_143328_) {
        this.f_143244_.m_157559_(p_143328_);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.f_143244_.close();
    }

    @Override
    public String m_46464_() {
        return "Chunks[S] W: " + this.f_8547_.m_6754_() + " E: " + this.f_143244_.m_157572_();
    }

    public boolean m_143319_(long p_143320_) {
        return this.f_143244_.m_157507_(p_143320_);
    }

    public boolean m_143336_(BlockPos p_143337_) {
        long l = ChunkPos.m_151388_(p_143337_);
        return this.f_8547_.m_143239_(l) && this.m_143319_(l);
    }

    public boolean m_143340_(BlockPos p_143341_) {
        return this.f_143244_.m_157546_(p_143341_);
    }

    public boolean m_143275_(ChunkPos p_143276_) {
        return this.f_143244_.m_157522_(p_143276_);
    }

    @Override
    public /* synthetic */ Scoreboard m_6188_() {
        return this.m_6188_();
    }

    @Override
    public /* synthetic */ ChunkSource m_7726_() {
        return this.m_7726_();
    }

    public /* synthetic */ TickList m_6217_() {
        return this.m_6217_();
    }

    public /* synthetic */ TickList m_6219_() {
        return this.m_6219_();
    }

    final class EntityCallbacks
    implements LevelCallback<Entity> {
        EntityCallbacks() {
        }

        @Override
        public void m_141989_(Entity p_143355_) {
        }

        @Override
        public void m_141986_(Entity p_143359_) {
            ServerLevel.this.m_6188_().m_83420_(p_143359_);
        }

        @Override
        public void m_141987_(Entity p_143363_) {
            ServerLevel.this.f_143243_.m_156908_(p_143363_);
        }

        @Override
        public void m_141983_(Entity p_143367_) {
            ServerLevel.this.f_143243_.m_156912_(p_143367_);
        }

        @Override
        public void m_141985_(Entity p_143371_) {
            ServerLevel.this.m_7726_().m_8463_(p_143371_);
            if (p_143371_ instanceof ServerPlayer) {
                ServerLevel.this.f_8546_.add((ServerPlayer)p_143371_);
                ServerLevel.this.m_8878_();
            }
            if (p_143371_ instanceof Mob) {
                ServerLevel.this.f_143246_.add((Mob)p_143371_);
            }
            if (p_143371_ instanceof EnderDragon) {
                for (EnderDragonPart enderDragonPart : ((EnderDragon)p_143371_).m_31156_()) {
                    ServerLevel.this.f_143247_.put(enderDragonPart.m_142049_(), (Object)enderDragonPart);
                }
            }
        }

        @Override
        public void m_141981_(Entity p_143375_) {
            EnderDragonPart[] enderDragonPartArray;
            ServerLevel.this.m_7726_().m_8443_(p_143375_);
            if (p_143375_ instanceof ServerPlayer) {
                enderDragonPartArray = (ServerPlayer)p_143375_;
                ServerLevel.this.f_8546_.remove(enderDragonPartArray);
                ServerLevel.this.m_8878_();
            }
            if (p_143375_ instanceof Mob) {
                ServerLevel.this.f_143246_.remove(p_143375_);
            }
            if (p_143375_ instanceof EnderDragon) {
                enderDragonPartArray = ((EnderDragon)p_143375_).m_31156_();
                int n = enderDragonPartArray.length;
                for (int i = 0; i < n; ++i) {
                    EnderDragonPart enderDragonPart = enderDragonPartArray[i];
                    ServerLevel.this.f_143247_.remove(enderDragonPart.m_142049_());
                }
            }
            if ((enderDragonPartArray = p_143375_.m_146887_()) != null) {
                enderDragonPartArray.m_157854_(p_143375_.f_19853_);
            }
        }

        @Override
        public /* synthetic */ void m_141981_(Object object) {
            this.m_141981_((Entity)object);
        }

        @Override
        public /* synthetic */ void m_141985_(Object object) {
            this.m_141985_((Entity)object);
        }

        @Override
        public /* synthetic */ void m_141983_(Object object) {
            this.m_141983_((Entity)object);
        }

        @Override
        public /* synthetic */ void m_141987_(Object object) {
            this.m_141987_((Entity)object);
        }

        @Override
        public /* synthetic */ void m_141986_(Object object) {
            this.m_141986_((Entity)object);
        }

        @Override
        public /* synthetic */ void m_141989_(Object object) {
            this.m_141989_((Entity)object);
        }
    }
}

