/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.network.ServerConnectionListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LegacyQueryHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger f_9675_ = LogManager.getLogger();
    public static final int f_143586_ = 127;
    private final ServerConnectionListener f_9676_;

    public LegacyQueryHandler(ServerConnectionListener p_9679_) {
        this.f_9676_ = p_9679_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext p_9686_, Object p_9687_) {
        ByteBuf byteBuf = (ByteBuf)p_9687_;
        byteBuf.markReaderIndex();
        boolean \u00e2\u02dc\u01922 = true;
        try {
            if (byteBuf.readUnsignedByte() != 254) {
                return;
            }
            InetSocketAddress inetSocketAddress = (InetSocketAddress)p_9686_.channel().remoteAddress();
            MinecraftServer \u00e2\u02dc\u01923 = this.f_9676_.m_9722_();
            int \u00e2\u02dc\u01924 = byteBuf.readableBytes();
            switch (\u00e2\u02dc\u01924) {
                case 0: {
                    f_9675_.debug("Ping: (<1.3.x) from {}:{}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress.getPort());
                    String string = String.format("%s\u00a7%d\u00a7%d", \u00e2\u02dc\u01923.m_129916_(), \u00e2\u02dc\u01923.m_7416_(), \u00e2\u02dc\u01923.m_7418_());
                    this.m_9680_(p_9686_, this.m_9683_(string));
                    break;
                }
                case 1: {
                    if (byteBuf.readUnsignedByte() != 1) {
                        return;
                    }
                    f_9675_.debug("Ping: (1.4-1.5.x) from {}:{}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress.getPort());
                    String \u00e2\u02dc\u01925 = String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, \u00e2\u02dc\u01923.m_7630_(), \u00e2\u02dc\u01923.m_129916_(), \u00e2\u02dc\u01923.m_7416_(), \u00e2\u02dc\u01923.m_7418_());
                    this.m_9680_(p_9686_, this.m_9683_(\u00e2\u02dc\u01925));
                    break;
                }
                default: {
                    boolean \u00e2\u02dc\u01926 = byteBuf.readUnsignedByte() == 1;
                    \u00e2\u02dc\u01926 &= byteBuf.readUnsignedByte() == 250;
                    \u00e2\u02dc\u01926 &= "MC|PingHost".equals(new String(byteBuf.readBytes(byteBuf.readShort() * 2).array(), StandardCharsets.UTF_16BE));
                    int \u00e2\u02dc\u01927 = byteBuf.readUnsignedShort();
                    \u00e2\u02dc\u01926 &= byteBuf.readUnsignedByte() >= 73;
                    \u00e2\u02dc\u01926 &= 3 + byteBuf.readBytes(byteBuf.readShort() * 2).array().length + 4 == \u00e2\u02dc\u01927;
                    \u00e2\u02dc\u01926 &= byteBuf.readInt() <= 65535;
                    if (!(\u00e2\u02dc\u01926 &= byteBuf.readableBytes() == 0)) {
                        return;
                    }
                    f_9675_.debug("Ping: (1.6) from {}:{}", (Object)inetSocketAddress.getAddress(), (Object)inetSocketAddress.getPort());
                    String \u00e2\u02dc\u01928 = String.format("\u00a71\u0000%d\u0000%s\u0000%s\u0000%d\u0000%d", 127, \u00e2\u02dc\u01923.m_7630_(), \u00e2\u02dc\u01923.m_129916_(), \u00e2\u02dc\u01923.m_7416_(), \u00e2\u02dc\u01923.m_7418_());
                    ByteBuf \u00e2\u02dc\u01929 = this.m_9683_(\u00e2\u02dc\u01928);
                    try {
                        this.m_9680_(p_9686_, \u00e2\u02dc\u01929);
                        break;
                    }
                    finally {
                        \u00e2\u02dc\u01929.release();
                    }
                }
            }
            byteBuf.release();
            \u00e2\u02dc\u01922 = false;
        }
        catch (RuntimeException runtimeException) {
        }
        finally {
            if (\u00e2\u02dc\u01922) {
                byteBuf.resetReaderIndex();
                p_9686_.channel().pipeline().remove("legacy_query");
                p_9686_.fireChannelRead(p_9687_);
            }
        }
    }

    private void m_9680_(ChannelHandlerContext p_9681_, ByteBuf p_9682_) {
        p_9681_.pipeline().firstContext().writeAndFlush((Object)p_9682_).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private ByteBuf m_9683_(String p_9684_) {
        ByteBuf byteBuf = Unpooled.buffer();
        byteBuf.writeByte(255);
        char[] \u00e2\u02dc\u01922 = p_9684_.toCharArray();
        byteBuf.writeShort(\u00e2\u02dc\u01922.length);
        for (char c : \u00e2\u02dc\u01922) {
            byteBuf.writeChar((int)c);
        }
        return byteBuf;
    }
}

