/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.collect.Lists;
import com.google.common.primitives.Floats;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.suggestion.Suggestions;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMaps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketUtils;
import net.minecraft.network.protocol.game.ClientboundBlockUpdatePacket;
import net.minecraft.network.protocol.game.ClientboundChatPacket;
import net.minecraft.network.protocol.game.ClientboundCommandSuggestionsPacket;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.network.protocol.game.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.game.ClientboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ClientboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ClientboundPlayerPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundTagQueryPacket;
import net.minecraft.network.protocol.game.ServerGamePacketListener;
import net.minecraft.network.protocol.game.ServerboundAcceptTeleportationPacket;
import net.minecraft.network.protocol.game.ServerboundBlockEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundChatPacket;
import net.minecraft.network.protocol.game.ServerboundClientCommandPacket;
import net.minecraft.network.protocol.game.ServerboundClientInformationPacket;
import net.minecraft.network.protocol.game.ServerboundCommandSuggestionPacket;
import net.minecraft.network.protocol.game.ServerboundContainerButtonClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClickPacket;
import net.minecraft.network.protocol.game.ServerboundContainerClosePacket;
import net.minecraft.network.protocol.game.ServerboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ServerboundEditBookPacket;
import net.minecraft.network.protocol.game.ServerboundEntityTagQuery;
import net.minecraft.network.protocol.game.ServerboundInteractPacket;
import net.minecraft.network.protocol.game.ServerboundJigsawGeneratePacket;
import net.minecraft.network.protocol.game.ServerboundKeepAlivePacket;
import net.minecraft.network.protocol.game.ServerboundLockDifficultyPacket;
import net.minecraft.network.protocol.game.ServerboundMovePlayerPacket;
import net.minecraft.network.protocol.game.ServerboundMoveVehiclePacket;
import net.minecraft.network.protocol.game.ServerboundPaddleBoatPacket;
import net.minecraft.network.protocol.game.ServerboundPickItemPacket;
import net.minecraft.network.protocol.game.ServerboundPlaceRecipePacket;
import net.minecraft.network.protocol.game.ServerboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerActionPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerCommandPacket;
import net.minecraft.network.protocol.game.ServerboundPlayerInputPacket;
import net.minecraft.network.protocol.game.ServerboundPongPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookChangeSettingsPacket;
import net.minecraft.network.protocol.game.ServerboundRecipeBookSeenRecipePacket;
import net.minecraft.network.protocol.game.ServerboundRenameItemPacket;
import net.minecraft.network.protocol.game.ServerboundResourcePackPacket;
import net.minecraft.network.protocol.game.ServerboundSeenAdvancementsPacket;
import net.minecraft.network.protocol.game.ServerboundSelectTradePacket;
import net.minecraft.network.protocol.game.ServerboundSetBeaconPacket;
import net.minecraft.network.protocol.game.ServerboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetCommandMinecartPacket;
import net.minecraft.network.protocol.game.ServerboundSetCreativeModeSlotPacket;
import net.minecraft.network.protocol.game.ServerboundSetJigsawBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSetStructureBlockPacket;
import net.minecraft.network.protocol.game.ServerboundSignUpdatePacket;
import net.minecraft.network.protocol.game.ServerboundSwingPacket;
import net.minecraft.network.protocol.game.ServerboundTeleportToEntityPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemOnPacket;
import net.minecraft.network.protocol.game.ServerboundUseItemPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerPlayerConnection;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PlayerRideableJumping;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.ChatVisiblity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.BaseCommandBlock;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CommandBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.CommandBlockEntity;
import net.minecraft.world.level.block.entity.JigsawBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.entity.StructureBlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerGamePacketListenerImpl
implements ServerPlayerConnection,
ServerGamePacketListener {
    static final Logger f_9744_ = LogManager.getLogger();
    private static final int f_143608_ = 15000;
    public final Connection f_9742_;
    private final MinecraftServer f_9745_;
    public ServerPlayer f_9743_;
    private int f_9746_;
    private long f_9747_;
    private boolean f_9748_;
    private long f_9749_;
    private int f_9750_;
    private int f_9751_;
    private double f_9753_;
    private double f_9754_;
    private double f_9755_;
    private double f_9756_;
    private double f_9757_;
    private double f_9758_;
    @Nullable
    private Entity f_9759_;
    private double f_9760_;
    private double f_9761_;
    private double f_9762_;
    private double f_9763_;
    private double f_9764_;
    private double f_9765_;
    @Nullable
    private Vec3 f_9766_;
    private int f_9767_;
    private int f_9735_;
    private boolean f_9736_;
    private int f_9737_;
    private boolean f_9738_;
    private int f_9739_;
    private int f_9740_;
    private int f_9741_;

    public ServerGamePacketListenerImpl(MinecraftServer p_9770_, Connection p_9771_, ServerPlayer p_9772_) {
        this.f_9745_ = p_9770_;
        this.f_9742_ = p_9771_;
        p_9771_.m_129505_(this);
        this.f_9743_ = p_9772_;
        p_9772_.f_8906_ = this;
        p_9772_.m_8967_().m_7674_();
    }

    public void m_9933_() {
        this.m_9953_();
        this.f_9743_.f_19854_ = this.f_9743_.m_20185_();
        this.f_9743_.f_19855_ = this.f_9743_.m_20186_();
        this.f_9743_.f_19856_ = this.f_9743_.m_20189_();
        this.f_9743_.m_9240_();
        this.f_9743_.m_19890_(this.f_9753_, this.f_9754_, this.f_9755_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
        ++this.f_9746_;
        this.f_9741_ = this.f_9740_;
        if (this.f_9736_ && !this.f_9743_.m_5803_()) {
            if (++this.f_9737_ > 80) {
                f_9744_.warn("{} was kicked for floating too long!", (Object)this.f_9743_.m_7755_().getString());
                this.m_9942_(new TranslatableComponent("multiplayer.disconnect.flying"));
                return;
            }
        } else {
            this.f_9736_ = false;
            this.f_9737_ = 0;
        }
        this.f_9759_ = this.f_9743_.m_20201_();
        if (this.f_9759_ == this.f_9743_ || this.f_9759_.m_6688_() != this.f_9743_) {
            this.f_9759_ = null;
            this.f_9738_ = false;
            this.f_9739_ = 0;
        } else {
            this.f_9760_ = this.f_9759_.m_20185_();
            this.f_9761_ = this.f_9759_.m_20186_();
            this.f_9762_ = this.f_9759_.m_20189_();
            this.f_9763_ = this.f_9759_.m_20185_();
            this.f_9764_ = this.f_9759_.m_20186_();
            this.f_9765_ = this.f_9759_.m_20189_();
            if (this.f_9738_ && this.f_9743_.m_20201_().m_6688_() == this.f_9743_) {
                if (++this.f_9739_ > 80) {
                    f_9744_.warn("{} was kicked for floating a vehicle too long!", (Object)this.f_9743_.m_7755_().getString());
                    this.m_9942_(new TranslatableComponent("multiplayer.disconnect.flying"));
                    return;
                }
            } else {
                this.f_9738_ = false;
                this.f_9739_ = 0;
            }
        }
        this.f_9745_.m_129905_().m_6180_("keepAlive");
        long l = Util.m_137550_();
        if (l - this.f_9747_ >= 15000L) {
            if (this.f_9748_) {
                this.m_9942_(new TranslatableComponent("disconnect.timeout"));
            } else {
                this.f_9748_ = true;
                this.f_9747_ = l;
                this.f_9749_ = l;
                this.m_141995_(new ClientboundKeepAlivePacket(this.f_9749_));
            }
        }
        this.f_9745_.m_129905_().m_7238_();
        if (this.f_9750_ > 0) {
            --this.f_9750_;
        }
        if (this.f_9751_ > 0) {
            --this.f_9751_;
        }
        if (this.f_9743_.m_8956_() > 0L && this.f_9745_.m_129924_() > 0 && Util.m_137550_() - this.f_9743_.m_8956_() > (long)(this.f_9745_.m_129924_() * 1000 * 60)) {
            this.m_9942_(new TranslatableComponent("multiplayer.disconnect.idling"));
        }
    }

    public void m_9953_() {
        this.f_9753_ = this.f_9743_.m_20185_();
        this.f_9754_ = this.f_9743_.m_20186_();
        this.f_9755_ = this.f_9743_.m_20189_();
        this.f_9756_ = this.f_9743_.m_20185_();
        this.f_9757_ = this.f_9743_.m_20186_();
        this.f_9758_ = this.f_9743_.m_20189_();
    }

    @Override
    public Connection m_6198_() {
        return this.f_9742_;
    }

    private boolean m_9956_() {
        return this.f_9745_.m_7779_(this.f_9743_.m_36316_());
    }

    public void m_9942_(Component p_9943_) {
        this.f_9742_.m_129514_(new ClientboundDisconnectPacket(p_9943_), (GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener)p_9828_ -> this.f_9742_.m_129507_(p_9943_)));
        this.f_9742_.m_129540_();
        this.f_9745_.m_18709_(this.f_9742_::m_129541_);
    }

    private <T, R> void m_9801_(T p_9802_, Consumer<R> p_9803_, BiFunction<TextFilter, T, CompletableFuture<R>> p_9804_) {
        MinecraftServer minecraftServer = this.f_9743_.m_9236_().m_142572_();
        Consumer<Object> \u00e2\u02dc\u01922 = p_9941_ -> {
            if (this.m_6198_().m_129536_()) {
                p_9803_.accept(p_9941_);
            } else {
                f_9744_.debug("Ignoring packet due to disconnection");
            }
        };
        p_9804_.apply(this.f_9743_.m_8967_(), (TextFilter)p_9802_).thenAcceptAsync(\u00e2\u02dc\u01922, (Executor)minecraftServer);
    }

    private void m_9809_(String p_9810_, Consumer<TextFilter.FilteredText> p_9811_) {
        this.m_9801_(p_9810_, p_9811_, TextFilter::m_6770_);
    }

    private void m_9815_(List<String> p_9816_, Consumer<List<TextFilter.FilteredText>> p_9817_) {
        this.m_9801_(p_9816_, p_9817_, TextFilter::m_5925_);
    }

    @Override
    public void m_5918_(ServerboundPlayerInputPacket p_9893_) {
        PacketUtils.m_131359_(p_9893_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_8980_(p_9893_.m_134355_(), p_9893_.m_134358_(), p_9893_.m_134359_(), p_9893_.m_134360_());
    }

    private static boolean m_143663_(double p_143664_, double p_143665_, double p_143666_, float p_143667_, float p_143668_) {
        return Double.isNaN(p_143664_) || Double.isNaN(p_143665_) || Double.isNaN(p_143666_) || !Floats.isFinite((float)p_143668_) || !Floats.isFinite((float)p_143667_);
    }

    private static double m_143609_(double p_143610_) {
        return Mth.m_14008_(p_143610_, -3.0E7, 3.0E7);
    }

    private static double m_143653_(double p_143654_) {
        return Mth.m_14008_(p_143654_, -2.0E7, 2.0E7);
    }

    @Override
    public void m_5659_(ServerboundMoveVehiclePacket p_9876_) {
        PacketUtils.m_131359_(p_9876_, this, this.f_9743_.m_9236_());
        if (ServerGamePacketListenerImpl.m_143663_(p_9876_.m_134199_(), p_9876_.m_134202_(), p_9876_.m_134203_(), p_9876_.m_134204_(), p_9876_.m_134205_())) {
            this.m_9942_(new TranslatableComponent("multiplayer.disconnect.invalid_vehicle_movement"));
            return;
        }
        Entity entity = this.f_9743_.m_20201_();
        if (entity != this.f_9743_ && entity.m_6688_() == this.f_9743_ && entity == this.f_9759_) {
            ServerLevel serverLevel = this.f_9743_.m_9236_();
            double \u00e2\u02dc\u01922 = entity.m_20185_();
            double \u00e2\u02dc\u01923 = entity.m_20186_();
            double \u00e2\u02dc\u01924 = entity.m_20189_();
            double \u00e2\u02dc\u01925 = ServerGamePacketListenerImpl.m_143609_(p_9876_.m_134199_());
            double \u00e2\u02dc\u01926 = ServerGamePacketListenerImpl.m_143653_(p_9876_.m_134202_());
            double \u00e2\u02dc\u01927 = ServerGamePacketListenerImpl.m_143609_(p_9876_.m_134203_());
            float \u00e2\u02dc\u01928 = Mth.m_14177_(p_9876_.m_134204_());
            float \u00e2\u02dc\u01929 = Mth.m_14177_(p_9876_.m_134205_());
            double \u00e2\u02dc\u019210 = \u00e2\u02dc\u01925 - this.f_9760_;
            double \u00e2\u02dc\u019211 = \u00e2\u02dc\u01926 - this.f_9761_;
            double \u00e2\u02dc\u019212 = \u00e2\u02dc\u01927 - this.f_9762_;
            double \u00e2\u02dc\u019213 = \u00e2\u02dc\u019210 * \u00e2\u02dc\u019210 + \u00e2\u02dc\u019211 * \u00e2\u02dc\u019211 + \u00e2\u02dc\u019212 * \u00e2\u02dc\u019212;
            double \u00e2\u02dc\u019214 = entity.m_20184_().m_82556_();
            if (\u00e2\u02dc\u019213 - \u00e2\u02dc\u019214 > 100.0 && !this.m_9956_()) {
                f_9744_.warn("{} (vehicle of {}) moved too quickly! {},{},{}", (Object)entity.m_7755_().getString(), (Object)this.f_9743_.m_7755_().getString(), (Object)\u00e2\u02dc\u019210, (Object)\u00e2\u02dc\u019211, (Object)\u00e2\u02dc\u019212);
                this.f_9742_.m_129512_(new ClientboundMoveVehiclePacket(entity));
                return;
            }
            boolean \u00e2\u02dc\u019215 = serverLevel.m_45756_(entity, entity.m_142469_().m_82406_(0.0625));
            \u00e2\u02dc\u019210 = \u00e2\u02dc\u01925 - this.f_9763_;
            \u00e2\u02dc\u019211 = \u00e2\u02dc\u01926 - this.f_9764_ - 1.0E-6;
            \u00e2\u02dc\u019212 = \u00e2\u02dc\u01927 - this.f_9765_;
            entity.m_6478_(MoverType.PLAYER, new Vec3(\u00e2\u02dc\u019210, \u00e2\u02dc\u019211, \u00e2\u02dc\u019212));
            double \u00e2\u02dc\u019216 = \u00e2\u02dc\u019211;
            \u00e2\u02dc\u019210 = \u00e2\u02dc\u01925 - entity.m_20185_();
            \u00e2\u02dc\u019211 = \u00e2\u02dc\u01926 - entity.m_20186_();
            if (\u00e2\u02dc\u019211 > -0.5 || \u00e2\u02dc\u019211 < 0.5) {
                \u00e2\u02dc\u019211 = 0.0;
            }
            \u00e2\u02dc\u019212 = \u00e2\u02dc\u01927 - entity.m_20189_();
            \u00e2\u02dc\u019213 = \u00e2\u02dc\u019210 * \u00e2\u02dc\u019210 + \u00e2\u02dc\u019211 * \u00e2\u02dc\u019211 + \u00e2\u02dc\u019212 * \u00e2\u02dc\u019212;
            boolean \u00e2\u02dc\u019217 = false;
            if (\u00e2\u02dc\u019213 > 0.0625) {
                \u00e2\u02dc\u019217 = true;
                f_9744_.warn("{} (vehicle of {}) moved wrongly! {}", (Object)entity.m_7755_().getString(), (Object)this.f_9743_.m_7755_().getString(), (Object)Math.sqrt(\u00e2\u02dc\u019213));
            }
            entity.m_19890_(\u00e2\u02dc\u01925, \u00e2\u02dc\u01926, \u00e2\u02dc\u01927, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929);
            boolean \u00e2\u02dc\u019218 = serverLevel.m_45756_(entity, entity.m_142469_().m_82406_(0.0625));
            if (\u00e2\u02dc\u019215 && (\u00e2\u02dc\u019217 || !\u00e2\u02dc\u019218)) {
                entity.m_19890_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929);
                this.f_9742_.m_129512_(new ClientboundMoveVehiclePacket(entity));
                return;
            }
            this.f_9743_.m_9236_().m_7726_().m_8385_(this.f_9743_);
            this.f_9743_.m_36378_(this.f_9743_.m_20185_() - \u00e2\u02dc\u01922, this.f_9743_.m_20186_() - \u00e2\u02dc\u01923, this.f_9743_.m_20189_() - \u00e2\u02dc\u01924);
            this.f_9738_ = \u00e2\u02dc\u019216 >= -0.03125 && !this.f_9745_.m_129915_() && this.m_9793_(entity);
            this.f_9763_ = entity.m_20185_();
            this.f_9764_ = entity.m_20186_();
            this.f_9765_ = entity.m_20189_();
        }
    }

    private boolean m_9793_(Entity p_9794_) {
        return p_9794_.f_19853_.m_45556_(p_9794_.m_142469_().m_82400_(0.0625).m_82363_(0.0, -0.55, 0.0)).allMatch(BlockBehaviour.BlockStateBase::m_60795_);
    }

    @Override
    public void m_7376_(ServerboundAcceptTeleportationPacket p_9835_) {
        PacketUtils.m_131359_(p_9835_, this, this.f_9743_.m_9236_());
        if (p_9835_.m_133795_() == this.f_9767_) {
            this.f_9743_.m_19890_(this.f_9766_.f_82479_, this.f_9766_.f_82480_, this.f_9766_.f_82481_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
            this.f_9756_ = this.f_9766_.f_82479_;
            this.f_9757_ = this.f_9766_.f_82480_;
            this.f_9758_ = this.f_9766_.f_82481_;
            if (this.f_9743_.m_8958_()) {
                this.f_9743_.m_8959_();
            }
            this.f_9766_ = null;
        }
    }

    @Override
    public void m_7411_(ServerboundRecipeBookSeenRecipePacket p_9897_) {
        PacketUtils.m_131359_(p_9897_, this, this.f_9743_.m_9236_());
        this.f_9745_.m_129894_().m_44043_(p_9897_.m_134390_()).ifPresent(this.f_9743_.m_8952_()::m_12721_);
    }

    @Override
    public void m_7982_(ServerboundRecipeBookChangeSettingsPacket p_9895_) {
        PacketUtils.m_131359_(p_9895_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_8952_().m_12696_(p_9895_.m_134375_(), p_9895_.m_134378_(), p_9895_.m_134379_());
    }

    @Override
    public void m_6947_(ServerboundSeenAdvancementsPacket p_9903_) {
        PacketUtils.m_131359_(p_9903_, this, this.f_9743_.m_9236_());
        if (p_9903_.m_134447_() == ServerboundSeenAdvancementsPacket.Action.OPENED_TAB) {
            ResourceLocation resourceLocation = p_9903_.m_134448_();
            Advancement \u00e2\u02dc\u01922 = this.f_9745_.m_129889_().m_136041_(resourceLocation);
            if (\u00e2\u02dc\u01922 != null) {
                this.f_9743_.m_8960_().m_135983_(\u00e2\u02dc\u01922);
            }
        }
    }

    @Override
    public void m_7741_(ServerboundCommandSuggestionPacket p_9847_) {
        PacketUtils.m_131359_(p_9847_, this, this.f_9743_.m_9236_());
        StringReader stringReader = new StringReader(p_9847_.m_133904_());
        if (stringReader.canRead() && stringReader.peek() == '/') {
            stringReader.skip();
        }
        ParseResults \u00e2\u02dc\u01922 = this.f_9745_.m_129892_().m_82094_().parse(stringReader, (Object)this.f_9743_.m_20203_());
        this.f_9745_.m_129892_().m_82094_().getCompletionSuggestions(\u00e2\u02dc\u01922).thenAccept(p_143647_ -> this.f_9742_.m_129512_(new ClientboundCommandSuggestionsPacket(p_9847_.m_133901_(), (Suggestions)p_143647_)));
    }

    @Override
    public void m_7192_(ServerboundSetCommandBlockPacket p_9911_) {
        PacketUtils.m_131359_(p_9911_, this, this.f_9743_.m_9236_());
        if (!this.f_9745_.m_6993_()) {
            this.f_9743_.m_6352_(new TranslatableComponent("advMode.notEnabled"), Util.f_137441_);
            return;
        }
        if (!this.f_9743_.m_36337_()) {
            this.f_9743_.m_6352_(new TranslatableComponent("advMode.notAllowed"), Util.f_137441_);
            return;
        }
        BaseCommandBlock baseCommandBlock = null;
        CommandBlockEntity \u00e2\u02dc\u01922 = null;
        BlockPos \u00e2\u02dc\u01923 = p_9911_.m_134521_();
        BlockEntity \u00e2\u02dc\u01924 = this.f_9743_.f_19853_.m_7702_(\u00e2\u02dc\u01923);
        if (\u00e2\u02dc\u01924 instanceof CommandBlockEntity) {
            \u00e2\u02dc\u01922 = (CommandBlockEntity)\u00e2\u02dc\u01924;
            baseCommandBlock = \u00e2\u02dc\u01922.m_59141_();
        }
        String \u00e2\u02dc\u01925 = p_9911_.m_134524_();
        boolean \u00e2\u02dc\u01926 = p_9911_.m_134525_();
        if (baseCommandBlock != null) {
            CommandBlockEntity.Mode mode = \u00e2\u02dc\u01922.m_59148_();
            BlockState \u00e2\u02dc\u01927 = this.f_9743_.f_19853_.m_8055_(\u00e2\u02dc\u01923);
            Direction \u00e2\u02dc\u01928 = \u00e2\u02dc\u01927.m_61143_(CommandBlock.f_51793_);
            \u00e2\u02dc\u0192 = (BlockState)((BlockState)(switch (p_9911_.m_134528_()) {
                case CommandBlockEntity.Mode.SEQUENCE -> Blocks.f_50448_.m_49966_();
                case CommandBlockEntity.Mode.AUTO -> Blocks.f_50447_.m_49966_();
                default -> Blocks.f_50272_.m_49966_();
            }).m_61124_(CommandBlock.f_51793_, \u00e2\u02dc\u01928)).m_61124_(CommandBlock.f_51794_, p_9911_.m_134526_());
            if (\u00e2\u02dc\u0192 != \u00e2\u02dc\u01927) {
                this.f_9743_.f_19853_.m_7731_(\u00e2\u02dc\u01923, \u00e2\u02dc\u0192, 2);
                \u00e2\u02dc\u01924.m_155250_(\u00e2\u02dc\u0192);
                this.f_9743_.f_19853_.m_46745_(\u00e2\u02dc\u01923).m_142169_(\u00e2\u02dc\u01924);
            }
            baseCommandBlock.m_6590_(\u00e2\u02dc\u01925);
            baseCommandBlock.m_45428_(\u00e2\u02dc\u01926);
            if (!\u00e2\u02dc\u01926) {
                baseCommandBlock.m_45433_(null);
            }
            \u00e2\u02dc\u01922.m_59137_(p_9911_.m_134527_());
            if (mode != p_9911_.m_134528_()) {
                \u00e2\u02dc\u01922.m_59144_();
            }
            baseCommandBlock.m_7368_();
            if (!StringUtil.m_14408_(\u00e2\u02dc\u01925)) {
                this.f_9743_.m_6352_(new TranslatableComponent("advMode.setCommand.success", \u00e2\u02dc\u01925), Util.f_137441_);
            }
        }
    }

    @Override
    public void m_6629_(ServerboundSetCommandMinecartPacket p_9913_) {
        PacketUtils.m_131359_(p_9913_, this, this.f_9743_.m_9236_());
        if (!this.f_9745_.m_6993_()) {
            this.f_9743_.m_6352_(new TranslatableComponent("advMode.notEnabled"), Util.f_137441_);
            return;
        }
        if (!this.f_9743_.m_36337_()) {
            this.f_9743_.m_6352_(new TranslatableComponent("advMode.notAllowed"), Util.f_137441_);
            return;
        }
        BaseCommandBlock baseCommandBlock = p_9913_.m_134537_(this.f_9743_.f_19853_);
        if (baseCommandBlock != null) {
            baseCommandBlock.m_6590_(p_9913_.m_134545_());
            baseCommandBlock.m_45428_(p_9913_.m_134548_());
            if (!p_9913_.m_134548_()) {
                baseCommandBlock.m_45433_(null);
            }
            baseCommandBlock.m_7368_();
            this.f_9743_.m_6352_(new TranslatableComponent("advMode.setCommand.success", p_9913_.m_134545_()), Util.f_137441_);
        }
    }

    @Override
    public void m_7965_(ServerboundPickItemPacket p_9880_) {
        PacketUtils.m_131359_(p_9880_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_150109_().m_36038_(p_9880_.m_134232_());
        this.f_9743_.f_8906_.m_141995_(new ClientboundContainerSetSlotPacket(-2, 0, this.f_9743_.m_150109_().f_35977_, this.f_9743_.m_150109_().m_8020_(this.f_9743_.m_150109_().f_35977_)));
        this.f_9743_.f_8906_.m_141995_(new ClientboundContainerSetSlotPacket(-2, 0, p_9880_.m_134232_(), this.f_9743_.m_150109_().m_8020_(p_9880_.m_134232_())));
        this.f_9743_.f_8906_.m_141995_(new ClientboundSetCarriedItemPacket(this.f_9743_.m_150109_().f_35977_));
    }

    @Override
    public void m_5591_(ServerboundRenameItemPacket p_9899_) {
        PacketUtils.m_131359_(p_9899_, this, this.f_9743_.m_9236_());
        if (this.f_9743_.f_36096_ instanceof AnvilMenu) {
            AnvilMenu anvilMenu = (AnvilMenu)this.f_9743_.f_36096_;
            String \u00e2\u02dc\u01922 = SharedConstants.m_136190_(p_9899_.m_134403_());
            if (\u00e2\u02dc\u01922.length() <= 50) {
                anvilMenu.m_39020_(\u00e2\u02dc\u01922);
            }
        }
    }

    @Override
    public void m_5712_(ServerboundSetBeaconPacket p_9907_) {
        PacketUtils.m_131359_(p_9907_, this, this.f_9743_.m_9236_());
        if (this.f_9743_.f_36096_ instanceof BeaconMenu) {
            ((BeaconMenu)this.f_9743_.f_36096_).m_39053_(p_9907_.m_134484_(), p_9907_.m_134487_());
        }
    }

    @Override
    public void m_7424_(ServerboundSetStructureBlockPacket p_9919_) {
        PacketUtils.m_131359_(p_9919_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_36337_()) {
            return;
        }
        BlockPos blockPos = p_9919_.m_134629_();
        BlockState \u00e2\u02dc\u01922 = this.f_9743_.f_19853_.m_8055_(blockPos);
        BlockEntity \u00e2\u02dc\u01923 = this.f_9743_.f_19853_.m_7702_(blockPos);
        if (\u00e2\u02dc\u01923 instanceof StructureBlockEntity) {
            StructureBlockEntity structureBlockEntity = (StructureBlockEntity)\u00e2\u02dc\u01923;
            structureBlockEntity.m_59860_(p_9919_.m_134633_());
            structureBlockEntity.m_59868_(p_9919_.m_134634_());
            structureBlockEntity.m_59885_(p_9919_.m_134635_());
            structureBlockEntity.m_155797_(p_9919_.m_179787_());
            structureBlockEntity.m_59881_(p_9919_.m_134637_());
            structureBlockEntity.m_59883_(p_9919_.m_134638_());
            structureBlockEntity.m_59887_(p_9919_.m_134639_());
            structureBlockEntity.m_59876_(p_9919_.m_134640_());
            structureBlockEntity.m_59896_(p_9919_.m_134641_());
            structureBlockEntity.m_59898_(p_9919_.m_134642_());
            structureBlockEntity.m_59838_(p_9919_.m_134643_());
            structureBlockEntity.m_59840_(p_9919_.m_134644_());
            if (structureBlockEntity.m_59901_()) {
                String string = structureBlockEntity.m_59895_();
                if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.SAVE_AREA) {
                    if (structureBlockEntity.m_59830_()) {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.save_success", string), false);
                    } else {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.save_failure", string), false);
                    }
                } else if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.LOAD_AREA) {
                    if (!structureBlockEntity.m_59832_()) {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.load_not_found", string), false);
                    } else if (structureBlockEntity.m_59842_(this.f_9743_.m_9236_())) {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.load_success", string), false);
                    } else {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.load_prepare", string), false);
                    }
                } else if (p_9919_.m_134632_() == StructureBlockEntity.UpdateType.SCAN_AREA) {
                    if (structureBlockEntity.m_59829_()) {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.size_success", string), false);
                    } else {
                        this.f_9743_.m_5661_(new TranslatableComponent("structure_block.size_failure"), false);
                    }
                }
            } else {
                this.f_9743_.m_5661_(new TranslatableComponent("structure_block.invalid_structure_name", p_9919_.m_134634_()), false);
            }
            structureBlockEntity.m_6596_();
            this.f_9743_.f_19853_.m_7260_(blockPos, \u00e2\u02dc\u01922, \u00e2\u02dc\u01922, 3);
        }
    }

    @Override
    public void m_8019_(ServerboundSetJigsawBlockPacket p_9917_) {
        PacketUtils.m_131359_(p_9917_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_36337_()) {
            return;
        }
        BlockPos blockPos = p_9917_.m_134585_();
        BlockState \u00e2\u02dc\u01922 = this.f_9743_.f_19853_.m_8055_(blockPos);
        BlockEntity \u00e2\u02dc\u01923 = this.f_9743_.f_19853_.m_7702_(blockPos);
        if (\u00e2\u02dc\u01923 instanceof JigsawBlockEntity) {
            JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)\u00e2\u02dc\u01923;
            jigsawBlockEntity.m_59435_(p_9917_.m_134588_());
            jigsawBlockEntity.m_59438_(p_9917_.m_134589_());
            jigsawBlockEntity.m_59440_(p_9917_.m_134590_());
            jigsawBlockEntity.m_59431_(p_9917_.m_134591_());
            jigsawBlockEntity.m_59424_(p_9917_.m_134592_());
            jigsawBlockEntity.m_6596_();
            this.f_9743_.f_19853_.m_7260_(blockPos, \u00e2\u02dc\u01922, \u00e2\u02dc\u01922, 3);
        }
    }

    @Override
    public void m_6449_(ServerboundJigsawGeneratePacket p_9868_) {
        PacketUtils.m_131359_(p_9868_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_36337_()) {
            return;
        }
        BlockPos blockPos = p_9868_.m_134087_();
        BlockEntity \u00e2\u02dc\u01922 = this.f_9743_.f_19853_.m_7702_(blockPos);
        if (\u00e2\u02dc\u01922 instanceof JigsawBlockEntity) {
            JigsawBlockEntity jigsawBlockEntity = (JigsawBlockEntity)\u00e2\u02dc\u01922;
            jigsawBlockEntity.m_59420_(this.f_9743_.m_9236_(), p_9868_.m_134090_(), p_9868_.m_134091_());
        }
    }

    @Override
    public void m_6321_(ServerboundSelectTradePacket p_9905_) {
        PacketUtils.m_131359_(p_9905_, this, this.f_9743_.m_9236_());
        int n = p_9905_.m_134469_();
        AbstractContainerMenu \u00e2\u02dc\u01922 = this.f_9743_.f_36096_;
        if (\u00e2\u02dc\u01922 instanceof MerchantMenu) {
            MerchantMenu merchantMenu = (MerchantMenu)\u00e2\u02dc\u01922;
            merchantMenu.m_40063_(n);
            merchantMenu.m_40072_(n);
        }
    }

    @Override
    public void m_6829_(ServerboundEditBookPacket p_9862_) {
        int n = p_9862_.m_134013_();
        if (!Inventory.m_36045_(n) && n != 40) {
            return;
        }
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        Optional<String> \u00e2\u02dc\u01923 = p_9862_.m_182761_();
        \u00e2\u02dc\u01923.ifPresent(\u00e2\u02dc\u01922::add);
        p_9862_.m_182755_().stream().limit(100L).forEach(\u00e2\u02dc\u01922::add);
        this.m_9815_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923.isPresent() ? p_143657_ -> this.m_143630_((TextFilter.FilteredText)p_143657_.get(0), p_143657_.subList(1, p_143657_.size()), n) : p_143627_ -> this.m_9812_((List<TextFilter.FilteredText>)p_143627_, n));
    }

    private void m_9812_(List<TextFilter.FilteredText> p_9813_, int p_9814_) {
        ItemStack itemStack = this.f_9743_.m_150109_().m_8020_(p_9814_);
        if (!itemStack.m_150930_(Items.f_42614_)) {
            return;
        }
        this.m_143634_(p_9813_, UnaryOperator.identity(), itemStack);
    }

    private void m_143630_(TextFilter.FilteredText p_143631_, List<TextFilter.FilteredText> p_143632_, int p_143633_) {
        ItemStack itemStack = this.f_9743_.m_150109_().m_8020_(p_143633_);
        if (!itemStack.m_150930_(Items.f_42614_)) {
            return;
        }
        \u00e2\u02dc\u0192 = new ItemStack(Items.f_42615_);
        CompoundTag \u00e2\u02dc\u01922 = itemStack.m_41783_();
        if (\u00e2\u02dc\u01922 != null) {
            \u00e2\u02dc\u0192.m_41751_(\u00e2\u02dc\u01922.m_6426_());
        }
        \u00e2\u02dc\u0192.m_41700_("author", StringTag.m_129297_(this.f_9743_.m_7755_().getString()));
        if (this.f_9743_.m_143387_()) {
            \u00e2\u02dc\u0192.m_41700_("title", StringTag.m_129297_(p_143631_.m_143722_()));
        } else {
            \u00e2\u02dc\u0192.m_41700_("filtered_title", StringTag.m_129297_(p_143631_.m_143722_()));
            \u00e2\u02dc\u0192.m_41700_("title", StringTag.m_129297_(p_143631_.m_143719_()));
        }
        this.m_143634_(p_143632_, p_143659_ -> Component.Serializer.m_130703_(new TextComponent((String)p_143659_)), \u00e2\u02dc\u0192);
        this.f_9743_.m_150109_().m_6836_(p_143633_, \u00e2\u02dc\u0192);
    }

    private void m_143634_(List<TextFilter.FilteredText> p_143635_, UnaryOperator<String> p_143636_, ItemStack p_143637_) {
        ListTag listTag = new ListTag();
        if (this.f_9743_.m_143387_()) {
            p_143635_.stream().map(p_143640_ -> StringTag.m_129297_((String)p_143636_.apply(p_143640_.m_143722_()))).forEach(listTag::add);
        } else {
            CompoundTag compoundTag = new CompoundTag();
            int \u00e2\u02dc\u01922 = p_143635_.size();
            for (int i = 0; i < \u00e2\u02dc\u01922; ++i) {
                TextFilter.FilteredText filteredText = p_143635_.get(i);
                String \u00e2\u02dc\u01923 = filteredText.m_143719_();
                listTag.add(StringTag.m_129297_((String)p_143636_.apply(\u00e2\u02dc\u01923)));
                String \u00e2\u02dc\u01924 = filteredText.m_143722_();
                if (\u00e2\u02dc\u01923.equals(\u00e2\u02dc\u01924)) continue;
                compoundTag.m_128359_(String.valueOf(i), (String)p_143636_.apply(\u00e2\u02dc\u01924));
            }
            if (!compoundTag.m_128456_()) {
                p_143637_.m_41700_("filtered_pages", compoundTag);
            }
        }
        p_143637_.m_41700_("pages", listTag);
    }

    @Override
    public void m_7548_(ServerboundEntityTagQuery p_9864_) {
        PacketUtils.m_131359_(p_9864_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_20310_(2)) {
            return;
        }
        Entity entity = this.f_9743_.m_9236_().m_6815_(p_9864_.m_134029_());
        if (entity != null) {
            CompoundTag compoundTag = entity.m_20240_(new CompoundTag());
            this.f_9743_.f_8906_.m_141995_(new ClientboundTagQueryPacket(p_9864_.m_134026_(), compoundTag));
        }
    }

    @Override
    public void m_6780_(ServerboundBlockEntityTagQuery p_9837_) {
        PacketUtils.m_131359_(p_9837_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_20310_(2)) {
            return;
        }
        BlockEntity blockEntity = this.f_9743_.m_9236_().m_7702_(p_9837_.m_133813_());
        CompoundTag \u00e2\u02dc\u01922 = blockEntity != null ? blockEntity.m_6945_(new CompoundTag()) : null;
        this.f_9743_.f_8906_.m_141995_(new ClientboundTagQueryPacket(p_9837_.m_133810_(), \u00e2\u02dc\u01922));
    }

    @Override
    public void m_7185_(ServerboundMovePlayerPacket p_9874_) {
        PacketUtils.m_131359_(p_9874_, this, this.f_9743_.m_9236_());
        if (ServerGamePacketListenerImpl.m_143663_(p_9874_.m_134129_(0.0), p_9874_.m_134140_(0.0), p_9874_.m_134146_(0.0), p_9874_.m_134131_(0.0f), p_9874_.m_134142_(0.0f))) {
            this.m_9942_(new TranslatableComponent("multiplayer.disconnect.invalid_player_movement"));
            return;
        }
        ServerLevel serverLevel = this.f_9743_.m_9236_();
        if (this.f_9743_.f_8944_) {
            return;
        }
        if (this.f_9746_ == 0) {
            this.m_9953_();
        }
        if (this.f_9766_ != null) {
            if (this.f_9746_ - this.f_9735_ > 20) {
                this.f_9735_ = this.f_9746_;
                this.m_9774_(this.f_9766_.f_82479_, this.f_9766_.f_82480_, this.f_9766_.f_82481_, this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
            }
            return;
        }
        this.f_9735_ = this.f_9746_;
        double \u00e2\u02dc\u01922 = ServerGamePacketListenerImpl.m_143609_(p_9874_.m_134129_(this.f_9743_.m_20185_()));
        double \u00e2\u02dc\u01923 = ServerGamePacketListenerImpl.m_143653_(p_9874_.m_134140_(this.f_9743_.m_20186_()));
        double \u00e2\u02dc\u01924 = ServerGamePacketListenerImpl.m_143609_(p_9874_.m_134146_(this.f_9743_.m_20189_()));
        float \u00e2\u02dc\u01925 = Mth.m_14177_(p_9874_.m_134131_(this.f_9743_.m_146908_()));
        float \u00e2\u02dc\u01926 = Mth.m_14177_(p_9874_.m_134142_(this.f_9743_.m_146909_()));
        if (this.f_9743_.m_20159_()) {
            this.f_9743_.m_19890_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), \u00e2\u02dc\u01925, \u00e2\u02dc\u01926);
            this.f_9743_.m_9236_().m_7726_().m_8385_(this.f_9743_);
            return;
        }
        double \u00e2\u02dc\u01927 = this.f_9743_.m_20185_();
        double \u00e2\u02dc\u01928 = this.f_9743_.m_20186_();
        double \u00e2\u02dc\u01929 = this.f_9743_.m_20189_();
        double \u00e2\u02dc\u019210 = this.f_9743_.m_20186_();
        double \u00e2\u02dc\u019211 = \u00e2\u02dc\u01922 - this.f_9753_;
        double \u00e2\u02dc\u019212 = \u00e2\u02dc\u01923 - this.f_9754_;
        double \u00e2\u02dc\u019213 = \u00e2\u02dc\u01924 - this.f_9755_;
        double \u00e2\u02dc\u019214 = this.f_9743_.m_20184_().m_82556_();
        double \u00e2\u02dc\u019215 = \u00e2\u02dc\u019211 * \u00e2\u02dc\u019211 + \u00e2\u02dc\u019212 * \u00e2\u02dc\u019212 + \u00e2\u02dc\u019213 * \u00e2\u02dc\u019213;
        if (this.f_9743_.m_5803_()) {
            if (\u00e2\u02dc\u019215 > 1.0) {
                this.m_9774_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), \u00e2\u02dc\u01925, \u00e2\u02dc\u01926);
            }
            return;
        }
        ++this.f_9740_;
        int \u00e2\u02dc\u019216 = this.f_9740_ - this.f_9741_;
        if (\u00e2\u02dc\u019216 > 5) {
            f_9744_.debug("{} is sending move packets too frequently ({} packets since last tick)", (Object)this.f_9743_.m_7755_().getString(), (Object)\u00e2\u02dc\u019216);
            \u00e2\u02dc\u019216 = 1;
        }
        if (!(this.f_9743_.m_8958_() || this.f_9743_.m_9236_().m_46469_().m_46207_(GameRules.f_46148_) && this.f_9743_.m_21255_())) {
            float f = \u00e2\u02dc\u0192 = this.f_9743_.m_21255_() ? 300.0f : 100.0f;
            if (\u00e2\u02dc\u019215 - \u00e2\u02dc\u019214 > (double)(\u00e2\u02dc\u0192 * (float)\u00e2\u02dc\u019216) && !this.m_9956_()) {
                f_9744_.warn("{} moved too quickly! {},{},{}", (Object)this.f_9743_.m_7755_().getString(), (Object)\u00e2\u02dc\u019211, (Object)\u00e2\u02dc\u019212, (Object)\u00e2\u02dc\u019213);
                this.m_9774_(this.f_9743_.m_20185_(), this.f_9743_.m_20186_(), this.f_9743_.m_20189_(), this.f_9743_.m_146908_(), this.f_9743_.m_146909_());
                return;
            }
        }
        AABB \u00e2\u02dc\u019217 = this.f_9743_.m_142469_();
        \u00e2\u02dc\u019211 = \u00e2\u02dc\u01922 - this.f_9756_;
        \u00e2\u02dc\u019212 = \u00e2\u02dc\u01923 - this.f_9757_;
        \u00e2\u02dc\u019213 = \u00e2\u02dc\u01924 - this.f_9758_;
        boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u019212 > 0.0;
        if (this.f_9743_.m_20096_() && !p_9874_.m_134139_() && \u00e2\u02dc\u0192) {
            this.f_9743_.m_6135_();
        }
        this.f_9743_.m_6478_(MoverType.PLAYER, new Vec3(\u00e2\u02dc\u019211, \u00e2\u02dc\u019212, \u00e2\u02dc\u019213));
        double \u00e2\u02dc\u019218 = \u00e2\u02dc\u019212;
        \u00e2\u02dc\u019211 = \u00e2\u02dc\u01922 - this.f_9743_.m_20185_();
        \u00e2\u02dc\u019212 = \u00e2\u02dc\u01923 - this.f_9743_.m_20186_();
        if (\u00e2\u02dc\u019212 > -0.5 || \u00e2\u02dc\u019212 < 0.5) {
            \u00e2\u02dc\u019212 = 0.0;
        }
        \u00e2\u02dc\u019213 = \u00e2\u02dc\u01924 - this.f_9743_.m_20189_();
        \u00e2\u02dc\u019215 = \u00e2\u02dc\u019211 * \u00e2\u02dc\u019211 + \u00e2\u02dc\u019212 * \u00e2\u02dc\u019212 + \u00e2\u02dc\u019213 * \u00e2\u02dc\u019213;
        boolean \u00e2\u02dc\u019219 = false;
        if (!this.f_9743_.m_8958_() && \u00e2\u02dc\u019215 > 0.0625 && !this.f_9743_.m_5803_() && !this.f_9743_.f_8941_.m_9295_() && this.f_9743_.f_8941_.m_9290_() != GameType.SPECTATOR) {
            \u00e2\u02dc\u019219 = true;
            f_9744_.warn("{} moved wrongly!", (Object)this.f_9743_.m_7755_().getString());
        }
        this.f_9743_.m_19890_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926);
        if (!this.f_9743_.f_19794_ && !this.f_9743_.m_5803_() && (\u00e2\u02dc\u019219 && serverLevel.m_45756_(this.f_9743_, \u00e2\u02dc\u019217) || this.m_9795_(serverLevel, \u00e2\u02dc\u019217))) {
            this.m_9774_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929, \u00e2\u02dc\u01925, \u00e2\u02dc\u01926);
            return;
        }
        this.f_9736_ = \u00e2\u02dc\u019218 >= -0.03125 && this.f_9743_.f_8941_.m_9290_() != GameType.SPECTATOR && !this.f_9745_.m_129915_() && !this.f_9743_.m_150110_().f_35936_ && !this.f_9743_.m_21023_(MobEffects.f_19620_) && !this.f_9743_.m_21255_() && this.m_9793_(this.f_9743_);
        this.f_9743_.m_9236_().m_7726_().m_8385_(this.f_9743_);
        this.f_9743_.m_8972_(this.f_9743_.m_20186_() - \u00e2\u02dc\u019210, p_9874_.m_134139_());
        this.f_9743_.m_6853_(p_9874_.m_134139_());
        if (\u00e2\u02dc\u0192) {
            this.f_9743_.f_19789_ = 0.0f;
        }
        this.f_9743_.m_36378_(this.f_9743_.m_20185_() - \u00e2\u02dc\u01927, this.f_9743_.m_20186_() - \u00e2\u02dc\u01928, this.f_9743_.m_20189_() - \u00e2\u02dc\u01929);
        this.f_9756_ = this.f_9743_.m_20185_();
        this.f_9757_ = this.f_9743_.m_20186_();
        this.f_9758_ = this.f_9743_.m_20189_();
    }

    private boolean m_9795_(LevelReader p_9796_, AABB p_9797_) {
        Stream<VoxelShape> stream = p_9796_.m_7786_(this.f_9743_, this.f_9743_.m_142469_().m_82406_(1.0E-5f), p_9938_ -> true);
        VoxelShape \u00e2\u02dc\u01922 = Shapes.m_83064_(p_9797_.m_82406_(1.0E-5f));
        return stream.anyMatch(p_9800_ -> !Shapes.m_83157_(p_9800_, \u00e2\u02dc\u01922, BooleanOp.f_82689_));
    }

    public void m_143611_(double p_143612_, double p_143613_, double p_143614_, float p_143615_, float p_143616_) {
        this.m_143617_(p_143612_, p_143613_, p_143614_, p_143615_, p_143616_, Collections.emptySet(), true);
    }

    public void m_9774_(double p_9775_, double p_9776_, double p_9777_, float p_9778_, float p_9779_) {
        this.m_143617_(p_9775_, p_9776_, p_9777_, p_9778_, p_9779_, Collections.emptySet(), false);
    }

    public void m_9780_(double p_9781_, double p_9782_, double p_9783_, float p_9784_, float p_9785_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_9786_) {
        this.m_143617_(p_9781_, p_9782_, p_9783_, p_9784_, p_9785_, p_9786_, false);
    }

    public void m_143617_(double p_143618_, double p_143619_, double p_143620_, float p_143621_, float p_143622_, Set<ClientboundPlayerPositionPacket.RelativeArgument> p_143623_, boolean p_143624_) {
        double d = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.X) ? this.f_9743_.m_20185_() : 0.0;
        \u00e2\u02dc\u0192 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.Y) ? this.f_9743_.m_20186_() : 0.0;
        \u00e2\u02dc\u0192 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.Z) ? this.f_9743_.m_20189_() : 0.0;
        float \u00e2\u02dc\u01922 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.Y_ROT) ? this.f_9743_.m_146908_() : 0.0f;
        float \u00e2\u02dc\u01923 = p_143623_.contains((Object)ClientboundPlayerPositionPacket.RelativeArgument.X_ROT) ? this.f_9743_.m_146909_() : 0.0f;
        this.f_9766_ = new Vec3(p_143618_, p_143619_, p_143620_);
        if (++this.f_9767_ == Integer.MAX_VALUE) {
            this.f_9767_ = 0;
        }
        this.f_9735_ = this.f_9746_;
        this.f_9743_.m_19890_(p_143618_, p_143619_, p_143620_, p_143621_, p_143622_);
        this.f_9743_.f_8906_.m_141995_(new ClientboundPlayerPositionPacket(p_143618_ - d, p_143619_ - \u00e2\u02dc\u0192, p_143620_ - \u00e2\u02dc\u0192, p_143621_ - \u00e2\u02dc\u01922, p_143622_ - \u00e2\u02dc\u01923, p_143623_, this.f_9767_, p_143624_));
    }

    @Override
    public void m_7502_(ServerboundPlayerActionPacket p_9889_) {
        PacketUtils.m_131359_(p_9889_, this, this.f_9743_.m_9236_());
        BlockPos blockPos = p_9889_.m_134281_();
        this.f_9743_.m_9243_();
        ServerboundPlayerActionPacket.Action \u00e2\u02dc\u01922 = p_9889_.m_134285_();
        switch (\u00e2\u02dc\u01922) {
            case SWAP_ITEM_WITH_OFFHAND: {
                if (!this.f_9743_.m_5833_()) {
                    ItemStack itemStack = this.f_9743_.m_21120_(InteractionHand.OFF_HAND);
                    this.f_9743_.m_21008_(InteractionHand.OFF_HAND, this.f_9743_.m_21120_(InteractionHand.MAIN_HAND));
                    this.f_9743_.m_21008_(InteractionHand.MAIN_HAND, itemStack);
                    this.f_9743_.m_5810_();
                }
                return;
            }
            case DROP_ITEM: {
                if (!this.f_9743_.m_5833_()) {
                    this.f_9743_.m_182294_(false);
                }
                return;
            }
            case DROP_ALL_ITEMS: {
                if (!this.f_9743_.m_5833_()) {
                    this.f_9743_.m_182294_(true);
                }
                return;
            }
            case RELEASE_USE_ITEM: {
                this.f_9743_.m_21253_();
                return;
            }
            case START_DESTROY_BLOCK: 
            case ABORT_DESTROY_BLOCK: 
            case STOP_DESTROY_BLOCK: {
                this.f_9743_.f_8941_.m_7391_(blockPos, \u00e2\u02dc\u01922, p_9889_.m_134284_(), this.f_9743_.f_19853_.m_151558_());
                return;
            }
        }
        throw new IllegalArgumentException("Invalid player action");
    }

    private static boolean m_9790_(ServerPlayer p_9791_, ItemStack p_9792_) {
        if (p_9792_.m_41619_()) {
            return false;
        }
        Item item = p_9792_.m_41720_();
        return (item instanceof BlockItem || item instanceof BucketItem) && !p_9791_.m_36335_().m_41519_(item);
    }

    @Override
    public void m_6371_(ServerboundUseItemOnPacket p_9930_) {
        PacketUtils.m_131359_(p_9930_, this, this.f_9743_.m_9236_());
        ServerLevel serverLevel = this.f_9743_.m_9236_();
        InteractionHand \u00e2\u02dc\u01922 = p_9930_.m_134703_();
        ItemStack \u00e2\u02dc\u01923 = this.f_9743_.m_21120_(\u00e2\u02dc\u01922);
        BlockHitResult \u00e2\u02dc\u01924 = p_9930_.m_134706_();
        BlockPos \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_82425_();
        Direction \u00e2\u02dc\u01926 = \u00e2\u02dc\u01924.m_82434_();
        this.f_9743_.m_9243_();
        int \u00e2\u02dc\u01927 = this.f_9743_.f_19853_.m_151558_();
        if (\u00e2\u02dc\u01925.m_123342_() < \u00e2\u02dc\u01927) {
            if (this.f_9766_ == null && this.f_9743_.m_20275_((double)\u00e2\u02dc\u01925.m_123341_() + 0.5, (double)\u00e2\u02dc\u01925.m_123342_() + 0.5, (double)\u00e2\u02dc\u01925.m_123343_() + 0.5) < 64.0 && serverLevel.m_7966_(this.f_9743_, \u00e2\u02dc\u01925)) {
                InteractionResult interactionResult = this.f_9743_.f_8941_.m_7179_(this.f_9743_, serverLevel, \u00e2\u02dc\u01923, \u00e2\u02dc\u01922, \u00e2\u02dc\u01924);
                if (\u00e2\u02dc\u01926 == Direction.UP && !interactionResult.m_19077_() && \u00e2\u02dc\u01925.m_123342_() >= \u00e2\u02dc\u01927 - 1 && ServerGamePacketListenerImpl.m_9790_(this.f_9743_, \u00e2\u02dc\u01923)) {
                    MutableComponent mutableComponent = new TranslatableComponent("build.tooHigh", \u00e2\u02dc\u01927 - 1).m_130940_(ChatFormatting.RED);
                    this.f_9743_.m_9146_(mutableComponent, ChatType.GAME_INFO, Util.f_137441_);
                } else if (interactionResult.m_19080_()) {
                    this.f_9743_.m_21011_(\u00e2\u02dc\u01922, true);
                }
            }
        } else {
            MutableComponent mutableComponent = new TranslatableComponent("build.tooHigh", \u00e2\u02dc\u01927 - 1).m_130940_(ChatFormatting.RED);
            this.f_9743_.m_9146_(mutableComponent, ChatType.GAME_INFO, Util.f_137441_);
        }
        this.f_9743_.f_8906_.m_141995_(new ClientboundBlockUpdatePacket(serverLevel, \u00e2\u02dc\u01925));
        this.f_9743_.f_8906_.m_141995_(new ClientboundBlockUpdatePacket(serverLevel, \u00e2\u02dc\u01925.m_142300_(\u00e2\u02dc\u01926)));
    }

    @Override
    public void m_5760_(ServerboundUseItemPacket p_9932_) {
        PacketUtils.m_131359_(p_9932_, this, this.f_9743_.m_9236_());
        ServerLevel serverLevel = this.f_9743_.m_9236_();
        InteractionHand \u00e2\u02dc\u01922 = p_9932_.m_134717_();
        ItemStack \u00e2\u02dc\u01923 = this.f_9743_.m_21120_(\u00e2\u02dc\u01922);
        this.f_9743_.m_9243_();
        if (\u00e2\u02dc\u01923.m_41619_()) {
            return;
        }
        InteractionResult \u00e2\u02dc\u01924 = this.f_9743_.f_8941_.m_6261_(this.f_9743_, serverLevel, \u00e2\u02dc\u01923, \u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01924.m_19080_()) {
            this.f_9743_.m_21011_(\u00e2\u02dc\u01922, true);
        }
    }

    @Override
    public void m_6936_(ServerboundTeleportToEntityPacket p_9928_) {
        PacketUtils.m_131359_(p_9928_, this, this.f_9743_.m_9236_());
        if (this.f_9743_.m_5833_()) {
            for (ServerLevel serverLevel : this.f_9745_.m_129785_()) {
                Entity entity = p_9928_.m_134681_(serverLevel);
                if (entity == null) continue;
                this.f_9743_.m_8999_(serverLevel, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), entity.m_146908_(), entity.m_146909_());
                return;
            }
        }
    }

    @Override
    public void m_7529_(ServerboundResourcePackPacket p_9901_) {
        PacketUtils.m_131359_(p_9901_, this, this.f_9743_.m_9236_());
        if (p_9901_.m_179741_() == ServerboundResourcePackPacket.Action.DECLINED && this.f_9745_.m_142205_()) {
            f_9744_.info("Disconnecting {} due to resource pack rejection", (Object)this.f_9743_.m_7755_());
            this.m_9942_(new TranslatableComponent("multiplayer.requiredTexturePrompt.disconnect"));
        }
    }

    @Override
    public void m_5938_(ServerboundPaddleBoatPacket p_9878_) {
        PacketUtils.m_131359_(p_9878_, this, this.f_9743_.m_9236_());
        Entity entity = this.f_9743_.m_20202_();
        if (entity instanceof Boat) {
            ((Boat)entity).m_38339_(p_9878_.m_134218_(), p_9878_.m_134221_());
        }
    }

    @Override
    public void m_142110_(ServerboundPongPacket p_143652_) {
    }

    @Override
    public void m_7026_(Component p_9825_) {
        f_9744_.info("{} lost connection: {}", (Object)this.f_9743_.m_7755_().getString(), (Object)p_9825_.getString());
        this.f_9745_.m_129929_();
        this.f_9745_.m_6846_().m_11264_(new TranslatableComponent("multiplayer.player.left", this.f_9743_.m_5446_()).m_130940_(ChatFormatting.YELLOW), ChatType.SYSTEM, Util.f_137441_);
        this.f_9743_.m_9231_();
        this.f_9745_.m_6846_().m_11286_(this.f_9743_);
        this.f_9743_.m_8967_().m_7670_();
        if (this.m_9956_()) {
            f_9744_.info("Stopping singleplayer server as player logged out");
            this.f_9745_.m_7570_(false);
        }
    }

    @Override
    public void m_141995_(Packet<?> p_9830_) {
        this.m_9831_(p_9830_, null);
    }

    public void m_9831_(Packet<?> p_9832_, @Nullable GenericFutureListener<? extends Future<? super Void>> p_9833_) {
        try {
            this.f_9742_.m_129514_(p_9832_, p_9833_);
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_(throwable, "Sending packet");
            CrashReportCategory \u00e2\u02dc\u01922 = crashReport.m_127514_("Packet being sent");
            \u00e2\u02dc\u01922.m_128165_("Packet class", () -> p_9832_.getClass().getCanonicalName());
            throw new ReportedException(crashReport);
        }
    }

    @Override
    public void m_7798_(ServerboundSetCarriedItemPacket p_9909_) {
        PacketUtils.m_131359_(p_9909_, this, this.f_9743_.m_9236_());
        if (p_9909_.m_134498_() < 0 || p_9909_.m_134498_() >= Inventory.m_36059_()) {
            f_9744_.warn("{} tried to set an invalid carried item", (Object)this.f_9743_.m_7755_().getString());
            return;
        }
        if (this.f_9743_.m_150109_().f_35977_ != p_9909_.m_134498_() && this.f_9743_.m_7655_() == InteractionHand.MAIN_HAND) {
            this.f_9743_.m_5810_();
        }
        this.f_9743_.m_150109_().f_35977_ = p_9909_.m_134498_();
        this.f_9743_.m_9243_();
    }

    @Override
    public void m_7388_(ServerboundChatPacket p_9841_) {
        String string = StringUtils.normalizeSpace((String)p_9841_.m_133837_());
        for (int i = 0; i < string.length(); ++i) {
            if (SharedConstants.m_136188_(string.charAt(i))) continue;
            this.m_9942_(new TranslatableComponent("multiplayer.disconnect.illegal_characters"));
            return;
        }
        if (string.startsWith("/")) {
            PacketUtils.m_131359_(p_9841_, this, this.f_9743_.m_9236_());
            this.m_143628_(TextFilter.FilteredText.m_143720_(string));
        } else {
            this.m_9809_(string, this::m_143628_);
        }
    }

    private void m_143628_(TextFilter.FilteredText p_143629_) {
        if (this.f_9743_.m_9241_() == ChatVisiblity.HIDDEN) {
            this.m_141995_(new ClientboundChatPacket(new TranslatableComponent("chat.disabled.options").m_130940_(ChatFormatting.RED), ChatType.SYSTEM, Util.f_137441_));
            return;
        }
        this.f_9743_.m_9243_();
        String string = p_143629_.m_143719_();
        if (string.startsWith("/")) {
            this.m_9957_(string);
        } else {
            \u00e2\u02dc\u0192 = p_143629_.m_143722_();
            TranslatableComponent translatableComponent = \u00e2\u02dc\u0192.isEmpty() ? null : new TranslatableComponent("chat.type.text", this.f_9743_.m_5446_(), \u00e2\u02dc\u0192);
            \u00e2\u02dc\u0192 = new TranslatableComponent("chat.type.text", this.f_9743_.m_5446_(), string);
            this.f_9745_.m_6846_().m_143991_(\u00e2\u02dc\u0192, p_143644_ -> this.f_9743_.m_143421_((ServerPlayer)p_143644_) ? translatableComponent : \u00e2\u02dc\u0192, ChatType.CHAT, this.f_9743_.m_142081_());
        }
        this.f_9750_ += 20;
        if (this.f_9750_ > 200 && !this.f_9745_.m_6846_().m_11303_(this.f_9743_.m_36316_())) {
            this.m_9942_(new TranslatableComponent("disconnect.spam"));
        }
    }

    private void m_9957_(String p_9958_) {
        this.f_9745_.m_129892_().m_82117_(this.f_9743_.m_20203_(), p_9958_);
    }

    @Override
    public void m_7953_(ServerboundSwingPacket p_9926_) {
        PacketUtils.m_131359_(p_9926_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9243_();
        this.f_9743_.m_6674_(p_9926_.m_134674_());
    }

    @Override
    public void m_5681_(ServerboundPlayerCommandPacket p_9891_) {
        PacketUtils.m_131359_(p_9891_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9243_();
        switch (p_9891_.m_134320_()) {
            case PRESS_SHIFT_KEY: {
                this.f_9743_.m_20260_(true);
                break;
            }
            case RELEASE_SHIFT_KEY: {
                this.f_9743_.m_20260_(false);
                break;
            }
            case START_SPRINTING: {
                this.f_9743_.m_6858_(true);
                break;
            }
            case STOP_SPRINTING: {
                this.f_9743_.m_6858_(false);
                break;
            }
            case STOP_SLEEPING: {
                if (!this.f_9743_.m_5803_()) break;
                this.f_9743_.m_6145_(false, true);
                this.f_9766_ = this.f_9743_.m_20182_();
                break;
            }
            case START_RIDING_JUMP: {
                if (!(this.f_9743_.m_20202_() instanceof PlayerRideableJumping)) break;
                PlayerRideableJumping playerRideableJumping = (PlayerRideableJumping)((Object)this.f_9743_.m_20202_());
                int \u00e2\u02dc\u01922 = p_9891_.m_134321_();
                if (!playerRideableJumping.m_7132_() || \u00e2\u02dc\u01922 <= 0) break;
                playerRideableJumping.m_7199_(\u00e2\u02dc\u01922);
                break;
            }
            case STOP_RIDING_JUMP: {
                if (!(this.f_9743_.m_20202_() instanceof PlayerRideableJumping)) break;
                \u00e2\u02dc\u0192 = (PlayerRideableJumping)((Object)this.f_9743_.m_20202_());
                \u00e2\u02dc\u0192.m_8012_();
                break;
            }
            case OPEN_INVENTORY: {
                if (!(this.f_9743_.m_20202_() instanceof AbstractHorse)) break;
                ((AbstractHorse)this.f_9743_.m_20202_()).m_30620_(this.f_9743_);
                break;
            }
            case START_FALL_FLYING: {
                if (this.f_9743_.m_36319_()) break;
                this.f_9743_.m_36321_();
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid client command!");
            }
        }
    }

    @Override
    public void m_6946_(ServerboundInteractPacket p_9866_) {
        PacketUtils.m_131359_(p_9866_, this, this.f_9743_.m_9236_());
        ServerLevel serverLevel = this.f_9743_.m_9236_();
        final Entity \u00e2\u02dc\u01922 = p_9866_.m_179603_(serverLevel);
        this.f_9743_.m_9243_();
        this.f_9743_.m_20260_(p_9866_.m_134061_());
        if (\u00e2\u02dc\u01922 != null) {
            double d = 36.0;
            if (this.f_9743_.m_20280_(\u00e2\u02dc\u01922) < 36.0) {
                p_9866_.m_179617_(new ServerboundInteractPacket.Handler(){

                    private void m_143678_(InteractionHand p_143679_, EntityInteraction p_143680_) {
                        ItemStack itemStack = ServerGamePacketListenerImpl.this.f_9743_.m_21120_(p_143679_).m_41777_();
                        InteractionResult \u00e2\u02dc\u019222 = p_143680_.m_143694_(ServerGamePacketListenerImpl.this.f_9743_, \u00e2\u02dc\u01922, p_143679_);
                        if (\u00e2\u02dc\u019222.m_19077_()) {
                            CriteriaTriggers.f_10565_.m_61494_(ServerGamePacketListenerImpl.this.f_9743_, itemStack, \u00e2\u02dc\u01922);
                            if (\u00e2\u02dc\u019222.m_19080_()) {
                                ServerGamePacketListenerImpl.this.f_9743_.m_21011_(p_143679_, true);
                            }
                        }
                    }

                    @Override
                    public void m_142299_(InteractionHand p_143677_) {
                        this.m_143678_(p_143677_, Player::m_36157_);
                    }

                    @Override
                    public void m_142143_(InteractionHand p_143682_, Vec3 p_143683_) {
                        this.m_143678_(p_143682_, (p_143686_, p_143687_, p_143688_) -> p_143687_.m_7111_(p_143686_, p_143683_, p_143688_));
                    }

                    @Override
                    public void m_141994_() {
                        if (\u00e2\u02dc\u01922 instanceof ItemEntity || \u00e2\u02dc\u01922 instanceof ExperienceOrb || \u00e2\u02dc\u01922 instanceof AbstractArrow || \u00e2\u02dc\u01922 == ServerGamePacketListenerImpl.this.f_9743_) {
                            ServerGamePacketListenerImpl.this.m_9942_(new TranslatableComponent("multiplayer.disconnect.invalid_entity_attacked"));
                            f_9744_.warn("Player {} tried to attack an invalid entity", (Object)ServerGamePacketListenerImpl.this.f_9743_.m_7755_().getString());
                            return;
                        }
                        ServerGamePacketListenerImpl.this.f_9743_.m_5706_(\u00e2\u02dc\u01922);
                    }
                });
            }
        }
    }

    @Override
    public void m_6272_(ServerboundClientCommandPacket p_9843_) {
        PacketUtils.m_131359_(p_9843_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9243_();
        ServerboundClientCommandPacket.Action action = p_9843_.m_133850_();
        switch (action) {
            case PERFORM_RESPAWN: {
                if (this.f_9743_.f_8944_) {
                    this.f_9743_.f_8944_ = false;
                    this.f_9743_ = this.f_9745_.m_6846_().m_11236_(this.f_9743_, true);
                    CriteriaTriggers.f_10588_.m_19757_(this.f_9743_, Level.f_46430_, Level.f_46428_);
                    break;
                }
                if (this.f_9743_.m_21223_() > 0.0f) {
                    return;
                }
                this.f_9743_ = this.f_9745_.m_6846_().m_11236_(this.f_9743_, false);
                if (!this.f_9745_.m_7035_()) break;
                this.f_9743_.m_143403_(GameType.SPECTATOR);
                this.f_9743_.m_9236_().m_46469_().m_46170_(GameRules.f_46146_).m_46246_(false, this.f_9745_);
                break;
            }
            case REQUEST_STATS: {
                this.f_9743_.m_8951_().m_12819_(this.f_9743_);
            }
        }
    }

    @Override
    public void m_7951_(ServerboundContainerClosePacket p_9858_) {
        PacketUtils.m_131359_(p_9858_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9230_();
    }

    @Override
    public void m_5914_(ServerboundContainerClickPacket p_9856_) {
        PacketUtils.m_131359_(p_9856_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9243_();
        if (this.f_9743_.f_36096_.f_38840_ == p_9856_.m_133959_()) {
            if (this.f_9743_.m_5833_()) {
                this.f_9743_.f_36096_.m_150429_();
            } else {
                boolean bl = p_9856_.m_182741_() != this.f_9743_.f_36096_.m_182424_();
                this.f_9743_.f_36096_.m_150443_();
                this.f_9743_.f_36096_.m_150399_(p_9856_.m_133962_(), p_9856_.m_133963_(), p_9856_.m_133966_(), this.f_9743_);
                for (Int2ObjectMap.Entry entry : Int2ObjectMaps.fastIterable(p_9856_.m_179582_())) {
                    this.f_9743_.f_36096_.m_182414_(entry.getIntKey(), (ItemStack)entry.getValue());
                }
                this.f_9743_.f_36096_.m_150422_(p_9856_.m_179581_());
                this.f_9743_.f_36096_.m_150444_();
                if (bl) {
                    this.f_9743_.f_36096_.m_182423_();
                } else {
                    this.f_9743_.f_36096_.m_38946_();
                }
            }
        }
    }

    @Override
    public void m_7191_(ServerboundPlaceRecipePacket p_9882_) {
        PacketUtils.m_131359_(p_9882_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9243_();
        if (this.f_9743_.m_5833_() || this.f_9743_.f_36096_.f_38840_ != p_9882_.m_134249_() || !(this.f_9743_.f_36096_ instanceof RecipeBookMenu)) {
            return;
        }
        this.f_9745_.m_129894_().m_44043_(p_9882_.m_134252_()).ifPresent(p_143650_ -> ((RecipeBookMenu)this.f_9743_.f_36096_).m_6951_(p_9882_.m_134253_(), (Recipe<?>)p_143650_, this.f_9743_));
    }

    @Override
    public void m_6557_(ServerboundContainerButtonClickPacket p_9854_) {
        PacketUtils.m_131359_(p_9854_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9243_();
        if (this.f_9743_.f_36096_.f_38840_ == p_9854_.m_133935_() && !this.f_9743_.m_5833_()) {
            this.f_9743_.f_36096_.m_6366_(this.f_9743_, p_9854_.m_133938_());
            this.f_9743_.f_36096_.m_38946_();
        }
    }

    @Override
    public void m_5964_(ServerboundSetCreativeModeSlotPacket p_9915_) {
        PacketUtils.m_131359_(p_9915_, this, this.f_9743_.m_9236_());
        if (this.f_9743_.f_8941_.m_9295_()) {
            boolean bl = p_9915_.m_134561_() < 0;
            ItemStack \u00e2\u02dc\u01922 = p_9915_.m_134564_();
            CompoundTag \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_41737_("BlockEntityTag");
            if (!\u00e2\u02dc\u01922.m_41619_() && \u00e2\u02dc\u01923 != null && \u00e2\u02dc\u01923.m_128441_("x") && \u00e2\u02dc\u01923.m_128441_("y") && \u00e2\u02dc\u01923.m_128441_("z") && (\u00e2\u02dc\u0192 = this.f_9743_.f_19853_.m_7702_(\u00e2\u02dc\u0192 = new BlockPos(\u00e2\u02dc\u01923.m_128451_("x"), \u00e2\u02dc\u01923.m_128451_("y"), \u00e2\u02dc\u01923.m_128451_("z")))) != null) {
                CompoundTag compoundTag = \u00e2\u02dc\u0192.m_6945_(new CompoundTag());
                compoundTag.m_128473_("x");
                compoundTag.m_128473_("y");
                compoundTag.m_128473_("z");
                \u00e2\u02dc\u01922.m_41700_("BlockEntityTag", compoundTag);
            }
            boolean bl2 = p_9915_.m_134561_() >= 1 && p_9915_.m_134561_() <= 45;
            boolean bl3 = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922.m_41619_() || \u00e2\u02dc\u01922.m_41773_() >= 0 && \u00e2\u02dc\u01922.m_41613_() <= 64 && !\u00e2\u02dc\u01922.m_41619_();
            if (bl2 && \u00e2\u02dc\u0192) {
                this.f_9743_.f_36095_.m_38853_(p_9915_.m_134561_()).m_5852_(\u00e2\u02dc\u01922);
                this.f_9743_.f_36095_.m_38946_();
            } else if (bl && \u00e2\u02dc\u0192 && this.f_9751_ < 200) {
                this.f_9751_ += 20;
                this.f_9743_.m_36176_(\u00e2\u02dc\u01922, true);
            }
        }
    }

    @Override
    public void m_5527_(ServerboundSignUpdatePacket p_9921_) {
        List<String> list = Stream.of(p_9921_.m_134663_()).map(ChatFormatting::m_126649_).collect(Collectors.toList());
        this.m_9815_(list, p_143662_ -> this.m_9922_(p_9921_, (List<TextFilter.FilteredText>)p_143662_));
    }

    private void m_9922_(ServerboundSignUpdatePacket p_9923_, List<TextFilter.FilteredText> p_9924_) {
        this.f_9743_.m_9243_();
        ServerLevel serverLevel = this.f_9743_.m_9236_();
        BlockPos \u00e2\u02dc\u01922 = p_9923_.m_134660_();
        if (serverLevel.m_46805_(\u00e2\u02dc\u01922)) {
            BlockState blockState = serverLevel.m_8055_(\u00e2\u02dc\u01922);
            BlockEntity \u00e2\u02dc\u01923 = serverLevel.m_7702_(\u00e2\u02dc\u01922);
            if (!(\u00e2\u02dc\u01923 instanceof SignBlockEntity)) {
                return;
            }
            SignBlockEntity \u00e2\u02dc\u01924 = (SignBlockEntity)\u00e2\u02dc\u01923;
            if (!\u00e2\u02dc\u01924.m_59751_() || !this.f_9743_.m_142081_().equals(\u00e2\u02dc\u01924.m_155726_())) {
                f_9744_.warn("Player {} just tried to change non-editable sign", (Object)this.f_9743_.m_7755_().getString());
                return;
            }
            for (int i = 0; i < p_9924_.size(); ++i) {
                TextFilter.FilteredText filteredText = p_9924_.get(i);
                if (this.f_9743_.m_143387_()) {
                    \u00e2\u02dc\u01924.m_59732_(i, new TextComponent(filteredText.m_143722_()));
                    continue;
                }
                \u00e2\u02dc\u01924.m_155702_(i, new TextComponent(filteredText.m_143719_()), new TextComponent(filteredText.m_143722_()));
            }
            \u00e2\u02dc\u01924.m_6596_();
            serverLevel.m_7260_(\u00e2\u02dc\u01922, blockState, blockState, 3);
        }
    }

    @Override
    public void m_5683_(ServerboundKeepAlivePacket p_9870_) {
        if (this.f_9748_ && p_9870_.m_134102_() == this.f_9749_) {
            int n = (int)(Util.m_137550_() - this.f_9747_);
            this.f_9743_.f_8943_ = (this.f_9743_.f_8943_ * 3 + n) / 4;
            this.f_9748_ = false;
        } else if (!this.m_9956_()) {
            this.m_9942_(new TranslatableComponent("disconnect.timeout"));
        }
    }

    @Override
    public void m_6828_(ServerboundPlayerAbilitiesPacket p_9887_) {
        PacketUtils.m_131359_(p_9887_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_150110_().f_35935_ = p_9887_.m_134264_() && this.f_9743_.m_150110_().f_35936_;
    }

    @Override
    public void m_5617_(ServerboundClientInformationPacket p_9845_) {
        PacketUtils.m_131359_(p_9845_, this, this.f_9743_.m_9236_());
        this.f_9743_.m_9156_(p_9845_);
    }

    @Override
    public void m_7423_(ServerboundCustomPayloadPacket p_9860_) {
    }

    @Override
    public void m_7477_(ServerboundChangeDifficultyPacket p_9839_) {
        PacketUtils.m_131359_(p_9839_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_20310_(2) && !this.m_9956_()) {
            return;
        }
        this.f_9745_.m_129827_(p_9839_.m_133824_(), false);
    }

    @Override
    public void m_7728_(ServerboundLockDifficultyPacket p_9872_) {
        PacketUtils.m_131359_(p_9872_, this, this.f_9743_.m_9236_());
        if (!this.f_9743_.m_20310_(2) && !this.m_9956_()) {
            return;
        }
        this.f_9745_.m_129958_(p_9872_.m_134115_());
    }

    @Override
    public ServerPlayer m_142253_() {
        return this.f_9743_;
    }

    @FunctionalInterface
    static interface EntityInteraction {
        public InteractionResult m_143694_(ServerPlayer var1, Entity var2, InteractionHand var3);
    }
}

