/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.network;

import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.server.network.TextFilter;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.thread.ProcessorMailbox;
import org.apache.commons.codec.binary.Base64;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextFilterClient
implements AutoCloseable {
    private static final Logger f_10098_ = LogManager.getLogger();
    private static final AtomicInteger f_10099_ = new AtomicInteger(1);
    private static final ThreadFactory f_10100_ = p_10148_ -> {
        Thread thread = new Thread(p_10148_);
        thread.setName("Chat-Filter-Worker-" + f_10099_.getAndIncrement());
        return thread;
    };
    private final URL f_10101_;
    final URL f_10102_;
    final URL f_10103_;
    private final String f_10104_;
    private final int f_10105_;
    private final String f_10106_;
    final IgnoreStrategy f_10107_;
    final ExecutorService f_10108_;

    private TextFilterClient(URI p_143726_, String p_143727_, int p_143728_, String p_143729_, IgnoreStrategy p_143730_, int p_143731_) throws MalformedURLException {
        this.f_10104_ = p_143727_;
        this.f_10105_ = p_143728_;
        this.f_10106_ = p_143729_;
        this.f_10107_ = p_143730_;
        this.f_10101_ = p_143726_.resolve("/v1/chat").toURL();
        this.f_10102_ = p_143726_.resolve("/v1/join").toURL();
        this.f_10103_ = p_143726_.resolve("/v1/leave").toURL();
        this.f_10108_ = Executors.newFixedThreadPool(p_143731_, f_10100_);
    }

    @Nullable
    public static TextFilterClient m_143736_(String p_143737_) {
        if (Strings.isNullOrEmpty((String)p_143737_)) {
            return null;
        }
        try {
            JsonObject jsonObject = GsonHelper.m_13864_(p_143737_);
            URI \u00e2\u02dc\u01922 = new URI(GsonHelper.m_13906_(jsonObject, "apiServer"));
            String \u00e2\u02dc\u01923 = GsonHelper.m_13906_(jsonObject, "apiKey");
            if (\u00e2\u02dc\u01923.isEmpty()) {
                throw new IllegalArgumentException("Missing API key");
            }
            int \u00e2\u02dc\u01924 = GsonHelper.m_13824_(jsonObject, "ruleId", 1);
            String \u00e2\u02dc\u01925 = GsonHelper.m_13851_(jsonObject, "serverId", "");
            int \u00e2\u02dc\u01926 = GsonHelper.m_13824_(jsonObject, "hashesToDrop", -1);
            int \u00e2\u02dc\u01927 = GsonHelper.m_13824_(jsonObject, "maxConcurrentRequests", 7);
            IgnoreStrategy \u00e2\u02dc\u01928 = IgnoreStrategy.m_143744_(\u00e2\u02dc\u01926);
            return new TextFilterClient(\u00e2\u02dc\u01922, new Base64().encodeToString(\u00e2\u02dc\u01923.getBytes(StandardCharsets.US_ASCII)), \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01928, \u00e2\u02dc\u01927);
        }
        catch (Exception exception) {
            f_10098_.warn("Failed to parse chat filter config {}", (Object)p_143737_, (Object)exception);
            return null;
        }
    }

    void m_10141_(GameProfile p_10142_, URL p_10143_, Executor p_10144_) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("server", this.f_10106_);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("user_id", p_10142_.getId().toString());
        jsonObject.addProperty("user_display_name", p_10142_.getName());
        p_10144_.execute(() -> {
            try {
                this.m_10151_(jsonObject, p_10143_);
            }
            catch (Exception exception) {
                f_10098_.warn("Failed to send join/leave packet to {} for player {}", (Object)p_10143_, (Object)p_10142_, (Object)exception);
            }
        });
    }

    CompletableFuture<TextFilter.FilteredText> m_10136_(GameProfile p_10137_, String p_10138_, IgnoreStrategy p_10139_, Executor p_10140_) {
        if (p_10138_.isEmpty()) {
            return CompletableFuture.completedFuture(TextFilter.FilteredText.f_143712_);
        }
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("rule", (Number)this.f_10105_);
        jsonObject.addProperty("server", this.f_10106_);
        jsonObject.addProperty("room", "Chat");
        jsonObject.addProperty("player", p_10137_.getId().toString());
        jsonObject.addProperty("player_display_name", p_10137_.getName());
        jsonObject.addProperty("text", p_10138_);
        return CompletableFuture.supplyAsync(() -> {
            try {
                JsonObject jsonObject = this.m_10127_(jsonObject, this.f_10101_);
                boolean \u00e2\u02dc\u01922 = GsonHelper.m_13855_(jsonObject, "response", false);
                if (\u00e2\u02dc\u01922) {
                    return TextFilter.FilteredText.m_143720_(p_10138_);
                }
                String \u00e2\u02dc\u01923 = GsonHelper.m_13851_(jsonObject, "hashed", null);
                if (\u00e2\u02dc\u01923 == null) {
                    return TextFilter.FilteredText.m_143723_(p_10138_);
                }
                int \u00e2\u02dc\u01924 = GsonHelper.m_13933_(jsonObject, "hashes").size();
                return p_10139_.m_10171_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924) ? TextFilter.FilteredText.m_143723_(p_10138_) : new TextFilter.FilteredText(p_10138_, \u00e2\u02dc\u01923);
            }
            catch (Exception exception) {
                f_10098_.warn("Failed to validate message '{}'", (Object)p_10138_, (Object)exception);
                return TextFilter.FilteredText.m_143723_(p_10138_);
            }
        }, p_10140_);
    }

    @Override
    public void close() {
        this.f_10108_.shutdownNow();
    }

    private void m_10145_(InputStream p_10146_) throws IOException {
        byte[] byArray = new byte[1024];
        while (p_10146_.read(byArray) != -1) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonObject m_10127_(JsonObject p_10128_, URL p_10129_) throws IOException {
        HttpURLConnection httpURLConnection = this.m_10156_(p_10128_, p_10129_);
        try (InputStream \u00e2\u02dc\u01922 = httpURLConnection.getInputStream();){
            JsonObject jsonObject;
            if (httpURLConnection.getResponseCode() == 204) {
                JsonObject jsonObject2 = new JsonObject();
                return jsonObject2;
            }
            try {
                jsonObject = Streams.parse((JsonReader)new JsonReader((Reader)new InputStreamReader(\u00e2\u02dc\u01922))).getAsJsonObject();
            }
            catch (Throwable throwable) {
                this.m_10145_(\u00e2\u02dc\u01922);
                throw throwable;
            }
            this.m_10145_(\u00e2\u02dc\u01922);
            return jsonObject;
        }
    }

    private void m_10151_(JsonObject p_10152_, URL p_10153_) throws IOException {
        HttpURLConnection httpURLConnection = this.m_10156_(p_10152_, p_10153_);
        try (InputStream \u00e2\u02dc\u01922 = httpURLConnection.getInputStream();){
            this.m_10145_(\u00e2\u02dc\u01922);
        }
    }

    private HttpURLConnection m_10156_(JsonObject p_10157_, URL p_10158_) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)p_10158_.openConnection();
        httpURLConnection.setConnectTimeout(15000);
        httpURLConnection.setReadTimeout(2000);
        httpURLConnection.setUseCaches(false);
        httpURLConnection.setDoOutput(true);
        httpURLConnection.setDoInput(true);
        httpURLConnection.setRequestMethod("POST");
        httpURLConnection.setRequestProperty("Content-Type", "application/json; charset=utf-8");
        httpURLConnection.setRequestProperty("Accept", "application/json");
        httpURLConnection.setRequestProperty("Authorization", "Basic " + this.f_10104_);
        httpURLConnection.setRequestProperty("User-Agent", "Minecraft server" + SharedConstants.m_136187_().getName());
        try (OutputStreamWriter \u00e2\u02dc\u01922 = new OutputStreamWriter(httpURLConnection.getOutputStream(), StandardCharsets.UTF_8);
             JsonWriter jsonWriter = new JsonWriter((Writer)\u00e2\u02dc\u01922);){
            Streams.write((JsonElement)p_10157_, (JsonWriter)jsonWriter);
        }
        int \u00e2\u02dc\u01923 = httpURLConnection.getResponseCode();
        if (\u00e2\u02dc\u01923 < 200 || \u00e2\u02dc\u01923 >= 300) {
            throw new RequestFailedException(\u00e2\u02dc\u01923 + " " + httpURLConnection.getResponseMessage());
        }
        return httpURLConnection;
    }

    public TextFilter m_10134_(GameProfile p_10135_) {
        return new PlayerContext(p_10135_);
    }

    @FunctionalInterface
    public static interface IgnoreStrategy {
        public static final IgnoreStrategy f_10162_ = (p_10169_, p_10170_) -> false;
        public static final IgnoreStrategy f_10163_ = (p_10166_, p_10167_) -> p_10166_.length() == p_10167_;

        public static IgnoreStrategy m_143738_(int p_143739_) {
            return (p_143742_, p_143743_) -> p_143743_ >= p_143739_;
        }

        public static IgnoreStrategy m_143744_(int p_143745_) {
            switch (p_143745_) {
                case -1: {
                    return f_10162_;
                }
                case 0: {
                    return f_10163_;
                }
            }
            return IgnoreStrategy.m_143738_(p_143745_);
        }

        public boolean m_10171_(String var1, int var2);
    }

    public static class RequestFailedException
    extends RuntimeException {
        RequestFailedException(String p_10199_) {
            super(p_10199_);
        }
    }

    class PlayerContext
    implements TextFilter {
        private final GameProfile f_10175_;
        private final Executor f_10176_;

        PlayerContext(GameProfile p_10179_) {
            this.f_10175_ = p_10179_;
            ProcessorMailbox<Runnable> processorMailbox = ProcessorMailbox.m_18751_(TextFilterClient.this.f_10108_, "chat stream for " + p_10179_.getName());
            this.f_10176_ = processorMailbox::m_6937_;
        }

        @Override
        public void m_7674_() {
            TextFilterClient.this.m_10141_(this.f_10175_, TextFilterClient.this.f_10102_, this.f_10176_);
        }

        @Override
        public void m_7670_() {
            TextFilterClient.this.m_10141_(this.f_10175_, TextFilterClient.this.f_10103_, this.f_10176_);
        }

        @Override
        public CompletableFuture<List<TextFilter.FilteredText>> m_5925_(List<String> p_10190_) {
            List list = (List)p_10190_.stream().map(p_10195_ -> TextFilterClient.this.m_10136_(this.f_10175_, (String)p_10195_, TextFilterClient.this.f_10107_, this.f_10176_)).collect(ImmutableList.toImmutableList());
            return Util.m_143840_(list).exceptionally(p_143747_ -> ImmutableList.of());
        }

        @Override
        public CompletableFuture<TextFilter.FilteredText> m_6770_(String p_10186_) {
            return TextFilterClient.this.m_10136_(this.f_10175_, p_10186_, TextFilterClient.this.f_10107_, this.f_10176_);
        }
    }
}

