/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.base.CharMatcher;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.ResourceLocationException;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.ResourcePackFileNotFoundException;
import org.apache.commons.io.filefilter.DirectoryFileFilter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FolderPackResources
extends AbstractPackResources {
    private static final Logger f_10252_ = LogManager.getLogger();
    private static final boolean f_10253_ = Util.m_137581_() == Util.OS.WINDOWS;
    private static final CharMatcher f_10254_ = CharMatcher.is((char)'\\');

    public FolderPackResources(File p_10257_) {
        super(p_10257_);
    }

    public static boolean m_10273_(File p_10274_, String p_10275_) throws IOException {
        String string = p_10274_.getCanonicalPath();
        if (f_10253_) {
            string = f_10254_.replaceFrom((CharSequence)string, '/');
        }
        return string.endsWith(p_10275_);
    }

    @Override
    protected InputStream m_5541_(String p_10277_) throws IOException {
        File file = this.m_10281_(p_10277_);
        if (file == null) {
            throw new ResourcePackFileNotFoundException(this.f_10203_, p_10277_);
        }
        return new FileInputStream(file);
    }

    @Override
    protected boolean m_6105_(String p_10279_) {
        return this.m_10281_(p_10279_) != null;
    }

    @Nullable
    private File m_10281_(String p_10282_) {
        try {
            File file = new File(this.f_10203_, p_10282_);
            if (file.isFile() && FolderPackResources.m_10273_(file, p_10282_)) {
                return file;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public Set<String> m_5698_(PackType p_10259_) {
        HashSet hashSet = Sets.newHashSet();
        File \u00e2\u02dc\u01922 = new File(this.f_10203_, p_10259_.m_10305_());
        File[] \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.listFiles((FileFilter)DirectoryFileFilter.DIRECTORY);
        if (\u00e2\u02dc\u01923 != null) {
            for (File file : \u00e2\u02dc\u01923) {
                String string = FolderPackResources.m_10217_(\u00e2\u02dc\u01922, file);
                if (string.equals(string.toLowerCase(Locale.ROOT))) {
                    hashSet.add(string.substring(0, string.length() - 1));
                    continue;
                }
                this.m_10230_(string);
            }
        }
        return hashSet;
    }

    @Override
    public void close() {
    }

    @Override
    public Collection<ResourceLocation> m_7466_(PackType p_10261_, String p_10262_, String p_10263_, int p_10264_, Predicate<String> p_10265_) {
        File file = new File(this.f_10203_, p_10261_.m_10305_());
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        this.m_10266_(new File(new File(file, p_10262_), p_10263_), p_10264_, p_10262_, \u00e2\u02dc\u01922, p_10263_ + "/", p_10265_);
        return \u00e2\u02dc\u01922;
    }

    private void m_10266_(File p_10267_, int p_10268_, String p_10269_, List<ResourceLocation> p_10270_, String p_10271_, Predicate<String> p_10272_) {
        File[] fileArray = p_10267_.listFiles();
        if (fileArray != null) {
            for (File file : fileArray) {
                if (file.isDirectory()) {
                    if (p_10268_ <= 0) continue;
                    this.m_10266_(file, p_10268_ - 1, p_10269_, p_10270_, p_10271_ + file.getName() + "/", p_10272_);
                    continue;
                }
                if (file.getName().endsWith(".mcmeta") || !p_10272_.test(file.getName())) continue;
                try {
                    p_10270_.add(new ResourceLocation(p_10269_, p_10271_ + file.getName()));
                }
                catch (ResourceLocationException resourceLocationException) {
                    f_10252_.error(resourceLocationException.getMessage());
                }
            }
        }
    }
}

