/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.FileSystemAlreadyExistsException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.AbstractPackResources;
import net.minecraft.server.packs.FolderPackResources;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.metadata.MetadataSectionSerializer;
import net.minecraft.server.packs.metadata.pack.PackMetadataSection;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class VanillaPackResources
implements PackResources,
ResourceProvider {
    public static Path f_10312_;
    private static final Logger f_10315_;
    public static Class<?> f_10313_;
    private static final Map<PackType, Path> f_182296_;
    public final PackMetadataSection f_143759_;
    public final Set<String> f_10314_;

    private static Path m_182297_(URI p_182298_) throws IOException {
        try {
            return Paths.get(p_182298_);
        }
        catch (FileSystemNotFoundException fileSystemNotFoundException) {
        }
        catch (Throwable throwable) {
            f_10315_.warn("Unable to get path for: {}", (Object)p_182298_, (Object)throwable);
        }
        try {
            FileSystems.newFileSystem(p_182298_, Collections.emptyMap());
        }
        catch (FileSystemAlreadyExistsException fileSystemAlreadyExistsException) {
            // empty catch block
        }
        return Paths.get(p_182298_);
    }

    public VanillaPackResources(PackMetadataSection p_143761_, String ... p_143762_) {
        this.f_143759_ = p_143761_;
        this.f_10314_ = ImmutableSet.copyOf((Object[])p_143762_);
    }

    @Override
    public InputStream m_5542_(String p_10358_) throws IOException {
        Path path;
        if (p_10358_.contains("/") || p_10358_.contains("\\")) {
            throw new IllegalArgumentException("Root resources can only be filenames, not paths (no / allowed!)");
        }
        if (f_10312_ != null && Files.exists(path = f_10312_.resolve(p_10358_), new LinkOption[0])) {
            return Files.newInputStream(path, new OpenOption[0]);
        }
        return this.m_5539_(p_10358_);
    }

    @Override
    public InputStream m_8031_(PackType p_10330_, ResourceLocation p_10331_) throws IOException {
        InputStream inputStream = this.m_8033_(p_10330_, p_10331_);
        if (inputStream != null) {
            return inputStream;
        }
        throw new FileNotFoundException(p_10331_.m_135815_());
    }

    @Override
    public Collection<ResourceLocation> m_7466_(PackType p_10324_, String p_10325_, String p_10326_, int p_10327_, Predicate<String> p_10328_) {
        Object object2;
        HashSet hashSet = Sets.newHashSet();
        if (f_10312_ != null) {
            try {
                VanillaPackResources.m_10342_(hashSet, p_10327_, p_10325_, f_10312_.resolve(p_10324_.m_10305_()), p_10326_, p_10328_);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (p_10324_ == PackType.CLIENT_RESOURCES) {
                object2 = null;
                try {
                    object2 = f_10313_.getClassLoader().getResources(p_10324_.m_10305_() + "/");
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                while (object2 != null && object2.hasMoreElements()) {
                    try {
                        URI uRI = ((URL)object2.nextElement()).toURI();
                        if (!"file".equals(uRI.getScheme())) continue;
                        VanillaPackResources.m_10342_(hashSet, p_10327_, p_10325_, Paths.get(uRI), p_10326_, p_10328_);
                    }
                    catch (IOException | URISyntaxException exception) {}
                }
            }
        }
        try {
            object2 = f_182296_.get((Object)p_10324_);
            if (object2 != null) {
                VanillaPackResources.m_10342_(hashSet, p_10327_, p_10325_, (Path)object2, p_10326_, p_10328_);
            } else {
                f_10315_.error("Can't access assets root for type: {}", (Object)p_10324_);
            }
        }
        catch (FileNotFoundException | NoSuchFileException object2) {
        }
        catch (IOException iOException) {
            f_10315_.error("Couldn't get a list of all vanilla resources", (Throwable)iOException);
        }
        return hashSet;
    }

    private static void m_10342_(Collection<ResourceLocation> p_10343_, int p_10344_, String p_10345_, Path p_10346_, String p_10347_, Predicate<String> p_10348_) throws IOException {
        Path path = p_10346_.resolve(p_10345_);
        try (Stream<Path> \u00e2\u02dc\u01922 = Files.walk(path.resolve(p_10347_), p_10344_, new FileVisitOption[0]);){
            \u00e2\u02dc\u01922.filter(p_10353_ -> !p_10353_.endsWith(".mcmeta") && Files.isRegularFile(p_10353_, new LinkOption[0]) && p_10348_.test(p_10353_.getFileName().toString())).map(p_10341_ -> new ResourceLocation(p_10345_, path.relativize((Path)p_10341_).toString().replaceAll("\\\\", "/"))).forEach(p_10343_::add);
        }
    }

    @Nullable
    protected InputStream m_8033_(PackType p_10359_, ResourceLocation p_10360_) {
        String string = VanillaPackResources.m_10362_(p_10359_, p_10360_);
        if (f_10312_ != null && Files.exists((Path)(object = f_10312_.resolve(p_10359_.m_10305_() + "/" + p_10360_.m_135827_() + "/" + p_10360_.m_135815_())), new LinkOption[0])) {
            try {
                return Files.newInputStream((Path)object, new OpenOption[0]);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        try {
            Object object = VanillaPackResources.class.getResource(string);
            if (VanillaPackResources.m_10335_(string, (URL)object)) {
                return ((URL)object).openStream();
            }
        }
        catch (IOException iOException) {
            return VanillaPackResources.class.getResourceAsStream(string);
        }
        return null;
    }

    private static String m_10362_(PackType p_10363_, ResourceLocation p_10364_) {
        return "/" + p_10363_.m_10305_() + "/" + p_10364_.m_135827_() + "/" + p_10364_.m_135815_();
    }

    private static boolean m_10335_(String p_10336_, @Nullable URL p_10337_) throws IOException {
        return p_10337_ != null && (p_10337_.getProtocol().equals("jar") || FolderPackResources.m_10273_(new File(p_10337_.getFile()), p_10336_));
    }

    @Nullable
    protected InputStream m_5539_(String p_10334_) {
        return VanillaPackResources.class.getResourceAsStream("/" + p_10334_);
    }

    @Override
    public boolean m_7211_(PackType p_10355_, ResourceLocation p_10356_) {
        String string = VanillaPackResources.m_10362_(p_10355_, p_10356_);
        if (f_10312_ != null && Files.exists((Path)(object = f_10312_.resolve(p_10355_.m_10305_() + "/" + p_10356_.m_135827_() + "/" + p_10356_.m_135815_())), new LinkOption[0])) {
            return true;
        }
        try {
            Object object = VanillaPackResources.class.getResource(string);
            return VanillaPackResources.m_10335_(string, (URL)object);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    @Override
    public Set<String> m_5698_(PackType p_10322_) {
        return this.f_10314_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <T> T m_5550_(MetadataSectionSerializer<T> p_10333_) throws IOException {
        try (InputStream inputStream = this.m_5542_("pack.mcmeta");){
            T t2;
            if (inputStream != null && (t2 = AbstractPackResources.m_10214_(p_10333_, inputStream)) != null) {
                T t = t2;
                return t;
            }
        }
        catch (FileNotFoundException | RuntimeException exception) {
            // empty catch block
        }
        if (p_10333_ != PackMetadataSection.f_10366_) return null;
        return (T)this.f_143759_;
    }

    @Override
    public String m_8017_() {
        return "Default";
    }

    @Override
    public void close() {
    }

    @Override
    public Resource m_142591_(final ResourceLocation p_143764_) throws IOException {
        return new Resource(){
            @Nullable
            InputStream f_143765_;

            @Override
            public void close() throws IOException {
                if (this.f_143765_ != null) {
                    this.f_143765_.close();
                }
            }

            @Override
            public ResourceLocation m_7843_() {
                return p_143764_;
            }

            @Override
            public InputStream m_6679_() {
                try {
                    this.f_143765_ = VanillaPackResources.this.m_8031_(PackType.CLIENT_RESOURCES, p_143764_);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Could not get client resource from vanilla pack", iOException);
                }
                return this.f_143765_;
            }

            @Override
            public boolean m_142564_() {
                return false;
            }

            @Override
            @Nullable
            public <T> T m_5507_(MetadataSectionSerializer<T> p_143773_) {
                return null;
            }

            @Override
            public String m_7816_() {
                return p_143764_.toString();
            }
        };
    }

    static {
        f_10315_ = LogManager.getLogger();
        f_182296_ = (Map)Util.m_137537_(() -> {
            Class<VanillaPackResources> clazz = VanillaPackResources.class;
            synchronized (VanillaPackResources.class) {
                ImmutableMap.Builder builder = ImmutableMap.builder();
                for (PackType packType : PackType.values()) {
                    String string = "/" + packType.m_10305_() + "/.mcassetsroot";
                    URL \u00e2\u02dc\u01922 = VanillaPackResources.class.getResource(string);
                    if (\u00e2\u02dc\u01922 == null) {
                        f_10315_.error("File {} does not exist in classpath", (Object)string);
                        continue;
                    }
                    try {
                        URI uRI = \u00e2\u02dc\u01922.toURI();
                        String \u00e2\u02dc\u01923 = uRI.getScheme();
                        if (!"jar".equals(\u00e2\u02dc\u01923) && !"file".equals(\u00e2\u02dc\u01923)) {
                            f_10315_.warn("Assets URL '{}' uses unexpected schema", (Object)uRI);
                        }
                        Path \u00e2\u02dc\u01924 = VanillaPackResources.m_182297_(uRI);
                        builder.put((Object)packType, (Object)\u00e2\u02dc\u01924.getParent());
                    }
                    catch (Exception exception) {
                        f_10315_.error("Couldn't resolve path to vanilla assets", (Throwable)exception);
                    }
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return builder.build();
            }
        });
    }
}

