/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.PackResources;
import net.minecraft.server.packs.PackType;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FallbackResourceManager
implements ResourceManager {
    static final Logger f_10600_ = LogManager.getLogger();
    protected final List<PackResources> f_10599_ = Lists.newArrayList();
    private final PackType f_10601_;
    private final String f_10602_;

    public FallbackResourceManager(PackType p_10605_, String p_10606_) {
        this.f_10601_ = p_10605_;
        this.f_10602_ = p_10606_;
    }

    public void m_10608_(PackResources p_10609_) {
        this.f_10599_.add(p_10609_);
    }

    @Override
    public Set<String> m_7187_() {
        return ImmutableSet.of((Object)this.f_10602_);
    }

    @Override
    public Resource m_142591_(ResourceLocation p_10614_) throws IOException {
        this.m_10626_(p_10614_);
        PackResources packResources = null;
        ResourceLocation \u00e2\u02dc\u01922 = FallbackResourceManager.m_10624_(p_10614_);
        for (int i = this.f_10599_.size() - 1; i >= 0; --i) {
            PackResources packResources2 = this.f_10599_.get(i);
            if (packResources == null && packResources2.m_7211_(this.f_10601_, \u00e2\u02dc\u01922)) {
                packResources = packResources2;
            }
            if (!packResources2.m_7211_(this.f_10601_, p_10614_)) continue;
            InputStream \u00e2\u02dc\u01923 = null;
            if (packResources != null) {
                \u00e2\u02dc\u01923 = this.m_10615_(\u00e2\u02dc\u01922, packResources);
            }
            return new SimpleResource(packResources2.m_8017_(), p_10614_, this.m_10615_(p_10614_, packResources2), \u00e2\u02dc\u01923);
        }
        throw new FileNotFoundException(p_10614_.toString());
    }

    @Override
    public boolean m_7165_(ResourceLocation p_10620_) {
        if (!this.m_10628_(p_10620_)) {
            return false;
        }
        for (int i = this.f_10599_.size() - 1; i >= 0; --i) {
            PackResources packResources = this.f_10599_.get(i);
            if (!packResources.m_7211_(this.f_10601_, p_10620_)) continue;
            return true;
        }
        return false;
    }

    protected InputStream m_10615_(ResourceLocation p_10616_, PackResources p_10617_) throws IOException {
        InputStream inputStream = p_10617_.m_8031_(this.f_10601_, p_10616_);
        return f_10600_.isDebugEnabled() ? new LeakedResourceWarningInputStream(inputStream, p_10616_, p_10617_.m_8017_()) : inputStream;
    }

    private void m_10626_(ResourceLocation p_10627_) throws IOException {
        if (!this.m_10628_(p_10627_)) {
            throw new IOException("Invalid relative path to resource: " + p_10627_);
        }
    }

    private boolean m_10628_(ResourceLocation p_10629_) {
        return !p_10629_.m_135815_().contains("..");
    }

    @Override
    public List<Resource> m_7396_(ResourceLocation p_10623_) throws IOException {
        this.m_10626_(p_10623_);
        ArrayList arrayList = Lists.newArrayList();
        ResourceLocation \u00e2\u02dc\u01922 = FallbackResourceManager.m_10624_(p_10623_);
        for (PackResources packResources : this.f_10599_) {
            if (!packResources.m_7211_(this.f_10601_, p_10623_)) continue;
            InputStream inputStream = packResources.m_7211_(this.f_10601_, \u00e2\u02dc\u01922) ? this.m_10615_(\u00e2\u02dc\u01922, packResources) : null;
            arrayList.add(new SimpleResource(packResources.m_8017_(), p_10623_, this.m_10615_(p_10623_, packResources), inputStream));
        }
        if (arrayList.isEmpty()) {
            throw new FileNotFoundException(p_10623_.toString());
        }
        return arrayList;
    }

    @Override
    public Collection<ResourceLocation> m_6540_(String p_10611_, Predicate<String> p_10612_) {
        ArrayList arrayList = Lists.newArrayList();
        for (PackResources packResources : this.f_10599_) {
            arrayList.addAll(packResources.m_7466_(this.f_10601_, this.f_10602_, p_10611_, Integer.MAX_VALUE, p_10612_));
        }
        Collections.sort(arrayList);
        return arrayList;
    }

    @Override
    public Stream<PackResources> m_7536_() {
        return this.f_10599_.stream();
    }

    static ResourceLocation m_10624_(ResourceLocation p_10625_) {
        return new ResourceLocation(p_10625_.m_135827_(), p_10625_.m_135815_() + ".mcmeta");
    }

    static class LeakedResourceWarningInputStream
    extends FilterInputStream {
        private final String f_10630_;
        private boolean f_10631_;

        public LeakedResourceWarningInputStream(InputStream p_10633_, ResourceLocation p_10634_, String p_10635_) {
            super(p_10633_);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            new Exception().printStackTrace(new PrintStream(byteArrayOutputStream));
            this.f_10630_ = "Leaked resource: '" + p_10634_ + "' loaded from pack: '" + p_10635_ + "'\n" + byteArrayOutputStream;
        }

        @Override
        public void close() throws IOException {
            super.close();
            this.f_10631_ = true;
        }

        protected void finalize() throws Throwable {
            if (!this.f_10631_) {
                f_10600_.warn(this.f_10630_);
            }
            super.finalize();
        }
    }
}

