/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.base.Stopwatch;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import net.minecraft.Util;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimpleReloadInstance;
import net.minecraft.util.Unit;
import net.minecraft.util.profiling.ActiveProfiler;
import net.minecraft.util.profiling.ProfileResults;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProfiledReloadInstance
extends SimpleReloadInstance<State> {
    private static final Logger f_10645_ = LogManager.getLogger();
    private final Stopwatch f_10646_ = Stopwatch.createUnstarted();

    public ProfiledReloadInstance(ResourceManager p_10649_, List<PreparableReloadListener> p_10650_, Executor p_10651_, Executor p_10652_, CompletableFuture<Unit> p_10653_) {
        super(p_10651_, p_10652_, p_10649_, p_10650_, (p_10668_, p_10669_, p_10670_, p_10671_, p_10672_) -> {
            AtomicLong atomicLong = new AtomicLong();
            \u00e2\u02dc\u0192 = new AtomicLong();
            ActiveProfiler \u00e2\u02dc\u01922 = new ActiveProfiler(Util.f_137440_, () -> 0, false);
            ActiveProfiler \u00e2\u02dc\u01923 = new ActiveProfiler(Util.f_137440_, () -> 0, false);
            CompletableFuture<Void> \u00e2\u02dc\u01924 = p_10670_.m_5540_(p_10668_, p_10669_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, p_143927_ -> p_10671_.execute(() -> {
                long l = Util.m_137569_();
                p_143927_.run();
                atomicLong.addAndGet(Util.m_137569_() - l);
            }), p_143920_ -> p_10672_.execute(() -> {
                long l = Util.m_137569_();
                p_143920_.run();
                \u00e2\u02dc\u0192.addAndGet(Util.m_137569_() - l);
            }));
            return \u00e2\u02dc\u01924.thenApplyAsync(p_143913_ -> new State(p_10670_.m_7812_(), \u00e2\u02dc\u01922.m_5948_(), \u00e2\u02dc\u01923.m_5948_(), atomicLong, \u00e2\u02dc\u0192), p_10652_);
        }, p_10653_);
        this.f_10646_.start();
        this.f_10800_.thenAcceptAsync(this::m_10664_, p_10652_);
    }

    private void m_10664_(List<State> p_10665_) {
        this.f_10646_.stop();
        int n = 0;
        f_10645_.info("Resource reload finished after {} ms", (Object)this.f_10646_.elapsed(TimeUnit.MILLISECONDS));
        for (State state : p_10665_) {
            ProfileResults profileResults = state.f_10687_;
            \u00e2\u02dc\u0192 = state.f_10688_;
            int \u00e2\u02dc\u01922 = (int)((double)state.f_10689_.get() / 1000000.0);
            int \u00e2\u02dc\u01923 = (int)((double)state.f_10690_.get() / 1000000.0);
            int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922 + \u00e2\u02dc\u01923;
            String \u00e2\u02dc\u01925 = state.f_10686_;
            f_10645_.info("{} took approximately {} ms ({} ms preparing, {} ms applying)", (Object)\u00e2\u02dc\u01925, (Object)\u00e2\u02dc\u01924, (Object)\u00e2\u02dc\u01922, (Object)\u00e2\u02dc\u01923);
            n += \u00e2\u02dc\u01923;
        }
        f_10645_.info("Total blocking time: {} ms", (Object)n);
    }

    public static class State {
        final String f_10686_;
        final ProfileResults f_10687_;
        final ProfileResults f_10688_;
        final AtomicLong f_10689_;
        final AtomicLong f_10690_;

        State(String p_10692_, ProfileResults p_10693_, ProfileResults p_10694_, AtomicLong p_10695_, AtomicLong p_10696_) {
            this.f_10686_ = p_10692_;
            this.f_10687_ = p_10693_;
            this.f_10688_ = p_10694_;
            this.f_10689_ = p_10695_;
            this.f_10690_ = p_10696_;
        }
    }
}

