/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.packs.resources;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class SimpleJsonResourceReloadListener
extends SimplePreparableReloadListener<Map<ResourceLocation, JsonElement>> {
    private static final Logger f_10762_ = LogManager.getLogger();
    private static final String f_143936_ = ".json";
    private static final int f_10763_ = ".json".length();
    private final Gson f_10764_;
    private final String f_10765_;

    public SimpleJsonResourceReloadListener(Gson p_10768_, String p_10769_) {
        this.f_10764_ = p_10768_;
        this.f_10765_ = p_10769_;
    }

    @Override
    protected Map<ResourceLocation, JsonElement> m_5944_(ResourceManager p_10771_, ProfilerFiller p_10772_) {
        HashMap hashMap = Maps.newHashMap();
        int \u00e2\u02dc\u01922 = this.f_10765_.length() + 1;
        for (ResourceLocation resourceLocation : p_10771_.m_6540_(this.f_10765_, p_10774_ -> p_10774_.endsWith(f_143936_))) {
            String string = resourceLocation.m_135815_();
            ResourceLocation \u00e2\u02dc\u01923 = new ResourceLocation(resourceLocation.m_135827_(), string.substring(\u00e2\u02dc\u01922, string.length() - f_10763_));
            try {
                Resource resource = p_10771_.m_142591_(resourceLocation);
                try {
                    InputStream inputStream = resource.m_6679_();
                    try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                        JsonElement jsonElement = GsonHelper.m_13776_(this.f_10764_, bufferedReader, JsonElement.class);
                        if (jsonElement != null) {
                            \u00e2\u02dc\u0192 = hashMap.put(\u00e2\u02dc\u01923, jsonElement);
                            if (\u00e2\u02dc\u0192 == null) continue;
                            throw new IllegalStateException("Duplicate data file ignored with ID " + \u00e2\u02dc\u01923);
                        }
                        f_10762_.error("Couldn't load data file {} from {} as it's null or empty", (Object)\u00e2\u02dc\u01923, (Object)resourceLocation);
                    }
                    finally {
                        if (inputStream == null) continue;
                        inputStream.close();
                    }
                }
                finally {
                    if (resource == null) continue;
                    resource.close();
                }
            }
            catch (JsonParseException | IOException | IllegalArgumentException throwable) {
                f_10762_.error("Couldn't parse data file {} from {}", (Object)\u00e2\u02dc\u01923, (Object)resourceLocation, (Object)throwable);
            }
        }
        return hashMap;
    }

    @Override
    protected /* synthetic */ Object m_5944_(ResourceManager resourceManager, ProfilerFiller profilerFiller) {
        return this.m_5944_(resourceManager, profilerFiller);
    }
}

