/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.GameProfileRepository;
import com.mojang.authlib.ProfileLookupCallback;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.world.entity.player.Player;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GameProfileCache {
    private static final Logger f_10964_ = LogManager.getLogger();
    private static final int f_143955_ = 1000;
    private static final int f_143956_ = 1;
    private static boolean f_10965_;
    private final Map<String, GameProfileInfo> f_10966_ = Maps.newConcurrentMap();
    private final Map<UUID, GameProfileInfo> f_10967_ = Maps.newConcurrentMap();
    private final Map<String, CompletableFuture<Optional<GameProfile>>> f_143957_ = Maps.newConcurrentMap();
    private final GameProfileRepository f_10968_;
    private final Gson f_10969_ = new GsonBuilder().create();
    private final File f_10970_;
    private final AtomicLong f_10971_ = new AtomicLong();
    @Nullable
    private Executor f_143958_;

    public GameProfileCache(GameProfileRepository p_10974_, File p_10975_) {
        this.f_10968_ = p_10974_;
        this.f_10970_ = p_10975_;
        Lists.reverse(this.m_10976_()).forEach(this::m_10979_);
    }

    private void m_10979_(GameProfileInfo p_10980_) {
        GameProfile gameProfile = p_10980_.m_11028_();
        p_10980_.m_11029_(this.m_11008_());
        String \u00e2\u02dc\u01922 = gameProfile.getName();
        if (\u00e2\u02dc\u01922 != null) {
            this.f_10966_.put(\u00e2\u02dc\u01922.toLowerCase(Locale.ROOT), p_10980_);
        }
        if ((\u00e2\u02dc\u0192 = gameProfile.getId()) != null) {
            this.f_10967_.put(\u00e2\u02dc\u0192, p_10980_);
        }
    }

    private static Optional<GameProfile> m_10993_(GameProfileRepository p_10994_, String p_10995_) {
        final AtomicReference atomicReference = new AtomicReference();
        ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_11017_) {
                atomicReference.set(p_11017_);
            }

            public void onProfileLookupFailed(GameProfile p_11014_, Exception p_11015_) {
                atomicReference.set(null);
            }
        };
        p_10994_.findProfilesByNames(new String[]{p_10995_}, Agent.MINECRAFT, \u00e2\u02dc\u01922);
        GameProfile \u00e2\u02dc\u01923 = (GameProfile)atomicReference.get();
        if (!GameProfileCache.m_11007_() && \u00e2\u02dc\u01923 == null) {
            UUID uUID = Player.m_36198_(new GameProfile(null, p_10995_));
            return Optional.of(new GameProfile(uUID, p_10995_));
        }
        return Optional.ofNullable(\u00e2\u02dc\u01923);
    }

    public static void m_11004_(boolean p_11005_) {
        f_10965_ = p_11005_;
    }

    private static boolean m_11007_() {
        return f_10965_;
    }

    public void m_10991_(GameProfile p_10992_) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(new Date());
        calendar.add(2, 1);
        Date \u00e2\u02dc\u01922 = calendar.getTime();
        GameProfileInfo \u00e2\u02dc\u01923 = new GameProfileInfo(p_10992_, \u00e2\u02dc\u01922);
        this.m_10979_(\u00e2\u02dc\u01923);
        this.m_11006_();
    }

    private long m_11008_() {
        return this.f_10971_.incrementAndGet();
    }

    public Optional<GameProfile> m_10996_(String p_10997_) {
        Optional<GameProfile> \u00e2\u02dc\u01924;
        String string = p_10997_.toLowerCase(Locale.ROOT);
        GameProfileInfo \u00e2\u02dc\u01922 = this.f_10966_.get(string);
        boolean \u00e2\u02dc\u01923 = false;
        if (\u00e2\u02dc\u01922 != null && new Date().getTime() >= \u00e2\u02dc\u01922.f_11019_.getTime()) {
            this.f_10967_.remove(\u00e2\u02dc\u01922.m_11028_().getId());
            this.f_10966_.remove(\u00e2\u02dc\u01922.m_11028_().getName().toLowerCase(Locale.ROOT));
            \u00e2\u02dc\u01923 = true;
            \u00e2\u02dc\u01922 = null;
        }
        if (\u00e2\u02dc\u01922 != null) {
            \u00e2\u02dc\u01922.m_11029_(this.m_11008_());
            \u00e2\u02dc\u01924 = Optional.of(\u00e2\u02dc\u01922.m_11028_());
        } else {
            \u00e2\u02dc\u01924 = GameProfileCache.m_10993_(this.f_10968_, string);
            if (\u00e2\u02dc\u01924.isPresent()) {
                this.m_10991_(\u00e2\u02dc\u01924.get());
                \u00e2\u02dc\u01923 = false;
            }
        }
        if (\u00e2\u02dc\u01923) {
            this.m_11006_();
        }
        return \u00e2\u02dc\u01924;
    }

    public void m_143967_(String p_143968_, Consumer<Optional<GameProfile>> p_143969_) {
        if (this.f_143958_ == null) {
            throw new IllegalStateException("No executor");
        }
        CompletableFuture<Optional<GameProfile>> completableFuture = this.f_143957_.get(p_143968_);
        if (completableFuture != null) {
            this.f_143957_.put(p_143968_, (CompletableFuture<Optional<GameProfile>>)completableFuture.whenCompleteAsync((p_143984_, p_143985_) -> p_143969_.accept((Optional<GameProfile>)p_143984_), this.f_143958_));
        } else {
            this.f_143957_.put(p_143968_, (CompletableFuture<Optional<GameProfile>>)((CompletableFuture)CompletableFuture.supplyAsync(() -> this.m_10996_(p_143968_), Util.m_137578_()).whenCompleteAsync((p_143965_, p_143966_) -> this.f_143957_.remove(p_143968_), this.f_143958_)).whenCompleteAsync((p_143978_, p_143979_) -> p_143969_.accept((Optional<GameProfile>)p_143978_), this.f_143958_));
        }
    }

    public Optional<GameProfile> m_11002_(UUID p_11003_) {
        GameProfileInfo gameProfileInfo = this.f_10967_.get(p_11003_);
        if (gameProfileInfo == null) {
            return Optional.empty();
        }
        gameProfileInfo.m_11029_(this.m_11008_());
        return Optional.of(gameProfileInfo.m_11028_());
    }

    public void m_143974_(Executor p_143975_) {
        this.f_143958_ = p_143975_;
    }

    private static DateFormat m_11009_() {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List<GameProfileInfo> m_10976_() {
        ArrayList arrayList = Lists.newArrayList();
        try (BufferedReader \u00e2\u02dc\u019222222 = Files.newReader((File)this.f_10970_, (Charset)StandardCharsets.UTF_8);){
            JsonArray \u00e2\u02dc\u01923 = (JsonArray)this.f_10969_.fromJson((Reader)\u00e2\u02dc\u019222222, JsonArray.class);
            if (\u00e2\u02dc\u01923 == null) {
                ArrayList arrayList2 = arrayList;
                return arrayList2;
            }
            DateFormat dateFormat = GameProfileCache.m_11009_();
            \u00e2\u02dc\u01923.forEach(p_143973_ -> GameProfileCache.m_10988_(p_143973_, dateFormat).ifPresent(arrayList::add));
            return arrayList;
        }
        catch (FileNotFoundException \u00e2\u02dc\u019222222) {
            return arrayList;
        }
        catch (JsonParseException | IOException throwable) {
            f_10964_.warn("Failed to load profile cache {}", (Object)this.f_10970_, (Object)throwable);
        }
        return arrayList;
    }

    public void m_11006_() {
        JsonArray jsonArray = new JsonArray();
        DateFormat \u00e2\u02dc\u01922 = GameProfileCache.m_11009_();
        this.m_10977_(1000).forEach(p_143962_ -> jsonArray.add(GameProfileCache.m_10981_(p_143962_, \u00e2\u02dc\u01922)));
        String \u00e2\u02dc\u01923 = this.f_10969_.toJson((JsonElement)jsonArray);
        try (BufferedWriter bufferedWriter = Files.newWriter((File)this.f_10970_, (Charset)StandardCharsets.UTF_8);){
            bufferedWriter.write(\u00e2\u02dc\u01923);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private Stream<GameProfileInfo> m_10977_(int p_10978_) {
        return ImmutableList.copyOf(this.f_10967_.values()).stream().sorted(Comparator.comparing(GameProfileInfo::m_11034_).reversed()).limit(p_10978_);
    }

    private static JsonElement m_10981_(GameProfileInfo p_10982_, DateFormat p_10983_) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("name", p_10982_.m_11028_().getName());
        UUID \u00e2\u02dc\u01922 = p_10982_.m_11028_().getId();
        jsonObject.addProperty("uuid", \u00e2\u02dc\u01922 == null ? "" : \u00e2\u02dc\u01922.toString());
        jsonObject.addProperty("expiresOn", p_10983_.format(p_10982_.m_11033_()));
        return jsonObject;
    }

    private static Optional<GameProfileInfo> m_10988_(JsonElement p_10989_, DateFormat p_10990_) {
        if (p_10989_.isJsonObject()) {
            JsonObject jsonObject = p_10989_.getAsJsonObject();
            JsonElement \u00e2\u02dc\u01922 = jsonObject.get("name");
            JsonElement \u00e2\u02dc\u01923 = jsonObject.get("uuid");
            JsonElement \u00e2\u02dc\u01924 = jsonObject.get("expiresOn");
            if (\u00e2\u02dc\u01922 == null || \u00e2\u02dc\u01923 == null) {
                return Optional.empty();
            }
            String \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.getAsString();
            String \u00e2\u02dc\u01926 = \u00e2\u02dc\u01922.getAsString();
            Date \u00e2\u02dc\u01927 = null;
            if (\u00e2\u02dc\u01924 != null) {
                try {
                    \u00e2\u02dc\u01927 = p_10990_.parse(\u00e2\u02dc\u01924.getAsString());
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
            if (\u00e2\u02dc\u01926 == null || \u00e2\u02dc\u01925 == null || \u00e2\u02dc\u01927 == null) {
                return Optional.empty();
            }
            try {
                UUID uUID = UUID.fromString(\u00e2\u02dc\u01925);
            }
            catch (Throwable throwable) {
                return Optional.empty();
            }
            return Optional.of(new GameProfileInfo(new GameProfile(uUID, \u00e2\u02dc\u01926), \u00e2\u02dc\u01927));
        }
        return Optional.empty();
    }

    static class GameProfileInfo {
        private final GameProfile f_11018_;
        final Date f_11019_;
        private volatile long f_11020_;

        GameProfileInfo(GameProfile p_11022_, Date p_11023_) {
            this.f_11018_ = p_11022_;
            this.f_11019_ = p_11023_;
        }

        public GameProfile m_11028_() {
            return this.f_11018_;
        }

        public Date m_11033_() {
            return this.f_11019_;
        }

        public void m_11029_(long p_11030_) {
            this.f_11020_ = p_11030_;
        }

        public long m_11034_() {
            return this.f_11020_;
        }
    }
}

