/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.mojang.authlib.Agent;
import com.mojang.authlib.GameProfile;
import com.mojang.authlib.ProfileLookupCallback;
import com.mojang.authlib.yggdrasil.ProfileNotFoundException;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.players.BanListEntry;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.PlayerList;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.server.players.UserWhiteListEntry;
import net.minecraft.util.StringUtil;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.LevelResource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OldUsersConverter {
    static final Logger f_11066_ = LogManager.getLogger();
    public static final File f_11062_ = new File("banned-ips.txt");
    public static final File f_11063_ = new File("banned-players.txt");
    public static final File f_11064_ = new File("ops.txt");
    public static final File f_11065_ = new File("white-list.txt");

    static List<String> m_11073_(File p_11074_, Map<String, String[]> p_11075_) throws IOException {
        List list = Files.readLines((File)p_11074_, (Charset)StandardCharsets.UTF_8);
        for (String string : list) {
            if ((string = string.trim()).startsWith("#") || string.length() < 1) continue;
            String[] stringArray = string.split("\\|");
            p_11075_.put(stringArray[0].toLowerCase(Locale.ROOT), stringArray);
        }
        return list;
    }

    private static void m_11086_(MinecraftServer p_11087_, Collection<String> p_11088_, ProfileLookupCallback p_11089_) {
        String[] stringArray = (String[])p_11088_.stream().filter(p_11077_ -> !StringUtil.m_14408_(p_11077_)).toArray(String[]::new);
        if (p_11087_.m_129797_()) {
            p_11087_.m_129926_().findProfilesByNames(stringArray, Agent.MINECRAFT, p_11089_);
        } else {
            for (String string : stringArray) {
                UUID uUID = Player.m_36198_(new GameProfile(null, string));
                GameProfile \u00e2\u02dc\u01922 = new GameProfile(uUID, string);
                p_11089_.onProfileLookupSucceeded(\u00e2\u02dc\u01922);
            }
        }
    }

    public static boolean m_11081_(final MinecraftServer p_11082_) {
        final UserBanList userBanList = new UserBanList(PlayerList.f_11189_);
        if (f_11063_.exists() && f_11063_.isFile()) {
            if (userBanList.m_11385_().exists()) {
                try {
                    userBanList.m_11399_();
                }
                catch (IOException iOException) {
                    f_11066_.warn("Could not load existing file {}", (Object)userBanList.m_11385_().getName(), (Object)iOException);
                }
            }
            try {
                final HashMap hashMap = Maps.newHashMap();
                OldUsersConverter.m_11073_(f_11063_, hashMap);
                ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_11123_) {
                        p_11082_.m_129927_().m_10991_(p_11123_);
                        String[] stringArray = (String[])hashMap.get(p_11123_.getName().toLowerCase(Locale.ROOT));
                        if (stringArray == null) {
                            f_11066_.warn("Could not convert user banlist entry for {}", (Object)p_11123_.getName());
                            throw new ConversionError("Profile not in the conversionlist");
                        }
                        Date \u00e2\u02dc\u01922 = stringArray.length > 1 ? OldUsersConverter.m_11095_(stringArray[1], null) : null;
                        String \u00e2\u02dc\u01923 = stringArray.length > 2 ? stringArray[2] : null;
                        Date \u00e2\u02dc\u01924 = stringArray.length > 3 ? OldUsersConverter.m_11095_(stringArray[3], null) : null;
                        String \u00e2\u02dc\u01925 = stringArray.length > 4 ? stringArray[4] : null;
                        userBanList.m_11381_(new UserBanListEntry(p_11123_, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925));
                    }

                    public void onProfileLookupFailed(GameProfile p_11120_, Exception p_11121_) {
                        f_11066_.warn("Could not lookup user banlist entry for {}", (Object)p_11120_.getName(), (Object)p_11121_);
                        if (!(p_11121_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_11120_.getName() + " from backend systems", p_11121_);
                        }
                    }
                };
                OldUsersConverter.m_11086_(p_11082_, hashMap.keySet(), \u00e2\u02dc\u01922);
                userBanList.m_11398_();
                OldUsersConverter.m_11100_(f_11063_);
            }
            catch (IOException iOException) {
                f_11066_.warn("Could not read old user banlist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (ConversionError conversionError) {
                f_11066_.error("Conversion failed, please try again later", (Throwable)conversionError);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean m_11098_(MinecraftServer p_11099_) {
        IpBanList ipBanList = new IpBanList(PlayerList.f_11190_);
        if (f_11062_.exists() && f_11062_.isFile()) {
            if (ipBanList.m_11385_().exists()) {
                try {
                    ipBanList.m_11399_();
                }
                catch (IOException iOException) {
                    f_11066_.warn("Could not load existing file {}", (Object)ipBanList.m_11385_().getName(), (Object)iOException);
                }
            }
            try {
                HashMap hashMap = Maps.newHashMap();
                OldUsersConverter.m_11073_(f_11062_, hashMap);
                for (String string : hashMap.keySet()) {
                    String[] stringArray = (String[])hashMap.get(string);
                    Date \u00e2\u02dc\u01922 = stringArray.length > 1 ? OldUsersConverter.m_11095_(stringArray[1], null) : null;
                    String \u00e2\u02dc\u01923 = stringArray.length > 2 ? stringArray[2] : null;
                    Date \u00e2\u02dc\u01924 = stringArray.length > 3 ? OldUsersConverter.m_11095_(stringArray[3], null) : null;
                    String \u00e2\u02dc\u01925 = stringArray.length > 4 ? stringArray[4] : null;
                    ipBanList.m_11381_(new IpBanListEntry(string, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925));
                }
                ipBanList.m_11398_();
                OldUsersConverter.m_11100_(f_11062_);
            }
            catch (IOException iOException) {
                f_11066_.warn("Could not parse old ip banlist to convert it!", (Throwable)iOException);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean m_11102_(final MinecraftServer p_11103_) {
        final ServerOpList serverOpList = new ServerOpList(PlayerList.f_11191_);
        if (f_11064_.exists() && f_11064_.isFile()) {
            if (serverOpList.m_11385_().exists()) {
                try {
                    serverOpList.m_11399_();
                }
                catch (IOException iOException) {
                    f_11066_.warn("Could not load existing file {}", (Object)serverOpList.m_11385_().getName(), (Object)iOException);
                }
            }
            try {
                List list = Files.readLines((File)f_11064_, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_11133_) {
                        p_11103_.m_129927_().m_10991_(p_11133_);
                        serverOpList.m_11381_(new ServerOpListEntry(p_11133_, p_11103_.m_7022_(), false));
                    }

                    public void onProfileLookupFailed(GameProfile p_11130_, Exception p_11131_) {
                        f_11066_.warn("Could not lookup oplist entry for {}", (Object)p_11130_.getName(), (Object)p_11131_);
                        if (!(p_11131_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_11130_.getName() + " from backend systems", p_11131_);
                        }
                    }
                };
                OldUsersConverter.m_11086_(p_11103_, list, \u00e2\u02dc\u01922);
                serverOpList.m_11398_();
                OldUsersConverter.m_11100_(f_11064_);
            }
            catch (IOException iOException) {
                f_11066_.warn("Could not read old oplist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (ConversionError conversionError) {
                f_11066_.error("Conversion failed, please try again later", (Throwable)conversionError);
                return false;
            }
            return true;
        }
        return true;
    }

    public static boolean m_11104_(final MinecraftServer p_11105_) {
        final UserWhiteList userWhiteList = new UserWhiteList(PlayerList.f_11192_);
        if (f_11065_.exists() && f_11065_.isFile()) {
            if (userWhiteList.m_11385_().exists()) {
                try {
                    userWhiteList.m_11399_();
                }
                catch (IOException iOException) {
                    f_11066_.warn("Could not load existing file {}", (Object)userWhiteList.m_11385_().getName(), (Object)iOException);
                }
            }
            try {
                List list = Files.readLines((File)f_11065_, (Charset)StandardCharsets.UTF_8);
                ProfileLookupCallback \u00e2\u02dc\u01922 = new ProfileLookupCallback(){

                    public void onProfileLookupSucceeded(GameProfile p_11143_) {
                        p_11105_.m_129927_().m_10991_(p_11143_);
                        userWhiteList.m_11381_(new UserWhiteListEntry(p_11143_));
                    }

                    public void onProfileLookupFailed(GameProfile p_11140_, Exception p_11141_) {
                        f_11066_.warn("Could not lookup user whitelist entry for {}", (Object)p_11140_.getName(), (Object)p_11141_);
                        if (!(p_11141_ instanceof ProfileNotFoundException)) {
                            throw new ConversionError("Could not request user " + p_11140_.getName() + " from backend systems", p_11141_);
                        }
                    }
                };
                OldUsersConverter.m_11086_(p_11105_, list, \u00e2\u02dc\u01922);
                userWhiteList.m_11398_();
                OldUsersConverter.m_11100_(f_11065_);
            }
            catch (IOException iOException) {
                f_11066_.warn("Could not read old whitelist to convert it!", (Throwable)iOException);
                return false;
            }
            catch (ConversionError conversionError) {
                f_11066_.error("Conversion failed, please try again later", (Throwable)conversionError);
                return false;
            }
            return true;
        }
        return true;
    }

    @Nullable
    public static UUID m_11083_(final MinecraftServer p_11084_, String p_11085_) {
        if (StringUtil.m_14408_(p_11085_) || p_11085_.length() > 16) {
            try {
                return UUID.fromString(p_11085_);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return null;
            }
        }
        Optional<UUID> optional = p_11084_.m_129927_().m_10996_(p_11085_).map(GameProfile::getId);
        if (optional.isPresent()) {
            return optional.get();
        }
        if (p_11084_.m_129792_() || !p_11084_.m_129797_()) {
            return Player.m_36198_(new GameProfile(null, p_11085_));
        }
        final ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        ProfileLookupCallback \u00e2\u02dc\u01923 = new ProfileLookupCallback(){

            public void onProfileLookupSucceeded(GameProfile p_11153_) {
                p_11084_.m_129927_().m_10991_(p_11153_);
                \u00e2\u02dc\u01922.add(p_11153_);
            }

            public void onProfileLookupFailed(GameProfile p_11150_, Exception p_11151_) {
                f_11066_.warn("Could not lookup user whitelist entry for {}", (Object)p_11150_.getName(), (Object)p_11151_);
            }
        };
        OldUsersConverter.m_11086_(p_11084_, Lists.newArrayList((Object[])new String[]{p_11085_}), \u00e2\u02dc\u01923);
        if (!\u00e2\u02dc\u01922.isEmpty() && ((GameProfile)\u00e2\u02dc\u01922.get(0)).getId() != null) {
            return ((GameProfile)\u00e2\u02dc\u01922.get(0)).getId();
        }
        return null;
    }

    public static boolean m_11090_(final DedicatedServer p_11091_) {
        final File file = OldUsersConverter.m_11110_(p_11091_);
        \u00e2\u02dc\u0192 = new File(file.getParentFile(), "playerdata");
        \u00e2\u02dc\u0192 = new File(file.getParentFile(), "unknownplayers");
        if (!file.exists() || !file.isDirectory()) {
            return true;
        }
        File[] \u00e2\u02dc\u01922 = file.listFiles();
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
        for (File file2 : \u00e2\u02dc\u01922) {
            String string = file2.getName();
            if (!string.toLowerCase(Locale.ROOT).endsWith(".dat") || (\u00e2\u02dc\u0192 = string.substring(0, string.length() - ".dat".length())).isEmpty()) continue;
            \u00e2\u02dc\u01923.add(\u00e2\u02dc\u0192);
        }
        try {
            Object[] objectArray = \u00e2\u02dc\u01923.toArray(new String[\u00e2\u02dc\u01923.size()]);
            ProfileLookupCallback \u00e2\u02dc\u01924 = new ProfileLookupCallback(){
                final /* synthetic */ String[] f_11158_;
                {
                    this.f_11158_ = stringArray;
                }

                public void onProfileLookupSucceeded(GameProfile p_11175_) {
                    p_11091_.m_129927_().m_10991_(p_11175_);
                    UUID uUID = p_11175_.getId();
                    if (uUID == null) {
                        throw new ConversionError("Missing UUID for user profile " + p_11175_.getName());
                    }
                    this.m_11167_(\u00e2\u02dc\u0192, this.m_11165_(p_11175_), uUID.toString());
                }

                public void onProfileLookupFailed(GameProfile p_11172_, Exception p_11173_) {
                    f_11066_.warn("Could not lookup user uuid for {}", (Object)p_11172_.getName(), (Object)p_11173_);
                    if (!(p_11173_ instanceof ProfileNotFoundException)) {
                        throw new ConversionError("Could not request user " + p_11172_.getName() + " from backend systems", p_11173_);
                    }
                    String string = this.m_11165_(p_11172_);
                    this.m_11167_(\u00e2\u02dc\u0192, string, string);
                }

                private void m_11167_(File p_11168_, String p_11169_, String p_11170_) {
                    File file2 = new File(file, p_11169_ + ".dat");
                    \u00e2\u02dc\u0192 = new File(p_11168_, p_11170_ + ".dat");
                    OldUsersConverter.m_11093_(p_11168_);
                    if (!file2.renameTo(\u00e2\u02dc\u0192)) {
                        throw new ConversionError("Could not convert file for " + p_11169_);
                    }
                }

                private String m_11165_(GameProfile p_11166_) {
                    String string = null;
                    for (String string2 : this.f_11158_) {
                        if (string2 == null || !string2.equalsIgnoreCase(p_11166_.getName())) continue;
                        string = string2;
                        break;
                    }
                    if (string == null) {
                        throw new ConversionError("Could not find the filename for " + p_11166_.getName() + " anymore");
                    }
                    return string;
                }
            };
            OldUsersConverter.m_11086_(p_11091_, Lists.newArrayList((Object[])objectArray), \u00e2\u02dc\u01924);
        }
        catch (ConversionError conversionError) {
            f_11066_.error("Conversion failed, please try again later", (Throwable)conversionError);
            return false;
        }
        return true;
    }

    static void m_11093_(File p_11094_) {
        if (p_11094_.exists()) {
            if (p_11094_.isDirectory()) {
                return;
            }
            throw new ConversionError("Can't create directory " + p_11094_.getName() + " in world save directory.");
        }
        if (!p_11094_.mkdirs()) {
            throw new ConversionError("Can't create directory " + p_11094_.getName() + " in world save directory.");
        }
    }

    public static boolean m_11106_(MinecraftServer p_11107_) {
        boolean bl = OldUsersConverter.m_11092_();
        bl = bl && OldUsersConverter.m_11108_(p_11107_);
        return bl;
    }

    private static boolean m_11092_() {
        boolean bl = false;
        if (f_11063_.exists() && f_11063_.isFile()) {
            bl = true;
        }
        \u00e2\u02dc\u0192 = false;
        if (f_11062_.exists() && f_11062_.isFile()) {
            \u00e2\u02dc\u0192 = true;
        }
        \u00e2\u02dc\u0192 = false;
        if (f_11064_.exists() && f_11064_.isFile()) {
            \u00e2\u02dc\u0192 = true;
        }
        \u00e2\u02dc\u0192 = false;
        if (f_11065_.exists() && f_11065_.isFile()) {
            \u00e2\u02dc\u0192 = true;
        }
        if (bl || \u00e2\u02dc\u0192 || \u00e2\u02dc\u0192 || \u00e2\u02dc\u0192) {
            f_11066_.warn("**** FAILED TO START THE SERVER AFTER ACCOUNT CONVERSION!");
            f_11066_.warn("** please remove the following files and restart the server:");
            if (bl) {
                f_11066_.warn("* {}", (Object)f_11063_.getName());
            }
            if (\u00e2\u02dc\u0192) {
                f_11066_.warn("* {}", (Object)f_11062_.getName());
            }
            if (\u00e2\u02dc\u0192) {
                f_11066_.warn("* {}", (Object)f_11064_.getName());
            }
            if (\u00e2\u02dc\u0192) {
                f_11066_.warn("* {}", (Object)f_11065_.getName());
            }
            return false;
        }
        return true;
    }

    private static boolean m_11108_(MinecraftServer p_11109_) {
        File file = OldUsersConverter.m_11110_(p_11109_);
        if (file.exists() && file.isDirectory() && (file.list().length > 0 || !file.delete())) {
            f_11066_.warn("**** DETECTED OLD PLAYER DIRECTORY IN THE WORLD SAVE");
            f_11066_.warn("**** THIS USUALLY HAPPENS WHEN THE AUTOMATIC CONVERSION FAILED IN SOME WAY");
            f_11066_.warn("** please restart the server and if the problem persists, remove the directory '{}'", (Object)file.getPath());
            return false;
        }
        return true;
    }

    private static File m_11110_(MinecraftServer p_11111_) {
        return p_11111_.m_129843_(LevelResource.f_78177_).toFile();
    }

    private static void m_11100_(File p_11101_) {
        File file = new File(p_11101_.getName() + ".converted");
        p_11101_.renameTo(file);
    }

    static Date m_11095_(String p_11096_, Date p_11097_) {
        Date date;
        try {
            date = BanListEntry.f_10943_.parse(p_11096_);
        }
        catch (ParseException parseException) {
            date = p_11097_;
        }
        return date;
    }

    static class ConversionError
    extends RuntimeException {
        ConversionError(String p_11182_, Throwable p_11183_) {
            super(p_11182_, p_11183_);
        }

        ConversionError(String p_11177_) {
            super(p_11177_);
        }
    }
}

