/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.players;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.net.SocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.FileUtil;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.Connection;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.ChatType;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundChangeDifficultyPacket;
import net.minecraft.network.protocol.game.ClientboundCustomPayloadPacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundGameEventPacket;
import net.minecraft.network.protocol.game.ClientboundInitializeBorderPacket;
import net.minecraft.network.protocol.game.ClientboundLoginPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerAbilitiesPacket;
import net.minecraft.network.protocol.game.ClientboundPlayerInfoPacket;
import net.minecraft.network.protocol.game.ClientboundRespawnPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderCenterPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderLerpSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderSizePacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDelayPacket;
import net.minecraft.network.protocol.game.ClientboundSetBorderWarningDistancePacket;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetChunkCacheRadiusPacket;
import net.minecraft.network.protocol.game.ClientboundSetDefaultSpawnPositionPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetPlayerTeamPacket;
import net.minecraft.network.protocol.game.ClientboundSetTimePacket;
import net.minecraft.network.protocol.game.ClientboundSoundPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateMobEffectPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateRecipesPacket;
import net.minecraft.network.protocol.game.ClientboundUpdateTagsPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.PlayerAdvancements;
import net.minecraft.server.ServerScoreboard;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.server.players.GameProfileCache;
import net.minecraft.server.players.IpBanList;
import net.minecraft.server.players.IpBanListEntry;
import net.minecraft.server.players.ServerOpList;
import net.minecraft.server.players.ServerOpListEntry;
import net.minecraft.server.players.UserBanList;
import net.minecraft.server.players.UserBanListEntry;
import net.minecraft.server.players.UserWhiteList;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.ServerStatsCounter;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.storage.LevelData;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.level.storage.PlayerDataStorage;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PlayerList {
    public static final File f_11189_ = new File("banned-players.json");
    public static final File f_11190_ = new File("banned-ips.json");
    public static final File f_11191_ = new File("ops.json");
    public static final File f_11192_ = new File("whitelist.json");
    private static final Logger f_11188_ = LogManager.getLogger();
    private static final int f_143987_ = 600;
    private static final SimpleDateFormat f_11194_ = new SimpleDateFormat("yyyy-MM-dd 'at' HH:mm:ss z");
    private final MinecraftServer f_11195_;
    private final List<ServerPlayer> f_11196_ = Lists.newArrayList();
    private final Map<UUID, ServerPlayer> f_11197_ = Maps.newHashMap();
    private final UserBanList f_11198_ = new UserBanList(f_11189_);
    private final IpBanList f_11199_ = new IpBanList(f_11190_);
    private final ServerOpList f_11200_ = new ServerOpList(f_11191_);
    private final UserWhiteList f_11201_ = new UserWhiteList(f_11192_);
    private final Map<UUID, ServerStatsCounter> f_11202_ = Maps.newHashMap();
    private final Map<UUID, PlayerAdvancements> f_11203_ = Maps.newHashMap();
    private final PlayerDataStorage f_11204_;
    private boolean f_11205_;
    private final RegistryAccess.RegistryHolder f_11206_;
    protected final int f_11193_;
    private int f_11207_;
    private boolean f_11209_;
    private static final boolean f_143988_ = false;
    private int f_11210_;

    public PlayerList(MinecraftServer p_11213_, RegistryAccess.RegistryHolder p_11214_, PlayerDataStorage p_11215_, int p_11216_) {
        this.f_11195_ = p_11213_;
        this.f_11206_ = p_11214_;
        this.f_11193_ = p_11216_;
        this.f_11204_ = p_11215_;
    }

    public void m_11261_(Connection p_11262_, ServerPlayer p_11263_) {
        Object object;
        ServerLevel serverLevel;
        GameProfile gameProfile = p_11263_.m_36316_();
        GameProfileCache \u00e2\u02dc\u01922 = this.f_11195_.m_129927_();
        Optional<GameProfile> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_11002_(gameProfile.getId());
        String \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.map(GameProfile::getName).orElse(gameProfile.getName());
        \u00e2\u02dc\u01922.m_10991_(gameProfile);
        CompoundTag \u00e2\u02dc\u01925 = this.m_11224_(p_11263_);
        ResourceKey<Level> \u00e2\u02dc\u01926 = \u00e2\u02dc\u01925 != null ? DimensionType.m_63911_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)\u00e2\u02dc\u01925.m_128423_("Dimension"))).resultOrPartial(arg_0 -> ((Logger)f_11188_).error(arg_0)).orElse(Level.f_46428_) : Level.f_46428_;
        ServerLevel \u00e2\u02dc\u01927 = this.f_11195_.m_129880_(\u00e2\u02dc\u01926);
        if (\u00e2\u02dc\u01927 == null) {
            f_11188_.warn("Unknown respawn dimension {}, defaulting to overworld", \u00e2\u02dc\u01926);
            serverLevel = this.f_11195_.m_129783_();
        } else {
            serverLevel = \u00e2\u02dc\u01927;
        }
        p_11263_.m_143425_(serverLevel);
        String \u00e2\u02dc\u01928 = "local";
        if (p_11262_.m_129523_() != null) {
            \u00e2\u02dc\u01928 = p_11262_.m_129523_().toString();
        }
        f_11188_.info("{}[{}] logged in with entity id {} at ({}, {}, {})", (Object)p_11263_.m_7755_().getString(), (Object)\u00e2\u02dc\u01928, (Object)p_11263_.m_142049_(), (Object)p_11263_.m_20185_(), (Object)p_11263_.m_20186_(), (Object)p_11263_.m_20189_());
        LevelData \u00e2\u02dc\u01929 = serverLevel.m_6106_();
        p_11263_.m_143427_(\u00e2\u02dc\u01925);
        ServerGamePacketListenerImpl \u00e2\u02dc\u019210 = new ServerGamePacketListenerImpl(this.f_11195_, p_11262_, p_11263_);
        GameRules \u00e2\u02dc\u019211 = serverLevel.m_46469_();
        boolean \u00e2\u02dc\u019212 = \u00e2\u02dc\u019211.m_46207_(GameRules.f_46156_);
        boolean \u00e2\u02dc\u019213 = \u00e2\u02dc\u019211.m_46207_(GameRules.f_46145_);
        \u00e2\u02dc\u019210.m_141995_(new ClientboundLoginPacket(p_11263_.m_142049_(), p_11263_.f_8941_.m_9290_(), p_11263_.f_8941_.m_9293_(), BiomeManager.m_47877_(serverLevel.m_7328_()), \u00e2\u02dc\u01929.m_5466_(), this.f_11195_.m_129784_(), this.f_11206_, serverLevel.m_6042_(), serverLevel.m_46472_(), this.m_11310_(), this.f_11207_, \u00e2\u02dc\u019213, !\u00e2\u02dc\u019212, serverLevel.m_46659_(), serverLevel.m_8584_()));
        \u00e2\u02dc\u019210.m_141995_(new ClientboundCustomPayloadPacket(ClientboundCustomPayloadPacket.f_132012_, new FriendlyByteBuf(Unpooled.buffer()).m_130070_(this.m_7873_().m_130001_())));
        \u00e2\u02dc\u019210.m_141995_(new ClientboundChangeDifficultyPacket(\u00e2\u02dc\u01929.m_5472_(), \u00e2\u02dc\u01929.m_5474_()));
        \u00e2\u02dc\u019210.m_141995_(new ClientboundPlayerAbilitiesPacket(p_11263_.m_150110_()));
        \u00e2\u02dc\u019210.m_141995_(new ClientboundSetCarriedItemPacket(p_11263_.m_150109_().f_35977_));
        \u00e2\u02dc\u019210.m_141995_(new ClientboundUpdateRecipesPacket(this.f_11195_.m_129894_().m_44051_()));
        \u00e2\u02dc\u019210.m_141995_(new ClientboundUpdateTagsPacket(this.f_11195_.m_129895_().m_144442_(this.f_11206_)));
        this.m_11289_(p_11263_);
        p_11263_.m_8951_().m_12850_();
        p_11263_.m_8952_().m_12789_(p_11263_);
        this.m_11273_(serverLevel.m_6188_(), p_11263_);
        this.f_11195_.m_129929_();
        TranslatableComponent \u00e2\u02dc\u019214 = p_11263_.m_36316_().getName().equalsIgnoreCase(\u00e2\u02dc\u01924) ? new TranslatableComponent("multiplayer.player.joined", p_11263_.m_5446_()) : new TranslatableComponent("multiplayer.player.joined.renamed", p_11263_.m_5446_(), \u00e2\u02dc\u01924);
        this.m_11264_(\u00e2\u02dc\u019214.m_130940_(ChatFormatting.YELLOW), ChatType.SYSTEM, Util.f_137441_);
        \u00e2\u02dc\u019210.m_9774_(p_11263_.m_20185_(), p_11263_.m_20186_(), p_11263_.m_20189_(), p_11263_.m_146908_(), p_11263_.m_146909_());
        this.f_11196_.add(p_11263_);
        this.f_11197_.put(p_11263_.m_142081_(), p_11263_);
        this.m_11268_(new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, p_11263_));
        for (int \u00e2\u02dc\u019215 = 0; \u00e2\u02dc\u019215 < this.f_11196_.size(); ++\u00e2\u02dc\u019215) {
            p_11263_.f_8906_.m_141995_(new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.ADD_PLAYER, this.f_11196_.get(\u00e2\u02dc\u019215)));
        }
        serverLevel.m_8834_(p_11263_);
        this.f_11195_.m_129901_().m_136293_(p_11263_);
        this.m_11229_(p_11263_, serverLevel);
        if (!this.f_11195_.m_129795_().isEmpty()) {
            p_11263_.m_143408_(this.f_11195_.m_129795_(), this.f_11195_.m_129796_(), this.f_11195_.m_142205_(), this.f_11195_.m_141958_());
        }
        Object \u00e2\u02dc\u019215 = p_11263_.m_21220_().iterator();
        while (\u00e2\u02dc\u019215.hasNext()) {
            object = \u00e2\u02dc\u019215.next();
            \u00e2\u02dc\u019210.m_141995_(new ClientboundUpdateMobEffectPacket(p_11263_.m_142049_(), (MobEffectInstance)object));
        }
        if (\u00e2\u02dc\u01925 != null && \u00e2\u02dc\u01925.m_128425_("RootVehicle", 10) && (object = EntityType.m_20645_(((CompoundTag)(\u00e2\u02dc\u019215 = \u00e2\u02dc\u01925.m_128469_("RootVehicle"))).m_128469_("Entity"), serverLevel, p_11223_ -> {
            if (!serverLevel.m_8847_((Entity)p_11223_)) {
                return null;
            }
            return p_11223_;
        })) != null) {
            UUID uUID = ((CompoundTag)\u00e2\u02dc\u019215).m_128403_("Attach") ? ((CompoundTag)\u00e2\u02dc\u019215).m_128342_("Attach") : null;
            if (((Entity)object).m_142081_().equals(uUID)) {
                p_11263_.m_7998_((Entity)object, true);
            } else {
                for (Entity entity : ((Entity)object).m_146897_()) {
                    if (!entity.m_142081_().equals(uUID)) continue;
                    p_11263_.m_7998_(entity, true);
                    break;
                }
            }
            if (!p_11263_.m_20159_()) {
                f_11188_.warn("Couldn't reattach entity to player");
                ((Entity)object).m_146870_();
                for (Entity entity : ((Entity)object).m_146897_()) {
                    entity.m_146870_();
                }
            }
        }
        p_11263_.m_143429_();
    }

    protected void m_11273_(ServerScoreboard p_11274_, ServerPlayer p_11275_) {
        HashSet hashSet = Sets.newHashSet();
        for (PlayerTeam playerTeam : p_11274_.m_83491_()) {
            p_11275_.f_8906_.m_141995_(ClientboundSetPlayerTeamPacket.m_179332_(playerTeam, true));
        }
        for (int i = 0; i < 19; ++i) {
            Objective objective = p_11274_.m_83416_(i);
            if (objective == null || hashSet.contains(objective)) continue;
            List<Packet<?>> \u00e2\u02dc\u01922 = p_11274_.m_136229_(objective);
            for (Packet<?> packet : \u00e2\u02dc\u01922) {
                p_11275_.f_8906_.m_141995_(packet);
            }
            hashSet.add(objective);
        }
    }

    public void m_11219_(ServerLevel p_11220_) {
        p_11220_.m_6857_().m_61929_(new BorderChangeListener(){

            @Override
            public void m_6312_(WorldBorder p_11321_, double p_11322_) {
                PlayerList.this.m_11268_(new ClientboundSetBorderSizePacket(p_11321_));
            }

            @Override
            public void m_6689_(WorldBorder p_11328_, double p_11329_, double p_11330_, long p_11331_) {
                PlayerList.this.m_11268_(new ClientboundSetBorderLerpSizePacket(p_11328_));
            }

            @Override
            public void m_7721_(WorldBorder p_11324_, double p_11325_, double p_11326_) {
                PlayerList.this.m_11268_(new ClientboundSetBorderCenterPacket(p_11324_));
            }

            @Override
            public void m_5904_(WorldBorder p_11333_, int p_11334_) {
                PlayerList.this.m_11268_(new ClientboundSetBorderWarningDelayPacket(p_11333_));
            }

            @Override
            public void m_5903_(WorldBorder p_11339_, int p_11340_) {
                PlayerList.this.m_11268_(new ClientboundSetBorderWarningDistancePacket(p_11339_));
            }

            @Override
            public void m_6315_(WorldBorder p_11336_, double p_11337_) {
            }

            @Override
            public void m_6313_(WorldBorder p_11342_, double p_11343_) {
            }
        });
    }

    @Nullable
    public CompoundTag m_11224_(ServerPlayer p_11225_) {
        CompoundTag compoundTag = this.f_11195_.m_129910_().m_6614_();
        if (p_11225_.m_7755_().getString().equals(this.f_11195_.m_129791_()) && compoundTag != null) {
            \u00e2\u02dc\u0192 = compoundTag;
            p_11225_.m_20258_(\u00e2\u02dc\u0192);
            f_11188_.debug("loading single player");
        } else {
            \u00e2\u02dc\u0192 = this.f_11204_.m_78435_(p_11225_);
        }
        return \u00e2\u02dc\u0192;
    }

    protected void m_6765_(ServerPlayer p_11277_) {
        this.f_11204_.m_78433_(p_11277_);
        ServerStatsCounter serverStatsCounter = this.f_11202_.get(p_11277_.m_142081_());
        if (serverStatsCounter != null) {
            serverStatsCounter.m_12818_();
        }
        if ((\u00e2\u02dc\u0192 = this.f_11203_.get(p_11277_.m_142081_())) != null) {
            \u00e2\u02dc\u0192.m_135991_();
        }
    }

    public void m_11286_(ServerPlayer p_11287_) {
        ServerLevel serverLevel = p_11287_.m_9236_();
        p_11287_.m_36220_(Stats.f_12989_);
        this.m_6765_(p_11287_);
        if (p_11287_.m_20159_() && ((Entity)(\u00e2\u02dc\u01922 = p_11287_.m_20201_())).m_146898_()) {
            f_11188_.debug("Removing player mount");
            p_11287_.m_8127_();
            ((Entity)\u00e2\u02dc\u01922).m_142429_().forEach(p_143990_ -> p_143990_.m_142467_(Entity.RemovalReason.UNLOADED_WITH_PLAYER));
        }
        p_11287_.m_19877_();
        serverLevel.m_143261_(p_11287_, Entity.RemovalReason.UNLOADED_WITH_PLAYER);
        p_11287_.m_8960_().m_135978_();
        this.f_11196_.remove(p_11287_);
        this.f_11195_.m_129901_().m_136305_(p_11287_);
        Object \u00e2\u02dc\u01922 = p_11287_.m_142081_();
        ServerPlayer \u00e2\u02dc\u01923 = this.f_11197_.get(\u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01923 == p_11287_) {
            this.f_11197_.remove(\u00e2\u02dc\u01922);
            this.f_11202_.remove(\u00e2\u02dc\u01922);
            this.f_11203_.remove(\u00e2\u02dc\u01922);
        }
        this.m_11268_(new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.REMOVE_PLAYER, p_11287_));
    }

    @Nullable
    public Component m_6418_(SocketAddress p_11257_, GameProfile p_11258_) {
        if (this.f_11198_.m_11406_(p_11258_)) {
            UserBanListEntry userBanListEntry = (UserBanListEntry)this.f_11198_.m_11388_(p_11258_);
            TranslatableComponent \u00e2\u02dc\u01922 = new TranslatableComponent("multiplayer.disconnect.banned.reason", userBanListEntry.m_10962_());
            if (userBanListEntry.m_10961_() != null) {
                \u00e2\u02dc\u01922.m_7220_(new TranslatableComponent("multiplayer.disconnect.banned.expiration", f_11194_.format(userBanListEntry.m_10961_())));
            }
            return \u00e2\u02dc\u01922;
        }
        if (!this.m_5764_(p_11258_)) {
            return new TranslatableComponent("multiplayer.disconnect.not_whitelisted");
        }
        if (this.f_11199_.m_11041_(p_11257_)) {
            IpBanListEntry \u00e2\u02dc\u01923 = this.f_11199_.m_11043_(p_11257_);
            TranslatableComponent \u00e2\u02dc\u01924 = new TranslatableComponent("multiplayer.disconnect.banned_ip.reason", \u00e2\u02dc\u01923.m_10962_());
            if (\u00e2\u02dc\u01923.m_10961_() != null) {
                \u00e2\u02dc\u01924.m_7220_(new TranslatableComponent("multiplayer.disconnect.banned_ip.expiration", f_11194_.format(\u00e2\u02dc\u01923.m_10961_())));
            }
            return \u00e2\u02dc\u01924;
        }
        if (this.f_11196_.size() >= this.f_11193_ && !this.m_5765_(p_11258_)) {
            return new TranslatableComponent("multiplayer.disconnect.server_full");
        }
        return null;
    }

    public ServerPlayer m_11300_(GameProfile p_11301_) {
        UUID uUID = Player.m_36198_(p_11301_);
        ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
        for (int i = 0; i < this.f_11196_.size(); ++i) {
            ServerPlayer serverPlayer = this.f_11196_.get(i);
            if (!serverPlayer.m_142081_().equals(uUID)) continue;
            \u00e2\u02dc\u01922.add(serverPlayer);
        }
        ServerPlayer serverPlayer = this.f_11197_.get(p_11301_.getId());
        if (serverPlayer != null && !\u00e2\u02dc\u01922.contains(serverPlayer)) {
            \u00e2\u02dc\u01922.add(serverPlayer);
        }
        for (ServerPlayer serverPlayer2 : \u00e2\u02dc\u01922) {
            serverPlayer2.f_8906_.m_9942_(new TranslatableComponent("multiplayer.disconnect.duplicate_login"));
        }
        return new ServerPlayer(this.f_11195_, this.f_11195_.m_129783_(), p_11301_);
    }

    public ServerPlayer m_11236_(ServerPlayer p_11237_, boolean p_11238_) {
        Optional \u00e2\u02dc\u01925;
        this.f_11196_.remove(p_11237_);
        p_11237_.m_9236_().m_143261_(p_11237_, Entity.RemovalReason.DISCARDED);
        BlockPos blockPos = p_11237_.m_8961_();
        float \u00e2\u02dc\u01922 = p_11237_.m_8962_();
        boolean \u00e2\u02dc\u01923 = p_11237_.m_8964_();
        ServerLevel \u00e2\u02dc\u01924 = this.f_11195_.m_129880_(p_11237_.m_8963_());
        if (\u00e2\u02dc\u01924 != null && blockPos != null) {
            Optional<Vec3> optional = Player.m_36130_(\u00e2\u02dc\u01924, blockPos, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, p_11238_);
        } else {
            \u00e2\u02dc\u01925 = Optional.empty();
        }
        ServerLevel \u00e2\u02dc\u01926 = \u00e2\u02dc\u01924 != null && \u00e2\u02dc\u01925.isPresent() ? \u00e2\u02dc\u01924 : this.f_11195_.m_129783_();
        ServerPlayer \u00e2\u02dc\u01927 = new ServerPlayer(this.f_11195_, \u00e2\u02dc\u01926, p_11237_.m_36316_());
        \u00e2\u02dc\u01927.f_8906_ = p_11237_.f_8906_;
        \u00e2\u02dc\u01927.m_9015_(p_11237_, p_11238_);
        \u00e2\u02dc\u01927.m_20234_(p_11237_.m_142049_());
        \u00e2\u02dc\u01927.m_36163_(p_11237_.m_5737_());
        for (String string : p_11237_.m_19880_()) {
            \u00e2\u02dc\u01927.m_20049_(string);
        }
        boolean bl = false;
        if (\u00e2\u02dc\u01925.isPresent()) {
            float \u00e2\u02dc\u019210;
            BlockState blockState = \u00e2\u02dc\u01926.m_8055_(blockPos);
            boolean \u00e2\u02dc\u01928 = blockState.m_60713_(Blocks.f_50724_);
            Vec3 \u00e2\u02dc\u01929 = (Vec3)\u00e2\u02dc\u01925.get();
            if (blockState.m_60620_(BlockTags.f_13038_) || \u00e2\u02dc\u01928) {
                Vec3 vec3 = Vec3.m_82539_(blockPos).m_82546_(\u00e2\u02dc\u01929).m_82541_();
                float f = (float)Mth.m_14175_(Mth.m_14136_(vec3.f_82481_, vec3.f_82479_) * 57.2957763671875 - 90.0);
            } else {
                \u00e2\u02dc\u019210 = \u00e2\u02dc\u01922;
            }
            \u00e2\u02dc\u01927.m_7678_(\u00e2\u02dc\u01929.f_82479_, \u00e2\u02dc\u01929.f_82480_, \u00e2\u02dc\u01929.f_82481_, \u00e2\u02dc\u019210, 0.0f);
            \u00e2\u02dc\u01927.m_9158_(\u00e2\u02dc\u01926.m_46472_(), blockPos, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, false);
            bl = !p_11238_ && \u00e2\u02dc\u01928;
        } else if (blockPos != null) {
            \u00e2\u02dc\u01927.f_8906_.m_141995_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132153_, 0.0f));
        }
        while (!\u00e2\u02dc\u01926.m_45786_(\u00e2\u02dc\u01927) && \u00e2\u02dc\u01927.m_20186_() < (double)\u00e2\u02dc\u01926.m_151558_()) {
            \u00e2\u02dc\u01927.m_6034_(\u00e2\u02dc\u01927.m_20185_(), \u00e2\u02dc\u01927.m_20186_() + 1.0, \u00e2\u02dc\u01927.m_20189_());
        }
        LevelData levelData = \u00e2\u02dc\u01927.f_19853_.m_6106_();
        \u00e2\u02dc\u01927.f_8906_.m_141995_(new ClientboundRespawnPacket(\u00e2\u02dc\u01927.f_19853_.m_6042_(), \u00e2\u02dc\u01927.f_19853_.m_46472_(), BiomeManager.m_47877_(\u00e2\u02dc\u01927.m_9236_().m_7328_()), \u00e2\u02dc\u01927.f_8941_.m_9290_(), \u00e2\u02dc\u01927.f_8941_.m_9293_(), \u00e2\u02dc\u01927.m_9236_().m_46659_(), \u00e2\u02dc\u01927.m_9236_().m_8584_(), p_11238_));
        \u00e2\u02dc\u01927.f_8906_.m_9774_(\u00e2\u02dc\u01927.m_20185_(), \u00e2\u02dc\u01927.m_20186_(), \u00e2\u02dc\u01927.m_20189_(), \u00e2\u02dc\u01927.m_146908_(), \u00e2\u02dc\u01927.m_146909_());
        \u00e2\u02dc\u01927.f_8906_.m_141995_(new ClientboundSetDefaultSpawnPositionPacket(\u00e2\u02dc\u01926.m_8900_(), \u00e2\u02dc\u01926.m_8901_()));
        \u00e2\u02dc\u01927.f_8906_.m_141995_(new ClientboundChangeDifficultyPacket(levelData.m_5472_(), levelData.m_5474_()));
        \u00e2\u02dc\u01927.f_8906_.m_141995_(new ClientboundSetExperiencePacket(\u00e2\u02dc\u01927.f_36080_, \u00e2\u02dc\u01927.f_36079_, \u00e2\u02dc\u01927.f_36078_));
        this.m_11229_(\u00e2\u02dc\u01927, \u00e2\u02dc\u01926);
        this.m_11289_(\u00e2\u02dc\u01927);
        \u00e2\u02dc\u01926.m_8845_(\u00e2\u02dc\u01927);
        this.f_11196_.add(\u00e2\u02dc\u01927);
        this.f_11197_.put(\u00e2\u02dc\u01927.m_142081_(), \u00e2\u02dc\u01927);
        \u00e2\u02dc\u01927.m_143429_();
        \u00e2\u02dc\u01927.m_21153_(\u00e2\u02dc\u01927.m_21223_());
        if (bl) {
            \u00e2\u02dc\u01927.f_8906_.m_141995_(new ClientboundSoundPacket(SoundEvents.f_12377_, SoundSource.BLOCKS, blockPos.m_123341_(), blockPos.m_123342_(), blockPos.m_123343_(), 1.0f, 1.0f));
        }
        return \u00e2\u02dc\u01927;
    }

    public void m_11289_(ServerPlayer p_11290_) {
        GameProfile gameProfile = p_11290_.m_36316_();
        int \u00e2\u02dc\u01922 = this.f_11195_.m_129944_(gameProfile);
        this.m_11226_(p_11290_, \u00e2\u02dc\u01922);
    }

    public void m_11288_() {
        if (++this.f_11210_ > 600) {
            this.m_11268_(new ClientboundPlayerInfoPacket(ClientboundPlayerInfoPacket.Action.UPDATE_LATENCY, this.f_11196_));
            this.f_11210_ = 0;
        }
    }

    public void m_11268_(Packet<?> p_11269_) {
        for (ServerPlayer serverPlayer : this.f_11196_) {
            serverPlayer.f_8906_.m_141995_(p_11269_);
        }
    }

    public void m_11270_(Packet<?> p_11271_, ResourceKey<Level> p_11272_) {
        for (ServerPlayer serverPlayer : this.f_11196_) {
            if (serverPlayer.f_19853_.m_46472_() != p_11272_) continue;
            serverPlayer.f_8906_.m_141995_(p_11271_);
        }
    }

    public void m_11249_(Player p_11250_, Component p_11251_) {
        Team team = p_11250_.m_5647_();
        if (team == null) {
            return;
        }
        Collection<String> \u00e2\u02dc\u01922 = team.m_6809_();
        for (String string : \u00e2\u02dc\u01922) {
            ServerPlayer serverPlayer = this.m_11255_(string);
            if (serverPlayer == null || serverPlayer == p_11250_) continue;
            serverPlayer.m_6352_(p_11251_, p_11250_.m_142081_());
        }
    }

    public void m_11278_(Player p_11279_, Component p_11280_) {
        Team team = p_11279_.m_5647_();
        if (team == null) {
            this.m_11264_(p_11280_, ChatType.SYSTEM, p_11279_.m_142081_());
            return;
        }
        for (int i = 0; i < this.f_11196_.size(); ++i) {
            ServerPlayer serverPlayer = this.f_11196_.get(i);
            if (serverPlayer.m_5647_() == team) continue;
            serverPlayer.m_6352_(p_11280_, p_11279_.m_142081_());
        }
    }

    public String[] m_11291_() {
        String[] stringArray = new String[this.f_11196_.size()];
        for (int i = 0; i < this.f_11196_.size(); ++i) {
            stringArray[i] = this.f_11196_.get(i).m_36316_().getName();
        }
        return stringArray;
    }

    public UserBanList m_11295_() {
        return this.f_11198_;
    }

    public IpBanList m_11299_() {
        return this.f_11199_;
    }

    public void m_5749_(GameProfile p_11254_) {
        this.f_11200_.m_11381_(new ServerOpListEntry(p_11254_, this.f_11195_.m_7022_(), this.f_11200_.m_11351_(p_11254_)));
        ServerPlayer serverPlayer = this.m_11259_(p_11254_.getId());
        if (serverPlayer != null) {
            this.m_11289_(serverPlayer);
        }
    }

    public void m_5750_(GameProfile p_11281_) {
        this.f_11200_.m_11393_(p_11281_);
        ServerPlayer serverPlayer = this.m_11259_(p_11281_.getId());
        if (serverPlayer != null) {
            this.m_11289_(serverPlayer);
        }
    }

    private void m_11226_(ServerPlayer p_11227_, int p_11228_) {
        if (p_11227_.f_8906_ != null) {
            byte by = p_11228_ <= 0 ? (byte)24 : (p_11228_ >= 4 ? (byte)28 : (byte)((byte)(24 + p_11228_)));
            p_11227_.f_8906_.m_141995_(new ClientboundEntityEventPacket(p_11227_, by));
        }
        this.f_11195_.m_129892_().m_82095_(p_11227_);
    }

    public boolean m_5764_(GameProfile p_11294_) {
        return !this.f_11205_ || this.f_11200_.m_11396_(p_11294_) || this.f_11201_.m_11396_(p_11294_);
    }

    public boolean m_11303_(GameProfile p_11304_) {
        return this.f_11200_.m_11396_(p_11304_) || this.f_11195_.m_7779_(p_11304_) && this.f_11195_.m_129910_().m_5468_() || this.f_11209_;
    }

    @Nullable
    public ServerPlayer m_11255_(String p_11256_) {
        for (ServerPlayer serverPlayer : this.f_11196_) {
            if (!serverPlayer.m_36316_().getName().equalsIgnoreCase(p_11256_)) continue;
            return serverPlayer;
        }
        return null;
    }

    public void m_11241_(@Nullable Player p_11242_, double p_11243_, double p_11244_, double p_11245_, double p_11246_, ResourceKey<Level> p_11247_, Packet<?> p_11248_) {
        for (int i = 0; i < this.f_11196_.size(); ++i) {
            ServerPlayer serverPlayer = this.f_11196_.get(i);
            if (serverPlayer == p_11242_ || serverPlayer.f_19853_.m_46472_() != p_11247_ || !((\u00e2\u02dc\u0192 = p_11243_ - serverPlayer.m_20185_()) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = p_11244_ - serverPlayer.m_20186_()) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = p_11245_ - serverPlayer.m_20189_()) * \u00e2\u02dc\u0192 < p_11246_ * p_11246_)) continue;
            serverPlayer.f_8906_.m_141995_(p_11248_);
        }
    }

    public void m_11302_() {
        for (int i = 0; i < this.f_11196_.size(); ++i) {
            this.m_6765_(this.f_11196_.get(i));
        }
    }

    public UserWhiteList m_11305_() {
        return this.f_11201_;
    }

    public String[] m_11306_() {
        return this.f_11201_.m_5875_();
    }

    public ServerOpList m_11307_() {
        return this.f_11200_;
    }

    public String[] m_11308_() {
        return this.f_11200_.m_5875_();
    }

    public void m_7542_() {
    }

    public void m_11229_(ServerPlayer p_11230_, ServerLevel p_11231_) {
        WorldBorder worldBorder = this.f_11195_.m_129783_().m_6857_();
        p_11230_.f_8906_.m_141995_(new ClientboundInitializeBorderPacket(worldBorder));
        p_11230_.f_8906_.m_141995_(new ClientboundSetTimePacket(p_11231_.m_46467_(), p_11231_.m_46468_(), p_11231_.m_46469_().m_46207_(GameRules.f_46140_)));
        p_11230_.f_8906_.m_141995_(new ClientboundSetDefaultSpawnPositionPacket(p_11231_.m_8900_(), p_11231_.m_8901_()));
        if (p_11231_.m_46471_()) {
            p_11230_.f_8906_.m_141995_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132154_, 0.0f));
            p_11230_.f_8906_.m_141995_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132160_, p_11231_.m_46722_(1.0f)));
            p_11230_.f_8906_.m_141995_(new ClientboundGameEventPacket(ClientboundGameEventPacket.f_132161_, p_11231_.m_46661_(1.0f)));
        }
    }

    public void m_11292_(ServerPlayer p_11293_) {
        p_11293_.f_36095_.m_150429_();
        p_11293_.m_9233_();
        p_11293_.f_8906_.m_141995_(new ClientboundSetCarriedItemPacket(p_11293_.m_150109_().f_35977_));
    }

    public int m_11309_() {
        return this.f_11196_.size();
    }

    public int m_11310_() {
        return this.f_11193_;
    }

    public boolean m_11311_() {
        return this.f_11205_;
    }

    public void m_6628_(boolean p_11276_) {
        this.f_11205_ = p_11276_;
    }

    public List<ServerPlayer> m_11282_(String p_11283_) {
        ArrayList arrayList = Lists.newArrayList();
        for (ServerPlayer serverPlayer : this.f_11196_) {
            if (!serverPlayer.m_9239_().equals(p_11283_)) continue;
            arrayList.add(serverPlayer);
        }
        return arrayList;
    }

    public int m_11312_() {
        return this.f_11207_;
    }

    public MinecraftServer m_7873_() {
        return this.f_11195_;
    }

    public CompoundTag m_6960_() {
        return null;
    }

    public void m_11284_(boolean p_11285_) {
        this.f_11209_ = p_11285_;
    }

    public void m_11313_() {
        for (int i = 0; i < this.f_11196_.size(); ++i) {
            this.f_11196_.get((int)i).f_8906_.m_9942_(new TranslatableComponent("multiplayer.disconnect.server_shutdown"));
        }
    }

    public void m_11264_(Component p_11265_, ChatType p_11266_, UUID p_11267_) {
        this.f_11195_.m_6352_(p_11265_, p_11267_);
        for (ServerPlayer serverPlayer : this.f_11196_) {
            serverPlayer.m_9146_(p_11265_, p_11266_, p_11267_);
        }
    }

    public void m_143991_(Component p_143992_, Function<ServerPlayer, Component> p_143993_, ChatType p_143994_, UUID p_143995_) {
        this.f_11195_.m_6352_(p_143992_, p_143995_);
        for (ServerPlayer serverPlayer : this.f_11196_) {
            Component component = p_143993_.apply(serverPlayer);
            if (component == null) continue;
            serverPlayer.m_9146_(component, p_143994_, p_143995_);
        }
    }

    public ServerStatsCounter m_11239_(Player p_11240_) {
        ServerStatsCounter \u00e2\u02dc\u01922;
        UUID uUID = p_11240_.m_142081_();
        ServerStatsCounter serverStatsCounter = \u00e2\u02dc\u01922 = uUID == null ? null : this.f_11202_.get(uUID);
        if (\u00e2\u02dc\u01922 == null) {
            File file = this.f_11195_.m_129843_(LevelResource.f_78175_).toFile();
            \u00e2\u02dc\u0192 = new File(file, uUID + ".json");
            if (!\u00e2\u02dc\u0192.exists() && FileUtil.m_133728_(\u00e2\u02dc\u0192 = (\u00e2\u02dc\u0192 = new File(file, p_11240_.m_7755_().getString() + ".json")).toPath()) && FileUtil.m_133734_(\u00e2\u02dc\u0192) && \u00e2\u02dc\u0192.startsWith(file.getPath()) && \u00e2\u02dc\u0192.isFile()) {
                \u00e2\u02dc\u0192.renameTo(\u00e2\u02dc\u0192);
            }
            \u00e2\u02dc\u01922 = new ServerStatsCounter(this.f_11195_, \u00e2\u02dc\u0192);
            this.f_11202_.put(uUID, \u00e2\u02dc\u01922);
        }
        return \u00e2\u02dc\u01922;
    }

    public PlayerAdvancements m_11296_(ServerPlayer p_11297_) {
        UUID uUID = p_11297_.m_142081_();
        PlayerAdvancements \u00e2\u02dc\u01922 = this.f_11203_.get(uUID);
        if (\u00e2\u02dc\u01922 == null) {
            File file = this.f_11195_.m_129843_(LevelResource.f_78174_).toFile();
            \u00e2\u02dc\u0192 = new File(file, uUID + ".json");
            \u00e2\u02dc\u01922 = new PlayerAdvancements(this.f_11195_.m_129933_(), this, this.f_11195_.m_129889_(), \u00e2\u02dc\u0192, p_11297_);
            this.f_11203_.put(uUID, \u00e2\u02dc\u01922);
        }
        \u00e2\u02dc\u01922.m_135979_(p_11297_);
        return \u00e2\u02dc\u01922;
    }

    public void m_11217_(int p_11218_) {
        this.f_11207_ = p_11218_;
        this.m_11268_(new ClientboundSetChunkCacheRadiusPacket(p_11218_));
        for (ServerLevel serverLevel : this.f_11195_.m_129785_()) {
            if (serverLevel == null) continue;
            serverLevel.m_7726_().m_8354_(p_11218_);
        }
    }

    public List<ServerPlayer> m_11314_() {
        return this.f_11196_;
    }

    @Nullable
    public ServerPlayer m_11259_(UUID p_11260_) {
        return this.f_11197_.get(p_11260_);
    }

    public boolean m_5765_(GameProfile p_11298_) {
        return false;
    }

    public void m_11315_() {
        for (PlayerAdvancements playerAdvancements : this.f_11203_.values()) {
            playerAdvancements.m_135981_(this.f_11195_.m_129889_());
        }
        this.m_11268_(new ClientboundUpdateTagsPacket(this.f_11195_.m_129895_().m_144442_(this.f_11206_)));
        ClientboundUpdateRecipesPacket clientboundUpdateRecipesPacket = new ClientboundUpdateRecipesPacket(this.f_11195_.m_129894_().m_44051_());
        for (ServerPlayer serverPlayer : this.f_11196_) {
            serverPlayer.f_8906_.m_141995_(clientboundUpdateRecipesPacket);
            serverPlayer.m_8952_().m_12789_(serverPlayer);
        }
    }

    public boolean m_11316_() {
        return this.f_11209_;
    }
}

