/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Maps;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.PortUnreachableException;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.rcon.NetworkDataOutputStream;
import net.minecraft.server.rcon.PktUtils;
import net.minecraft.server.rcon.thread.GenericThread;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class QueryThreadGs4
extends GenericThread {
    private static final Logger f_11524_ = LogManager.getLogger();
    private static final String f_144024_ = "SMP";
    private static final String f_144025_ = "MINECRAFT";
    private static final long f_144026_ = 30000L;
    private static final long f_144027_ = 5000L;
    private long f_11525_;
    private final int f_11526_;
    private final int f_11527_;
    private final int f_11528_;
    private final String f_11529_;
    private final String f_11530_;
    private DatagramSocket f_11531_;
    private final byte[] f_11532_ = new byte[1460];
    private String f_11533_;
    private String f_11534_;
    private final Map<SocketAddress, RequestChallenge> f_11535_;
    private final NetworkDataOutputStream f_11536_;
    private long f_11537_;
    private final ServerInterface f_11538_;

    private QueryThreadGs4(ServerInterface p_11541_, int p_11542_) {
        super("Query Listener");
        this.f_11538_ = p_11541_;
        this.f_11526_ = p_11542_;
        this.f_11534_ = p_11541_.m_6866_();
        this.f_11527_ = p_11541_.m_7448_();
        this.f_11529_ = p_11541_.m_6995_();
        this.f_11528_ = p_11541_.m_7418_();
        this.f_11530_ = p_11541_.m_7123_();
        this.f_11537_ = 0L;
        this.f_11533_ = "0.0.0.0";
        if (this.f_11534_.isEmpty() || this.f_11533_.equals(this.f_11534_)) {
            this.f_11534_ = "0.0.0.0";
            try {
                InetAddress inetAddress = InetAddress.getLocalHost();
                this.f_11533_ = inetAddress.getHostAddress();
            }
            catch (UnknownHostException unknownHostException) {
                f_11524_.warn("Unable to determine local host IP, please set server-ip in server.properties", (Throwable)unknownHostException);
            }
        } else {
            this.f_11533_ = this.f_11534_;
        }
        this.f_11536_ = new NetworkDataOutputStream(1460);
        this.f_11535_ = Maps.newHashMap();
    }

    @Nullable
    public static QueryThreadGs4 m_11553_(ServerInterface p_11554_) {
        int n = p_11554_.m_7913_().f_139746_;
        if (0 >= n || 65535 < n) {
            f_11524_.warn("Invalid query port {} found in server.properties (queries disabled)", (Object)n);
            return null;
        }
        QueryThreadGs4 \u00e2\u02dc\u01922 = new QueryThreadGs4(p_11554_, n);
        if (!\u00e2\u02dc\u01922.m_7528_()) {
            return null;
        }
        return \u00e2\u02dc\u01922;
    }

    private void m_11555_(byte[] p_11556_, DatagramPacket p_11557_) throws IOException {
        this.f_11531_.send(new DatagramPacket(p_11556_, p_11556_.length, p_11557_.getSocketAddress()));
    }

    private boolean m_11549_(DatagramPacket p_11550_) throws IOException {
        byte[] byArray = p_11550_.getData();
        int \u00e2\u02dc\u01922 = p_11550_.getLength();
        SocketAddress \u00e2\u02dc\u01923 = p_11550_.getSocketAddress();
        f_11524_.debug("Packet len {} [{}]", (Object)\u00e2\u02dc\u01922, (Object)\u00e2\u02dc\u01923);
        if (3 > \u00e2\u02dc\u01922 || -2 != byArray[0] || -3 != byArray[1]) {
            f_11524_.debug("Invalid packet [{}]", (Object)\u00e2\u02dc\u01923);
            return false;
        }
        f_11524_.debug("Packet '{}' [{}]", (Object)PktUtils.m_11483_(byArray[2]), (Object)\u00e2\u02dc\u01923);
        switch (byArray[2]) {
            case 9: {
                this.m_11563_(p_11550_);
                f_11524_.debug("Challenge [{}]", (Object)\u00e2\u02dc\u01923);
                return true;
            }
            case 0: {
                if (!this.m_11560_(p_11550_).booleanValue()) {
                    f_11524_.debug("Invalid challenge [{}]", (Object)\u00e2\u02dc\u01923);
                    return false;
                }
                if (15 == \u00e2\u02dc\u01922) {
                    this.m_11555_(this.m_11558_(p_11550_), p_11550_);
                    f_11524_.debug("Rules [{}]", (Object)\u00e2\u02dc\u01923);
                    break;
                }
                NetworkDataOutputStream networkDataOutputStream = new NetworkDataOutputStream(1460);
                networkDataOutputStream.m_11472_(0);
                networkDataOutputStream.m_11478_(this.m_11551_(p_11550_.getSocketAddress()));
                networkDataOutputStream.m_11474_(this.f_11529_);
                networkDataOutputStream.m_11474_(f_144024_);
                networkDataOutputStream.m_11474_(this.f_11530_);
                networkDataOutputStream.m_11474_(Integer.toString(this.f_11538_.m_7416_()));
                networkDataOutputStream.m_11474_(Integer.toString(this.f_11528_));
                networkDataOutputStream.m_11476_((short)this.f_11527_);
                networkDataOutputStream.m_11474_(this.f_11533_);
                this.m_11555_(networkDataOutputStream.m_11471_(), p_11550_);
                f_11524_.debug("Status [{}]", (Object)\u00e2\u02dc\u01923);
            }
        }
        return true;
    }

    private byte[] m_11558_(DatagramPacket p_11559_) throws IOException {
        long l = Util.m_137550_();
        if (l < this.f_11537_ + 5000L) {
            byte[] byArray = this.f_11536_.m_11471_();
            \u00e2\u02dc\u0192 = this.m_11551_(p_11559_.getSocketAddress());
            byArray[1] = \u00e2\u02dc\u0192[0];
            byArray[2] = \u00e2\u02dc\u0192[1];
            byArray[3] = \u00e2\u02dc\u0192[2];
            byArray[4] = \u00e2\u02dc\u0192[3];
            return byArray;
        }
        this.f_11537_ = l;
        this.f_11536_.m_11480_();
        this.f_11536_.m_11472_(0);
        this.f_11536_.m_11478_(this.m_11551_(p_11559_.getSocketAddress()));
        this.f_11536_.m_11474_("splitnum");
        this.f_11536_.m_11472_(128);
        this.f_11536_.m_11472_(0);
        this.f_11536_.m_11474_("hostname");
        this.f_11536_.m_11474_(this.f_11529_);
        this.f_11536_.m_11474_("gametype");
        this.f_11536_.m_11474_(f_144024_);
        this.f_11536_.m_11474_("game_id");
        this.f_11536_.m_11474_(f_144025_);
        this.f_11536_.m_11474_("version");
        this.f_11536_.m_11474_(this.f_11538_.m_7630_());
        this.f_11536_.m_11474_("plugins");
        this.f_11536_.m_11474_(this.f_11538_.m_7138_());
        this.f_11536_.m_11474_("map");
        this.f_11536_.m_11474_(this.f_11530_);
        this.f_11536_.m_11474_("numplayers");
        this.f_11536_.m_11474_("" + this.f_11538_.m_7416_());
        this.f_11536_.m_11474_("maxplayers");
        this.f_11536_.m_11474_("" + this.f_11528_);
        this.f_11536_.m_11474_("hostport");
        this.f_11536_.m_11474_("" + this.f_11527_);
        this.f_11536_.m_11474_("hostip");
        this.f_11536_.m_11474_(this.f_11533_);
        this.f_11536_.m_11472_(0);
        this.f_11536_.m_11472_(1);
        this.f_11536_.m_11474_("player_");
        this.f_11536_.m_11472_(0);
        for (String string : \u00e2\u02dc\u0192 = this.f_11538_.m_7641_()) {
            this.f_11536_.m_11474_(string);
        }
        this.f_11536_.m_11472_(0);
        return this.f_11536_.m_11471_();
    }

    private byte[] m_11551_(SocketAddress p_11552_) {
        return this.f_11535_.get(p_11552_).m_11578_();
    }

    private Boolean m_11560_(DatagramPacket p_11561_) {
        SocketAddress socketAddress = p_11561_.getSocketAddress();
        if (!this.f_11535_.containsKey(socketAddress)) {
            return false;
        }
        byte[] \u00e2\u02dc\u01922 = p_11561_.getData();
        return this.f_11535_.get(socketAddress).m_11574_() == PktUtils.m_11496_(\u00e2\u02dc\u01922, 7, p_11561_.getLength());
    }

    private void m_11563_(DatagramPacket p_11564_) throws IOException {
        RequestChallenge requestChallenge = new RequestChallenge(p_11564_);
        this.f_11535_.put(p_11564_.getSocketAddress(), requestChallenge);
        this.m_11555_(requestChallenge.m_11577_(), p_11564_);
    }

    private void m_11562_() {
        if (!this.f_11515_) {
            return;
        }
        long l = Util.m_137550_();
        if (l < this.f_11525_ + 30000L) {
            return;
        }
        this.f_11525_ = l;
        this.f_11535_.values().removeIf(p_11546_ -> p_11546_.m_11575_(l));
    }

    @Override
    public void run() {
        f_11524_.info("Query running on {}:{}", (Object)this.f_11534_, (Object)this.f_11526_);
        this.f_11525_ = Util.m_137550_();
        DatagramPacket datagramPacket = new DatagramPacket(this.f_11532_, this.f_11532_.length);
        try {
            while (this.f_11515_) {
                try {
                    this.f_11531_.receive(datagramPacket);
                    this.m_11562_();
                    this.m_11549_(datagramPacket);
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.m_11562_();
                }
                catch (PortUnreachableException socketTimeoutException) {
                }
                catch (IOException iOException) {
                    this.m_11547_(iOException);
                }
            }
        }
        finally {
            f_11524_.debug("closeSocket: {}:{}", (Object)this.f_11534_, (Object)this.f_11526_);
            this.f_11531_.close();
        }
    }

    @Override
    public boolean m_7528_() {
        if (this.f_11515_) {
            return true;
        }
        if (!this.m_11565_()) {
            return false;
        }
        return super.m_7528_();
    }

    private void m_11547_(Exception p_11548_) {
        if (!this.f_11515_) {
            return;
        }
        f_11524_.warn("Unexpected exception", (Throwable)p_11548_);
        if (!this.m_11565_()) {
            f_11524_.error("Failed to recover from exception, shutting down!");
            this.f_11515_ = false;
        }
    }

    private boolean m_11565_() {
        try {
            this.f_11531_ = new DatagramSocket(this.f_11526_, InetAddress.getByName(this.f_11534_));
            this.f_11531_.setSoTimeout(500);
            return true;
        }
        catch (Exception exception) {
            f_11524_.warn("Unable to initialise query system on {}:{}", (Object)this.f_11534_, (Object)this.f_11526_, (Object)exception);
            return false;
        }
    }

    static class RequestChallenge {
        private final long f_11567_ = new Date().getTime();
        private final int f_11568_;
        private final byte[] f_11569_;
        private final byte[] f_11570_;
        private final String f_11571_;

        public RequestChallenge(DatagramPacket p_11573_) {
            byte[] byArray = p_11573_.getData();
            this.f_11569_ = new byte[4];
            this.f_11569_[0] = byArray[3];
            this.f_11569_[1] = byArray[4];
            this.f_11569_[2] = byArray[5];
            this.f_11569_[3] = byArray[6];
            this.f_11571_ = new String(this.f_11569_, StandardCharsets.UTF_8);
            this.f_11568_ = new Random().nextInt(0x1000000);
            this.f_11570_ = String.format("\t%s%d\u0000", this.f_11571_, this.f_11568_).getBytes(StandardCharsets.UTF_8);
        }

        public Boolean m_11575_(long p_11576_) {
            return this.f_11567_ < p_11576_;
        }

        public int m_11574_() {
            return this.f_11568_;
        }

        public byte[] m_11577_() {
            return this.f_11570_;
        }

        public byte[] m_11578_() {
            return this.f_11569_;
        }

        public String m_144028_() {
            return this.f_11571_;
        }
    }
}

