/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.rcon.thread;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.ServerInterface;
import net.minecraft.server.dedicated.DedicatedServerProperties;
import net.minecraft.server.rcon.thread.GenericThread;
import net.minecraft.server.rcon.thread.RconClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RconThread
extends GenericThread {
    private static final Logger f_11601_ = LogManager.getLogger();
    private final ServerSocket f_11602_;
    private final String f_11603_;
    private final List<RconClient> f_11604_ = Lists.newArrayList();
    private final ServerInterface f_11605_;

    private RconThread(ServerInterface p_11608_, ServerSocket p_11609_, String p_11610_) {
        super("RCON Listener");
        this.f_11605_ = p_11608_;
        this.f_11602_ = p_11609_;
        this.f_11603_ = p_11610_;
    }

    private void m_11618_() {
        this.f_11604_.removeIf(p_11612_ -> !p_11612_.m_11523_());
    }

    @Override
    public void run() {
        try {
            while (this.f_11515_) {
                try {
                    Socket socket = this.f_11602_.accept();
                    RconClient \u00e2\u02dc\u01922 = new RconClient(this.f_11605_, this.f_11603_, socket);
                    \u00e2\u02dc\u01922.m_7528_();
                    this.f_11604_.add(\u00e2\u02dc\u01922);
                    this.m_11618_();
                }
                catch (SocketTimeoutException socketTimeoutException) {
                    this.m_11618_();
                }
                catch (IOException iOException) {
                    if (!this.f_11515_) continue;
                    f_11601_.info("IO exception: ", (Throwable)iOException);
                }
            }
        }
        finally {
            this.m_11613_(this.f_11602_);
        }
    }

    @Nullable
    public static RconThread m_11615_(ServerInterface p_11616_) {
        DedicatedServerProperties dedicatedServerProperties = p_11616_.m_7913_();
        String \u00e2\u02dc\u01922 = p_11616_.m_6866_();
        if (\u00e2\u02dc\u01922.isEmpty()) {
            \u00e2\u02dc\u01922 = "0.0.0.0";
        }
        if (0 >= (\u00e2\u02dc\u0192 = dedicatedServerProperties.f_139748_) || 65535 < \u00e2\u02dc\u0192) {
            f_11601_.warn("Invalid rcon port {} found in server.properties, rcon disabled!", (Object)\u00e2\u02dc\u0192);
            return null;
        }
        String \u00e2\u02dc\u01923 = dedicatedServerProperties.f_139749_;
        if (\u00e2\u02dc\u01923.isEmpty()) {
            f_11601_.warn("No rcon password set in server.properties, rcon disabled!");
            return null;
        }
        try {
            ServerSocket serverSocket = new ServerSocket(\u00e2\u02dc\u0192, 0, InetAddress.getByName(\u00e2\u02dc\u01922));
            serverSocket.setSoTimeout(500);
            RconThread \u00e2\u02dc\u01924 = new RconThread(p_11616_, serverSocket, \u00e2\u02dc\u01923);
            if (!\u00e2\u02dc\u01924.m_7528_()) {
                return null;
            }
            f_11601_.info("RCON running on {}:{}", (Object)\u00e2\u02dc\u01922, (Object)\u00e2\u02dc\u0192);
            return \u00e2\u02dc\u01924;
        }
        catch (IOException iOException) {
            f_11601_.warn("Unable to initialise RCON on {}:{}", (Object)\u00e2\u02dc\u01922, (Object)\u00e2\u02dc\u0192, (Object)iOException);
            return null;
        }
    }

    @Override
    public void m_7530_() {
        this.f_11515_ = false;
        this.m_11613_(this.f_11602_);
        super.m_7530_();
        for (RconClient rconClient : this.f_11604_) {
            if (!rconClient.m_11523_()) continue;
            rconClient.m_7530_();
        }
        this.f_11604_.clear();
    }

    private void m_11613_(ServerSocket p_11614_) {
        f_11601_.debug("closeSocket: {}", (Object)p_11614_);
        try {
            p_11614_.close();
        }
        catch (IOException iOException) {
            f_11601_.warn("Failed to close socket", (Throwable)iOException);
        }
    }
}

