/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ResourceLocationException;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.network.protocol.game.ClientboundRecipePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.RecipeBook;
import net.minecraft.stats.RecipeBookSettings;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerRecipeBook
extends RecipeBook {
    public static final String f_144248_ = "recipeBook";
    private static final Logger f_12786_ = LogManager.getLogger();

    public int m_12791_(Collection<Recipe<?>> p_12792_, ServerPlayer p_12793_) {
        ArrayList arrayList = Lists.newArrayList();
        int \u00e2\u02dc\u01922 = 0;
        for (Recipe<?> recipe : p_12792_) {
            ResourceLocation resourceLocation = recipe.m_6423_();
            if (this.f_12680_.contains(resourceLocation) || recipe.m_5598_()) continue;
            this.m_12702_(resourceLocation);
            this.m_12719_(resourceLocation);
            arrayList.add(resourceLocation);
            CriteriaTriggers.f_10572_.m_63718_(p_12793_, recipe);
            ++\u00e2\u02dc\u01922;
        }
        this.m_12801_(ClientboundRecipePacket.State.ADD, p_12793_, arrayList);
        return \u00e2\u02dc\u01922;
    }

    public int m_12806_(Collection<Recipe<?>> p_12807_, ServerPlayer p_12808_) {
        ArrayList arrayList = Lists.newArrayList();
        int \u00e2\u02dc\u01922 = 0;
        for (Recipe<?> recipe : p_12807_) {
            ResourceLocation resourceLocation = recipe.m_6423_();
            if (!this.f_12680_.contains(resourceLocation)) continue;
            this.m_12715_(resourceLocation);
            arrayList.add(resourceLocation);
            ++\u00e2\u02dc\u01922;
        }
        this.m_12801_(ClientboundRecipePacket.State.REMOVE, p_12808_, arrayList);
        return \u00e2\u02dc\u01922;
    }

    private void m_12801_(ClientboundRecipePacket.State p_12802_, ServerPlayer p_12803_, List<ResourceLocation> p_12804_) {
        p_12803_.f_8906_.m_141995_(new ClientboundRecipePacket(p_12802_, p_12804_, Collections.emptyList(), this.m_12684_()));
    }

    public CompoundTag m_12805_() {
        CompoundTag compoundTag = new CompoundTag();
        this.m_12684_().m_12759_(compoundTag);
        ListTag \u00e2\u02dc\u01922 = new ListTag();
        for (ResourceLocation resourceLocation : this.f_12680_) {
            \u00e2\u02dc\u01922.add(StringTag.m_129297_(resourceLocation.toString()));
        }
        compoundTag.m_128365_("recipes", \u00e2\u02dc\u01922);
        ListTag \u00e2\u02dc\u01923 = new ListTag();
        for (ResourceLocation resourceLocation : this.f_12681_) {
            \u00e2\u02dc\u01923.add(StringTag.m_129297_(resourceLocation.toString()));
        }
        compoundTag.m_128365_("toBeDisplayed", \u00e2\u02dc\u01923);
        return compoundTag;
    }

    public void m_12794_(CompoundTag p_12795_, RecipeManager p_12796_) {
        this.m_12687_(RecipeBookSettings.m_12741_(p_12795_));
        ListTag listTag = p_12795_.m_128437_("recipes", 8);
        this.m_12797_(listTag, this::m_12700_, p_12796_);
        \u00e2\u02dc\u0192 = p_12795_.m_128437_("toBeDisplayed", 8);
        this.m_12797_(\u00e2\u02dc\u0192, this::m_12723_, p_12796_);
    }

    private void m_12797_(ListTag p_12798_, Consumer<Recipe<?>> p_12799_, RecipeManager p_12800_) {
        for (int i = 0; i < p_12798_.size(); ++i) {
            String string = p_12798_.m_128778_(i);
            try {
                ResourceLocation resourceLocation = new ResourceLocation(string);
                Optional<Recipe<?>> \u00e2\u02dc\u01922 = p_12800_.m_44043_(resourceLocation);
                if (!\u00e2\u02dc\u01922.isPresent()) {
                    f_12786_.error("Tried to load unrecognized recipe: {} removed now.", (Object)resourceLocation);
                    continue;
                }
                p_12799_.accept(\u00e2\u02dc\u01922.get());
                continue;
            }
            catch (ResourceLocationException resourceLocationException) {
                f_12786_.error("Tried to load improperly formatted recipe: {} removed now.", (Object)string);
            }
        }
    }

    public void m_12789_(ServerPlayer p_12790_) {
        p_12790_.f_8906_.m_141995_(new ClientboundRecipePacket(ClientboundRecipePacket.State.INIT, this.f_12680_, this.f_12681_, this.m_12684_()));
    }
}

