/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.stats;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonReader;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.network.protocol.game.ClientboundAwardStatsPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.stats.StatsCounter;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.player.Player;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ServerStatsCounter
extends StatsCounter {
    private static final Logger f_12809_ = LogManager.getLogger();
    private final MinecraftServer f_12810_;
    private final File f_12811_;
    private final Set<Stat<?>> f_12812_ = Sets.newHashSet();

    public ServerStatsCounter(MinecraftServer p_12816_, File p_12817_) {
        this.f_12810_ = p_12816_;
        this.f_12811_ = p_12817_;
        if (p_12817_.isFile()) {
            try {
                this.m_12832_(p_12816_.m_129933_(), FileUtils.readFileToString((File)p_12817_));
            }
            catch (IOException iOException) {
                f_12809_.error("Couldn't read statistics file {}", (Object)p_12817_, (Object)iOException);
            }
            catch (JsonParseException jsonParseException) {
                f_12809_.error("Couldn't parse statistics file {}", (Object)p_12817_, (Object)jsonParseException);
            }
        }
    }

    public void m_12818_() {
        try {
            FileUtils.writeStringToFile((File)this.f_12811_, (String)this.m_12845_());
        }
        catch (IOException iOException) {
            f_12809_.error("Couldn't save stats", (Throwable)iOException);
        }
    }

    @Override
    public void m_6085_(Player p_12827_, Stat<?> p_12828_, int p_12829_) {
        super.m_6085_(p_12827_, p_12828_, p_12829_);
        this.f_12812_.add(p_12828_);
    }

    private Set<Stat<?>> m_12851_() {
        HashSet hashSet = Sets.newHashSet(this.f_12812_);
        this.f_12812_.clear();
        return hashSet;
    }

    public void m_12832_(DataFixer p_12833_, String p_12834_) {
        try (JsonReader jsonReader = new JsonReader((Reader)new StringReader(p_12834_));){
            jsonReader.setLenient(false);
            JsonElement jsonElement = Streams.parse((JsonReader)jsonReader);
            if (jsonElement.isJsonNull()) {
                f_12809_.error("Unable to parse Stat data from {}", (Object)this.f_12811_);
                return;
            }
            CompoundTag \u00e2\u02dc\u01922 = ServerStatsCounter.m_12830_(jsonElement.getAsJsonObject());
            if (!\u00e2\u02dc\u01922.m_128425_("DataVersion", 99)) {
                \u00e2\u02dc\u01922.m_128405_("DataVersion", 1343);
            }
            if ((\u00e2\u02dc\u01922 = NbtUtils.m_129213_(p_12833_, DataFixTypes.STATS, \u00e2\u02dc\u01922, \u00e2\u02dc\u01922.m_128451_("DataVersion"))).m_128425_("stats", 10)) {
                CompoundTag compoundTag = \u00e2\u02dc\u01922.m_128469_("stats");
                for (String string : compoundTag.m_128431_()) {
                    if (!compoundTag.m_128425_(string, 10)) continue;
                    Util.m_137521_(Registry.f_122867_.m_6612_(new ResourceLocation(string)), p_12844_ -> {
                        CompoundTag compoundTag = compoundTag.m_128469_(string);
                        for (String string : compoundTag.m_128431_()) {
                            if (compoundTag.m_128425_(string, 99)) {
                                Util.m_137521_(this.m_12823_((StatType)p_12844_, string), p_144252_ -> this.f_13013_.put(p_144252_, compoundTag.m_128451_(string)), () -> f_12809_.warn("Invalid statistic in {}: Don't know what {} is", (Object)this.f_12811_, (Object)string));
                                continue;
                            }
                            f_12809_.warn("Invalid statistic value in {}: Don't know what {} is for key {}", (Object)this.f_12811_, (Object)compoundTag.m_128423_(string), (Object)string);
                        }
                    }, () -> f_12809_.warn("Invalid statistic type in {}: Don't know what {} is", (Object)this.f_12811_, (Object)string));
                }
            }
        }
        catch (JsonParseException | IOException throwable) {
            f_12809_.error("Unable to parse Stat data from {}", (Object)this.f_12811_, (Object)throwable);
        }
    }

    private <T> Optional<Stat<T>> m_12823_(StatType<T> p_12824_, String p_12825_) {
        return Optional.ofNullable(ResourceLocation.m_135820_(p_12825_)).flatMap(p_12824_.m_12893_()::m_6612_).map(p_12824_::m_12902_);
    }

    private static CompoundTag m_12830_(JsonObject p_12831_) {
        CompoundTag compoundTag = new CompoundTag();
        for (Map.Entry entry : p_12831_.entrySet()) {
            JsonElement jsonElement = (JsonElement)entry.getValue();
            if (jsonElement.isJsonObject()) {
                compoundTag.m_128365_((String)entry.getKey(), ServerStatsCounter.m_12830_(jsonElement.getAsJsonObject()));
                continue;
            }
            if (!jsonElement.isJsonPrimitive() || !(\u00e2\u02dc\u0192 = jsonElement.getAsJsonPrimitive()).isNumber()) continue;
            compoundTag.m_128405_((String)entry.getKey(), \u00e2\u02dc\u0192.getAsInt());
        }
        return compoundTag;
    }

    protected String m_12845_() {
        HashMap hashMap = Maps.newHashMap();
        for (Object object2 : this.f_13013_.object2IntEntrySet()) {
            Stat stat = (Stat)object2.getKey();
            hashMap.computeIfAbsent(stat.m_12859_(), p_12822_ -> new JsonObject()).addProperty(ServerStatsCounter.m_12846_(stat).toString(), (Number)object2.getIntValue());
        }
        JsonObject jsonObject = new JsonObject();
        for (Map.Entry entry : hashMap.entrySet()) {
            jsonObject.add(Registry.f_122867_.m_7981_((StatType)entry.getKey()).toString(), (JsonElement)entry.getValue());
        }
        JsonObject jsonObject2 = new JsonObject();
        jsonObject2.add("stats", (JsonElement)jsonObject);
        jsonObject2.addProperty("DataVersion", (Number)SharedConstants.m_136187_().getWorldVersion());
        return jsonObject2.toString();
    }

    private static <T> ResourceLocation m_12846_(Stat<T> p_12847_) {
        return p_12847_.m_12859_().m_12893_().m_7981_(p_12847_.m_12867_());
    }

    public void m_12850_() {
        this.f_12812_.addAll((Collection<Stat<?>>)this.f_13013_.keySet());
    }

    public void m_12819_(ServerPlayer p_12820_) {
        Object2IntOpenHashMap object2IntOpenHashMap = new Object2IntOpenHashMap();
        for (Stat<?> stat : this.m_12851_()) {
            object2IntOpenHashMap.put(stat, this.m_13015_(stat));
        }
        p_12820_.f_8906_.m_141995_(new ClientboundAwardStatsPacket((Object2IntMap<Stat<?>>)object2IntOpenHashMap));
    }
}

