/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.Tag;
import net.minecraft.tags.TagCollection;
import net.minecraft.util.GsonHelper;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagLoader<T> {
    private static final Logger f_13445_ = LogManager.getLogger();
    private static final Gson f_13446_ = new Gson();
    private static final String f_144491_ = ".json";
    private static final int f_13447_ = ".json".length();
    private final Function<ResourceLocation, Optional<T>> f_13448_;
    private final String f_13449_;

    public TagLoader(Function<ResourceLocation, Optional<T>> p_144493_, String p_144494_) {
        this.f_13448_ = p_144493_;
        this.f_13449_ = p_144494_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ResourceLocation, Tag.Builder> m_144495_(ResourceManager p_144496_) {
        HashMap hashMap = Maps.newHashMap();
        for (ResourceLocation resourceLocation : p_144496_.m_6540_(this.f_13449_, p_144506_ -> p_144506_.endsWith(f_144491_))) {
            String string = resourceLocation.m_135815_();
            ResourceLocation \u00e2\u02dc\u01922 = new ResourceLocation(resourceLocation.m_135827_(), string.substring(this.f_13449_.length() + 1, string.length() - f_13447_));
            try {
                for (Resource resource : p_144496_.m_7396_(resourceLocation)) {
                    try {
                        InputStream inputStream = resource.m_6679_();
                        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                            JsonObject jsonObject = GsonHelper.m_13776_(f_13446_, bufferedReader, JsonObject.class);
                            if (jsonObject == null) {
                                f_13445_.error("Couldn't load tag list {} from {} in data pack {} as it is empty or null", (Object)\u00e2\u02dc\u01922, (Object)resourceLocation, (Object)resource.m_7816_());
                                continue;
                            }
                            hashMap.computeIfAbsent(\u00e2\u02dc\u01922, p_144555_ -> Tag.Builder.m_13304_()).m_13312_(jsonObject, resource.m_7816_());
                        }
                        finally {
                            if (inputStream == null) continue;
                            inputStream.close();
                        }
                    }
                    catch (IOException | RuntimeException exception) {
                        f_13445_.error("Couldn't read tag list {} from {} in data pack {}", (Object)\u00e2\u02dc\u01922, (Object)resourceLocation, (Object)resource.m_7816_(), (Object)exception);
                    }
                    finally {
                        IOUtils.closeQuietly((Closeable)resource);
                    }
                }
            }
            catch (IOException iOException) {
                f_13445_.error("Couldn't read tag list {} from {}", (Object)\u00e2\u02dc\u01922, (Object)resourceLocation, (Object)iOException);
            }
        }
        return hashMap;
    }

    private static void m_144523_(Map<ResourceLocation, Tag.Builder> p_144524_, Multimap<ResourceLocation, ResourceLocation> p_144525_, Set<ResourceLocation> p_144526_, ResourceLocation p_144527_, BiConsumer<ResourceLocation, Tag.Builder> p_144528_) {
        if (!p_144526_.add(p_144527_)) {
            return;
        }
        p_144525_.get((Object)p_144527_).forEach(p_144514_ -> TagLoader.m_144523_(p_144524_, p_144525_, p_144526_, p_144514_, p_144528_));
        Tag.Builder builder = p_144524_.get(p_144527_);
        if (builder != null) {
            p_144528_.accept(p_144527_, builder);
        }
    }

    private static boolean m_144501_(Multimap<ResourceLocation, ResourceLocation> p_144502_, ResourceLocation p_144503_, ResourceLocation p_144504_) {
        Collection collection = p_144502_.get((Object)p_144504_);
        if (collection.contains(p_144503_)) {
            return true;
        }
        return collection.stream().anyMatch(p_144567_ -> TagLoader.m_144501_(p_144502_, p_144503_, p_144567_));
    }

    private static void m_144550_(Multimap<ResourceLocation, ResourceLocation> p_144551_, ResourceLocation p_144552_, ResourceLocation p_144553_) {
        if (!TagLoader.m_144501_(p_144551_, p_144552_, p_144553_)) {
            p_144551_.put((Object)p_144552_, (Object)p_144553_);
        }
    }

    public TagCollection<T> m_144507_(Map<ResourceLocation, Tag.Builder> p_144508_) {
        HashMap hashMap = Maps.newHashMap();
        Function<ResourceLocation, Tag> \u00e2\u02dc\u01922 = hashMap::get;
        Function<ResourceLocation, Object> \u00e2\u02dc\u01923 = p_144540_ -> this.f_13448_.apply((ResourceLocation)p_144540_).orElse(null);
        HashMultimap \u00e2\u02dc\u01924 = HashMultimap.create();
        p_144508_.forEach((arg_0, arg_1) -> TagLoader.m_144546_((Multimap)\u00e2\u02dc\u01924, arg_0, arg_1));
        p_144508_.forEach((arg_0, arg_1) -> TagLoader.m_144497_((Multimap)\u00e2\u02dc\u01924, arg_0, arg_1));
        HashSet \u00e2\u02dc\u01925 = Sets.newHashSet();
        p_144508_.keySet().forEach(arg_0 -> TagLoader.m_144515_(p_144508_, (Multimap)\u00e2\u02dc\u01924, \u00e2\u02dc\u01925, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, hashMap, arg_0));
        return TagCollection.m_13396_(hashMap);
    }

    public TagCollection<T> m_144544_(ResourceManager p_144545_) {
        return this.m_144507_(this.m_144495_(p_144545_));
    }

    private static /* synthetic */ void m_144515_(Map p_144516_, Multimap p_144517_, Set p_144518_, Function p_144519_, Function p_144520_, Map p_144521_, ResourceLocation p_144522_) {
        TagLoader.m_144523_(p_144516_, (Multimap<ResourceLocation, ResourceLocation>)p_144517_, p_144518_, p_144522_, (p_144537_, p_144538_) -> p_144538_.m_144371_(p_144519_, p_144520_).ifLeft(p_144543_ -> f_13445_.error("Couldn't load tag {} as it is missing following references: {}", p_144537_, (Object)p_144543_.stream().map(Objects::toString).collect(Collectors.joining(",")))).ifRight(p_144532_ -> p_144521_.put(p_144537_, p_144532_)));
    }

    private static /* synthetic */ void m_144497_(Multimap p_144498_, ResourceLocation p_144499_, Tag.Builder p_144500_) {
        p_144500_.m_144374_(p_144559_ -> TagLoader.m_144550_((Multimap<ResourceLocation, ResourceLocation>)p_144498_, p_144499_, p_144559_));
    }

    private static /* synthetic */ void m_144546_(Multimap p_144547_, ResourceLocation p_144548_, Tag.Builder p_144549_) {
        p_144549_.m_144366_(p_144563_ -> TagLoader.m_144550_((Multimap<ResourceLocation, ResourceLocation>)p_144547_, p_144548_, p_144563_));
    }
}

