/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.tags;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.tags.SerializationTags;
import net.minecraft.tags.StaticTagHelper;
import net.minecraft.tags.StaticTags;
import net.minecraft.tags.TagCollection;
import net.minecraft.tags.TagContainer;
import net.minecraft.tags.TagLoader;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TagManager
implements PreparableReloadListener {
    private static final Logger f_144568_ = LogManager.getLogger();
    private final RegistryAccess f_144569_;
    private TagContainer f_13478_ = TagContainer.f_13420_;

    public TagManager(RegistryAccess p_144572_) {
        this.f_144569_ = p_144572_;
    }

    public TagContainer m_13480_() {
        return this.f_13478_;
    }

    @Override
    public CompletableFuture<Void> m_5540_(PreparableReloadListener.PreparationBarrier p_13482_, ResourceManager p_13483_, ProfilerFiller p_13484_, ProfilerFiller p_13485_, Executor p_13486_, Executor p_13487_) {
        ArrayList arrayList = Lists.newArrayList();
        StaticTags.m_144349_(p_144583_ -> {
            LoaderInfo loaderInfo = this.m_144575_(p_13483_, p_13486_, (StaticTagHelper)p_144583_);
            if (loaderInfo != null) {
                arrayList.add(loaderInfo);
            }
        });
        return ((CompletableFuture)CompletableFuture.allOf((CompletableFuture[])arrayList.stream().map(p_144591_ -> p_144591_.f_144598_).toArray(CompletableFuture[]::new)).thenCompose(p_13482_::m_6769_)).thenAcceptAsync(p_144594_ -> {
            TagContainer.Builder builder = new TagContainer.Builder();
            arrayList.forEach(p_144586_ -> p_144586_.m_144602_(builder));
            TagContainer \u00e2\u02dc\u01922 = builder.m_144485_();
            Multimap<ResourceKey<? extends Registry<?>>, ResourceLocation> \u00e2\u02dc\u01923 = StaticTags.m_13283_(\u00e2\u02dc\u01922);
            if (!\u00e2\u02dc\u01923.isEmpty()) {
                throw new IllegalStateException("Missing required tags: " + \u00e2\u02dc\u01923.entries().stream().map(p_144596_ -> p_144596_.getKey() + ":" + p_144596_.getValue()).sorted().collect(Collectors.joining(",")));
            }
            SerializationTags.m_13202_(\u00e2\u02dc\u01922);
            this.f_13478_ = \u00e2\u02dc\u01922;
        }, p_13487_);
    }

    @Nullable
    private <T> LoaderInfo<T> m_144575_(ResourceManager p_144576_, Executor p_144577_, StaticTagHelper<T> p_144578_) {
        Optional<Registry<T>> optional = this.f_144569_.m_6632_(p_144578_.m_144338_());
        if (optional.isPresent()) {
            Registry<T> registry = optional.get();
            TagLoader \u00e2\u02dc\u01922 = new TagLoader(registry::m_6612_, p_144578_.m_144339_());
            CompletableFuture<TagCollection> \u00e2\u02dc\u01923 = CompletableFuture.supplyAsync(() -> \u00e2\u02dc\u01922.m_144544_(p_144576_), p_144577_);
            return new LoaderInfo<T>(p_144578_, \u00e2\u02dc\u01923);
        }
        f_144568_.warn("Can't find registry for {}", p_144578_.m_144338_());
        return null;
    }

    static class LoaderInfo<T> {
        private final StaticTagHelper<T> f_144597_;
        final CompletableFuture<? extends TagCollection<T>> f_144598_;

        LoaderInfo(StaticTagHelper<T> p_144600_, CompletableFuture<? extends TagCollection<T>> p_144601_) {
            this.f_144597_ = p_144600_;
            this.f_144598_ = p_144601_;
        }

        public void m_144602_(TagContainer.Builder p_144603_) {
            p_144603_.m_144486_(this.f_144597_.m_144338_(), this.f_144598_.join());
        }
    }
}

