/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.AccessDeniedException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;

public class DirectoryLock
implements AutoCloseable {
    public static final String f_144627_ = "session.lock";
    private final FileChannel f_13632_;
    private final FileLock f_13633_;
    private static final ByteBuffer f_13634_;

    public static DirectoryLock m_13640_(Path p_13641_) throws IOException {
        Path path = p_13641_.resolve(f_144627_);
        if (!Files.isDirectory(p_13641_, new LinkOption[0])) {
            Files.createDirectories(p_13641_, new FileAttribute[0]);
        }
        FileChannel \u00e2\u02dc\u01922 = FileChannel.open(path, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        try {
            \u00e2\u02dc\u01922.write(f_13634_.duplicate());
            \u00e2\u02dc\u01922.force(true);
            FileLock fileLock = \u00e2\u02dc\u01922.tryLock();
            if (fileLock == null) {
                throw LockException.m_13648_(path);
            }
            return new DirectoryLock(\u00e2\u02dc\u01922, fileLock);
        }
        catch (IOException iOException) {
            try {
                \u00e2\u02dc\u01922.close();
            }
            catch (IOException iOException2) {
                iOException.addSuppressed(iOException2);
            }
            throw iOException;
        }
    }

    private DirectoryLock(FileChannel p_13637_, FileLock p_13638_) {
        this.f_13632_ = p_13637_;
        this.f_13633_ = p_13638_;
    }

    @Override
    public void close() throws IOException {
        try {
            if (this.f_13633_.isValid()) {
                this.f_13633_.release();
            }
        }
        finally {
            if (this.f_13632_.isOpen()) {
                this.f_13632_.close();
            }
        }
    }

    public boolean m_13639_() {
        return this.f_13633_.isValid();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean m_13642_(Path p_13643_) throws IOException {
        Path path = p_13643_.resolve(f_144627_);
        try (FileChannel fileChannel = FileChannel.open(path, StandardOpenOption.WRITE);){
            boolean bl;
            block15: {
                FileLock fileLock = fileChannel.tryLock();
                try {
                    boolean bl2 = bl = fileLock == null;
                    if (fileLock == null) break block15;
                }
                catch (Throwable throwable) {
                    if (fileLock != null) {
                        try {
                            fileLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                fileLock.close();
            }
            return bl;
        }
        catch (AccessDeniedException accessDeniedException) {
            return true;
        }
        catch (NoSuchFileException noSuchFileException) {
            return false;
        }
    }

    static {
        byte[] byArray = "\u2603".getBytes(Charsets.UTF_8);
        f_13634_ = ByteBuffer.allocateDirect(byArray.length);
        f_13634_.put(byArray);
        f_13634_.flip();
    }

    public static class LockException
    extends IOException {
        private LockException(Path p_13646_, String p_13647_) {
            super(p_13646_.toAbsolutePath() + ": " + p_13647_);
        }

        public static LockException m_13648_(Path p_13649_) {
            return new LockException(p_13649_, "already locked (possibly by other Minecraft instance?)");
        }
    }
}

