/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;

public class ExtraCodecs {
    public static final Codec<Integer> f_144628_ = ExtraCodecs.m_144633_(0, Integer.MAX_VALUE, p_144656_ -> "Value must be non-negative: " + p_144656_);
    public static final Codec<Integer> f_144629_ = ExtraCodecs.m_144633_(1, Integer.MAX_VALUE, p_144643_ -> "Value must be positive: " + p_144643_);

    public static <F, S> Codec<Either<F, S>> m_144639_(Codec<F> p_144640_, Codec<S> p_144641_) {
        return new XorCodec<F, S>(p_144640_, p_144641_);
    }

    private static <N extends Number> Function<N, DataResult<N>> m_144644_(N p_144645_, N p_144646_, Function<N, String> p_144647_) {
        return p_144652_ -> {
            if (((Comparable)((Object)p_144652_)).compareTo(p_144645_) >= 0 && ((Comparable)((Object)p_144652_)).compareTo(p_144646_) <= 0) {
                return DataResult.success((Object)p_144652_);
            }
            return DataResult.error((String)((String)p_144647_.apply(p_144652_)));
        };
    }

    private static Codec<Integer> m_144633_(int p_144634_, int p_144635_, Function<Integer, String> p_144636_) {
        Function<Integer, DataResult<Integer>> function = ExtraCodecs.m_144644_(p_144634_, p_144635_, p_144636_);
        return Codec.INT.flatXmap(function, function);
    }

    public static <T> Function<List<T>, DataResult<List<T>>> m_144632_() {
        return p_144654_ -> {
            if (p_144654_.isEmpty()) {
                return DataResult.error((String)"List must have contents");
            }
            return DataResult.success((Object)p_144654_);
        };
    }

    public static <T> Codec<List<T>> m_144637_(Codec<List<T>> p_144638_) {
        return p_144638_.flatXmap(ExtraCodecs.m_144632_(), ExtraCodecs.m_144632_());
    }

    public static <T> Function<List<Supplier<T>>, DataResult<List<Supplier<T>>>> m_181036_() {
        return p_181033_ -> {
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < p_181033_.size(); ++i) {
                Supplier supplier = (Supplier)p_181033_.get(i);
                try {
                    if (supplier.get() != null) continue;
                    arrayList.add("Missing value [" + i + "] : " + supplier);
                    continue;
                }
                catch (Exception \u00e2\u02dc\u01922) {
                    arrayList.add("Invalid value [" + i + "]: " + supplier + ", message: " + \u00e2\u02dc\u01922.getMessage());
                }
            }
            if (!arrayList.isEmpty()) {
                return DataResult.error((String)String.join((CharSequence)"; ", arrayList));
            }
            return DataResult.success((Object)p_181033_, (Lifecycle)Lifecycle.stable());
        };
    }

    public static <T> Function<Supplier<T>, DataResult<Supplier<T>>> m_181037_() {
        return p_181035_ -> {
            try {
                if (p_181035_.get() == null) {
                    return DataResult.error((String)("Missing value: " + p_181035_));
                }
            }
            catch (Exception exception) {
                return DataResult.error((String)("Invalid value: " + p_181035_ + ", message: " + exception.getMessage()));
            }
            return DataResult.success((Object)p_181035_, (Lifecycle)Lifecycle.stable());
        };
    }

    static final class XorCodec<F, S>
    implements Codec<Either<F, S>> {
        private final Codec<F> f_144657_;
        private final Codec<S> f_144658_;

        public XorCodec(Codec<F> p_144660_, Codec<S> p_144661_) {
            this.f_144657_ = p_144660_;
            this.f_144658_ = p_144661_;
        }

        public <T> DataResult<Pair<Either<F, S>, T>> decode(DynamicOps<T> p_144679_, T p_144680_) {
            DataResult dataResult = this.f_144657_.decode(p_144679_, p_144680_).map(p_144673_ -> p_144673_.mapFirst(Either::left));
            \u00e2\u02dc\u0192 = this.f_144658_.decode(p_144679_, p_144680_).map(p_144667_ -> p_144667_.mapFirst(Either::right));
            Optional \u00e2\u02dc\u01922 = dataResult.result();
            Optional \u00e2\u02dc\u01923 = \u00e2\u02dc\u0192.result();
            if (\u00e2\u02dc\u01922.isPresent() && \u00e2\u02dc\u01923.isPresent()) {
                return DataResult.error((String)("Both alternatives read successfully, can not pick the correct one; first: " + \u00e2\u02dc\u01922.get() + " second: " + \u00e2\u02dc\u01923.get()), (Object)((Pair)\u00e2\u02dc\u01922.get()));
            }
            return \u00e2\u02dc\u01922.isPresent() ? dataResult : \u00e2\u02dc\u0192;
        }

        public <T> DataResult<T> encode(Either<F, S> p_144663_, DynamicOps<T> p_144664_, T p_144665_) {
            return (DataResult)p_144663_.map(p_144677_ -> this.f_144657_.encode(p_144677_, p_144664_, p_144665_), p_144671_ -> this.f_144658_.encode(p_144671_, p_144664_, p_144665_));
        }

        public boolean equals(Object p_144686_) {
            if (this == p_144686_) {
                return true;
            }
            if (p_144686_ == null || this.getClass() != p_144686_.getClass()) {
                return false;
            }
            XorCodec xorCodec = (XorCodec)p_144686_;
            return Objects.equals(this.f_144657_, xorCodec.f_144657_) && Objects.equals(this.f_144658_, xorCodec.f_144658_);
        }

        public int hashCode() {
            return Objects.hash(this.f_144657_, this.f_144658_);
        }

        public String toString() {
            return "XorCodec[" + this.f_144657_ + ", " + this.f_144658_ + "]";
        }

        public /* synthetic */ DataResult encode(Object object, DynamicOps dynamicOps, Object object2) {
            return this.encode((Either)object, dynamicOps, object2);
        }
    }
}

