/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util;

import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WeighedRandom {
    static final Logger f_145028_ = LogManager.getLogger();

    public static int m_14470_(List<? extends WeighedRandomItem> p_14471_) {
        long l = 0L;
        for (WeighedRandomItem weighedRandomItem : p_14471_) {
            l += (long)weighedRandomItem.f_14482_;
        }
        if (l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Sum of weights must be <= 2147483647");
        }
        return (int)l;
    }

    public static <T extends WeighedRandomItem> Optional<T> m_145037_(Random p_145038_, List<T> p_145039_, int p_145040_) {
        if (p_145040_ < 0) {
            throw Util.m_137570_(new IllegalArgumentException("Negative total weight in getRandomItem"));
        }
        if (p_145040_ == 0) {
            return Optional.empty();
        }
        int n = p_145038_.nextInt(p_145040_);
        return WeighedRandom.m_145031_(p_145039_, n);
    }

    public static <T extends WeighedRandomItem> Optional<T> m_145031_(List<T> p_145032_, int p_145033_) {
        for (WeighedRandomItem weighedRandomItem : p_145032_) {
            if ((p_145033_ -= weighedRandomItem.f_14482_) >= 0) continue;
            return Optional.of(weighedRandomItem);
        }
        return Optional.empty();
    }

    public static <T extends WeighedRandomItem> Optional<T> m_145034_(Random p_145035_, List<T> p_145036_) {
        return WeighedRandom.m_145037_(p_145035_, p_145036_, WeighedRandom.m_14470_(p_145036_));
    }

    public static class WeighedRandomItem {
        protected final int f_14482_;

        public WeighedRandomItem(int p_14484_) {
            if (p_14484_ < 0) {
                throw Util.m_137570_(new IllegalArgumentException("Weight should be >= 0"));
            }
            if (p_14484_ == 0 && SharedConstants.f_136183_) {
                f_145028_.warn("Found 0 weight, make sure this is intentional!");
            }
            this.f_14482_ = p_14484_;
        }
    }
}

