/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class BedBlockEntityInjecter
extends DataFix {
    public BedBlockEntityInjecter(Schema p_14701_, boolean p_14702_) {
        super(p_14701_, p_14702_);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(References.f_16773_);
        \u00e2\u02dc\u0192 = type.findFieldType("Level");
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.findFieldType("TileEntities");
        if (!(\u00e2\u02dc\u0192 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType \u00e2\u02dc\u01922 = (List.ListType)\u00e2\u02dc\u0192;
        return this.m_14709_(\u00e2\u02dc\u0192, \u00e2\u02dc\u01922);
    }

    private <TE> TypeRewriteRule m_14709_(Type<?> p_14710_, List.ListType<TE> p_14711_) {
        Type type = p_14711_.getElement();
        OpticFinder \u00e2\u02dc\u01922 = DSL.fieldFinder((String)"Level", p_14710_);
        OpticFinder \u00e2\u02dc\u01923 = DSL.fieldFinder((String)"TileEntities", p_14711_);
        int \u00e2\u02dc\u01924 = 416;
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("InjectBedBlockEntityType", (Type)this.getInputSchema().findChoiceType(References.f_16781_), (Type)this.getOutputSchema().findChoiceType(References.f_16781_), p_14717_ -> p_145085_ -> p_145085_), (TypeRewriteRule)this.fixTypeEverywhereTyped("BedBlockEntityInjecter", this.getOutputSchema().getType(References.f_16773_), p_14708_ -> {
            Typed typed = p_14708_.getTyped(\u00e2\u02dc\u01922);
            Dynamic \u00e2\u02dc\u01922 = (Dynamic)typed.get(DSL.remainderFinder());
            int \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.get("xPos").asInt(0);
            int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.get("zPos").asInt(0);
            ArrayList \u00e2\u02dc\u01925 = Lists.newArrayList((Iterable)((Iterable)typed.getOrCreate(\u00e2\u02dc\u01923)));
            List \u00e2\u02dc\u01926 = \u00e2\u02dc\u01922.get("Sections").asList(Function.identity());
            for (int i = 0; i < \u00e2\u02dc\u01926.size(); ++i) {
                Dynamic dynamic = (Dynamic)\u00e2\u02dc\u01926.get(i);
                int \u00e2\u02dc\u01927 = dynamic.get("Y").asInt(0);
                Stream<Integer> \u00e2\u02dc\u01928 = dynamic.get("Blocks").asStream().map(p_145087_ -> p_145087_.asInt(0));
                int \u00e2\u02dc\u01929 = 0;
                Iterator iterator = ((Iterable)\u00e2\u02dc\u01928::iterator).iterator();
                while (iterator.hasNext()) {
                    int n = (Integer)iterator.next();
                    if (416 == (n & 0xFF) << 4) {
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929 & 0xF;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929 >> 8 & 0xF;
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01929 >> 4 & 0xF;
                        HashMap hashMap = Maps.newHashMap();
                        hashMap.put(dynamic.createString("id"), dynamic.createString("minecraft:bed"));
                        hashMap.put(dynamic.createString("x"), dynamic.createInt(\u00e2\u02dc\u0192 + (\u00e2\u02dc\u01923 << 4)));
                        hashMap.put(dynamic.createString("y"), dynamic.createInt(\u00e2\u02dc\u0192 + (\u00e2\u02dc\u01927 << 4)));
                        hashMap.put(dynamic.createString("z"), dynamic.createInt(\u00e2\u02dc\u0192 + (\u00e2\u02dc\u01924 << 4)));
                        hashMap.put(dynamic.createString("color"), dynamic.createShort((short)14));
                        \u00e2\u02dc\u01925.add(((Pair)type.read(dynamic.createMap((Map)hashMap)).result().orElseThrow(() -> new IllegalStateException("Could not parse newly created bed block entity."))).getFirst());
                    }
                    ++\u00e2\u02dc\u01929;
                }
            }
            if (!\u00e2\u02dc\u01925.isEmpty()) {
                return p_14708_.set(\u00e2\u02dc\u01922, typed.set(\u00e2\u02dc\u01923, (Object)\u00e2\u02dc\u01925));
            }
            return p_14708_;
        }));
    }
}

