/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import java.util.List;
import java.util.stream.LongStream;
import net.minecraft.util.Mth;
import net.minecraft.util.datafix.fixes.References;

public class BitStorageAlignFix
extends DataFix {
    private static final int f_145092_ = 6;
    private static final int f_145093_ = 16;
    private static final int f_145094_ = 16;
    private static final int f_145095_ = 4096;
    private static final int f_145096_ = 9;
    private static final int f_145097_ = 256;

    public BitStorageAlignFix(Schema p_14736_) {
        super(p_14736_, false);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.f_16773_);
        \u00e2\u02dc\u0192 = type.findFieldType("Level");
        OpticFinder \u00e2\u02dc\u01922 = DSL.fieldFinder((String)"Level", (Type)\u00e2\u02dc\u0192);
        OpticFinder \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.type().findField("Sections");
        \u00e2\u02dc\u0192 = ((List.ListType)\u00e2\u02dc\u01923.type()).getElement();
        OpticFinder \u00e2\u02dc\u01924 = DSL.typeFinder((Type)\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = DSL.named((String)References.f_16783_.typeName(), (Type)DSL.remainderType());
        OpticFinder \u00e2\u02dc\u01925 = DSL.fieldFinder((String)"Palette", (Type)DSL.list((Type)\u00e2\u02dc\u0192));
        return this.fixTypeEverywhereTyped("BitStorageAlignFix", type, this.getOutputSchema().getType(References.f_16773_), p_14749_ -> p_14749_.updateTyped(\u00e2\u02dc\u01922, p_145120_ -> this.m_14762_(BitStorageAlignFix.m_14750_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, p_145120_))));
    }

    private Typed<?> m_14762_(Typed<?> p_14763_) {
        return p_14763_.update(DSL.remainderFinder(), p_14765_ -> p_14765_.update("Heightmaps", p_145113_ -> p_145113_.updateMapValues(p_145110_ -> p_145110_.mapSecond(p_145123_ -> BitStorageAlignFix.m_14776_(p_14765_, p_145123_, 256, 9)))));
    }

    private static Typed<?> m_14750_(OpticFinder<?> p_14751_, OpticFinder<?> p_14752_, OpticFinder<List<Pair<String, Dynamic<?>>>> p_14753_, Typed<?> p_14754_) {
        return p_14754_.updateTyped(p_14751_, p_14758_ -> p_14758_.updateTyped(p_14752_, p_145103_ -> {
            int n = p_145103_.getOptional(p_14753_).map(p_145115_ -> Math.max(4, DataFixUtils.ceillog2((int)p_145115_.size()))).orElse(0);
            if (n == 0 || Mth.m_14152_(n)) {
                return p_145103_;
            }
            return p_145103_.update(DSL.remainderFinder(), p_145100_ -> p_145100_.update("BlockStates", p_145107_ -> BitStorageAlignFix.m_14776_(p_145100_, p_145107_, 4096, n)));
        }));
    }

    private static Dynamic<?> m_14776_(Dynamic<?> p_14777_, Dynamic<?> p_14778_, int p_14779_, int p_14780_) {
        long[] lArray = p_14778_.asLongStream().toArray();
        \u00e2\u02dc\u0192 = BitStorageAlignFix.m_14737_(p_14779_, p_14780_, lArray);
        return p_14777_.createLongList(LongStream.of(\u00e2\u02dc\u0192));
    }

    public static long[] m_14737_(int p_14738_, int p_14739_, long[] p_14740_) {
        int n = p_14740_.length;
        if (n == 0) {
            return p_14740_;
        }
        long \u00e2\u02dc\u01922 = (1L << p_14739_) - 1L;
        \u00e2\u02dc\u0192 = 64 / p_14739_;
        \u00e2\u02dc\u0192 = (p_14738_ + \u00e2\u02dc\u0192 - 1) / \u00e2\u02dc\u0192;
        long[] \u00e2\u02dc\u01923 = new long[\u00e2\u02dc\u0192];
        \u00e2\u02dc\u0192 = 0;
        \u00e2\u02dc\u0192 = 0;
        long \u00e2\u02dc\u01924 = 0L;
        \u00e2\u02dc\u0192 = 0;
        long \u00e2\u02dc\u01925 = p_14740_[0];
        long \u00e2\u02dc\u01926 = n > 1 ? p_14740_[1] : 0L;
        for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < p_14738_; ++\u00e2\u02dc\u0192) {
            long \u00e2\u02dc\u01927;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * p_14739_;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 >> 6;
            \u00e2\u02dc\u0192 = (\u00e2\u02dc\u0192 + 1) * p_14739_ - 1 >> 6;
            n2 = \u00e2\u02dc\u0192 ^ \u00e2\u02dc\u0192 << 6;
            if (\u00e2\u02dc\u0192 != \u00e2\u02dc\u0192) {
                \u00e2\u02dc\u01925 = \u00e2\u02dc\u01926;
                \u00e2\u02dc\u01926 = \u00e2\u02dc\u0192 + 1 < n ? p_14740_[\u00e2\u02dc\u0192 + 1] : 0L;
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
            }
            if (\u00e2\u02dc\u0192 == \u00e2\u02dc\u0192) {
                \u00e2\u02dc\u01927 = \u00e2\u02dc\u01925 >>> n2 & \u00e2\u02dc\u01922;
            } else {
                int n2;
                \u00e2\u02dc\u0192 = 64 - n2;
                \u00e2\u02dc\u01927 = (\u00e2\u02dc\u01925 >>> n2 | \u00e2\u02dc\u01926 << \u00e2\u02dc\u0192) & \u00e2\u02dc\u01922;
            }
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 + p_14739_;
            if (\u00e2\u02dc\u0192 >= 64) {
                \u00e2\u02dc\u01923[\u00e2\u02dc\u0192++] = \u00e2\u02dc\u01924;
                \u00e2\u02dc\u01924 = \u00e2\u02dc\u01927;
                \u00e2\u02dc\u0192 = p_14739_;
                continue;
            }
            \u00e2\u02dc\u01924 |= \u00e2\u02dc\u01927 << \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
        }
        if (\u00e2\u02dc\u01924 != 0L) {
            \u00e2\u02dc\u01923[\u00e2\u02dc\u0192] = \u00e2\u02dc\u01924;
        }
        return \u00e2\u02dc\u01923;
    }
}

