/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.util.datafix.fixes.References;

public class EntityRidingToPassengersFix
extends DataFix {
    public EntityRidingToPassengersFix(Schema p_15638_, boolean p_15639_) {
        super(p_15638_, p_15639_);
    }

    public TypeRewriteRule makeRule() {
        Schema schema = this.getInputSchema();
        \u00e2\u02dc\u0192 = this.getOutputSchema();
        Type \u00e2\u02dc\u01922 = schema.getTypeRaw(References.f_16785_);
        Type \u00e2\u02dc\u01923 = \u00e2\u02dc\u0192.getTypeRaw(References.f_16785_);
        Type \u00e2\u02dc\u01924 = schema.getTypeRaw(References.f_16786_);
        return this.m_15641_(schema, \u00e2\u02dc\u0192, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
    }

    private <OldEntityTree, NewEntityTree, Entity> TypeRewriteRule m_15641_(Schema p_15642_, Schema p_15643_, Type<OldEntityTree> p_15644_, Type<NewEntityTree> p_15645_, Type<Entity> p_15646_) {
        Type type = DSL.named((String)References.f_16785_.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Riding", p_15644_)), p_15646_));
        \u00e2\u02dc\u0192 = DSL.named((String)References.f_16785_.typeName(), (Type)DSL.and((Type)DSL.optional((Type)DSL.field((String)"Passengers", (Type)DSL.list(p_15645_))), p_15646_));
        \u00e2\u02dc\u0192 = p_15642_.getType(References.f_16785_);
        \u00e2\u02dc\u0192 = p_15643_.getType(References.f_16785_);
        if (!Objects.equals(\u00e2\u02dc\u0192, type)) {
            throw new IllegalStateException("Old entity type is not what was expected.");
        }
        if (!\u00e2\u02dc\u0192.equals((Object)\u00e2\u02dc\u0192, true, true)) {
            throw new IllegalStateException("New entity type is not what was expected.");
        }
        OpticFinder \u00e2\u02dc\u01922 = DSL.typeFinder((Type)type);
        OpticFinder \u00e2\u02dc\u01923 = DSL.typeFinder((Type)\u00e2\u02dc\u0192);
        OpticFinder \u00e2\u02dc\u01924 = DSL.typeFinder(p_15645_);
        \u00e2\u02dc\u0192 = p_15642_.getType(References.f_16772_);
        \u00e2\u02dc\u0192 = p_15643_.getType(References.f_16772_);
        return TypeRewriteRule.seq((TypeRewriteRule)this.fixTypeEverywhere("EntityRidingToPassengerFix", type, \u00e2\u02dc\u0192, p_15653_ -> p_145320_ -> {
            Optional<Object> \u00e2\u02dc\u01923 = Optional.empty();
            Pair \u00e2\u02dc\u01922 = p_145320_;
            while (true) {
                Either either = (Either)DataFixUtils.orElse(\u00e2\u02dc\u01923.map(p_145326_ -> {
                    Typed typed = (Typed)p_15645_.pointTyped(p_15653_).orElseThrow(() -> new IllegalStateException("Could not create new entity tree"));
                    Object \u00e2\u02dc\u01922 = typed.set(\u00e2\u02dc\u01923, p_145326_).getOptional(\u00e2\u02dc\u01924).orElseThrow(() -> new IllegalStateException("Should always have an entity tree here"));
                    return Either.left((Object)ImmutableList.of(\u00e2\u02dc\u01922));
                }), (Object)Either.right((Object)DSL.unit()));
                \u00e2\u02dc\u01923 = Optional.of(Pair.of((Object)References.f_16785_.typeName(), (Object)Pair.of((Object)either, (Object)((Pair)\u00e2\u02dc\u01922.getSecond()).getSecond())));
                Optional optional = ((Either)((Pair)\u00e2\u02dc\u01922.getSecond()).getFirst()).left();
                if (!optional.isPresent()) break;
                \u00e2\u02dc\u01922 = (Pair)new Typed(p_15644_, p_15653_, optional.get()).getOptional(\u00e2\u02dc\u01922).orElseThrow(() -> new IllegalStateException("Should always have an entity here"));
            }
            return (Pair)\u00e2\u02dc\u01923.orElseThrow(() -> new IllegalStateException("Should always have an entity tree here"));
        }), (TypeRewriteRule)this.writeAndRead("player RootVehicle injecter", \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
    }
}

