/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.PackedBitStorage;
import net.minecraft.util.datafix.fixes.References;

public class LeavesFix
extends DataFix {
    private static final int f_145445_ = 128;
    private static final int f_145446_ = 64;
    private static final int f_145447_ = 32;
    private static final int f_145448_ = 16;
    private static final int f_145449_ = 8;
    private static final int f_145450_ = 4;
    private static final int f_145451_ = 2;
    private static final int f_145452_ = 1;
    private static final int[][] f_16200_ = new int[][]{{-1, 0, 0}, {1, 0, 0}, {0, -1, 0}, {0, 1, 0}, {0, 0, -1}, {0, 0, 1}};
    private static final int f_145453_ = 7;
    private static final int f_145454_ = 12;
    private static final int f_145455_ = 4096;
    static final Object2IntMap<String> f_16201_ = (Object2IntMap)DataFixUtils.make((Object)new Object2IntOpenHashMap(), p_16235_ -> {
        p_16235_.put((Object)"minecraft:acacia_leaves", 0);
        p_16235_.put((Object)"minecraft:birch_leaves", 1);
        p_16235_.put((Object)"minecraft:dark_oak_leaves", 2);
        p_16235_.put((Object)"minecraft:jungle_leaves", 3);
        p_16235_.put((Object)"minecraft:oak_leaves", 4);
        p_16235_.put((Object)"minecraft:spruce_leaves", 5);
    });
    static final Set<String> f_16202_ = ImmutableSet.of((Object)"minecraft:acacia_bark", (Object)"minecraft:birch_bark", (Object)"minecraft:dark_oak_bark", (Object)"minecraft:jungle_bark", (Object)"minecraft:oak_bark", (Object)"minecraft:spruce_bark", (Object[])new String[]{"minecraft:acacia_log", "minecraft:birch_log", "minecraft:dark_oak_log", "minecraft:jungle_log", "minecraft:oak_log", "minecraft:spruce_log", "minecraft:stripped_acacia_log", "minecraft:stripped_birch_log", "minecraft:stripped_dark_oak_log", "minecraft:stripped_jungle_log", "minecraft:stripped_oak_log", "minecraft:stripped_spruce_log"});

    public LeavesFix(Schema p_16205_, boolean p_16206_) {
        super(p_16205_, p_16206_);
    }

    protected TypeRewriteRule makeRule() {
        Type type = this.getInputSchema().getType(References.f_16773_);
        OpticFinder \u00e2\u02dc\u01922 = type.findField("Level");
        OpticFinder \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.type().findField("Sections");
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923.type();
        if (!(\u00e2\u02dc\u0192 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        \u00e2\u02dc\u0192 = ((List.ListType)\u00e2\u02dc\u0192).getElement();
        OpticFinder \u00e2\u02dc\u01924 = DSL.typeFinder((Type)\u00e2\u02dc\u0192);
        return this.fixTypeEverywhereTyped("Leaves fix", type, p_16220_ -> p_16220_.updateTyped(\u00e2\u02dc\u01922, p_145461_ -> {
            int[] nArray = new int[]{0};
            Typed \u00e2\u02dc\u01922 = p_145461_.updateTyped(\u00e2\u02dc\u01923, p_145465_ -> {
                Int2ObjectOpenHashMap int2ObjectOpenHashMap = new Int2ObjectOpenHashMap(p_145465_.getAllTyped(\u00e2\u02dc\u01924).stream().map(p_145467_ -> new LeavesSection((Typed<?>)p_145467_, this.getInputSchema())).collect(Collectors.toMap(Section::m_16301_, p_145457_ -> p_145457_)));
                if (int2ObjectOpenHashMap.values().stream().allMatch(Section::m_16298_)) {
                    return p_145465_;
                }
                ArrayList \u00e2\u02dc\u01922 = Lists.newArrayList();
                for (int i = 0; i < 7; ++i) {
                    \u00e2\u02dc\u01922.add(new IntOpenHashSet());
                }
                for (LeavesSection \u00e2\u02dc\u01923 : int2ObjectOpenHashMap.values()) {
                    if (\u00e2\u02dc\u01923.m_16298_()) continue;
                    for (int i = 0; i < 4096; ++i) {
                        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923.m_16302_(i);
                        if (\u00e2\u02dc\u01923.m_16257_(\u00e2\u02dc\u0192)) {
                            ((IntSet)\u00e2\u02dc\u01922.get(0)).add(\u00e2\u02dc\u01923.m_16301_() << 12 | i);
                            continue;
                        }
                        if (!\u00e2\u02dc\u01923.m_16276_(\u00e2\u02dc\u0192)) continue;
                        n = this.m_16208_(i);
                        \u00e2\u02dc\u0192 = this.m_16247_(i);
                        p_145464_[0] = nArray[0] | LeavesFix.m_16236_(n == 0, n == 15, \u00e2\u02dc\u0192 == 0, \u00e2\u02dc\u0192 == 15);
                    }
                }
                for (int i = 1; i < 7; ++i) {
                    LeavesSection \u00e2\u02dc\u01923;
                    \u00e2\u02dc\u01923 = (IntSet)\u00e2\u02dc\u01922.get(i - 1);
                    IntSet intSet = (IntSet)\u00e2\u02dc\u01922.get(i);
                    IntIterator \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923.iterator();
                    while (\u00e2\u02dc\u01924.hasNext()) {
                        int n = \u00e2\u02dc\u01924.nextInt();
                        \u00e2\u02dc\u0192 = this.m_16208_(n);
                        \u00e2\u02dc\u0192 = this.m_16245_(n);
                        \u00e2\u02dc\u0192 = this.m_16247_(n);
                        for (int[] nArray : f_16200_) {
                            int n2 = \u00e2\u02dc\u0192 + nArray[0];
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 + nArray[1];
                            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 + nArray[2];
                            if (n2 < 0 || n2 > 15 || \u00e2\u02dc\u0192 < 0 || \u00e2\u02dc\u0192 > 15 || \u00e2\u02dc\u0192 < 0 || \u00e2\u02dc\u0192 > 255 || (\u00e2\u02dc\u0192 = (LeavesSection)int2ObjectOpenHashMap.get(\u00e2\u02dc\u0192 >> 4)) == null || \u00e2\u02dc\u0192.m_16298_() || !\u00e2\u02dc\u0192.m_16276_(\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_16302_(\u00e2\u02dc\u0192 = LeavesFix.m_16210_(n2, \u00e2\u02dc\u0192 & 0xF, \u00e2\u02dc\u0192))) || (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_16278_(\u00e2\u02dc\u0192)) <= i) continue;
                            \u00e2\u02dc\u0192.m_16259_(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, i);
                            intSet.add(LeavesFix.m_16210_(n2, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192));
                        }
                    }
                }
                return p_145465_.updateTyped(\u00e2\u02dc\u01924, arg_0 -> LeavesFix.m_145468_((Int2ObjectMap)int2ObjectOpenHashMap, arg_0));
            });
            if (nArray[0] != 0) {
                \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.update(DSL.remainderFinder(), p_145473_ -> {
                    Dynamic dynamic = (Dynamic)DataFixUtils.orElse((Optional)p_145473_.get("UpgradeData").result(), (Object)p_145473_.emptyMap());
                    return p_145473_.set("UpgradeData", dynamic.set("Sides", p_145473_.createByte((byte)(dynamic.get("Sides").asByte((byte)0) | nArray[0]))));
                });
            }
            return \u00e2\u02dc\u01922;
        }));
    }

    public static int m_16210_(int p_16211_, int p_16212_, int p_16213_) {
        return p_16212_ << 8 | p_16213_ << 4 | p_16211_;
    }

    private int m_16208_(int p_16209_) {
        return p_16209_ & 0xF;
    }

    private int m_16245_(int p_16246_) {
        return p_16246_ >> 8 & 0xFF;
    }

    private int m_16247_(int p_16248_) {
        return p_16248_ >> 4 & 0xF;
    }

    public static int m_16236_(boolean p_16237_, boolean p_16238_, boolean p_16239_, boolean p_16240_) {
        int n = 0;
        if (p_16239_) {
            n = p_16238_ ? (n |= 2) : (p_16237_ ? (n |= 0x80) : (n |= 1));
        } else if (p_16240_) {
            n = p_16237_ ? (n |= 0x20) : (p_16238_ ? (n |= 8) : (n |= 0x10));
        } else if (p_16238_) {
            n |= 4;
        } else if (p_16237_) {
            n |= 0x40;
        }
        return n;
    }

    private static /* synthetic */ Typed m_145468_(Int2ObjectMap p_145469_, Typed p_145470_) {
        return ((LeavesSection)p_145469_.get(((Dynamic)p_145470_.get(DSL.remainderFinder())).get("Y").asInt(0))).m_16288_(p_145470_);
    }

    public static final class LeavesSection
    extends Section {
        private static final String f_145474_ = "persistent";
        private static final String f_145475_ = "decayable";
        private static final String f_145476_ = "distance";
        @Nullable
        private IntSet f_16250_;
        @Nullable
        private IntSet f_16251_;
        @Nullable
        private Int2IntMap f_16252_;

        public LeavesSection(Typed<?> p_16254_, Schema p_16255_) {
            super(p_16254_, p_16255_);
        }

        @Override
        protected boolean m_7969_() {
            this.f_16250_ = new IntOpenHashSet();
            this.f_16251_ = new IntOpenHashSet();
            this.f_16252_ = new Int2IntOpenHashMap();
            for (int i = 0; i < this.f_16281_.size(); ++i) {
                Dynamic dynamic = (Dynamic)this.f_16281_.get(i);
                String \u00e2\u02dc\u01922 = dynamic.get("Name").asString("");
                if (f_16201_.containsKey((Object)\u00e2\u02dc\u01922)) {
                    boolean bl = Objects.equals(dynamic.get("Properties").get(f_145475_).asString(""), "false");
                    this.f_16250_.add(i);
                    this.f_16252_.put(this.m_16292_(\u00e2\u02dc\u01922, bl, 7), i);
                    this.f_16281_.set(i, this.m_16271_(dynamic, \u00e2\u02dc\u01922, bl, 7));
                }
                if (!f_16202_.contains(\u00e2\u02dc\u01922)) continue;
                this.f_16251_.add(i);
            }
            return this.f_16250_.isEmpty() && this.f_16251_.isEmpty();
        }

        private Dynamic<?> m_16271_(Dynamic<?> p_16272_, String p_16273_, boolean p_16274_, int p_16275_) {
            Dynamic dynamic = p_16272_.emptyMap();
            dynamic = dynamic.set(f_145474_, dynamic.createString(p_16274_ ? "true" : "false"));
            dynamic = dynamic.set(f_145476_, dynamic.createString(Integer.toString(p_16275_)));
            \u00e2\u02dc\u0192 = p_16272_.emptyMap();
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.set("Properties", dynamic);
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.set("Name", \u00e2\u02dc\u0192.createString(p_16273_));
            return \u00e2\u02dc\u0192;
        }

        public boolean m_16257_(int p_16258_) {
            return this.f_16251_.contains(p_16258_);
        }

        public boolean m_16276_(int p_16277_) {
            return this.f_16250_.contains(p_16277_);
        }

        int m_16278_(int p_16279_) {
            if (this.m_16257_(p_16279_)) {
                return 0;
            }
            return Integer.parseInt(((Dynamic)this.f_16281_.get(p_16279_)).get("Properties").get(f_145476_).asString(""));
        }

        void m_16259_(int p_16260_, int p_16261_, int p_16262_) {
            int n;
            Dynamic dynamic = (Dynamic)this.f_16281_.get(p_16261_);
            String \u00e2\u02dc\u01922 = dynamic.get("Name").asString("");
            int \u00e2\u02dc\u01923 = this.m_16292_(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 = Objects.equals(dynamic.get("Properties").get(f_145474_).asString(""), "true"), p_16262_);
            if (!this.f_16252_.containsKey(\u00e2\u02dc\u01923)) {
                n = this.f_16281_.size();
                this.f_16250_.add(n);
                this.f_16252_.put(\u00e2\u02dc\u01923, n);
                this.f_16281_.add(this.m_16271_(dynamic, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192, p_16262_));
            }
            n = this.f_16252_.get(\u00e2\u02dc\u01923);
            if (1 << this.f_16283_.m_14567_() <= n) {
                PackedBitStorage packedBitStorage = new PackedBitStorage(this.f_16283_.m_14567_() + 1, 4096);
                for (int i = 0; i < 4096; ++i) {
                    packedBitStorage.m_14564_(i, this.f_16283_.m_14562_(i));
                }
                this.f_16283_ = packedBitStorage;
            }
            this.f_16283_.m_14564_(p_16260_, n);
        }
    }

    public static abstract class Section {
        protected static final String f_145477_ = "BlockStates";
        protected static final String f_145478_ = "Name";
        protected static final String f_145479_ = "Properties";
        private final Type<Pair<String, Dynamic<?>>> f_16284_ = DSL.named((String)References.f_16783_.typeName(), (Type)DSL.remainderType());
        protected final OpticFinder<List<Pair<String, Dynamic<?>>>> f_16280_ = DSL.fieldFinder((String)"Palette", (Type)DSL.list(this.f_16284_));
        protected final List<Dynamic<?>> f_16281_;
        protected final int f_16282_;
        @Nullable
        protected PackedBitStorage f_16283_;

        public Section(Typed<?> p_16286_, Schema p_16287_) {
            if (!Objects.equals(p_16287_.getType(References.f_16783_), this.f_16284_)) {
                throw new IllegalStateException("Block state type is not what was expected.");
            }
            Optional optional = p_16286_.getOptional(this.f_16280_);
            this.f_16281_ = optional.map(p_16297_ -> p_16297_.stream().map(Pair::getSecond).collect(Collectors.toList())).orElse((List)ImmutableList.of());
            Dynamic \u00e2\u02dc\u01922 = (Dynamic)p_16286_.get(DSL.remainderFinder());
            this.f_16282_ = \u00e2\u02dc\u01922.get("Y").asInt(0);
            this.m_16290_(\u00e2\u02dc\u01922);
        }

        protected void m_16290_(Dynamic<?> p_16291_) {
            if (this.m_7969_()) {
                this.f_16283_ = null;
            } else {
                long[] lArray = p_16291_.get(f_145477_).asLongStream().toArray();
                int \u00e2\u02dc\u01922 = Math.max(4, DataFixUtils.ceillog2((int)this.f_16281_.size()));
                this.f_16283_ = new PackedBitStorage(\u00e2\u02dc\u01922, 4096, lArray);
            }
        }

        public Typed<?> m_16288_(Typed<?> p_16289_) {
            if (this.m_16298_()) {
                return p_16289_;
            }
            return p_16289_.update(DSL.remainderFinder(), p_16305_ -> p_16305_.set(f_145477_, p_16305_.createLongList(Arrays.stream(this.f_16283_.m_14561_())))).set(this.f_16280_, this.f_16281_.stream().map(p_16300_ -> Pair.of((Object)References.f_16783_.typeName(), (Object)p_16300_)).collect(Collectors.toList()));
        }

        public boolean m_16298_() {
            return this.f_16283_ == null;
        }

        public int m_16302_(int p_16303_) {
            return this.f_16283_.m_14562_(p_16303_);
        }

        protected int m_16292_(String p_16293_, boolean p_16294_, int p_16295_) {
            return f_16201_.get((Object)p_16293_) << 5 | (p_16294_ ? 16 : 0) | p_16295_;
        }

        int m_16301_() {
            return this.f_16282_;
        }

        protected abstract boolean m_7969_();
    }
}

