/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Splitter;
import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.DataFixUtils;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.Dynamic;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.minecraft.util.datafix.fixes.BlockStateData;
import net.minecraft.util.datafix.fixes.EntityBlockStateFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.commons.lang3.math.NumberUtils;

public class LevelFlatGeneratorInfoFix
extends DataFix {
    private static final String f_145489_ = "generatorOptions";
    @VisibleForTesting
    static final String f_145488_ = "minecraft:bedrock,2*minecraft:dirt,minecraft:grass_block;1;village";
    private static final Splitter f_16337_ = Splitter.on((char)';').limit(5);
    private static final Splitter f_16338_ = Splitter.on((char)',');
    private static final Splitter f_16339_ = Splitter.on((char)'x').limit(2);
    private static final Splitter f_16340_ = Splitter.on((char)'*').limit(2);
    private static final Splitter f_16341_ = Splitter.on((char)':').limit(3);

    public LevelFlatGeneratorInfoFix(Schema p_16344_, boolean p_16345_) {
        super(p_16344_, p_16345_);
    }

    public TypeRewriteRule makeRule() {
        return this.fixTypeEverywhereTyped("LevelFlatGeneratorInfoFix", this.getInputSchema().getType(References.f_16771_), p_16351_ -> p_16351_.update(DSL.remainderFinder(), this::m_16352_));
    }

    private Dynamic<?> m_16352_(Dynamic<?> p_16353_) {
        if (p_16353_.get("generatorName").asString("").equalsIgnoreCase("flat")) {
            return p_16353_.update(f_145489_, p_16357_ -> (Dynamic)DataFixUtils.orElse((Optional)p_16357_.asString().map(this::m_16354_).map(arg_0 -> ((Dynamic)p_16357_).createString(arg_0)).result(), (Object)p_16357_));
        }
        return p_16353_;
    }

    @VisibleForTesting
    String m_16354_(String p_16355_) {
        String \u00e2\u02dc\u01923;
        if (p_16355_.isEmpty()) {
            return f_145488_;
        }
        Iterator iterator = f_16337_.split((CharSequence)p_16355_).iterator();
        String \u00e2\u02dc\u01922 = (String)iterator.next();
        if (iterator.hasNext()) {
            int n = NumberUtils.toInt((String)\u00e2\u02dc\u01922, (int)0);
            \u00e2\u02dc\u01923 = (String)iterator.next();
        } else {
            n = 0;
            \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922;
        }
        if (n < 0 || n > 3) {
            return f_145488_;
        }
        StringBuilder stringBuilder = new StringBuilder();
        Splitter \u00e2\u02dc\u01924 = n < 3 ? f_16339_ : f_16340_;
        stringBuilder.append(StreamSupport.stream(f_16338_.split((CharSequence)\u00e2\u02dc\u01923).spliterator(), false).map(p_16349_ -> {
            String \u00e2\u02dc\u01922;
            List list = \u00e2\u02dc\u01924.splitToList((CharSequence)p_16349_);
            if (list.size() == 2) {
                int n = NumberUtils.toInt((String)((String)list.get(0)));
                \u00e2\u02dc\u01922 = (String)list.get(1);
            } else {
                n = 1;
                \u00e2\u02dc\u01922 = (String)list.get(0);
            }
            List list2 = f_16341_.splitToList((CharSequence)\u00e2\u02dc\u01922);
            int \u00e2\u02dc\u01923 = ((String)list2.get(0)).equals("minecraft") ? 1 : 0;
            String \u00e2\u02dc\u01924 = (String)list2.get(\u00e2\u02dc\u01923);
            int \u00e2\u02dc\u01925 = n == 3 ? EntityBlockStateFix.m_15365_("minecraft:" + \u00e2\u02dc\u01924) : NumberUtils.toInt((String)\u00e2\u02dc\u01924, (int)0);
            int \u00e2\u02dc\u01926 = \u00e2\u02dc\u01923 + 1;
            int \u00e2\u02dc\u01927 = list2.size() > \u00e2\u02dc\u01926 ? NumberUtils.toInt((String)((String)list2.get(\u00e2\u02dc\u01926)), (int)0) : 0;
            return (String)(n == 1 ? "" : n + "*") + BlockStateData.m_14952_(\u00e2\u02dc\u01925 << 4 | \u00e2\u02dc\u01927).get("Name").asString("");
        }).collect(Collectors.joining(",")));
        while (iterator.hasNext()) {
            stringBuilder.append(';').append((String)iterator.next());
        }
        return stringBuilder.toString();
    }
}

