/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Sets;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.OptionalDynamic;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import net.minecraft.util.datafix.fixes.References;

public class SavedDataFeaturePoolElementFix
extends DataFix {
    private static final Pattern f_145641_ = Pattern.compile("\\[(\\d+)\\]");
    private static final Set<String> f_145642_ = Sets.newHashSet((Object[])new String[]{"minecraft:jigsaw", "minecraft:nvi", "minecraft:pcp", "minecraft:bastionremnant", "minecraft:runtime"});
    private static final Set<String> f_145643_ = Sets.newHashSet((Object[])new String[]{"minecraft:tree", "minecraft:flower", "minecraft:block_pile", "minecraft:random_patch"});

    public SavedDataFeaturePoolElementFix(Schema p_145646_) {
        super(p_145646_, false);
    }

    public TypeRewriteRule makeRule() {
        return this.writeFixAndRead("SavedDataFeaturePoolElementFix", this.getInputSchema().getType(References.f_16790_), this.getOutputSchema().getType(References.f_16790_), SavedDataFeaturePoolElementFix::m_145662_);
    }

    private static <T> Dynamic<T> m_145662_(Dynamic<T> p_145663_) {
        return p_145663_.update("Children", SavedDataFeaturePoolElementFix::m_145664_);
    }

    private static <T> Dynamic<T> m_145664_(Dynamic<T> p_145665_) {
        return p_145665_.asStreamOpt().map(SavedDataFeaturePoolElementFix::m_145660_).map(arg_0 -> p_145665_.createList(arg_0)).result().orElse(p_145665_);
    }

    private static Stream<? extends Dynamic<?>> m_145660_(Stream<? extends Dynamic<?>> p_145661_) {
        return p_145661_.map(p_145667_ -> {
            String string = p_145667_.get("id").asString("");
            if (!f_145642_.contains(string)) {
                return p_145667_;
            }
            OptionalDynamic \u00e2\u02dc\u01922 = p_145667_.get("pool_element");
            if (!\u00e2\u02dc\u01922.get("element_type").asString("").equals("minecraft:feature_pool_element")) {
                return p_145667_;
            }
            if (!\u00e2\u02dc\u01922.get("feature").get("name").result().isPresent()) {
                return p_145667_;
            }
            return p_145667_.update("pool_element", p_145669_ -> p_145669_.update("feature", SavedDataFeaturePoolElementFix::m_145647_));
        });
    }

    private static <T> OptionalDynamic<T> m_145649_(Dynamic<T> p_145650_, String ... p_145651_) {
        if (p_145651_.length == 0) {
            throw new IllegalArgumentException("Missing path");
        }
        OptionalDynamic \u00e2\u02dc\u01924 = p_145650_.get(p_145651_[0]);
        for (int i = 1; i < p_145651_.length; ++i) {
            String string = p_145651_[i];
            Matcher \u00e2\u02dc\u01922 = f_145641_.matcher(string);
            if (\u00e2\u02dc\u01922.matches()) {
                int n = Integer.parseInt(\u00e2\u02dc\u01922.group(1));
                List \u00e2\u02dc\u01923 = \u00e2\u02dc\u01924.asList(Function.identity());
                if (n >= 0 && n < \u00e2\u02dc\u01923.size()) {
                    \u00e2\u02dc\u01924 = new OptionalDynamic(p_145650_.getOps(), DataResult.success((Object)((Dynamic)\u00e2\u02dc\u01923.get(n))));
                    continue;
                }
                \u00e2\u02dc\u01924 = new OptionalDynamic(p_145650_.getOps(), DataResult.error((String)("Missing id:" + n)));
                continue;
            }
            \u00e2\u02dc\u01924 = \u00e2\u02dc\u01924.get(string);
        }
        return \u00e2\u02dc\u01924;
    }

    @VisibleForTesting
    protected static Dynamic<?> m_145647_(Dynamic<?> p_145648_) {
        Optional<String> optional = SavedDataFeaturePoolElementFix.m_145652_(SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "type").asString(""), SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "name").asString(""), SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "config", "state_provider", "type").asString(""), SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "config", "state_provider", "state", "Name").asString(""), SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "config", "state_provider", "entries", "[0]", "data", "Name").asString(""), SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "config", "foliage_placer", "type").asString(""), SavedDataFeaturePoolElementFix.m_145649_(p_145648_, "config", "leaves_provider", "state", "Name").asString(""));
        if (optional.isPresent()) {
            return p_145648_.createString(optional.get());
        }
        return p_145648_;
    }

    private static Optional<String> m_145652_(String p_145653_, String p_145654_, String p_145655_, String p_145656_, String p_145657_, String p_145658_, String p_145659_) {
        String string;
        if (!p_145653_.isEmpty()) {
            string = p_145653_;
        } else if (!p_145654_.isEmpty()) {
            string = "minecraft:normal_tree".equals(p_145654_) ? "minecraft:tree" : p_145654_;
        } else {
            return Optional.empty();
        }
        if (f_145643_.contains(string)) {
            if ("minecraft:random_patch".equals(string)) {
                if ("minecraft:simple_state_provider".equals(p_145655_)) {
                    if ("minecraft:sweet_berry_bush".equals(p_145656_)) {
                        return Optional.of("minecraft:patch_berry_bush");
                    }
                    if ("minecraft:cactus".equals(p_145656_)) {
                        return Optional.of("minecraft:patch_cactus");
                    }
                } else if ("minecraft:weighted_state_provider".equals(p_145655_) && ("minecraft:grass".equals(p_145657_) || "minecraft:fern".equals(p_145657_))) {
                    return Optional.of("minecraft:patch_taiga_grass");
                }
            } else if ("minecraft:block_pile".equals(string)) {
                if ("minecraft:simple_state_provider".equals(p_145655_) || "minecraft:rotated_block_provider".equals(p_145655_)) {
                    if ("minecraft:hay_block".equals(p_145656_)) {
                        return Optional.of("minecraft:pile_hay");
                    }
                    if ("minecraft:melon".equals(p_145656_)) {
                        return Optional.of("minecraft:pile_melon");
                    }
                    if ("minecraft:snow".equals(p_145656_)) {
                        return Optional.of("minecraft:pile_snow");
                    }
                } else if ("minecraft:weighted_state_provider".equals(p_145655_)) {
                    if ("minecraft:packed_ice".equals(p_145657_) || "minecraft:blue_ice".equals(p_145657_)) {
                        return Optional.of("minecraft:pile_ice");
                    }
                    if ("minecraft:jack_o_lantern".equals(p_145657_) || "minecraft:pumpkin".equals(p_145657_)) {
                        return Optional.of("minecraft:pile_pumpkin");
                    }
                }
            } else {
                if ("minecraft:flower".equals(string)) {
                    return Optional.of("minecraft:flower_plain");
                }
                if ("minecraft:tree".equals(string)) {
                    if ("minecraft:acacia_foliage_placer".equals(p_145658_)) {
                        return Optional.of("minecraft:acacia");
                    }
                    if ("minecraft:blob_foliage_placer".equals(p_145658_) && "minecraft:oak_leaves".equals(p_145659_)) {
                        return Optional.of("minecraft:oak");
                    }
                    if ("minecraft:pine_foliage_placer".equals(p_145658_)) {
                        return Optional.of("minecraft:pine");
                    }
                    if ("minecraft:spruce_foliage_placer".equals(p_145658_)) {
                        return Optional.of("minecraft:spruce");
                    }
                }
            }
        }
        return Optional.empty();
    }
}

