/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.datafix.fixes;

import com.mojang.datafixers.DSL;
import com.mojang.datafixers.DataFix;
import com.mojang.datafixers.OpticFinder;
import com.mojang.datafixers.TypeRewriteRule;
import com.mojang.datafixers.Typed;
import com.mojang.datafixers.schemas.Schema;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.templates.List;
import com.mojang.datafixers.types.templates.TaggedChoice;
import com.mojang.serialization.Dynamic;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.util.datafix.fixes.AddNewChoices;
import net.minecraft.util.datafix.fixes.LeavesFix;
import net.minecraft.util.datafix.fixes.References;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TrappedChestBlockEntityFix
extends DataFix {
    private static final Logger f_17015_ = LogManager.getLogger();
    private static final int f_145734_ = 4096;
    private static final short f_145735_ = 12;

    public TrappedChestBlockEntityFix(Schema p_17018_, boolean p_17019_) {
        super(p_17018_, p_17019_);
    }

    public TypeRewriteRule makeRule() {
        Type type = this.getOutputSchema().getType(References.f_16773_);
        \u00e2\u02dc\u0192 = type.findFieldType("Level");
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.findFieldType("TileEntities");
        if (!(\u00e2\u02dc\u0192 instanceof List.ListType)) {
            throw new IllegalStateException("Tile entity type is not a list type.");
        }
        List.ListType \u00e2\u02dc\u01922 = (List.ListType)\u00e2\u02dc\u0192;
        OpticFinder \u00e2\u02dc\u01923 = DSL.fieldFinder((String)"TileEntities", (Type)\u00e2\u02dc\u01922);
        \u00e2\u02dc\u0192 = this.getInputSchema().getType(References.f_16773_);
        OpticFinder \u00e2\u02dc\u01924 = \u00e2\u02dc\u0192.findField("Level");
        OpticFinder \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.type().findField("Sections");
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u01925.type();
        if (!(\u00e2\u02dc\u0192 instanceof List.ListType)) {
            throw new IllegalStateException("Expecting sections to be a list.");
        }
        \u00e2\u02dc\u0192 = ((List.ListType)\u00e2\u02dc\u0192).getElement();
        OpticFinder \u00e2\u02dc\u01926 = DSL.typeFinder((Type)\u00e2\u02dc\u0192);
        return TypeRewriteRule.seq((TypeRewriteRule)new AddNewChoices(this.getOutputSchema(), "AddTrappedChestFix", References.f_16781_).makeRule(), (TypeRewriteRule)this.fixTypeEverywhereTyped("Trapped Chest fix", \u00e2\u02dc\u0192, p_17031_ -> p_17031_.updateTyped(\u00e2\u02dc\u01924, p_145746_ -> {
            Optional optional = p_145746_.getOptionalTyped(\u00e2\u02dc\u01925);
            if (!optional.isPresent()) {
                return p_145746_;
            }
            List \u00e2\u02dc\u01922 = ((Typed)optional.get()).getAllTyped(\u00e2\u02dc\u01926);
            IntOpenHashSet \u00e2\u02dc\u01923 = new IntOpenHashSet();
            for (Typed typed : \u00e2\u02dc\u01922) {
                TrappedChestSection trappedChestSection = new TrappedChestSection(typed, this.getInputSchema());
                if (trappedChestSection.m_16298_()) continue;
                for (int i = 0; i < 4096; ++i) {
                    \u00e2\u02dc\u0192 = trappedChestSection.m_16302_(i);
                    if (!trappedChestSection.m_17053_(\u00e2\u02dc\u0192)) continue;
                    \u00e2\u02dc\u01923.add(trappedChestSection.m_16301_() << 12 | i);
                }
            }
            Dynamic dynamic = (Dynamic)p_145746_.get(DSL.remainderFinder());
            int \u00e2\u02dc\u01924 = dynamic.get("xPos").asInt(0);
            int \u00e2\u02dc\u01925 = dynamic.get("zPos").asInt(0);
            TaggedChoice.TaggedChoiceType \u00e2\u02dc\u01926 = this.getInputSchema().findChoiceType(References.f_16781_);
            return p_145746_.updateTyped(\u00e2\u02dc\u01923, arg_0 -> TrappedChestBlockEntityFix.m_145747_(\u00e2\u02dc\u01926, \u00e2\u02dc\u01924, \u00e2\u02dc\u01925, (IntSet)\u00e2\u02dc\u01923, arg_0));
        })));
    }

    private static /* synthetic */ Typed m_145747_(TaggedChoice.TaggedChoiceType p_145748_, int p_145749_, int p_145750_, IntSet p_145751_, Typed p_145752_) {
        return p_145752_.updateTyped(p_145748_.finder(), p_145741_ -> {
            Dynamic dynamic = (Dynamic)p_145741_.getOrCreate(DSL.remainderFinder());
            int \u00e2\u02dc\u01922 = dynamic.get("x").asInt(0) - (p_145749_ << 4);
            if (p_145751_.contains(LeavesFix.m_16210_(\u00e2\u02dc\u01922, \u00e2\u02dc\u0192 = dynamic.get("y").asInt(0), \u00e2\u02dc\u0192 = dynamic.get("z").asInt(0) - (p_145750_ << 4)))) {
                return p_145741_.update(p_145748_.finder(), p_145754_ -> p_145754_.mapFirst(p_145756_ -> {
                    if (!Objects.equals(p_145756_, "minecraft:chest")) {
                        f_17015_.warn("Block Entity was expected to be a chest");
                    }
                    return "minecraft:trapped_chest";
                }));
            }
            return p_145741_;
        });
    }

    public static final class TrappedChestSection
    extends LeavesFix.Section {
        @Nullable
        private IntSet f_17048_;

        public TrappedChestSection(Typed<?> p_17050_, Schema p_17051_) {
            super(p_17050_, p_17051_);
        }

        @Override
        protected boolean m_7969_() {
            this.f_17048_ = new IntOpenHashSet();
            for (int i = 0; i < this.f_16281_.size(); ++i) {
                Dynamic dynamic = (Dynamic)this.f_16281_.get(i);
                String \u00e2\u02dc\u01922 = dynamic.get("Name").asString("");
                if (!Objects.equals(\u00e2\u02dc\u01922, "minecraft:trapped_chest")) continue;
                this.f_17048_.add(i);
            }
            return this.f_17048_.isEmpty();
        }

        public boolean m_17053_(int p_17054_) {
            return this.f_17048_.contains(p_17054_);
        }
    }
}

