/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.profiling;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongMaps;
import java.io.BufferedWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.util.profiling.ProfileResults;
import net.minecraft.util.profiling.ProfilerPathEntry;
import net.minecraft.util.profiling.ResultField;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FilledProfileResults
implements ProfileResults {
    private static final Logger f_18452_ = LogManager.getLogger();
    private static final ProfilerPathEntry f_18453_ = new ProfilerPathEntry(){

        @Override
        public long m_7235_() {
            return 0L;
        }

        @Override
        public long m_142752_() {
            return 0L;
        }

        @Override
        public long m_7234_() {
            return 0L;
        }

        @Override
        public Object2LongMap<String> m_7446_() {
            return Object2LongMaps.emptyMap();
        }
    };
    private static final Splitter f_18454_ = Splitter.on((char)'\u001e');
    private static final Comparator<Map.Entry<String, CounterCollector>> f_18455_ = Map.Entry.comparingByValue(Comparator.comparingLong(p_18489_ -> p_18489_.f_18538_)).reversed();
    private final Map<String, ? extends ProfilerPathEntry> f_18456_;
    private final long f_18457_;
    private final int f_18458_;
    private final long f_18459_;
    private final int f_18460_;
    private final int f_18461_;

    public FilledProfileResults(Map<String, ? extends ProfilerPathEntry> p_18464_, long p_18465_, int p_18466_, long p_18467_, int p_18468_) {
        this.f_18456_ = p_18464_;
        this.f_18457_ = p_18465_;
        this.f_18458_ = p_18466_;
        this.f_18459_ = p_18467_;
        this.f_18460_ = p_18468_;
        this.f_18461_ = p_18468_ - p_18466_;
    }

    private ProfilerPathEntry m_18525_(String p_18526_) {
        ProfilerPathEntry profilerPathEntry = this.f_18456_.get(p_18526_);
        return profilerPathEntry != null ? profilerPathEntry : f_18453_;
    }

    @Override
    public List<ResultField> m_6412_(String p_18493_) {
        String string = p_18493_;
        ProfilerPathEntry \u00e2\u02dc\u01922 = this.m_18525_("root");
        long \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_7235_();
        ProfilerPathEntry \u00e2\u02dc\u01924 = this.m_18525_((String)p_18493_);
        long \u00e2\u02dc\u01925 = \u00e2\u02dc\u01924.m_7235_();
        long \u00e2\u02dc\u01926 = \u00e2\u02dc\u01924.m_7234_();
        ArrayList \u00e2\u02dc\u01927 = Lists.newArrayList();
        if (!((String)p_18493_).isEmpty()) {
            p_18493_ = (String)p_18493_ + "\u001e";
        }
        long \u00e2\u02dc\u01928 = 0L;
        for (String string2 : this.f_18456_.keySet()) {
            if (!FilledProfileResults.m_18494_((String)p_18493_, string2)) continue;
            \u00e2\u02dc\u01928 += this.m_18525_(string2).m_7235_();
        }
        float \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928;
        if (\u00e2\u02dc\u01928 < \u00e2\u02dc\u01925) {
            \u00e2\u02dc\u01928 = \u00e2\u02dc\u01925;
        }
        if (\u00e2\u02dc\u01923 < \u00e2\u02dc\u01928) {
            \u00e2\u02dc\u01923 = \u00e2\u02dc\u01928;
        }
        for (String string3 : this.f_18456_.keySet()) {
            if (!FilledProfileResults.m_18494_((String)p_18493_, string3)) continue;
            ProfilerPathEntry profilerPathEntry = this.m_18525_(string3);
            long \u00e2\u02dc\u019210 = profilerPathEntry.m_7235_();
            double \u00e2\u02dc\u019211 = (double)\u00e2\u02dc\u019210 * 100.0 / (double)\u00e2\u02dc\u01928;
            double \u00e2\u02dc\u019212 = (double)\u00e2\u02dc\u019210 * 100.0 / (double)\u00e2\u02dc\u01923;
            String \u00e2\u02dc\u019213 = string3.substring(((String)p_18493_).length());
            \u00e2\u02dc\u01927.add(new ResultField(\u00e2\u02dc\u019213, \u00e2\u02dc\u019211, \u00e2\u02dc\u019212, profilerPathEntry.m_7234_()));
        }
        if ((float)\u00e2\u02dc\u01928 > \u00e2\u02dc\u01929) {
            \u00e2\u02dc\u01927.add(new ResultField("unspecified", (double)((float)\u00e2\u02dc\u01928 - \u00e2\u02dc\u01929) * 100.0 / (double)\u00e2\u02dc\u01928, (double)((float)\u00e2\u02dc\u01928 - \u00e2\u02dc\u01929) * 100.0 / (double)\u00e2\u02dc\u01923, \u00e2\u02dc\u01926));
        }
        Collections.sort(\u00e2\u02dc\u01927);
        \u00e2\u02dc\u01927.add(0, new ResultField(string, 100.0, (double)\u00e2\u02dc\u01928 * 100.0 / (double)\u00e2\u02dc\u01923, \u00e2\u02dc\u01926));
        return \u00e2\u02dc\u01927;
    }

    private static boolean m_18494_(String p_18495_, String p_18496_) {
        return p_18496_.length() > p_18495_.length() && p_18496_.startsWith(p_18495_) && p_18496_.indexOf(30, p_18495_.length() + 1) < 0;
    }

    private Map<String, CounterCollector> m_18531_() {
        TreeMap treeMap = Maps.newTreeMap();
        this.f_18456_.forEach((p_18512_, p_18513_) -> {
            Object2LongMap<String> object2LongMap = p_18513_.m_7446_();
            if (!object2LongMap.isEmpty()) {
                List list = f_18454_.splitToList((CharSequence)p_18512_);
                object2LongMap.forEach((p_145944_, p_145945_) -> treeMap.computeIfAbsent(p_145944_, p_145947_ -> new CounterCollector()).m_18547_(list.iterator(), (long)p_145945_));
            }
        });
        return treeMap;
    }

    @Override
    public long m_7229_() {
        return this.f_18457_;
    }

    @Override
    public int m_7230_() {
        return this.f_18458_;
    }

    @Override
    public long m_7236_() {
        return this.f_18459_;
    }

    @Override
    public int m_7317_() {
        return this.f_18460_;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean m_142444_(Path p_145940_) {
        boolean bl;
        BufferedWriter bufferedWriter = null;
        try {
            Files.createDirectories(p_145940_.getParent(), new FileAttribute[0]);
            bufferedWriter = Files.newBufferedWriter(p_145940_, StandardCharsets.UTF_8, new OpenOption[0]);
            bufferedWriter.write(this.m_18485_(this.m_18577_(), this.m_7315_()));
            bl = true;
        }
        catch (Throwable \u00e2\u02dc\u01922) {
            boolean bl2;
            try {
                f_18452_.error("Could not save profiler results to {}", (Object)p_145940_, (Object)\u00e2\u02dc\u01922);
                bl2 = false;
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(bufferedWriter);
                throw throwable;
            }
            IOUtils.closeQuietly((Writer)bufferedWriter);
            return bl2;
        }
        IOUtils.closeQuietly((Writer)bufferedWriter);
        return bl;
    }

    protected String m_18485_(long p_18486_, int p_18487_) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("---- Minecraft Profiler Results ----\n");
        stringBuilder.append("// ");
        stringBuilder.append(FilledProfileResults.m_18532_());
        stringBuilder.append("\n\n");
        stringBuilder.append("Version: ").append(SharedConstants.m_136187_().getId()).append('\n');
        stringBuilder.append("Time span: ").append(p_18486_ / 1000000L).append(" ms\n");
        stringBuilder.append("Tick span: ").append(p_18487_).append(" ticks\n");
        stringBuilder.append("// This is approximately ").append(String.format(Locale.ROOT, "%.2f", Float.valueOf((float)p_18487_ / ((float)p_18486_ / 1.0E9f)))).append(" ticks per second. It should be ").append(20).append(" ticks per second\n\n");
        stringBuilder.append("--- BEGIN PROFILE DUMP ---\n\n");
        this.m_18481_(0, "root", stringBuilder);
        stringBuilder.append("--- END PROFILE DUMP ---\n\n");
        Map<String, CounterCollector> \u00e2\u02dc\u01922 = this.m_18531_();
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            stringBuilder.append("--- BEGIN COUNTER DUMP ---\n\n");
            this.m_18514_(\u00e2\u02dc\u01922, stringBuilder, p_18487_);
            stringBuilder.append("--- END COUNTER DUMP ---\n\n");
        }
        return stringBuilder.toString();
    }

    @Override
    public String m_142368_() {
        StringBuilder stringBuilder = new StringBuilder();
        this.m_18481_(0, "root", stringBuilder);
        return stringBuilder.toString();
    }

    private static StringBuilder m_18497_(StringBuilder p_18498_, int p_18499_) {
        p_18498_.append(String.format("[%02d] ", p_18499_));
        for (int i = 0; i < p_18499_; ++i) {
            p_18498_.append("|   ");
        }
        return p_18498_;
    }

    private void m_18481_(int p_18482_, String p_18483_, StringBuilder p_18484_) {
        List<ResultField> list = this.m_6412_(p_18483_);
        Object2LongMap<String> \u00e2\u02dc\u01922 = ((ProfilerPathEntry)ObjectUtils.firstNonNull((Object[])new ProfilerPathEntry[]{this.f_18456_.get(p_18483_), f_18453_})).m_7446_();
        \u00e2\u02dc\u01922.forEach((p_18508_, p_18509_) -> FilledProfileResults.m_18497_(p_18484_, p_18482_).append('#').append((String)p_18508_).append(' ').append(p_18509_).append('/').append(p_18509_ / (long)this.f_18461_).append('\n'));
        if (list.size() < 3) {
            return;
        }
        for (int i = 1; i < list.size(); ++i) {
            ResultField resultField = list.get(i);
            FilledProfileResults.m_18497_(p_18484_, p_18482_).append(resultField.f_18610_).append('(').append(resultField.f_18609_).append('/').append(String.format(Locale.ROOT, "%.0f", Float.valueOf((float)resultField.f_18609_ / (float)this.f_18461_))).append(')').append(" - ").append(String.format(Locale.ROOT, "%.2f", resultField.f_18607_)).append("%/").append(String.format(Locale.ROOT, "%.2f", resultField.f_18608_)).append("%\n");
            if ("unspecified".equals(resultField.f_18610_)) continue;
            try {
                this.m_18481_(p_18482_ + 1, p_18483_ + "\u001e" + resultField.f_18610_, p_18484_);
                continue;
            }
            catch (Exception \u00e2\u02dc\u01923) {
                p_18484_.append("[[ EXCEPTION ").append(\u00e2\u02dc\u01923).append(" ]]");
            }
        }
    }

    private void m_18475_(int p_18476_, String p_18477_, CounterCollector p_18478_, int p_18479_, StringBuilder p_18480_) {
        FilledProfileResults.m_18497_(p_18480_, p_18476_).append(p_18477_).append(" total:").append(p_18478_.f_18537_).append('/').append(p_18478_.f_18538_).append(" average: ").append(p_18478_.f_18537_ / (long)p_18479_).append('/').append(p_18478_.f_18538_ / (long)p_18479_).append('\n');
        p_18478_.f_18539_.entrySet().stream().sorted(f_18455_).forEach(p_18474_ -> this.m_18475_(p_18476_ + 1, (String)p_18474_.getKey(), (CounterCollector)p_18474_.getValue(), p_18479_, p_18480_));
    }

    private void m_18514_(Map<String, CounterCollector> p_18515_, StringBuilder p_18516_, int p_18517_) {
        p_18515_.forEach((p_18503_, p_18504_) -> {
            p_18516_.append("-- Counter: ").append((String)p_18503_).append(" --\n");
            this.m_18475_(0, "root", p_18504_.f_18539_.get("root"), p_18517_, p_18516_);
            p_18516_.append("\n\n");
        });
    }

    private static String m_18532_() {
        String[] stringArray = new String[]{"Shiny numbers!", "Am I not running fast enough? :(", "I'm working as hard as I can!", "Will I ever be good enough for you? :(", "Speedy. Zoooooom!", "Hello world", "40% better than a crash report.", "Now with extra numbers", "Now with less numbers", "Now with the same numbers", "You should add flames to things, it makes them go faster!", "Do you feel the need for... optimization?", "*cracks redstone whip*", "Maybe if you treated it better then it'll have more motivation to work faster! Poor server."};
        try {
            return stringArray[(int)(Util.m_137569_() % (long)stringArray.length)];
        }
        catch (Throwable \u00e2\u02dc\u01922) {
            return "Witty comment unavailable :(";
        }
    }

    @Override
    public int m_7315_() {
        return this.f_18461_;
    }

    static class CounterCollector {
        long f_18537_;
        long f_18538_;
        final Map<String, CounterCollector> f_18539_ = Maps.newHashMap();

        CounterCollector() {
        }

        public void m_18547_(Iterator<String> p_18548_, long p_18549_) {
            this.f_18538_ += p_18549_;
            if (!p_18548_.hasNext()) {
                this.f_18537_ += p_18549_;
            } else {
                this.f_18539_.computeIfAbsent(p_18548_.next(), p_18546_ -> new CounterCollector()).m_18547_(p_18548_, p_18549_);
            }
        }
    }
}

