/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.thread;

import com.google.common.collect.Queues;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.annotation.Nullable;

public interface StrictQueue<T, F> {
    @Nullable
    public F m_6610_();

    public boolean m_6944_(T var1);

    public boolean m_7263_();

    public int m_142732_();

    public static final class FixedPriorityQueue
    implements StrictQueue<IntRunnable, Runnable> {
        private final List<Queue<Runnable>> f_18771_;

        public FixedPriorityQueue(int p_18773_) {
            this.f_18771_ = IntStream.range(0, p_18773_).mapToObj(p_18776_ -> Queues.newConcurrentLinkedQueue()).collect(Collectors.toList());
        }

        @Override
        @Nullable
        public Runnable m_6610_() {
            for (Queue<Runnable> queue : this.f_18771_) {
                Runnable runnable = queue.poll();
                if (runnable == null) continue;
                return runnable;
            }
            return null;
        }

        @Override
        public boolean m_6944_(IntRunnable p_18778_) {
            int n = p_18778_.m_18788_();
            this.f_18771_.get(n).add(p_18778_);
            return true;
        }

        @Override
        public boolean m_7263_() {
            return this.f_18771_.stream().allMatch(Collection::isEmpty);
        }

        @Override
        public int m_142732_() {
            int n = 0;
            for (Queue<Runnable> queue : this.f_18771_) {
                n += queue.size();
            }
            return n;
        }

        @Override
        @Nullable
        public /* synthetic */ Object m_6610_() {
            return this.m_6610_();
        }
    }

    public static final class IntRunnable
    implements Runnable {
        private final int f_18783_;
        private final Runnable f_18784_;

        public IntRunnable(int p_18786_, Runnable p_18787_) {
            this.f_18783_ = p_18786_;
            this.f_18784_ = p_18787_;
        }

        @Override
        public void run() {
            this.f_18784_.run();
        }

        public int m_18788_() {
            return this.f_18783_;
        }
    }

    public static final class QueueStrictQueue<T>
    implements StrictQueue<T, T> {
        private final Queue<T> f_18790_;

        public QueueStrictQueue(Queue<T> p_18792_) {
            this.f_18790_ = p_18792_;
        }

        @Override
        @Nullable
        public T m_6610_() {
            return this.f_18790_.poll();
        }

        @Override
        public boolean m_6944_(T p_18795_) {
            return this.f_18790_.add(p_18795_);
        }

        @Override
        public boolean m_7263_() {
            return this.f_18790_.isEmpty();
        }

        @Override
        public int m_142732_() {
            return this.f_18790_.size();
        }
    }
}

