/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.util.worldupdate;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.datafixers.DataFixer;
import it.unimi.dsi.fastutil.objects.Object2FloatMap;
import it.unimi.dsi.fastutil.objects.Object2FloatMaps;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenCustomHashMap;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.concurrent.ThreadFactory;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ReportedException;
import net.minecraft.SharedConstants;
import net.minecraft.Util;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.storage.ChunkStorage;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraft.world.level.storage.LevelStorageSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class WorldUpgrader {
    private static final Logger f_18797_ = LogManager.getLogger();
    private static final ThreadFactory f_18798_ = new ThreadFactoryBuilder().setDaemon(true).build();
    private final ImmutableSet<ResourceKey<Level>> f_18799_;
    private final boolean f_18800_;
    private final LevelStorageSource.LevelStorageAccess f_18801_;
    private final Thread f_18802_;
    private final DataFixer f_18803_;
    private volatile boolean f_18804_ = true;
    private volatile boolean f_18805_;
    private volatile float f_18806_;
    private volatile int f_18807_;
    private volatile int f_18808_;
    private volatile int f_18809_;
    private final Object2FloatMap<ResourceKey<Level>> f_18810_ = Object2FloatMaps.synchronize((Object2FloatMap)new Object2FloatOpenCustomHashMap(Util.m_137583_()));
    private volatile Component f_18811_ = new TranslatableComponent("optimizeWorld.stage.counting");
    private static final Pattern f_18812_ = Pattern.compile("^r\\.(-?[0-9]+)\\.(-?[0-9]+)\\.mca$");
    private final DimensionDataStorage f_18813_;

    public WorldUpgrader(LevelStorageSource.LevelStorageAccess p_18816_, DataFixer p_18817_, ImmutableSet<ResourceKey<Level>> p_18818_, boolean p_18819_) {
        this.f_18799_ = p_18818_;
        this.f_18800_ = p_18819_;
        this.f_18803_ = p_18817_;
        this.f_18801_ = p_18816_;
        this.f_18813_ = new DimensionDataStorage(new File(this.f_18801_.m_78299_(Level.f_46428_), "data"), p_18817_);
        this.f_18802_ = f_18798_.newThread(this::m_18838_);
        this.f_18802_.setUncaughtExceptionHandler((p_18825_, p_18826_) -> {
            f_18797_.error("Error upgrading world", p_18826_);
            this.f_18811_ = new TranslatableComponent("optimizeWorld.stage.failed");
            this.f_18805_ = true;
        });
        this.f_18802_.start();
    }

    public void m_18820_() {
        this.f_18804_ = false;
        try {
            this.f_18802_.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void m_18838_() {
        ImmutableMap.Builder \u00e2\u02dc\u01923;
        ResourceKey \u00e2\u02dc\u019222;
        this.f_18807_ = 0;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ResourceKey \u00e2\u02dc\u019222 : this.f_18799_) {
            \u00e2\u02dc\u01923 = this.m_18830_(\u00e2\u02dc\u019222);
            builder.put((Object)\u00e2\u02dc\u019222, \u00e2\u02dc\u01923.listIterator());
            this.f_18807_ += \u00e2\u02dc\u01923.size();
        }
        if (this.f_18807_ == 0) {
            this.f_18805_ = true;
            return;
        }
        float f = this.f_18807_;
        \u00e2\u02dc\u019222 = builder.build();
        \u00e2\u02dc\u01923 = ImmutableMap.builder();
        for (ResourceKey resourceKey : this.f_18799_) {
            File file = this.f_18801_.m_78299_(resourceKey);
            \u00e2\u02dc\u01923.put((Object)resourceKey, (Object)new ChunkStorage(new File(file, "region"), this.f_18803_, true));
        }
        ImmutableMap immutableMap = \u00e2\u02dc\u01923.build();
        long \u00e2\u02dc\u01924 = Util.m_137550_();
        this.f_18811_ = new TranslatableComponent("optimizeWorld.stage.upgrading");
        while (this.f_18804_) {
            boolean bl = false;
            float \u00e2\u02dc\u01925 = 0.0f;
            for (ResourceKey resourceKey : this.f_18799_) {
                ListIterator listIterator = (ListIterator)\u00e2\u02dc\u019222.get(resourceKey);
                ChunkStorage \u00e2\u02dc\u01926 = (ChunkStorage)immutableMap.get((Object)resourceKey);
                if (listIterator.hasNext()) {
                    ChunkPos chunkPos = (ChunkPos)listIterator.next();
                    boolean \u00e2\u02dc\u01927 = false;
                    try {
                        CompoundTag compoundTag = \u00e2\u02dc\u01926.m_63512_(chunkPos);
                        if (compoundTag != null) {
                            boolean bl2;
                            int n = ChunkStorage.m_63505_(compoundTag);
                            CompoundTag \u00e2\u02dc\u01928 = \u00e2\u02dc\u01926.m_63507_(resourceKey, () -> this.f_18813_, compoundTag);
                            CompoundTag \u00e2\u02dc\u01929 = \u00e2\u02dc\u01928.m_128469_("Level");
                            ChunkPos \u00e2\u02dc\u019210 = new ChunkPos(\u00e2\u02dc\u01929.m_128451_("xPos"), \u00e2\u02dc\u01929.m_128451_("zPos"));
                            if (!\u00e2\u02dc\u019210.equals(chunkPos)) {
                                f_18797_.warn("Chunk {} has invalid position {}", (Object)chunkPos, (Object)\u00e2\u02dc\u019210);
                            }
                            boolean bl3 = bl2 = n < SharedConstants.m_136187_().getWorldVersion();
                            if (this.f_18800_) {
                                bl2 = bl2 || \u00e2\u02dc\u01929.m_128441_("Heightmaps");
                                \u00e2\u02dc\u01929.m_128473_("Heightmaps");
                                bl2 = bl2 || \u00e2\u02dc\u01929.m_128441_("isLightOn");
                                \u00e2\u02dc\u01929.m_128473_("isLightOn");
                            }
                            if (bl2) {
                                \u00e2\u02dc\u01926.m_63502_(chunkPos, \u00e2\u02dc\u01928);
                                \u00e2\u02dc\u01927 = true;
                            }
                        }
                    }
                    catch (ReportedException reportedException) {
                        Throwable throwable = reportedException.getCause();
                        if (throwable instanceof IOException) {
                            f_18797_.error("Error upgrading chunk {}", (Object)chunkPos, (Object)throwable);
                        }
                        throw reportedException;
                    }
                    catch (IOException iOException) {
                        f_18797_.error("Error upgrading chunk {}", (Object)chunkPos, (Object)iOException);
                    }
                    if (\u00e2\u02dc\u01927) {
                        ++this.f_18808_;
                    } else {
                        ++this.f_18809_;
                    }
                    bl = true;
                }
                float \u00e2\u02dc\u019211 = (float)listIterator.nextIndex() / f;
                this.f_18810_.put((Object)resourceKey, \u00e2\u02dc\u019211);
                \u00e2\u02dc\u01925 += \u00e2\u02dc\u019211;
            }
            this.f_18806_ = \u00e2\u02dc\u01925;
            if (bl) continue;
            this.f_18804_ = false;
        }
        this.f_18811_ = new TranslatableComponent("optimizeWorld.stage.finished");
        for (ChunkStorage chunkStorage : immutableMap.values()) {
            try {
                chunkStorage.close();
            }
            catch (IOException iOException) {
                f_18797_.error("Error upgrading chunk", (Throwable)iOException);
            }
        }
        this.f_18813_.m_78151_();
        \u00e2\u02dc\u01924 = Util.m_137550_() - \u00e2\u02dc\u01924;
        f_18797_.info("World optimizaton finished after {} ms", (Object)\u00e2\u02dc\u01924);
        this.f_18805_ = true;
    }

    private List<ChunkPos> m_18830_(ResourceKey<Level> p_18831_) {
        File file = this.f_18801_.m_78299_(p_18831_);
        \u00e2\u02dc\u0192 = new File(file, "region");
        File[] \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192.listFiles((p_18822_, p_18823_) -> p_18823_.endsWith(".mca"));
        if (\u00e2\u02dc\u01922 == null) {
            return ImmutableList.of();
        }
        ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
        for (File file2 : \u00e2\u02dc\u01922) {
            Matcher matcher = f_18812_.matcher(file2.getName());
            if (!matcher.matches()) continue;
            int \u00e2\u02dc\u01924 = Integer.parseInt(matcher.group(1)) << 5;
            int \u00e2\u02dc\u01925 = Integer.parseInt(matcher.group(2)) << 5;
            try (RegionFile regionFile = new RegionFile(file2, \u00e2\u02dc\u0192, true);){
                for (int i = 0; i < 32; ++i) {
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 32; ++\u00e2\u02dc\u0192) {
                        ChunkPos chunkPos = new ChunkPos(i + \u00e2\u02dc\u01924, \u00e2\u02dc\u0192 + \u00e2\u02dc\u01925);
                        if (!regionFile.m_63673_(chunkPos)) continue;
                        \u00e2\u02dc\u01923.add(chunkPos);
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return \u00e2\u02dc\u01923;
    }

    public boolean m_18829_() {
        return this.f_18805_;
    }

    public ImmutableSet<ResourceKey<Level>> m_18832_() {
        return this.f_18799_;
    }

    public float m_18827_(ResourceKey<Level> p_18828_) {
        return this.f_18810_.getFloat(p_18828_);
    }

    public float m_18833_() {
        return this.f_18806_;
    }

    public int m_18834_() {
        return this.f_18807_;
    }

    public int m_18835_() {
        return this.f_18808_;
    }

    public int m_18836_() {
        return this.f_18809_;
    }

    public Component m_18837_() {
        return this.f_18811_;
    }
}

