/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.ParticleArgument;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.PushReaction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class AreaEffectCloud
extends Entity {
    private static final Logger f_19696_ = LogManager.getLogger();
    private static final int f_146782_ = 5;
    private static final EntityDataAccessor<Float> f_19697_ = SynchedEntityData.m_135353_(AreaEffectCloud.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> f_19698_ = SynchedEntityData.m_135353_(AreaEffectCloud.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> f_19699_ = SynchedEntityData.m_135353_(AreaEffectCloud.class, EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ParticleOptions> f_19700_ = SynchedEntityData.m_135353_(AreaEffectCloud.class, EntityDataSerializers.f_135036_);
    private static final float f_146781_ = 32.0f;
    private Potion f_19701_ = Potions.f_43598_;
    private final List<MobEffectInstance> f_19685_ = Lists.newArrayList();
    private final Map<Entity, Integer> f_19686_ = Maps.newHashMap();
    private int f_19687_ = 600;
    private int f_19688_ = 20;
    private int f_19689_ = 20;
    private boolean f_19690_;
    private int f_19691_;
    private float f_19692_;
    private float f_19693_;
    @Nullable
    private LivingEntity f_19694_;
    @Nullable
    private UUID f_19695_;

    public AreaEffectCloud(EntityType<? extends AreaEffectCloud> p_19704_, Level p_19705_) {
        super(p_19704_, p_19705_);
        this.f_19794_ = true;
        this.m_19712_(3.0f);
    }

    public AreaEffectCloud(Level p_19707_, double p_19708_, double p_19709_, double p_19710_) {
        this((EntityType<? extends AreaEffectCloud>)EntityType.f_20476_, p_19707_);
        this.m_6034_(p_19708_, p_19709_, p_19710_);
    }

    @Override
    protected void m_8097_() {
        this.m_20088_().m_135372_(f_19698_, 0);
        this.m_20088_().m_135372_(f_19697_, Float.valueOf(0.5f));
        this.m_20088_().m_135372_(f_19699_, false);
        this.m_20088_().m_135372_(f_19700_, ParticleTypes.f_123811_);
    }

    public void m_19712_(float p_19713_) {
        if (!this.f_19853_.f_46443_) {
            this.m_20088_().m_135381_(f_19697_, Float.valueOf(Mth.m_14036_(p_19713_, 0.0f, 32.0f)));
        }
    }

    @Override
    public void m_6210_() {
        double d = this.m_20185_();
        \u00e2\u02dc\u0192 = this.m_20186_();
        \u00e2\u02dc\u0192 = this.m_20189_();
        super.m_6210_();
        this.m_6034_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
    }

    public float m_19743_() {
        return this.m_20088_().m_135370_(f_19697_).floatValue();
    }

    public void m_19722_(Potion p_19723_) {
        this.f_19701_ = p_19723_;
        if (!this.f_19690_) {
            this.m_19750_();
        }
    }

    private void m_19750_() {
        if (this.f_19701_ == Potions.f_43598_ && this.f_19685_.isEmpty()) {
            this.m_20088_().m_135381_(f_19698_, 0);
        } else {
            this.m_20088_().m_135381_(f_19698_, PotionUtils.m_43564_(PotionUtils.m_43561_(this.f_19701_, this.f_19685_)));
        }
    }

    public void m_19716_(MobEffectInstance p_19717_) {
        this.f_19685_.add(p_19717_);
        if (!this.f_19690_) {
            this.m_19750_();
        }
    }

    public int m_19744_() {
        return this.m_20088_().m_135370_(f_19698_);
    }

    public void m_19714_(int p_19715_) {
        this.f_19690_ = true;
        this.m_20088_().m_135381_(f_19698_, p_19715_);
    }

    public ParticleOptions m_19745_() {
        return this.m_20088_().m_135370_(f_19700_);
    }

    public void m_19724_(ParticleOptions p_19725_) {
        this.m_20088_().m_135381_(f_19700_, p_19725_);
    }

    protected void m_19730_(boolean p_19731_) {
        this.m_20088_().m_135381_(f_19699_, p_19731_);
    }

    public boolean m_19747_() {
        return this.m_20088_().m_135370_(f_19699_);
    }

    public int m_19748_() {
        return this.f_19687_;
    }

    public void m_19734_(int p_19735_) {
        this.f_19687_ = p_19735_;
    }

    @Override
    public void m_8119_() {
        block20: {
            ArrayList \u00e2\u02dc\u019210;
            float \u00e2\u02dc\u01922;
            block21: {
                boolean bl;
                block19: {
                    float \u00e2\u02dc\u01924;
                    super.m_8119_();
                    boolean bl2 = this.m_19747_();
                    \u00e2\u02dc\u01922 = this.m_19743_();
                    if (!this.f_19853_.f_46443_) break block19;
                    if (bl2 && this.f_19796_.nextBoolean()) {
                        return;
                    }
                    ParticleOptions \u00e2\u02dc\u01923 = this.m_19745_();
                    if (bl2) {
                        int n = 2;
                        \u00e2\u02dc\u01924 = 0.2f;
                    } else {
                        n = Mth.m_14167_((float)Math.PI * \u00e2\u02dc\u01922 * \u00e2\u02dc\u01922);
                        \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922;
                    }
                    for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < n; ++\u00e2\u02dc\u0192) {
                        double d;
                        float \u00e2\u02dc\u01925 = this.f_19796_.nextFloat() * ((float)Math.PI * 2);
                        float \u00e2\u02dc\u01926 = Mth.m_14116_(this.f_19796_.nextFloat()) * \u00e2\u02dc\u01924;
                        double \u00e2\u02dc\u01927 = this.m_20185_() + (double)(Mth.m_14089_(\u00e2\u02dc\u01925) * \u00e2\u02dc\u01926);
                        double \u00e2\u02dc\u01928 = this.m_20186_();
                        double \u00e2\u02dc\u01929 = this.m_20189_() + (double)(Mth.m_14031_(\u00e2\u02dc\u01925) * \u00e2\u02dc\u01926);
                        if (\u00e2\u02dc\u01923.m_6012_() == ParticleTypes.f_123811_) {
                            \u00e2\u02dc\u0192 = bl2 && this.f_19796_.nextBoolean() ? 0xFFFFFF : this.m_19744_();
                            d = (float)(\u00e2\u02dc\u0192 >> 16 & 0xFF) / 255.0f;
                            \u00e2\u02dc\u0192 = (float)(\u00e2\u02dc\u0192 >> 8 & 0xFF) / 255.0f;
                            \u00e2\u02dc\u0192 = (float)(\u00e2\u02dc\u0192 & 0xFF) / 255.0f;
                        } else if (bl2) {
                            d = 0.0;
                            \u00e2\u02dc\u0192 = 0.0;
                            \u00e2\u02dc\u0192 = 0.0;
                        } else {
                            d = (0.5 - this.f_19796_.nextDouble()) * 0.15;
                            \u00e2\u02dc\u0192 = 0.01f;
                            \u00e2\u02dc\u0192 = (0.5 - this.f_19796_.nextDouble()) * 0.15;
                        }
                        this.f_19853_.m_7107_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01927, \u00e2\u02dc\u01928, \u00e2\u02dc\u01929, d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    }
                    break block20;
                }
                if (this.f_19797_ >= this.f_19688_ + this.f_19687_) {
                    this.m_146870_();
                    return;
                }
                boolean bl3 = bl = this.f_19797_ < this.f_19688_;
                if (bl2 != bl) {
                    this.m_19730_(bl);
                }
                if (bl) {
                    return;
                }
                if (this.f_19693_ != 0.0f) {
                    if ((\u00e2\u02dc\u01922 += this.f_19693_) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.m_19712_(\u00e2\u02dc\u01922);
                }
                if (this.f_19797_ % 5 != 0) break block20;
                this.f_19686_.entrySet().removeIf(p_146784_ -> this.f_19797_ >= (Integer)p_146784_.getValue());
                \u00e2\u02dc\u019210 = Lists.newArrayList();
                for (MobEffectInstance mobEffectInstance : this.f_19701_.m_43488_()) {
                    \u00e2\u02dc\u019210.add(new MobEffectInstance(mobEffectInstance.m_19544_(), mobEffectInstance.m_19557_() / 4, mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_()));
                }
                \u00e2\u02dc\u019210.addAll(this.f_19685_);
                if (!\u00e2\u02dc\u019210.isEmpty()) break block21;
                this.f_19686_.clear();
                break block20;
            }
            List<LivingEntity> list = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_());
            if (list.isEmpty()) break block20;
            for (LivingEntity livingEntity : list) {
                if (this.f_19686_.containsKey(livingEntity) || !livingEntity.m_5801_() || !((\u00e2\u02dc\u0192 = (\u00e2\u02dc\u0192 = livingEntity.m_20185_() - this.m_20185_()) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = livingEntity.m_20189_() - this.m_20189_()) * \u00e2\u02dc\u0192) <= (double)(\u00e2\u02dc\u01922 * \u00e2\u02dc\u01922))) continue;
                this.f_19686_.put(livingEntity, this.f_19797_ + this.f_19689_);
                for (MobEffectInstance mobEffectInstance : \u00e2\u02dc\u019210) {
                    if (mobEffectInstance.m_19544_().m_8093_()) {
                        mobEffectInstance.m_19544_().m_19461_(this, this.m_19749_(), livingEntity, mobEffectInstance.m_19564_(), 0.5);
                        continue;
                    }
                    livingEntity.m_147207_(new MobEffectInstance(mobEffectInstance), this);
                }
                if (this.f_19692_ != 0.0f) {
                    if ((\u00e2\u02dc\u01922 += this.f_19692_) < 0.5f) {
                        this.m_146870_();
                        return;
                    }
                    this.m_19712_(\u00e2\u02dc\u01922);
                }
                if (this.f_19691_ == 0) continue;
                this.f_19687_ += this.f_19691_;
                if (this.f_19687_ > 0) continue;
                this.m_146870_();
                return;
            }
        }
    }

    public float m_146787_() {
        return this.f_19692_;
    }

    public void m_19732_(float p_19733_) {
        this.f_19692_ = p_19733_;
    }

    public float m_146788_() {
        return this.f_19693_;
    }

    public void m_19738_(float p_19739_) {
        this.f_19693_ = p_19739_;
    }

    public int m_146789_() {
        return this.f_19691_;
    }

    public void m_146785_(int p_146786_) {
        this.f_19691_ = p_146786_;
    }

    public int m_146790_() {
        return this.f_19688_;
    }

    public void m_19740_(int p_19741_) {
        this.f_19688_ = p_19741_;
    }

    public void m_19718_(@Nullable LivingEntity p_19719_) {
        this.f_19694_ = p_19719_;
        this.f_19695_ = p_19719_ == null ? null : p_19719_.m_142081_();
    }

    @Nullable
    public LivingEntity m_19749_() {
        Entity entity;
        if (this.f_19694_ == null && this.f_19695_ != null && this.f_19853_ instanceof ServerLevel && (entity = ((ServerLevel)this.f_19853_).m_8791_(this.f_19695_)) instanceof LivingEntity) {
            this.f_19694_ = (LivingEntity)entity;
        }
        return this.f_19694_;
    }

    @Override
    protected void m_7378_(CompoundTag p_19727_) {
        this.f_19797_ = p_19727_.m_128451_("Age");
        this.f_19687_ = p_19727_.m_128451_("Duration");
        this.f_19688_ = p_19727_.m_128451_("WaitTime");
        this.f_19689_ = p_19727_.m_128451_("ReapplicationDelay");
        this.f_19691_ = p_19727_.m_128451_("DurationOnUse");
        this.f_19692_ = p_19727_.m_128457_("RadiusOnUse");
        this.f_19693_ = p_19727_.m_128457_("RadiusPerTick");
        this.m_19712_(p_19727_.m_128457_("Radius"));
        if (p_19727_.m_128403_("Owner")) {
            this.f_19695_ = p_19727_.m_128342_("Owner");
        }
        if (p_19727_.m_128425_("Particle", 8)) {
            try {
                this.m_19724_(ParticleArgument.m_103944_(new StringReader(p_19727_.m_128461_("Particle"))));
            }
            catch (CommandSyntaxException commandSyntaxException) {
                f_19696_.warn("Couldn't load custom particle {}", (Object)p_19727_.m_128461_("Particle"), (Object)commandSyntaxException);
            }
        }
        if (p_19727_.m_128425_("Color", 99)) {
            this.m_19714_(p_19727_.m_128451_("Color"));
        }
        if (p_19727_.m_128425_("Potion", 8)) {
            this.m_19722_(PotionUtils.m_43577_(p_19727_));
        }
        if (p_19727_.m_128425_("Effects", 9)) {
            ListTag listTag = p_19727_.m_128437_("Effects", 10);
            this.f_19685_.clear();
            for (int i = 0; i < listTag.size(); ++i) {
                MobEffectInstance mobEffectInstance = MobEffectInstance.m_19560_(listTag.m_128728_(i));
                if (mobEffectInstance == null) continue;
                this.m_19716_(mobEffectInstance);
            }
        }
    }

    @Override
    protected void m_7380_(CompoundTag p_19737_) {
        p_19737_.m_128405_("Age", this.f_19797_);
        p_19737_.m_128405_("Duration", this.f_19687_);
        p_19737_.m_128405_("WaitTime", this.f_19688_);
        p_19737_.m_128405_("ReapplicationDelay", this.f_19689_);
        p_19737_.m_128405_("DurationOnUse", this.f_19691_);
        p_19737_.m_128350_("RadiusOnUse", this.f_19692_);
        p_19737_.m_128350_("RadiusPerTick", this.f_19693_);
        p_19737_.m_128350_("Radius", this.m_19743_());
        p_19737_.m_128359_("Particle", this.m_19745_().m_5942_());
        if (this.f_19695_ != null) {
            p_19737_.m_128362_("Owner", this.f_19695_);
        }
        if (this.f_19690_) {
            p_19737_.m_128405_("Color", this.m_19744_());
        }
        if (this.f_19701_ != Potions.f_43598_) {
            p_19737_.m_128359_("Potion", Registry.f_122828_.m_7981_(this.f_19701_).toString());
        }
        if (!this.f_19685_.isEmpty()) {
            ListTag listTag = new ListTag();
            for (MobEffectInstance mobEffectInstance : this.f_19685_) {
                listTag.add(mobEffectInstance.m_19555_(new CompoundTag()));
            }
            p_19737_.m_128365_("Effects", listTag);
        }
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_19729_) {
        if (f_19697_.equals(p_19729_)) {
            this.m_6210_();
        }
        super.m_7350_(p_19729_);
    }

    public Potion m_146791_() {
        return this.f_19701_;
    }

    @Override
    public PushReaction m_7752_() {
        return PushReaction.IGNORE;
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket(this);
    }

    @Override
    public EntityDimensions m_6972_(Pose p_19721_) {
        return EntityDimensions.m_20395_(this.m_19743_() * 2.0f, 0.5f);
    }
}

