/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.collect.Sets;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LightningRodBlock;
import net.minecraft.world.level.block.WeatheringCopper;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LightningBolt
extends Entity {
    private static final int f_147136_ = 2;
    private static final double f_147137_ = 3.0;
    private static final double f_147138_ = 15.0;
    private int f_20860_;
    public long f_20859_;
    private int f_20861_;
    private boolean f_20862_;
    @Nullable
    private ServerPlayer f_20863_;
    private final Set<Entity> f_147134_ = Sets.newHashSet();
    private int f_147135_;

    public LightningBolt(EntityType<? extends LightningBolt> p_20865_, Level p_20866_) {
        super(p_20865_, p_20866_);
        this.f_19811_ = true;
        this.f_20860_ = 2;
        this.f_20859_ = this.f_19796_.nextLong();
        this.f_20861_ = this.f_19796_.nextInt(3) + 1;
    }

    public void m_20874_(boolean p_20875_) {
        this.f_20862_ = p_20875_;
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.WEATHER;
    }

    @Nullable
    public ServerPlayer m_147158_() {
        return this.f_20863_;
    }

    public void m_20879_(@Nullable ServerPlayer p_20880_) {
        this.f_20863_ = p_20880_;
    }

    private void m_147161_() {
        BlockPos blockPos = this.m_147162_();
        BlockState \u00e2\u02dc\u01922 = this.f_19853_.m_8055_(blockPos);
        if (\u00e2\u02dc\u01922.m_60713_(Blocks.f_152587_)) {
            ((LightningRodBlock)\u00e2\u02dc\u01922.m_60734_()).m_153760_(\u00e2\u02dc\u01922, this.f_19853_, blockPos);
        }
    }

    @Override
    public void m_8119_() {
        List<Entity> list;
        super.m_8119_();
        if (this.f_20860_ == 2) {
            if (this.f_19853_.m_5776_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12090_, SoundSource.WEATHER, 10000.0f, 0.8f + this.f_19796_.nextFloat() * 0.2f, false);
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12089_, SoundSource.WEATHER, 2.0f, 0.5f + this.f_19796_.nextFloat() * 0.2f, false);
            } else {
                Difficulty object = this.f_19853_.m_46791_();
                if (object == Difficulty.NORMAL || object == Difficulty.HARD) {
                    this.m_20870_(4);
                }
                this.m_147161_();
                LightningBolt.m_147150_(this.f_19853_, this.m_147162_());
                this.m_146850_(GameEvent.f_157772_);
            }
        }
        --this.f_20860_;
        if (this.f_20860_ < 0) {
            if (this.f_20861_ == 0) {
                if (this.f_19853_ instanceof ServerLevel) {
                    list = this.f_19853_.m_6249_(this, new AABB(this.m_20185_() - 15.0, this.m_20186_() - 15.0, this.m_20189_() - 15.0, this.m_20185_() + 15.0, this.m_20186_() + 6.0 + 15.0, this.m_20189_() + 15.0), p_147140_ -> p_147140_.m_6084_() && !this.f_147134_.contains(p_147140_));
                    for (ServerPlayer serverPlayer : ((ServerLevel)this.f_19853_).m_8795_(p_147157_ -> p_147157_.m_20270_(this) < 256.0f)) {
                        CriteriaTriggers.f_145089_.m_153391_(serverPlayer, this, list);
                    }
                }
                this.m_146870_();
            } else if (this.f_20860_ < -this.f_19796_.nextInt(10)) {
                --this.f_20861_;
                this.f_20860_ = 1;
                this.f_20859_ = this.f_19796_.nextLong();
                this.m_20870_(0);
            }
        }
        if (this.f_20860_ >= 0) {
            if (!(this.f_19853_ instanceof ServerLevel)) {
                this.f_19853_.m_6580_(2);
            } else if (!this.f_20862_) {
                list = this.f_19853_.m_6249_(this, new AABB(this.m_20185_() - 3.0, this.m_20186_() - 3.0, this.m_20189_() - 3.0, this.m_20185_() + 3.0, this.m_20186_() + 6.0 + 3.0, this.m_20189_() + 3.0), Entity::m_6084_);
                for (Entity entity : list) {
                    entity.m_8038_((ServerLevel)this.f_19853_, this);
                }
                this.f_147134_.addAll(list);
                if (this.f_20863_ != null) {
                    CriteriaTriggers.f_10554_.m_21721_(this.f_20863_, list);
                }
            }
        }
    }

    private BlockPos m_147162_() {
        Vec3 vec3 = this.m_20182_();
        return new BlockPos(vec3.f_82479_, vec3.f_82480_ - 1.0E-6, vec3.f_82481_);
    }

    private void m_20870_(int p_20871_) {
        if (this.f_20862_ || this.f_19853_.f_46443_ || !this.f_19853_.m_46469_().m_46207_(GameRules.f_46131_)) {
            return;
        }
        BlockPos blockPos = this.m_142538_();
        BlockState \u00e2\u02dc\u01922 = BaseFireBlock.m_49245_(this.f_19853_, blockPos);
        if (this.f_19853_.m_8055_(blockPos).m_60795_() && \u00e2\u02dc\u01922.m_60710_(this.f_19853_, blockPos)) {
            this.f_19853_.m_46597_(blockPos, \u00e2\u02dc\u01922);
            ++this.f_147135_;
        }
        for (int i = 0; i < p_20871_; ++i) {
            BlockPos blockPos2 = blockPos.m_142082_(this.f_19796_.nextInt(3) - 1, this.f_19796_.nextInt(3) - 1, this.f_19796_.nextInt(3) - 1);
            \u00e2\u02dc\u01922 = BaseFireBlock.m_49245_(this.f_19853_, blockPos2);
            if (!this.f_19853_.m_8055_(blockPos2).m_60795_() || !\u00e2\u02dc\u01922.m_60710_(this.f_19853_, blockPos2)) continue;
            this.f_19853_.m_46597_(blockPos2, \u00e2\u02dc\u01922);
            ++this.f_147135_;
        }
    }

    private static void m_147150_(Level p_147151_, BlockPos p_147152_) {
        BlockState \u00e2\u02dc\u01922;
        BlockState blockState = p_147151_.m_8055_(p_147152_);
        if (blockState.m_60713_(Blocks.f_152587_)) {
            BlockPos blockPos = p_147152_.m_142300_(blockState.m_61143_(LightningRodBlock.f_52588_).m_122424_());
            \u00e2\u02dc\u01922 = p_147151_.m_8055_(blockPos);
        } else {
            blockPos = p_147152_;
            \u00e2\u02dc\u01922 = blockState;
        }
        if (!(\u00e2\u02dc\u01922.m_60734_() instanceof WeatheringCopper)) {
            return;
        }
        p_147151_.m_46597_(blockPos, WeatheringCopper.m_154906_(p_147151_.m_8055_(blockPos)));
        BlockPos.MutableBlockPos mutableBlockPos = p_147152_.m_122032_();
        int \u00e2\u02dc\u01923 = p_147151_.f_46441_.nextInt(3) + 3;
        for (int i = 0; i < \u00e2\u02dc\u01923; ++i) {
            \u00e2\u02dc\u0192 = p_147151_.f_46441_.nextInt(8) + 1;
            LightningBolt.m_147145_(p_147151_, blockPos, mutableBlockPos, \u00e2\u02dc\u0192);
        }
    }

    private static void m_147145_(Level p_147146_, BlockPos p_147147_, BlockPos.MutableBlockPos p_147148_, int p_147149_) {
        p_147148_.m_122190_(p_147147_);
        for (int i = 0; i < p_147149_ && (\u00e2\u02dc\u0192 = LightningBolt.m_147153_(p_147146_, p_147148_)).isPresent(); ++i) {
            p_147148_.m_122190_(\u00e2\u02dc\u0192.get());
        }
    }

    private static Optional<BlockPos> m_147153_(Level p_147154_, BlockPos p_147155_) {
        for (BlockPos blockPos : BlockPos.m_175264_(p_147154_.f_46441_, 10, p_147155_, 1)) {
            BlockState blockState = p_147154_.m_8055_(blockPos);
            if (!(blockState.m_60734_() instanceof WeatheringCopper)) continue;
            WeatheringCopper.m_154899_(blockState).ifPresent(p_147144_ -> p_147154_.m_46597_(blockPos, (BlockState)p_147144_));
            p_147154_.m_46796_(3002, blockPos, -1);
            return Optional.of(blockPos);
        }
        return Optional.empty();
    }

    @Override
    public boolean m_6783_(double p_20869_) {
        double d = 64.0 * LightningBolt.m_20150_();
        return p_20869_ < d * d;
    }

    @Override
    protected void m_8097_() {
    }

    @Override
    protected void m_7378_(CompoundTag p_20873_) {
    }

    @Override
    protected void m_7380_(CompoundTag p_20877_) {
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddEntityPacket(this);
    }

    public int m_147159_() {
        return this.f_147135_;
    }

    public Stream<Entity> m_147160_() {
        return this.f_147134_.stream().filter(Entity::m_6084_);
    }
}

