/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity;

import com.google.common.base.Objects;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.BlockUtil;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.protocol.game.ClientboundAnimatePacket;
import net.minecraft.network.protocol.game.ClientboundEntityEventPacket;
import net.minecraft.network.protocol.game.ClientboundSetEquipmentPacket;
import net.minecraft.network.protocol.game.ClientboundTakeItemEntityPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.Tag;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.CombatTracker;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffectUtil;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SlotAccess;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.attributes.DefaultAttributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.entity.boss.wither.WitherBoss;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ElytraItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.item.enchantment.FrostWalkerEnchantment;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractSkullBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.HoneyBlock;
import net.minecraft.world.level.block.LadderBlock;
import net.minecraft.world.level.block.PowderSnowBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.PlayerTeam;
import org.apache.logging.log4j.Logger;

public abstract class LivingEntity
extends Entity {
    private static final UUID f_20929_ = UUID.fromString("662A6B8D-DA3E-4C1C-8813-96EA6097278D");
    private static final UUID f_20959_ = UUID.fromString("87f46a96-686f-4796-b035-22e16ee9e038");
    private static final UUID f_147184_ = UUID.fromString("1eaf83ff-7207-4596-b37a-d7a07b3ec4ce");
    private static final AttributeModifier f_20960_ = new AttributeModifier(f_20929_, "Sprinting speed boost", (double)0.3f, AttributeModifier.Operation.MULTIPLY_TOTAL);
    public static final int f_147166_ = 2;
    public static final int f_147167_ = 4;
    public static final int f_147168_ = 98;
    public static final int f_147169_ = 100;
    public static final int f_147170_ = 6;
    public static final int f_147171_ = 100;
    private static final int f_147178_ = 40;
    public static final double f_147172_ = 0.003;
    public static final double f_147173_ = 0.08;
    public static final int f_147174_ = 20;
    private static final int f_147179_ = 7;
    private static final int f_147180_ = 10;
    private static final int f_147181_ = 2;
    public static final int f_147175_ = 4;
    private static final double f_147182_ = 128.0;
    protected static final int f_147176_ = 1;
    protected static final int f_147177_ = 2;
    protected static final int f_147163_ = 4;
    protected static final EntityDataAccessor<Byte> f_20909_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Float> f_20961_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135029_);
    private static final EntityDataAccessor<Integer> f_20962_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> f_20963_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> f_20940_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> f_20941_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Optional<BlockPos>> f_20942_ = SynchedEntityData.m_135353_(LivingEntity.class, EntityDataSerializers.f_135039_);
    protected static final float f_147164_ = 1.74f;
    protected static final EntityDimensions f_20910_ = EntityDimensions.m_20398_(0.2f, 0.2f);
    public static final float f_147165_ = 0.5f;
    private final AttributeMap f_20943_;
    private final CombatTracker f_20944_ = new CombatTracker(this);
    private final Map<MobEffect, MobEffectInstance> f_20945_ = Maps.newHashMap();
    private final NonNullList<ItemStack> f_20946_ = NonNullList.m_122780_(2, ItemStack.f_41583_);
    private final NonNullList<ItemStack> f_20947_ = NonNullList.m_122780_(4, ItemStack.f_41583_);
    public boolean f_20911_;
    private boolean f_147183_ = false;
    public InteractionHand f_20912_;
    public int f_20913_;
    public int f_20914_;
    public int f_20915_;
    public int f_20916_;
    public int f_20917_;
    public float f_20918_;
    public int f_20919_;
    public float f_20920_;
    public float f_20921_;
    protected int f_20922_;
    public float f_20923_;
    public float f_20924_;
    public float f_20925_;
    public final int f_20926_ = 20;
    public final float f_20927_;
    public final float f_20928_;
    public float f_20883_;
    public float f_20884_;
    public float f_20885_;
    public float f_20886_;
    public float f_20887_ = 0.02f;
    @Nullable
    protected Player f_20888_;
    protected int f_20889_;
    protected boolean f_20890_;
    protected int f_20891_;
    protected float f_20892_;
    protected float f_20893_;
    protected float f_20894_;
    protected float f_20895_;
    protected float f_20896_;
    protected int f_20897_;
    protected float f_20898_;
    protected boolean f_20899_;
    public float f_20900_;
    public float f_20901_;
    public float f_20902_;
    protected int f_20903_;
    protected double f_20904_;
    protected double f_20905_;
    protected double f_20906_;
    protected double f_20907_;
    protected double f_20908_;
    protected double f_20933_;
    protected int f_20934_;
    private boolean f_20948_ = true;
    @Nullable
    private LivingEntity f_20949_;
    private int f_20950_;
    private LivingEntity f_20951_;
    private int f_20952_;
    private float f_20953_;
    private int f_20954_;
    private float f_20955_;
    protected ItemStack f_20935_ = ItemStack.f_41583_;
    protected int f_20936_;
    protected int f_20937_;
    private BlockPos f_20956_;
    private Optional<BlockPos> f_20957_ = Optional.empty();
    @Nullable
    private DamageSource f_20958_;
    private long f_20930_;
    protected int f_20938_;
    private float f_20931_;
    private float f_20932_;
    protected Brain<?> f_20939_;

    protected LivingEntity(EntityType<? extends LivingEntity> p_20966_, Level p_20967_) {
        super(p_20966_, p_20967_);
        this.f_20943_ = new AttributeMap(DefaultAttributes.m_22297_(p_20966_));
        this.m_21153_(this.m_21233_());
        this.f_19850_ = true;
        this.f_20928_ = (float)((Math.random() + 1.0) * (double)0.01f);
        this.m_20090_();
        this.f_20927_ = (float)Math.random() * 12398.0f;
        this.m_146922_((float)(Math.random() * 6.2831854820251465));
        this.f_20885_ = this.m_146908_();
        this.f_19793_ = 0.6f;
        NbtOps nbtOps = NbtOps.f_128958_;
        this.f_20939_ = this.m_8075_(new Dynamic((DynamicOps)nbtOps, (Object)((net.minecraft.nbt.Tag)nbtOps.createMap((Map)ImmutableMap.of((Object)nbtOps.createString("memories"), (Object)((net.minecraft.nbt.Tag)nbtOps.emptyMap()))))));
    }

    public Brain<?> m_6274_() {
        return this.f_20939_;
    }

    protected Brain.Provider<?> m_5490_() {
        return Brain.m_21923_(ImmutableList.of(), ImmutableList.of());
    }

    protected Brain<?> m_8075_(Dynamic<?> p_21069_) {
        return this.m_5490_().m_22073_(p_21069_);
    }

    @Override
    public void m_6074_() {
        this.m_6469_(DamageSource.f_19317_, Float.MAX_VALUE);
    }

    public boolean m_6549_(EntityType<?> p_21032_) {
        return true;
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(f_20909_, (byte)0);
        this.f_19804_.m_135372_(f_20962_, 0);
        this.f_19804_.m_135372_(f_20963_, false);
        this.f_19804_.m_135372_(f_20940_, 0);
        this.f_19804_.m_135372_(f_20941_, 0);
        this.f_19804_.m_135372_(f_20961_, Float.valueOf(1.0f));
        this.f_19804_.m_135372_(f_20942_, Optional.empty());
    }

    public static AttributeSupplier.Builder m_21183_() {
        return AttributeSupplier.m_22244_().m_22266_(Attributes.f_22276_).m_22266_(Attributes.f_22278_).m_22266_(Attributes.f_22279_).m_22266_(Attributes.f_22284_).m_22266_(Attributes.f_22285_);
    }

    @Override
    protected void m_7840_(double p_20990_, boolean p_20991_, BlockState p_20992_, BlockPos p_20993_) {
        if (!this.m_20069_()) {
            this.m_20074_();
        }
        if (!this.f_19853_.f_46443_ && p_20991_ && this.f_19789_ > 0.0f) {
            this.m_21185_();
            this.m_21186_();
        }
        if (!this.f_19853_.f_46443_ && this.f_19789_ > 3.0f && p_20991_) {
            float f = Mth.m_14167_(this.f_19789_ - 3.0f);
            if (!p_20992_.m_60795_()) {
                double d = Math.min((double)(0.2f + f / 15.0f), 2.5);
                int \u00e2\u02dc\u01922 = (int)(150.0 * d);
                ((ServerLevel)this.f_19853_).m_8767_(new BlockParticleOption(ParticleTypes.f_123794_, p_20992_), this.m_20185_(), this.m_20186_(), this.m_20189_(), \u00e2\u02dc\u01922, 0.0, 0.0, 0.0, 0.15f);
            }
        }
        super.m_7840_(p_20990_, p_20991_, p_20992_, p_20993_);
    }

    public boolean m_6040_() {
        return this.m_6336_() == MobType.f_21641_;
    }

    public float m_20998_(float p_20999_) {
        return Mth.m_14179_(p_20999_, this.f_20932_, this.f_20931_);
    }

    @Override
    public void m_6075_() {
        this.f_20920_ = this.f_20921_;
        if (this.f_19803_) {
            this.m_21257_().ifPresent(this::m_21080_);
        }
        if (this.m_6039_()) {
            this.m_21184_();
        }
        super.m_6075_();
        this.f_19853_.m_46473_().m_6180_("livingEntityBaseTick");
        boolean bl = this instanceof Player;
        if (this.m_6084_()) {
            if (this.m_5830_()) {
                this.m_6469_(DamageSource.f_19310_, 1.0f);
            } else if (bl && !this.f_19853_.m_6857_().m_61935_(this.m_142469_()) && (\u00e2\u02dc\u0192 = this.f_19853_.m_6857_().m_61925_(this) + this.f_19853_.m_6857_().m_61964_()) < 0.0 && (\u00e2\u02dc\u0192 = this.f_19853_.m_6857_().m_61965_()) > 0.0) {
                this.m_6469_(DamageSource.f_19310_, Math.max(1, Mth.m_14107_(-\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192)));
            }
        }
        if (this.m_5825_() || this.f_19853_.f_46443_) {
            this.m_20095_();
        }
        boolean bl2 = \u00e2\u02dc\u0192 = bl && ((Player)this).m_150110_().f_35934_;
        if (this.m_6084_()) {
            Object object;
            if (this.m_19941_(FluidTags.f_13131_) && !this.f_19853_.m_8055_(new BlockPos(this.m_20185_(), this.m_20188_(), this.m_20189_())).m_60713_(Blocks.f_50628_)) {
                if (!(this.m_6040_() || MobEffectUtil.m_19588_(this) || \u00e2\u02dc\u0192)) {
                    this.m_20301_(this.m_7302_(this.m_20146_()));
                    if (this.m_20146_() == -20) {
                        this.m_20301_(0);
                        object = this.m_20184_();
                        for (int i = 0; i < 8; ++i) {
                            double d = this.f_19796_.nextDouble() - this.f_19796_.nextDouble();
                            \u00e2\u02dc\u0192 = this.f_19796_.nextDouble() - this.f_19796_.nextDouble();
                            \u00e2\u02dc\u0192 = this.f_19796_.nextDouble() - this.f_19796_.nextDouble();
                            this.f_19853_.m_7106_(ParticleTypes.f_123795_, this.m_20185_() + d, this.m_20186_() + \u00e2\u02dc\u0192, this.m_20189_() + \u00e2\u02dc\u0192, ((Vec3)object).f_82479_, ((Vec3)object).f_82480_, ((Vec3)object).f_82481_);
                        }
                        this.m_6469_(DamageSource.f_19312_, 2.0f);
                    }
                }
                if (!this.f_19853_.f_46443_ && this.m_20159_() && this.m_20202_() != null && !this.m_20202_().m_6146_()) {
                    this.m_8127_();
                }
            } else if (this.m_20146_() < this.m_6062_()) {
                this.m_20301_(this.m_7305_(this.m_20146_()));
            }
            if (!this.f_19853_.f_46443_ && !Objects.equal((Object)this.f_20956_, (Object)(object = this.m_142538_()))) {
                this.f_20956_ = object;
                this.m_5806_((BlockPos)object);
            }
        }
        if (this.m_6084_() && (this.m_20071_() || this.f_146808_)) {
            if (!this.f_19853_.f_46443_ && this.f_146810_) {
                this.m_146873_();
            }
            this.m_20095_();
        }
        if (this.f_20916_ > 0) {
            --this.f_20916_;
        }
        if (this.f_19802_ > 0 && !(this instanceof ServerPlayer)) {
            --this.f_19802_;
        }
        if (this.m_21224_()) {
            this.m_6153_();
        }
        if (this.f_20889_ > 0) {
            --this.f_20889_;
        } else {
            this.f_20888_ = null;
        }
        if (this.f_20951_ != null && !this.f_20951_.m_6084_()) {
            this.f_20951_ = null;
        }
        if (this.f_20949_ != null) {
            if (!this.f_20949_.m_6084_()) {
                this.m_6703_(null);
            } else if (this.f_19797_ - this.f_20950_ > 100) {
                this.m_6703_(null);
            }
        }
        this.m_21217_();
        this.f_20895_ = this.f_20894_;
        this.f_20884_ = this.f_20883_;
        this.f_20886_ = this.f_20885_;
        this.f_19859_ = this.m_146908_();
        this.f_19860_ = this.m_146909_();
        this.f_19853_.m_46473_().m_7238_();
    }

    public boolean m_6039_() {
        return this.f_19797_ % 5 == 0 && this.m_20184_().f_82479_ != 0.0 && this.m_20184_().f_82481_ != 0.0 && !this.m_5833_() && EnchantmentHelper.m_44942_(this) && this.m_6046_();
    }

    protected void m_21184_() {
        Vec3 vec3 = this.m_20184_();
        this.f_19853_.m_7106_(ParticleTypes.f_123746_, this.m_20185_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), this.m_20186_() + 0.1, this.m_20189_() + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_(), vec3.f_82479_ * -0.2, 0.1, vec3.f_82481_ * -0.2);
        float \u00e2\u02dc\u01922 = this.f_19796_.nextFloat() * 0.4f + this.f_19796_.nextFloat() > 0.9f ? 0.6f : 0.0f;
        this.m_5496_(SoundEvents.f_12404_, \u00e2\u02dc\u01922, 0.6f + this.f_19796_.nextFloat() * 0.4f);
    }

    protected boolean m_6046_() {
        return this.f_19853_.m_8055_(this.m_20099_()).m_60620_(BlockTags.f_13080_);
    }

    @Override
    protected float m_6041_() {
        if (this.m_6046_() && EnchantmentHelper.m_44836_(Enchantments.f_44976_, this) > 0) {
            return 1.0f;
        }
        return super.m_6041_();
    }

    protected boolean m_6757_(BlockState p_21140_) {
        return !p_21140_.m_60795_() || this.m_21255_();
    }

    protected void m_21185_() {
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return;
        }
        if (attributeInstance.m_22111_(f_20959_) != null) {
            attributeInstance.m_22120_(f_20959_);
        }
    }

    protected void m_21186_() {
        int n;
        if (!this.m_20075_().m_60795_() && (n = EnchantmentHelper.m_44836_(Enchantments.f_44976_, this)) > 0 && this.m_6046_()) {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
            if (attributeInstance == null) {
                return;
            }
            attributeInstance.m_22118_(new AttributeModifier(f_20959_, "Soul speed boost", (double)(0.03f * (1.0f + (float)n * 0.35f)), AttributeModifier.Operation.ADDITION));
            if (this.m_21187_().nextFloat() < 0.04f) {
                ItemStack itemStack = this.m_6844_(EquipmentSlot.FEET);
                itemStack.m_41622_(1, this, p_21301_ -> p_21301_.m_21166_(EquipmentSlot.FEET));
            }
        }
    }

    protected void m_147225_() {
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (attributeInstance == null) {
            return;
        }
        if (attributeInstance.m_22111_(f_147184_) != null) {
            attributeInstance.m_22120_(f_147184_);
        }
    }

    protected void m_147226_() {
        int n;
        if (!this.m_20075_().m_60795_() && (n = this.m_146888_()) > 0) {
            AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
            if (attributeInstance == null) {
                return;
            }
            float \u00e2\u02dc\u01922 = -0.05f * this.m_146889_();
            attributeInstance.m_22118_(new AttributeModifier(f_147184_, "Powder snow slow", (double)\u00e2\u02dc\u01922, AttributeModifier.Operation.ADDITION));
        }
    }

    protected void m_5806_(BlockPos p_21175_) {
        int n = EnchantmentHelper.m_44836_(Enchantments.f_44974_, this);
        if (n > 0) {
            FrostWalkerEnchantment.m_45018_(this, this.f_19853_, p_21175_, n);
        }
        if (this.m_6757_(this.m_20075_())) {
            this.m_21185_();
        }
        this.m_21186_();
    }

    public boolean m_6162_() {
        return false;
    }

    public float m_6134_() {
        return this.m_6162_() ? 0.5f : 1.0f;
    }

    protected boolean m_6129_() {
        return true;
    }

    @Override
    public boolean m_6146_() {
        return false;
    }

    protected void m_6153_() {
        ++this.f_20919_;
        if (this.f_20919_ == 20 && !this.f_19853_.m_5776_()) {
            this.f_19853_.m_7605_(this, (byte)60);
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    protected boolean m_6149_() {
        return !this.m_6162_();
    }

    protected boolean m_6125_() {
        return !this.m_6162_();
    }

    protected int m_7302_(int p_21303_) {
        int n = EnchantmentHelper.m_44918_(this);
        if (n > 0 && this.f_19796_.nextInt(n + 1) > 0) {
            return p_21303_;
        }
        return p_21303_ - 1;
    }

    protected int m_7305_(int p_21307_) {
        return Math.min(p_21307_ + 4, this.m_6062_());
    }

    protected int m_6552_(Player p_21201_) {
        return 0;
    }

    protected boolean m_6124_() {
        return false;
    }

    public Random m_21187_() {
        return this.f_19796_;
    }

    @Nullable
    public LivingEntity m_142581_() {
        return this.f_20949_;
    }

    public int m_21213_() {
        return this.f_20950_;
    }

    public void m_6598_(@Nullable Player p_21248_) {
        this.f_20888_ = p_21248_;
        this.f_20889_ = this.f_19797_;
    }

    public void m_6703_(@Nullable LivingEntity p_21039_) {
        this.f_20949_ = p_21039_;
        this.f_20950_ = this.f_19797_;
    }

    @Nullable
    public LivingEntity m_21214_() {
        return this.f_20951_;
    }

    public int m_21215_() {
        return this.f_20952_;
    }

    public void m_21335_(Entity p_21336_) {
        this.f_20951_ = p_21336_ instanceof LivingEntity ? (LivingEntity)p_21336_ : null;
        this.f_20952_ = this.f_19797_;
    }

    public int m_21216_() {
        return this.f_20891_;
    }

    public void m_21310_(int p_21311_) {
        this.f_20891_ = p_21311_;
    }

    public boolean m_147223_() {
        return this.f_147183_;
    }

    public void m_147244_(boolean p_147245_) {
        this.f_147183_ = p_147245_;
    }

    protected void m_147218_(ItemStack p_147219_) {
        SoundEvent soundEvent = p_147219_.m_150920_();
        if (p_147219_.m_41619_() || soundEvent == null || this.m_5833_()) {
            return;
        }
        this.m_146850_(GameEvent.f_157811_);
        this.m_5496_(soundEvent, 1.0f, 1.0f);
    }

    @Override
    public void m_7380_(CompoundTag p_21145_) {
        DataResult<net.minecraft.nbt.Tag> dataResult;
        p_21145_.m_128350_("Health", this.m_21223_());
        p_21145_.m_128376_("HurtTime", (short)this.f_20916_);
        p_21145_.m_128405_("HurtByTimestamp", this.f_20950_);
        p_21145_.m_128376_("DeathTime", (short)this.f_20919_);
        p_21145_.m_128350_("AbsorptionAmount", this.m_6103_());
        p_21145_.m_128365_("Attributes", this.m_21204_().m_22180_());
        if (!this.f_20945_.isEmpty()) {
            dataResult = new DataResult<net.minecraft.nbt.Tag>();
            for (MobEffectInstance mobEffectInstance : this.f_20945_.values()) {
                dataResult.add(mobEffectInstance.m_19555_(new CompoundTag()));
            }
            p_21145_.m_128365_("ActiveEffects", (net.minecraft.nbt.Tag)dataResult);
        }
        p_21145_.m_128379_("FallFlying", this.m_21255_());
        this.m_21257_().ifPresent(p_21099_ -> {
            p_21145_.m_128405_("SleepingX", p_21099_.m_123341_());
            p_21145_.m_128405_("SleepingY", p_21099_.m_123342_());
            p_21145_.m_128405_("SleepingZ", p_21099_.m_123343_());
        });
        dataResult = this.f_20939_.m_21914_(NbtOps.f_128958_);
        dataResult.resultOrPartial(arg_0 -> ((Logger)f_19849_).error(arg_0)).ifPresent(p_21102_ -> p_21145_.m_128365_("Brain", (net.minecraft.nbt.Tag)p_21102_));
    }

    @Override
    public void m_7378_(CompoundTag p_21096_) {
        Object object;
        this.m_7911_(p_21096_.m_128457_("AbsorptionAmount"));
        if (p_21096_.m_128425_("Attributes", 9) && this.f_19853_ != null && !this.f_19853_.f_46443_) {
            this.m_21204_().m_22168_(p_21096_.m_128437_("Attributes", 10));
        }
        if (p_21096_.m_128425_("ActiveEffects", 9)) {
            object = p_21096_.m_128437_("ActiveEffects", 10);
            for (int i = 0; i < ((ListTag)object).size(); ++i) {
                CompoundTag compoundTag = ((ListTag)object).m_128728_(i);
                MobEffectInstance \u00e2\u02dc\u01922 = MobEffectInstance.m_19560_(compoundTag);
                if (\u00e2\u02dc\u01922 == null) continue;
                this.f_20945_.put(\u00e2\u02dc\u01922.m_19544_(), \u00e2\u02dc\u01922);
            }
        }
        if (p_21096_.m_128425_("Health", 99)) {
            this.m_21153_(p_21096_.m_128457_("Health"));
        }
        this.f_20916_ = p_21096_.m_128448_("HurtTime");
        this.f_20919_ = p_21096_.m_128448_("DeathTime");
        this.f_20950_ = p_21096_.m_128451_("HurtByTimestamp");
        if (p_21096_.m_128425_("Team", 8)) {
            object = p_21096_.m_128461_("Team");
            PlayerTeam \u00e2\u02dc\u01923 = this.f_19853_.m_6188_().m_83489_((String)object);
            boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 != null && this.f_19853_.m_6188_().m_6546_(this.m_20149_(), \u00e2\u02dc\u01923);
            if (!\u00e2\u02dc\u0192) {
                f_19849_.warn("Unable to add mob to team \"{}\" (that team probably doesn't exist)", object);
            }
        }
        if (p_21096_.m_128471_("FallFlying")) {
            this.m_20115_(7, true);
        }
        if (p_21096_.m_128425_("SleepingX", 99) && p_21096_.m_128425_("SleepingY", 99) && p_21096_.m_128425_("SleepingZ", 99)) {
            object = new BlockPos(p_21096_.m_128451_("SleepingX"), p_21096_.m_128451_("SleepingY"), p_21096_.m_128451_("SleepingZ"));
            this.m_21250_((BlockPos)object);
            this.f_19804_.m_135381_(f_19806_, Pose.SLEEPING);
            if (!this.f_19803_) {
                this.m_21080_((BlockPos)object);
            }
        }
        if (p_21096_.m_128425_("Brain", 10)) {
            this.f_20939_ = this.m_8075_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_21096_.m_128423_("Brain")));
        }
    }

    protected void m_21217_() {
        Iterator<MobEffect> iterator = this.f_20945_.keySet().iterator();
        try {
            while (iterator.hasNext()) {
                MobEffect mobEffect = iterator.next();
                MobEffectInstance \u00e2\u02dc\u01922 = this.f_20945_.get(mobEffect);
                if (!\u00e2\u02dc\u01922.m_19552_(this, () -> this.m_141973_(\u00e2\u02dc\u01922, true, null))) {
                    if (this.f_19853_.f_46443_) continue;
                    iterator.remove();
                    this.m_7285_(\u00e2\u02dc\u01922);
                    continue;
                }
                if (\u00e2\u02dc\u01922.m_19557_() % 600 != 0) continue;
                this.m_141973_(\u00e2\u02dc\u01922, false, null);
            }
        }
        catch (ConcurrentModificationException mobEffect) {
            // empty catch block
        }
        if (this.f_20948_) {
            if (!this.f_19853_.f_46443_) {
                this.m_8034_();
                this.m_147239_();
            }
            this.f_20948_ = false;
        }
        int n = this.f_19804_.m_135370_(f_20962_);
        boolean \u00e2\u02dc\u01923 = this.f_19804_.m_135370_(f_20963_);
        if (n > 0) {
            boolean bl = this.m_20145_() ? this.f_19796_.nextInt(15) == 0 : this.f_19796_.nextBoolean();
            if (\u00e2\u02dc\u01923) {
                bl &= this.f_19796_.nextInt(5) == 0;
            }
            if (bl && n > 0) {
                double d = (double)(n >> 16 & 0xFF) / 255.0;
                \u00e2\u02dc\u0192 = (double)(n >> 8 & 0xFF) / 255.0;
                \u00e2\u02dc\u0192 = (double)(n >> 0 & 0xFF) / 255.0;
                this.f_19853_.m_7106_(\u00e2\u02dc\u01923 ? ParticleTypes.f_123770_ : ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
        }
    }

    protected void m_8034_() {
        if (this.f_20945_.isEmpty()) {
            this.m_21218_();
            this.m_6842_(false);
        } else {
            Collection<MobEffectInstance> collection = this.f_20945_.values();
            this.f_19804_.m_135381_(f_20963_, LivingEntity.m_21179_(collection));
            this.f_19804_.m_135381_(f_20962_, PotionUtils.m_43564_(collection));
            this.m_6842_(this.m_21023_(MobEffects.f_19609_));
        }
    }

    private void m_147239_() {
        boolean bl = this.m_142038_();
        if (this.m_20291_(6) != bl) {
            this.m_20115_(6, bl);
        }
    }

    public double m_20968_(@Nullable Entity p_20969_) {
        double d = 1.0;
        if (this.m_20163_()) {
            d *= 0.8;
        }
        if (this.m_20145_()) {
            float f = this.m_21207_();
            if (f < 0.1f) {
                f = 0.1f;
            }
            d *= 0.7 * (double)f;
        }
        if (p_20969_ != null) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.HEAD);
            EntityType<?> \u00e2\u02dc\u01922 = p_20969_.m_6095_();
            if (\u00e2\u02dc\u01922 == EntityType.f_20524_ && itemStack.m_150930_(Items.f_42678_) || \u00e2\u02dc\u01922 == EntityType.f_20501_ && itemStack.m_150930_(Items.f_42681_) || \u00e2\u02dc\u01922 == EntityType.f_20558_ && itemStack.m_150930_(Items.f_42682_)) {
                d *= 0.5;
            }
        }
        return d;
    }

    public boolean m_6779_(LivingEntity p_21171_) {
        if (p_21171_ instanceof Player && this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            return false;
        }
        return p_21171_.m_142066_();
    }

    public boolean m_21040_(LivingEntity p_21041_, TargetingConditions p_21042_) {
        return p_21042_.m_26885_(this, p_21041_);
    }

    public boolean m_142066_() {
        return !this.m_20147_() && this.m_142065_();
    }

    public boolean m_142065_() {
        return !this.m_5833_() && this.m_6084_();
    }

    public static boolean m_21179_(Collection<MobEffectInstance> p_21180_) {
        for (MobEffectInstance mobEffectInstance : p_21180_) {
            if (mobEffectInstance.m_19571_()) continue;
            return false;
        }
        return true;
    }

    protected void m_21218_() {
        this.f_19804_.m_135381_(f_20963_, false);
        this.f_19804_.m_135381_(f_20962_, 0);
    }

    public boolean m_21219_() {
        if (this.f_19853_.f_46443_) {
            return false;
        }
        Iterator<MobEffectInstance> iterator = this.f_20945_.values().iterator();
        boolean \u00e2\u02dc\u01922 = false;
        while (iterator.hasNext()) {
            this.m_7285_(iterator.next());
            iterator.remove();
            \u00e2\u02dc\u01922 = true;
        }
        return \u00e2\u02dc\u01922;
    }

    public Collection<MobEffectInstance> m_21220_() {
        return this.f_20945_.values();
    }

    public Map<MobEffect, MobEffectInstance> m_21221_() {
        return this.f_20945_;
    }

    public boolean m_21023_(MobEffect p_21024_) {
        return this.f_20945_.containsKey(p_21024_);
    }

    @Nullable
    public MobEffectInstance m_21124_(MobEffect p_21125_) {
        return this.f_20945_.get(p_21125_);
    }

    public final boolean m_7292_(MobEffectInstance p_21165_) {
        return this.m_147207_(p_21165_, null);
    }

    public boolean m_147207_(MobEffectInstance p_147208_, @Nullable Entity p_147209_) {
        if (!this.m_7301_(p_147208_)) {
            return false;
        }
        MobEffectInstance mobEffectInstance = this.f_20945_.get(p_147208_.m_19544_());
        if (mobEffectInstance == null) {
            this.f_20945_.put(p_147208_.m_19544_(), p_147208_);
            this.m_142540_(p_147208_, p_147209_);
            return true;
        }
        if (mobEffectInstance.m_19558_(p_147208_)) {
            this.m_141973_(mobEffectInstance, true, p_147209_);
            return true;
        }
        return false;
    }

    public boolean m_7301_(MobEffectInstance p_21197_) {
        MobEffect mobEffect;
        return this.m_6336_() != MobType.f_21641_ || (mobEffect = p_21197_.m_19544_()) != MobEffects.f_19605_ && mobEffect != MobEffects.f_19614_;
    }

    public void m_147215_(MobEffectInstance p_147216_, @Nullable Entity p_147217_) {
        if (!this.m_7301_(p_147216_)) {
            return;
        }
        MobEffectInstance mobEffectInstance = this.f_20945_.put(p_147216_.m_19544_(), p_147216_);
        if (mobEffectInstance == null) {
            this.m_142540_(p_147216_, p_147217_);
        } else {
            this.m_141973_(p_147216_, true, p_147217_);
        }
    }

    public boolean m_21222_() {
        return this.m_6336_() == MobType.f_21641_;
    }

    @Nullable
    public MobEffectInstance m_6234_(@Nullable MobEffect p_21164_) {
        return this.f_20945_.remove(p_21164_);
    }

    public boolean m_21195_(MobEffect p_21196_) {
        MobEffectInstance mobEffectInstance = this.m_6234_(p_21196_);
        if (mobEffectInstance != null) {
            this.m_7285_(mobEffectInstance);
            return true;
        }
        return false;
    }

    protected void m_142540_(MobEffectInstance p_147190_, @Nullable Entity p_147191_) {
        this.f_20948_ = true;
        if (!this.f_19853_.f_46443_) {
            p_147190_.m_19544_().m_6385_(this, this.m_21204_(), p_147190_.m_19564_());
        }
    }

    protected void m_141973_(MobEffectInstance p_147192_, boolean p_147193_, @Nullable Entity p_147194_) {
        this.f_20948_ = true;
        if (p_147193_ && !this.f_19853_.f_46443_) {
            MobEffect mobEffect = p_147192_.m_19544_();
            mobEffect.m_6386_(this, this.m_21204_(), p_147192_.m_19564_());
            mobEffect.m_6385_(this, this.m_21204_(), p_147192_.m_19564_());
        }
    }

    protected void m_7285_(MobEffectInstance p_21126_) {
        this.f_20948_ = true;
        if (!this.f_19853_.f_46443_) {
            p_21126_.m_19544_().m_6386_(this, this.m_21204_(), p_21126_.m_19564_());
        }
    }

    public void m_5634_(float p_21116_) {
        float f = this.m_21223_();
        if (f > 0.0f) {
            this.m_21153_(f + p_21116_);
        }
    }

    public float m_21223_() {
        return this.f_19804_.m_135370_(f_20961_).floatValue();
    }

    public void m_21153_(float p_21154_) {
        this.f_19804_.m_135381_(f_20961_, Float.valueOf(Mth.m_14036_(p_21154_, 0.0f, this.m_21233_())));
    }

    public boolean m_21224_() {
        return this.m_21223_() <= 0.0f;
    }

    @Override
    public boolean m_6469_(DamageSource p_21016_, float p_21017_) {
        boolean bl;
        if (this.m_6673_(p_21016_)) {
            return false;
        }
        if (this.f_19853_.f_46443_) {
            return false;
        }
        if (this.m_21224_()) {
            return false;
        }
        if (p_21016_.m_19384_() && this.m_21023_(MobEffects.f_19607_)) {
            return false;
        }
        if (this.m_5803_() && !this.f_19853_.f_46443_) {
            this.m_5796_();
        }
        this.f_20891_ = 0;
        float f = p_21017_;
        boolean \u00e2\u02dc\u01922 = false;
        \u00e2\u02dc\u0192 = 0.0f;
        if (p_21017_ > 0.0f && this.m_21275_(p_21016_)) {
            this.m_7909_(p_21017_);
            \u00e2\u02dc\u0192 = p_21017_;
            p_21017_ = 0.0f;
            if (!p_21016_.m_19360_() && (\u00e2\u02dc\u0192 = p_21016_.m_7640_()) instanceof LivingEntity) {
                this.m_6728_((LivingEntity)\u00e2\u02dc\u0192);
            }
            \u00e2\u02dc\u01922 = true;
        }
        this.f_20924_ = 1.5f;
        boolean \u00e2\u02dc\u01923 = true;
        if ((float)this.f_19802_ > 10.0f) {
            if (p_21017_ <= this.f_20898_) {
                return false;
            }
            this.m_6475_(p_21016_, p_21017_ - this.f_20898_);
            this.f_20898_ = p_21017_;
            \u00e2\u02dc\u01923 = false;
        } else {
            this.f_20898_ = p_21017_;
            this.f_19802_ = 20;
            this.m_6475_(p_21016_, p_21017_);
            this.f_20916_ = this.f_20917_ = 10;
        }
        if (p_21016_.m_146705_() && !this.m_6844_(EquipmentSlot.HEAD).m_41619_()) {
            this.m_142642_(p_21016_, p_21017_);
            p_21017_ *= 0.75f;
        }
        this.f_20918_ = 0.0f;
        Entity \u00e2\u02dc\u01924 = p_21016_.m_7639_();
        if (\u00e2\u02dc\u01924 != null) {
            if (\u00e2\u02dc\u01924 instanceof LivingEntity && !p_21016_.m_181121_()) {
                this.m_6703_((LivingEntity)\u00e2\u02dc\u01924);
            }
            if (\u00e2\u02dc\u01924 instanceof Player) {
                this.f_20889_ = 100;
                this.f_20888_ = (Player)\u00e2\u02dc\u01924;
            } else if (\u00e2\u02dc\u01924 instanceof Wolf && ((TamableAnimal)(object = (Wolf)\u00e2\u02dc\u01924)).m_21824_()) {
                this.f_20889_ = 100;
                LivingEntity livingEntity = ((TamableAnimal)object).m_142480_();
                this.f_20888_ = livingEntity != null && livingEntity.m_6095_() == EntityType.f_20532_ ? (Player)livingEntity : null;
            }
        }
        if (\u00e2\u02dc\u01923) {
            if (\u00e2\u02dc\u01922) {
                this.f_19853_.m_7605_(this, (byte)29);
            } else if (p_21016_ instanceof EntityDamageSource && ((EntityDamageSource)p_21016_).m_19403_()) {
                this.f_19853_.m_7605_(this, (byte)33);
            } else {
                int n = p_21016_ == DamageSource.f_19312_ ? 36 : (p_21016_.m_19384_() ? 37 : (p_21016_ == DamageSource.f_19325_ ? 44 : (p_21016_ == DamageSource.f_146701_ ? 57 : 2)));
                this.f_19853_.m_7605_(this, (byte)n);
            }
            if (p_21016_ != DamageSource.f_19312_ && (!\u00e2\u02dc\u01922 || p_21017_ > 0.0f)) {
                this.m_5834_();
            }
            if (\u00e2\u02dc\u01924 != null) {
                double d = \u00e2\u02dc\u01924.m_20185_() - this.m_20185_();
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u01924.m_20189_() - this.m_20189_();
                while (d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 < 1.0E-4) {
                    d = (Math.random() - Math.random()) * 0.01;
                    \u00e2\u02dc\u0192 = (Math.random() - Math.random()) * 0.01;
                }
                this.f_20918_ = (float)(Mth.m_14136_(\u00e2\u02dc\u0192, d) * 57.2957763671875 - (double)this.m_146908_());
                this.m_147240_(0.4f, d, \u00e2\u02dc\u0192);
            } else {
                this.f_20918_ = (int)(Math.random() * 2.0) * 180;
            }
        }
        if (this.m_21224_()) {
            if (!this.m_21262_(p_21016_)) {
                Object object = this.m_5592_();
                if (\u00e2\u02dc\u01923 && object != null) {
                    this.m_5496_((SoundEvent)object, this.m_6121_(), this.m_6100_());
                }
                this.m_6667_(p_21016_);
            }
        } else if (\u00e2\u02dc\u01923) {
            this.m_6677_(p_21016_);
        }
        boolean bl2 = bl = !\u00e2\u02dc\u01922 || p_21017_ > 0.0f;
        if (bl) {
            this.f_20958_ = p_21016_;
            this.f_20930_ = this.f_19853_.m_46467_();
        }
        if (this instanceof ServerPlayer) {
            CriteriaTriggers.f_10574_.m_35174_((ServerPlayer)this, p_21016_, f, p_21017_, \u00e2\u02dc\u01922);
            if (\u00e2\u02dc\u0192 > 0.0f && \u00e2\u02dc\u0192 < 3.4028235E37f) {
                ((ServerPlayer)this).m_36222_(Stats.f_12932_, Math.round(\u00e2\u02dc\u0192 * 10.0f));
            }
        }
        if (\u00e2\u02dc\u01924 instanceof ServerPlayer) {
            CriteriaTriggers.f_10573_.m_60112_((ServerPlayer)\u00e2\u02dc\u01924, this, p_21016_, f, p_21017_, \u00e2\u02dc\u01922);
        }
        return bl;
    }

    protected void m_6728_(LivingEntity p_21200_) {
        p_21200_.m_6731_(this);
    }

    protected void m_6731_(LivingEntity p_21246_) {
        p_21246_.m_147240_(0.5, p_21246_.m_20185_() - this.m_20185_(), p_21246_.m_20189_() - this.m_20189_());
    }

    private boolean m_21262_(DamageSource p_21263_) {
        if (p_21263_.m_19378_()) {
            return false;
        }
        ItemStack itemStack = null;
        for (InteractionHand interactionHand : InteractionHand.values()) {
            ItemStack itemStack2 = this.m_21120_(interactionHand);
            if (!itemStack2.m_150930_(Items.f_42747_)) continue;
            itemStack = itemStack2.m_41777_();
            itemStack2.m_41774_(1);
            break;
        }
        if (itemStack != null) {
            if (this instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)this;
                serverPlayer.m_36246_(Stats.f_12982_.m_12902_(Items.f_42747_));
                CriteriaTriggers.f_10551_.m_74431_(serverPlayer, itemStack);
            }
            this.m_21153_(1.0f);
            this.m_21219_();
            this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 900, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 100, 1));
            this.m_7292_(new MobEffectInstance(MobEffects.f_19607_, 800, 0));
            this.f_19853_.m_7605_(this, (byte)35);
        }
        return itemStack != null;
    }

    @Nullable
    public DamageSource m_21225_() {
        if (this.f_19853_.m_46467_() - this.f_20930_ > 40L) {
            this.f_20958_ = null;
        }
        return this.f_20958_;
    }

    protected void m_6677_(DamageSource p_21160_) {
        SoundEvent soundEvent = this.m_7975_(p_21160_);
        if (soundEvent != null) {
            this.m_5496_(soundEvent, this.m_6121_(), this.m_6100_());
        }
    }

    public boolean m_21275_(DamageSource p_21276_) {
        Entity entity = p_21276_.m_7640_();
        boolean \u00e2\u02dc\u01922 = false;
        if (entity instanceof AbstractArrow && ((AbstractArrow)(\u00e2\u02dc\u0192 = (AbstractArrow)entity)).m_36796_() > 0) {
            \u00e2\u02dc\u01922 = true;
        }
        if (!p_21276_.m_19376_() && this.m_21254_() && !\u00e2\u02dc\u01922 && (\u00e2\u02dc\u0192 = p_21276_.m_7270_()) != null) {
            Vec3 vec3 = this.m_20252_(1.0f);
            \u00e2\u02dc\u0192 = ((Vec3)\u00e2\u02dc\u0192).m_82505_(this.m_20182_()).m_82541_();
            \u00e2\u02dc\u0192 = new Vec3(\u00e2\u02dc\u0192.f_82479_, 0.0, \u00e2\u02dc\u0192.f_82481_);
            if (\u00e2\u02dc\u0192.m_82526_(vec3) < 0.0) {
                return true;
            }
        }
        return false;
    }

    private void m_21278_(ItemStack p_21279_) {
        if (!p_21279_.m_41619_()) {
            if (!this.m_20067_()) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_12018_, this.m_5720_(), 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f, false);
            }
            this.m_21060_(p_21279_, 5);
        }
    }

    public void m_6667_(DamageSource p_21014_) {
        if (this.m_146910_() || this.f_20890_) {
            return;
        }
        Entity entity = p_21014_.m_7639_();
        LivingEntity \u00e2\u02dc\u01922 = this.m_21232_();
        if (this.f_20897_ >= 0 && \u00e2\u02dc\u01922 != null) {
            \u00e2\u02dc\u01922.m_5993_(this, this.f_20897_, p_21014_);
        }
        if (this.m_5803_()) {
            this.m_5796_();
        }
        if (!this.f_19853_.f_46443_ && this.m_8077_()) {
            f_19849_.info("Named entity {} died: {}", (Object)this, (Object)this.m_21231_().m_19293_().getString());
        }
        this.f_20890_ = true;
        this.m_21231_().m_19296_();
        if (this.f_19853_ instanceof ServerLevel) {
            if (entity != null) {
                entity.m_5837_((ServerLevel)this.f_19853_, this);
            }
            this.m_6668_(p_21014_);
            this.m_21268_(\u00e2\u02dc\u01922);
        }
        this.f_19853_.m_7605_(this, (byte)3);
        this.m_20124_(Pose.DYING);
    }

    protected void m_21268_(@Nullable LivingEntity p_21269_) {
        if (this.f_19853_.f_46443_) {
            return;
        }
        boolean bl = false;
        if (p_21269_ instanceof WitherBoss) {
            Object object;
            if (this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_)) {
                object = this.m_142538_();
                BlockState \u00e2\u02dc\u01922 = Blocks.f_50070_.m_49966_();
                if (this.f_19853_.m_8055_((BlockPos)object).m_60795_() && \u00e2\u02dc\u01922.m_60710_(this.f_19853_, (BlockPos)object)) {
                    this.f_19853_.m_7731_((BlockPos)object, \u00e2\u02dc\u01922, 3);
                    bl = true;
                }
            }
            if (!bl) {
                object = new ItemEntity(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_(), new ItemStack(Items.f_41951_));
                this.f_19853_.m_7967_((Entity)object);
            }
        }
    }

    protected void m_6668_(DamageSource p_21192_) {
        Entity entity = p_21192_.m_7639_();
        int \u00e2\u02dc\u01922 = entity instanceof Player ? EnchantmentHelper.m_44930_((LivingEntity)entity) : 0;
        boolean bl = \u00e2\u02dc\u0192 = this.f_20889_ > 0;
        if (this.m_6125_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_7625_(p_21192_, \u00e2\u02dc\u0192);
            this.m_7472_(p_21192_, \u00e2\u02dc\u01922, \u00e2\u02dc\u0192);
        }
        this.m_5907_();
        this.m_21226_();
    }

    protected void m_5907_() {
    }

    protected void m_21226_() {
        if (this.f_19853_ instanceof ServerLevel && (this.m_6124_() || this.f_20889_ > 0 && this.m_6149_() && this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_))) {
            ExperienceOrb.m_147082_((ServerLevel)this.f_19853_, this.m_20182_(), this.m_6552_(this.f_20888_));
        }
    }

    protected void m_7472_(DamageSource p_21018_, int p_21019_, boolean p_21020_) {
    }

    public ResourceLocation m_5743_() {
        return this.m_6095_().m_20677_();
    }

    protected void m_7625_(DamageSource p_21021_, boolean p_21022_) {
        ResourceLocation resourceLocation = this.m_5743_();
        LootTable \u00e2\u02dc\u01922 = this.f_19853_.m_142572_().m_129898_().m_79217_(resourceLocation);
        LootContext.Builder \u00e2\u02dc\u01923 = this.m_7771_(p_21022_, p_21021_);
        \u00e2\u02dc\u01922.m_79148_(\u00e2\u02dc\u01923.m_78975_(LootContextParamSets.f_81415_), this::m_19983_);
    }

    protected LootContext.Builder m_7771_(boolean p_21105_, DamageSource p_21106_) {
        LootContext.Builder builder = new LootContext.Builder((ServerLevel)this.f_19853_).m_78977_(this.f_19796_).m_78972_(LootContextParams.f_81455_, this).m_78972_(LootContextParams.f_81460_, this.m_20182_()).m_78972_(LootContextParams.f_81457_, p_21106_).m_78984_(LootContextParams.f_81458_, p_21106_.m_7639_()).m_78984_(LootContextParams.f_81459_, p_21106_.m_7640_());
        if (p_21105_ && this.f_20888_ != null) {
            builder = builder.m_78972_(LootContextParams.f_81456_, this.f_20888_).m_78963_(this.f_20888_.m_36336_());
        }
        return builder;
    }

    public void m_147240_(double p_147241_, double p_147242_, double p_147243_) {
        if ((p_147241_ *= 1.0 - this.m_21133_(Attributes.f_22278_)) <= 0.0) {
            return;
        }
        this.f_19812_ = true;
        Vec3 vec3 = this.m_20184_();
        \u00e2\u02dc\u0192 = new Vec3(p_147242_, 0.0, p_147243_).m_82541_().m_82490_(p_147241_);
        this.m_20334_(vec3.f_82479_ / 2.0 - \u00e2\u02dc\u0192.f_82479_, this.f_19861_ ? Math.min(0.4, vec3.f_82480_ / 2.0 + p_147241_) : vec3.f_82480_, vec3.f_82481_ / 2.0 - \u00e2\u02dc\u0192.f_82481_);
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource p_21239_) {
        return SoundEvents.f_11915_;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return SoundEvents.f_11910_;
    }

    protected SoundEvent m_5896_(int p_21313_) {
        if (p_21313_ > 4) {
            return SoundEvents.f_11908_;
        }
        return SoundEvents.f_11916_;
    }

    protected SoundEvent m_7838_(ItemStack p_21174_) {
        return p_21174_.m_41615_();
    }

    public SoundEvent m_7866_(ItemStack p_21202_) {
        return p_21202_.m_41616_();
    }

    @Override
    public void m_6853_(boolean p_21182_) {
        super.m_6853_(p_21182_);
        if (p_21182_) {
            this.f_20957_ = Optional.empty();
        }
    }

    public Optional<BlockPos> m_21227_() {
        return this.f_20957_;
    }

    public boolean m_6147_() {
        if (this.m_5833_()) {
            return false;
        }
        BlockPos blockPos = this.m_142538_();
        BlockState \u00e2\u02dc\u01922 = this.m_146900_();
        if (\u00e2\u02dc\u01922.m_60620_(BlockTags.f_13082_)) {
            this.f_20957_ = Optional.of(blockPos);
            return true;
        }
        if (\u00e2\u02dc\u01922.m_60734_() instanceof TrapDoorBlock && this.m_21176_(blockPos, \u00e2\u02dc\u01922)) {
            this.f_20957_ = Optional.of(blockPos);
            return true;
        }
        return false;
    }

    private boolean m_21176_(BlockPos p_21177_, BlockState p_21178_) {
        BlockState blockState;
        return p_21178_.m_61143_(TrapDoorBlock.f_57514_) != false && (blockState = this.f_19853_.m_8055_(p_21177_.m_7495_())).m_60713_(Blocks.f_50155_) && blockState.m_61143_(LadderBlock.f_54337_) == p_21178_.m_61143_(TrapDoorBlock.f_54117_);
    }

    @Override
    public boolean m_6084_() {
        return !this.m_146910_() && this.m_21223_() > 0.0f;
    }

    @Override
    public boolean m_142535_(float p_147187_, float p_147188_, DamageSource p_147189_) {
        boolean bl = super.m_142535_(p_147187_, p_147188_, p_147189_);
        int \u00e2\u02dc\u01922 = this.m_5639_(p_147187_, p_147188_);
        if (\u00e2\u02dc\u01922 > 0) {
            this.m_5496_(this.m_5896_(\u00e2\u02dc\u01922), 1.0f, 1.0f);
            this.m_21229_();
            this.m_6469_(p_147189_, \u00e2\u02dc\u01922);
            return true;
        }
        return bl;
    }

    protected int m_5639_(float p_21237_, float p_21238_) {
        MobEffectInstance mobEffectInstance = this.m_21124_(MobEffects.f_19603_);
        float \u00e2\u02dc\u01922 = mobEffectInstance == null ? 0.0f : (float)(mobEffectInstance.m_19564_() + 1);
        return Mth.m_14167_((p_21237_ - 3.0f - \u00e2\u02dc\u01922) * p_21238_);
    }

    protected void m_21229_() {
        if (this.m_20067_()) {
            return;
        }
        int n = Mth.m_14107_(this.m_20185_());
        BlockState \u00e2\u02dc\u01922 = this.f_19853_.m_8055_(new BlockPos(n, \u00e2\u02dc\u0192 = Mth.m_14107_(this.m_20186_() - (double)0.2f), \u00e2\u02dc\u0192 = Mth.m_14107_(this.m_20189_())));
        if (!\u00e2\u02dc\u01922.m_60795_()) {
            SoundType soundType = \u00e2\u02dc\u01922.m_60827_();
            this.m_5496_(soundType.m_56779_(), soundType.m_56773_() * 0.5f, soundType.m_56774_() * 0.75f);
        }
    }

    @Override
    public void m_6053_() {
        this.f_20916_ = this.f_20917_ = 10;
        this.f_20918_ = 0.0f;
    }

    public int m_21230_() {
        return Mth.m_14107_(this.m_21133_(Attributes.f_22284_));
    }

    protected void m_6472_(DamageSource p_21122_, float p_21123_) {
    }

    protected void m_142642_(DamageSource p_147213_, float p_147214_) {
    }

    protected void m_7909_(float p_21316_) {
    }

    protected float m_21161_(DamageSource p_21162_, float p_21163_) {
        if (!p_21162_.m_19376_()) {
            this.m_6472_(p_21162_, p_21163_);
            p_21163_ = CombatRules.m_19272_(p_21163_, this.m_21230_(), (float)this.m_21133_(Attributes.f_22285_));
        }
        return p_21163_;
    }

    protected float m_6515_(DamageSource p_21193_, float p_21194_) {
        float f;
        if (p_21193_.m_19379_()) {
            return p_21194_;
        }
        if (this.m_21023_(MobEffects.f_19606_) && p_21193_ != DamageSource.f_19317_ && (f = (\u00e2\u02dc\u0192 = p_21194_) - (p_21194_ = Math.max((\u00e2\u02dc\u0192 = p_21194_ * (float)(\u00e2\u02dc\u0192 = 25 - (n = (this.m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5))) / 25.0f, 0.0f))) > 0.0f && f < 3.4028235E37f) {
            if (this instanceof ServerPlayer) {
                ((ServerPlayer)this).m_36222_(Stats.f_12934_, Math.round(f * 10.0f));
            } else if (p_21193_.m_7639_() instanceof ServerPlayer) {
                ((ServerPlayer)p_21193_.m_7639_()).m_36222_(Stats.f_12930_, Math.round(f * 10.0f));
            }
        }
        if (p_21194_ <= 0.0f) {
            return 0.0f;
        }
        int n = EnchantmentHelper.m_44856_(this.m_6168_(), p_21193_);
        if (n > 0) {
            p_21194_ = CombatRules.m_19269_(p_21194_, n);
        }
        return p_21194_;
    }

    protected void m_6475_(DamageSource p_21240_, float p_21241_) {
        if (this.m_6673_(p_21240_)) {
            return;
        }
        p_21241_ = this.m_21161_(p_21240_, p_21241_);
        float f = p_21241_ = this.m_6515_(p_21240_, p_21241_);
        p_21241_ = Math.max(p_21241_ - this.m_6103_(), 0.0f);
        this.m_7911_(this.m_6103_() - (f - p_21241_));
        \u00e2\u02dc\u0192 = f - p_21241_;
        if (\u00e2\u02dc\u0192 > 0.0f && \u00e2\u02dc\u0192 < 3.4028235E37f && p_21240_.m_7639_() instanceof ServerPlayer) {
            ((ServerPlayer)p_21240_.m_7639_()).m_36222_(Stats.f_12929_, Math.round(\u00e2\u02dc\u0192 * 10.0f));
        }
        if (p_21241_ == 0.0f) {
            return;
        }
        \u00e2\u02dc\u0192 = this.m_21223_();
        this.m_21153_(\u00e2\u02dc\u0192 - p_21241_);
        this.m_21231_().m_19289_(p_21240_, \u00e2\u02dc\u0192, p_21241_);
        this.m_7911_(this.m_6103_() - p_21241_);
        this.m_146852_(GameEvent.f_157808_, p_21240_.m_7639_());
    }

    public CombatTracker m_21231_() {
        return this.f_20944_;
    }

    @Nullable
    public LivingEntity m_21232_() {
        if (this.f_20944_.m_19294_() != null) {
            return this.f_20944_.m_19294_();
        }
        if (this.f_20888_ != null) {
            return this.f_20888_;
        }
        if (this.f_20949_ != null) {
            return this.f_20949_;
        }
        return null;
    }

    public final float m_21233_() {
        return (float)this.m_21133_(Attributes.f_22276_);
    }

    public final int m_21234_() {
        return this.f_19804_.m_135370_(f_20940_);
    }

    public final void m_21317_(int p_21318_) {
        this.f_19804_.m_135381_(f_20940_, p_21318_);
    }

    public final int m_21235_() {
        return this.f_19804_.m_135370_(f_20941_);
    }

    public final void m_21321_(int p_21322_) {
        this.f_19804_.m_135381_(f_20941_, p_21322_);
    }

    private int m_21304_() {
        if (MobEffectUtil.m_19584_(this)) {
            return 6 - (1 + MobEffectUtil.m_19586_(this));
        }
        if (this.m_21023_(MobEffects.f_19599_)) {
            return 6 + (1 + this.m_21124_(MobEffects.f_19599_).m_19564_()) * 2;
        }
        return 6;
    }

    public void m_6674_(InteractionHand p_21007_) {
        this.m_21011_(p_21007_, false);
    }

    public void m_21011_(InteractionHand p_21012_, boolean p_21013_) {
        if (!this.f_20911_ || this.f_20913_ >= this.m_21304_() / 2 || this.f_20913_ < 0) {
            this.f_20913_ = -1;
            this.f_20911_ = true;
            this.f_20912_ = p_21012_;
            if (this.f_19853_ instanceof ServerLevel) {
                ClientboundAnimatePacket clientboundAnimatePacket = new ClientboundAnimatePacket(this, p_21012_ == InteractionHand.MAIN_HAND ? 0 : 3);
                ServerChunkCache \u00e2\u02dc\u01922 = ((ServerLevel)this.f_19853_).m_7726_();
                if (p_21013_) {
                    \u00e2\u02dc\u01922.m_8394_(this, clientboundAnimatePacket);
                } else {
                    \u00e2\u02dc\u01922.m_8445_(this, clientboundAnimatePacket);
                }
            }
        }
    }

    @Override
    public void m_7822_(byte p_20975_) {
        switch (p_20975_) {
            case 2: 
            case 33: 
            case 36: 
            case 37: 
            case 44: 
            case 57: {
                DamageSource damageSource;
                SoundEvent soundEvent;
                this.f_20924_ = 1.5f;
                this.f_19802_ = 20;
                this.f_20916_ = this.f_20917_ = 10;
                this.f_20918_ = 0.0f;
                if (p_20975_ == 33) {
                    this.m_5496_(SoundEvents.f_12511_, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
                if ((soundEvent = this.m_7975_(damageSource = p_20975_ == 37 ? DamageSource.f_19307_ : (p_20975_ == 36 ? DamageSource.f_19312_ : (p_20975_ == 44 ? DamageSource.f_19325_ : (p_20975_ == 57 ? DamageSource.f_146701_ : DamageSource.f_19318_))))) != null) {
                    this.m_5496_(soundEvent, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
                this.m_6469_(DamageSource.f_19318_, 0.0f);
                this.f_20958_ = damageSource;
                this.f_20930_ = this.f_19853_.m_46467_();
                break;
            }
            case 3: {
                SoundEvent soundEvent = this.m_5592_();
                if (soundEvent != null) {
                    this.m_5496_(soundEvent, this.m_6121_(), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
                }
                if (this instanceof Player) break;
                this.m_21153_(0.0f);
                this.m_6667_(DamageSource.f_19318_);
                break;
            }
            case 30: {
                this.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
                break;
            }
            case 29: {
                this.m_5496_(SoundEvents.f_12346_, 1.0f, 0.8f + this.f_19853_.f_46441_.nextFloat() * 0.4f);
                break;
            }
            case 46: {
                int n = 128;
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 128; ++\u00e2\u02dc\u0192) {
                    double d = (double)\u00e2\u02dc\u0192 / 127.0;
                    float \u00e2\u02dc\u01922 = (this.f_19796_.nextFloat() - 0.5f) * 0.2f;
                    float \u00e2\u02dc\u01923 = (this.f_19796_.nextFloat() - 0.5f) * 0.2f;
                    float \u00e2\u02dc\u01924 = (this.f_19796_.nextFloat() - 0.5f) * 0.2f;
                    \u00e2\u02dc\u0192 = Mth.m_14139_(d, this.f_19854_, this.m_20185_()) + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_() * 2.0;
                    \u00e2\u02dc\u0192 = Mth.m_14139_(d, this.f_19855_, this.m_20186_()) + this.f_19796_.nextDouble() * (double)this.m_20206_();
                    \u00e2\u02dc\u0192 = Mth.m_14139_(d, this.f_19856_, this.m_20189_()) + (this.f_19796_.nextDouble() - 0.5) * (double)this.m_20205_() * 2.0;
                    this.f_19853_.m_7106_(ParticleTypes.f_123760_, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
                }
                break;
            }
            case 47: {
                this.m_21278_(this.m_6844_(EquipmentSlot.MAINHAND));
                break;
            }
            case 48: {
                this.m_21278_(this.m_6844_(EquipmentSlot.OFFHAND));
                break;
            }
            case 49: {
                this.m_21278_(this.m_6844_(EquipmentSlot.HEAD));
                break;
            }
            case 50: {
                this.m_21278_(this.m_6844_(EquipmentSlot.CHEST));
                break;
            }
            case 51: {
                this.m_21278_(this.m_6844_(EquipmentSlot.LEGS));
                break;
            }
            case 52: {
                this.m_21278_(this.m_6844_(EquipmentSlot.FEET));
                break;
            }
            case 54: {
                HoneyBlock.m_54010_(this);
                break;
            }
            case 55: {
                this.m_21312_();
                break;
            }
            case 60: {
                this.m_147246_();
                break;
            }
            default: {
                super.m_7822_(p_20975_);
            }
        }
    }

    private void m_147246_() {
        for (int i = 0; i < 20; ++i) {
            double d = this.f_19796_.nextGaussian() * 0.02;
            \u00e2\u02dc\u0192 = this.f_19796_.nextGaussian() * 0.02;
            \u00e2\u02dc\u0192 = this.f_19796_.nextGaussian() * 0.02;
            this.f_19853_.m_7106_(ParticleTypes.f_123759_, this.m_20208_(1.0), this.m_20187_(), this.m_20262_(1.0), d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        }
    }

    private void m_21312_() {
        ItemStack itemStack = this.m_6844_(EquipmentSlot.OFFHAND);
        this.m_8061_(EquipmentSlot.OFFHAND, this.m_6844_(EquipmentSlot.MAINHAND));
        this.m_8061_(EquipmentSlot.MAINHAND, itemStack);
    }

    @Override
    protected void m_6088_() {
        this.m_6469_(DamageSource.f_19317_, 4.0f);
    }

    protected void m_21203_() {
        int n = this.m_21304_();
        if (this.f_20911_) {
            ++this.f_20913_;
            if (this.f_20913_ >= n) {
                this.f_20913_ = 0;
                this.f_20911_ = false;
            }
        } else {
            this.f_20913_ = 0;
        }
        this.f_20921_ = (float)this.f_20913_ / (float)n;
    }

    @Nullable
    public AttributeInstance m_21051_(Attribute p_21052_) {
        return this.m_21204_().m_22146_(p_21052_);
    }

    public double m_21133_(Attribute p_21134_) {
        return this.m_21204_().m_22181_(p_21134_);
    }

    public double m_21172_(Attribute p_21173_) {
        return this.m_21204_().m_22185_(p_21173_);
    }

    public AttributeMap m_21204_() {
        return this.f_20943_;
    }

    public MobType m_6336_() {
        return MobType.f_21640_;
    }

    public ItemStack m_21205_() {
        return this.m_6844_(EquipmentSlot.MAINHAND);
    }

    public ItemStack m_21206_() {
        return this.m_6844_(EquipmentSlot.OFFHAND);
    }

    public boolean m_21055_(Item p_21056_) {
        return this.m_21093_(p_147200_ -> p_147200_.m_150930_(p_21056_));
    }

    public boolean m_21093_(Predicate<ItemStack> p_21094_) {
        return p_21094_.test(this.m_21205_()) || p_21094_.test(this.m_21206_());
    }

    public ItemStack m_21120_(InteractionHand p_21121_) {
        if (p_21121_ == InteractionHand.MAIN_HAND) {
            return this.m_6844_(EquipmentSlot.MAINHAND);
        }
        if (p_21121_ == InteractionHand.OFF_HAND) {
            return this.m_6844_(EquipmentSlot.OFFHAND);
        }
        throw new IllegalArgumentException("Invalid hand " + p_21121_);
    }

    public void m_21008_(InteractionHand p_21009_, ItemStack p_21010_) {
        if (p_21009_ == InteractionHand.MAIN_HAND) {
            this.m_8061_(EquipmentSlot.MAINHAND, p_21010_);
        } else if (p_21009_ == InteractionHand.OFF_HAND) {
            this.m_8061_(EquipmentSlot.OFFHAND, p_21010_);
        } else {
            throw new IllegalArgumentException("Invalid hand " + p_21009_);
        }
    }

    public boolean m_21033_(EquipmentSlot p_21034_) {
        return !this.m_6844_(p_21034_).m_41619_();
    }

    @Override
    public abstract Iterable<ItemStack> m_6168_();

    public abstract ItemStack m_6844_(EquipmentSlot var1);

    @Override
    public abstract void m_8061_(EquipmentSlot var1, ItemStack var2);

    protected void m_181122_(ItemStack p_181123_) {
        CompoundTag compoundTag = p_181123_.m_41783_();
        if (compoundTag != null) {
            p_181123_.m_41720_().m_142312_(compoundTag);
        }
    }

    public float m_21207_() {
        Iterable<ItemStack> iterable = this.m_6168_();
        int \u00e2\u02dc\u01922 = 0;
        int \u00e2\u02dc\u01923 = 0;
        for (ItemStack itemStack : iterable) {
            if (!itemStack.m_41619_()) {
                ++\u00e2\u02dc\u01923;
            }
            ++\u00e2\u02dc\u01922;
        }
        return \u00e2\u02dc\u01922 > 0 ? (float)\u00e2\u02dc\u01923 / (float)\u00e2\u02dc\u01922 : 0.0f;
    }

    @Override
    public void m_6858_(boolean p_21284_) {
        super.m_6858_(p_21284_);
        AttributeInstance attributeInstance = this.m_21051_(Attributes.f_22279_);
        if (attributeInstance.m_22111_(f_20929_) != null) {
            attributeInstance.m_22130_(f_20960_);
        }
        if (p_21284_) {
            attributeInstance.m_22118_(f_20960_);
        }
    }

    protected float m_6121_() {
        return 1.0f;
    }

    public float m_6100_() {
        if (this.m_6162_()) {
            return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.5f;
        }
        return (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f;
    }

    protected boolean m_6107_() {
        return this.m_21224_();
    }

    @Override
    public void m_7334_(Entity p_21294_) {
        if (!this.m_5803_()) {
            super.m_7334_(p_21294_);
        }
    }

    private void m_21028_(Entity p_21029_) {
        Vec3 \u00e2\u02dc\u01922;
        if (this.m_146910_()) {
            \u00e2\u02dc\u01922 = this.m_20182_();
        } else if (p_21029_.m_146910_() || this.f_19853_.m_8055_(p_21029_.m_142538_()).m_60620_(BlockTags.f_13075_)) {
            double d = Math.max(this.m_20186_(), p_21029_.m_20186_());
            \u00e2\u02dc\u01922 = new Vec3(this.m_20185_(), d, this.m_20189_());
        } else {
            \u00e2\u02dc\u01922 = p_21029_.m_7688_(this);
        }
        this.m_142098_(\u00e2\u02dc\u01922.f_82479_, \u00e2\u02dc\u01922.f_82480_, \u00e2\u02dc\u01922.f_82481_);
    }

    @Override
    public boolean m_6052_() {
        return this.m_20151_();
    }

    protected float m_6118_() {
        return 0.42f * this.m_20098_();
    }

    public double m_182332_() {
        return this.m_21023_(MobEffects.f_19603_) ? (double)(0.1f * (float)(this.m_21124_(MobEffects.f_19603_).m_19564_() + 1)) : 0.0;
    }

    protected void m_6135_() {
        double d = (double)this.m_6118_() + this.m_182332_();
        Vec3 \u00e2\u02dc\u01922 = this.m_20184_();
        this.m_20334_(\u00e2\u02dc\u01922.f_82479_, d, \u00e2\u02dc\u01922.f_82481_);
        if (this.m_20142_()) {
            float f = this.m_146908_() * ((float)Math.PI / 180);
            this.m_20256_(this.m_20184_().m_82520_(-Mth.m_14031_(f) * 0.2f, 0.0, Mth.m_14089_(f) * 0.2f));
        }
        this.f_19812_ = true;
    }

    protected void m_21208_() {
        this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04f, 0.0));
    }

    protected void m_6197_(Tag<Fluid> p_21158_) {
        this.m_20256_(this.m_20184_().m_82520_(0.0, 0.04f, 0.0));
    }

    protected float m_6108_() {
        return 0.8f;
    }

    public boolean m_7479_(Fluid p_21070_) {
        return false;
    }

    public void m_7023_(Vec3 p_21280_) {
        if (this.m_6142_() || this.m_6109_()) {
            double d = 0.08;
            boolean bl = \u00e2\u02dc\u0192 = this.m_20184_().f_82480_ <= 0.0;
            if (\u00e2\u02dc\u0192 && this.m_21023_(MobEffects.f_19591_)) {
                d = 0.01;
                this.f_19789_ = 0.0f;
            }
            FluidState \u00e2\u02dc\u01922 = this.f_19853_.m_6425_(this.m_142538_());
            if (this.m_20069_() && this.m_6129_() && !this.m_7479_(\u00e2\u02dc\u01922.m_76152_())) {
                \u00e2\u02dc\u0192 = this.m_20186_();
                float f = this.m_20142_() ? 0.9f : this.m_6108_();
                \u00e2\u02dc\u0192 = 0.02f;
                \u00e2\u02dc\u0192 = EnchantmentHelper.m_44922_(this);
                if (\u00e2\u02dc\u0192 > 3.0f) {
                    \u00e2\u02dc\u0192 = 3.0f;
                }
                if (!this.f_19861_) {
                    \u00e2\u02dc\u0192 *= 0.5f;
                }
                if (\u00e2\u02dc\u0192 > 0.0f) {
                    f += (0.54600006f - f) * \u00e2\u02dc\u0192 / 3.0f;
                    \u00e2\u02dc\u0192 += (this.m_6113_() - \u00e2\u02dc\u0192) * \u00e2\u02dc\u0192 / 3.0f;
                }
                if (this.m_21023_(MobEffects.f_19593_)) {
                    f = 0.96f;
                }
                this.m_19920_(\u00e2\u02dc\u0192, p_21280_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                Vec3 \u00e2\u02dc\u01923 = this.m_20184_();
                if (this.f_19862_ && this.m_6147_()) {
                    \u00e2\u02dc\u01923 = new Vec3(\u00e2\u02dc\u01923.f_82479_, 0.2, \u00e2\u02dc\u01923.f_82481_);
                }
                this.m_20256_(\u00e2\u02dc\u01923.m_82542_(f, 0.8f, f));
                Vec3 \u00e2\u02dc\u01924 = this.m_20994_(d, \u00e2\u02dc\u0192, this.m_20184_());
                this.m_20256_(\u00e2\u02dc\u01924);
                if (this.f_19862_ && this.m_20229_(\u00e2\u02dc\u01924.f_82479_, \u00e2\u02dc\u01924.f_82480_ + (double)0.6f - this.m_20186_() + \u00e2\u02dc\u0192, \u00e2\u02dc\u01924.f_82481_)) {
                    this.m_20334_(\u00e2\u02dc\u01924.f_82479_, 0.3f, \u00e2\u02dc\u01924.f_82481_);
                }
            } else if (this.m_20077_() && this.m_6129_() && !this.m_7479_(\u00e2\u02dc\u01922.m_76152_())) {
                Vec3 vec3;
                double d2 = this.m_20186_();
                this.m_19920_(0.02f, p_21280_);
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.m_20120_(FluidTags.f_13132_) <= this.m_20204_()) {
                    this.m_20256_(this.m_20184_().m_82542_(0.5, 0.8f, 0.5));
                    vec3 = this.m_20994_(d, \u00e2\u02dc\u0192, this.m_20184_());
                    this.m_20256_(vec3);
                } else {
                    this.m_20256_(this.m_20184_().m_82490_(0.5));
                }
                if (!this.m_20068_()) {
                    this.m_20256_(this.m_20184_().m_82520_(0.0, -d / 4.0, 0.0));
                }
                vec3 = this.m_20184_();
                if (this.f_19862_ && this.m_20229_(vec3.f_82479_, vec3.f_82480_ + (double)0.6f - this.m_20186_() + d2, vec3.f_82481_)) {
                    this.m_20334_(vec3.f_82479_, 0.3f, vec3.f_82481_);
                }
            } else if (this.m_21255_()) {
                float f;
                double d3;
                Vec3 \u00e2\u02dc\u019210 = this.m_20184_();
                if (\u00e2\u02dc\u019210.f_82480_ > -0.5) {
                    this.f_19789_ = 1.0f;
                }
                vec3 = this.m_20154_();
                float \u00e2\u02dc\u01925 = this.m_146909_() * ((float)Math.PI / 180);
                double \u00e2\u02dc\u01926 = Math.sqrt(vec3.f_82479_ * vec3.f_82479_ + vec3.f_82481_ * vec3.f_82481_);
                double \u00e2\u02dc\u01927 = \u00e2\u02dc\u019210.m_165924_();
                double \u00e2\u02dc\u01928 = vec3.m_82553_();
                float \u00e2\u02dc\u01929 = Mth.m_14089_(\u00e2\u02dc\u01925);
                \u00e2\u02dc\u01929 = (float)((double)\u00e2\u02dc\u01929 * ((double)\u00e2\u02dc\u01929 * Math.min(1.0, \u00e2\u02dc\u01928 / 0.4)));
                \u00e2\u02dc\u019210 = this.m_20184_().m_82520_(0.0, d * (-1.0 + (double)\u00e2\u02dc\u01929 * 0.75), 0.0);
                if (\u00e2\u02dc\u019210.f_82480_ < 0.0 && \u00e2\u02dc\u01926 > 0.0) {
                    d3 = \u00e2\u02dc\u019210.f_82480_ * -0.1 * (double)\u00e2\u02dc\u01929;
                    \u00e2\u02dc\u019210 = \u00e2\u02dc\u019210.m_82520_(vec3.f_82479_ * d3 / \u00e2\u02dc\u01926, d3, vec3.f_82481_ * d3 / \u00e2\u02dc\u01926);
                }
                if (\u00e2\u02dc\u01925 < 0.0f && \u00e2\u02dc\u01926 > 0.0) {
                    d3 = \u00e2\u02dc\u01927 * (double)(-Mth.m_14031_(\u00e2\u02dc\u01925)) * 0.04;
                    \u00e2\u02dc\u019210 = \u00e2\u02dc\u019210.m_82520_(-vec3.f_82479_ * d3 / \u00e2\u02dc\u01926, d3 * 3.2, -vec3.f_82481_ * d3 / \u00e2\u02dc\u01926);
                }
                if (\u00e2\u02dc\u01926 > 0.0) {
                    Vec3 vec3;
                    \u00e2\u02dc\u019210 = \u00e2\u02dc\u019210.m_82520_((vec3.f_82479_ / \u00e2\u02dc\u01926 * \u00e2\u02dc\u01927 - \u00e2\u02dc\u019210.f_82479_) * 0.1, 0.0, (vec3.f_82481_ / \u00e2\u02dc\u01926 * \u00e2\u02dc\u01927 - \u00e2\u02dc\u019210.f_82481_) * 0.1);
                }
                this.m_20256_(\u00e2\u02dc\u019210.m_82542_(0.99f, 0.98f, 0.99f));
                this.m_6478_(MoverType.SELF, this.m_20184_());
                if (this.f_19862_ && !this.f_19853_.f_46443_ && (f = (float)((\u00e2\u02dc\u0192 = \u00e2\u02dc\u01927 - (d3 = this.m_20184_().m_165924_())) * 10.0 - 3.0)) > 0.0f) {
                    this.m_5496_(this.m_5896_((int)f), 1.0f, 1.0f);
                    this.m_6469_(DamageSource.f_19316_, f);
                }
                if (this.f_19861_ && !this.f_19853_.f_46443_) {
                    this.m_20115_(7, false);
                }
            } else {
                BlockPos blockPos = this.m_20099_();
                float \u00e2\u02dc\u019211 = this.f_19853_.m_8055_(blockPos).m_60734_().m_49958_();
                float \u00e2\u02dc\u019212 = this.f_19861_ ? \u00e2\u02dc\u019211 * 0.91f : 0.91f;
                Vec3 \u00e2\u02dc\u019213 = this.m_21074_(p_21280_, \u00e2\u02dc\u019211);
                double \u00e2\u02dc\u019214 = \u00e2\u02dc\u019213.f_82480_;
                if (this.m_21023_(MobEffects.f_19620_)) {
                    \u00e2\u02dc\u019214 += (0.05 * (double)(this.m_21124_(MobEffects.f_19620_).m_19564_() + 1) - \u00e2\u02dc\u019213.f_82480_) * 0.2;
                    this.f_19789_ = 0.0f;
                } else if (!this.f_19853_.f_46443_ || this.f_19853_.m_46805_(blockPos)) {
                    if (!this.m_20068_()) {
                        \u00e2\u02dc\u019214 -= d;
                    }
                } else {
                    \u00e2\u02dc\u019214 = this.m_20186_() > (double)this.f_19853_.m_141937_() ? -0.1 : 0.0;
                }
                if (this.m_147223_()) {
                    this.m_20334_(\u00e2\u02dc\u019213.f_82479_, \u00e2\u02dc\u019214, \u00e2\u02dc\u019213.f_82481_);
                } else {
                    this.m_20334_(\u00e2\u02dc\u019213.f_82479_ * (double)\u00e2\u02dc\u019212, \u00e2\u02dc\u019214 * (double)0.98f, \u00e2\u02dc\u019213.f_82481_ * (double)\u00e2\u02dc\u019212);
                }
            }
        }
        this.m_21043_(this, this instanceof FlyingAnimal);
    }

    public void m_21043_(LivingEntity p_21044_, boolean p_21045_) {
        p_21044_.f_20923_ = p_21044_.f_20924_;
        double d = p_21044_.m_20185_() - p_21044_.f_19854_;
        float \u00e2\u02dc\u01922 = (float)Math.sqrt(d * d + (\u00e2\u02dc\u0192 = p_21045_ ? p_21044_.m_20186_() - p_21044_.f_19855_ : 0.0) * \u00e2\u02dc\u0192 + (\u00e2\u02dc\u0192 = p_21044_.m_20189_() - p_21044_.f_19856_) * \u00e2\u02dc\u0192) * 4.0f;
        if (\u00e2\u02dc\u01922 > 1.0f) {
            \u00e2\u02dc\u01922 = 1.0f;
        }
        p_21044_.f_20924_ += (\u00e2\u02dc\u01922 - p_21044_.f_20924_) * 0.4f;
        p_21044_.f_20925_ += p_21044_.f_20924_;
    }

    public Vec3 m_21074_(Vec3 p_21075_, float p_21076_) {
        this.m_19920_(this.m_21330_(p_21076_), p_21075_);
        this.m_20256_(this.m_21297_(this.m_20184_()));
        this.m_6478_(MoverType.SELF, this.m_20184_());
        Vec3 vec3 = this.m_20184_();
        if ((this.f_19862_ || this.f_20899_) && (this.m_6147_() || this.m_146900_().m_60713_(Blocks.f_152499_) && PowderSnowBlock.m_154255_(this))) {
            vec3 = new Vec3(vec3.f_82479_, 0.2, vec3.f_82481_);
        }
        return vec3;
    }

    public Vec3 m_20994_(double p_20995_, boolean p_20996_, Vec3 p_20997_) {
        if (!this.m_20068_() && !this.m_20142_()) {
            double d = p_20996_ && Math.abs(p_20997_.f_82480_ - 0.005) >= 0.003 && Math.abs(p_20997_.f_82480_ - p_20995_ / 16.0) < 0.003 ? -0.003 : p_20997_.f_82480_ - p_20995_ / 16.0;
            return new Vec3(p_20997_.f_82479_, d, p_20997_.f_82481_);
        }
        return p_20997_;
    }

    private Vec3 m_21297_(Vec3 p_21298_) {
        if (this.m_6147_()) {
            this.f_19789_ = 0.0f;
            float f = 0.15f;
            double \u00e2\u02dc\u01922 = Mth.m_14008_(p_21298_.f_82479_, -0.15f, 0.15f);
            double \u00e2\u02dc\u01923 = Mth.m_14008_(p_21298_.f_82481_, -0.15f, 0.15f);
            double \u00e2\u02dc\u01924 = Math.max(p_21298_.f_82480_, (double)-0.15f);
            if (\u00e2\u02dc\u01924 < 0.0 && !this.m_146900_().m_60713_(Blocks.f_50616_) && this.m_5791_() && this instanceof Player) {
                \u00e2\u02dc\u01924 = 0.0;
            }
            p_21298_ = new Vec3(\u00e2\u02dc\u01922, \u00e2\u02dc\u01924, \u00e2\u02dc\u01923);
        }
        return p_21298_;
    }

    private float m_21330_(float p_21331_) {
        if (this.f_19861_) {
            return this.m_6113_() * (0.21600002f / (p_21331_ * p_21331_ * p_21331_));
        }
        return this.f_20887_;
    }

    public float m_6113_() {
        return this.f_20953_;
    }

    public void m_7910_(float p_21320_) {
        this.f_20953_ = p_21320_;
    }

    public boolean m_7327_(Entity p_20970_) {
        this.m_21335_(p_20970_);
        return false;
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        this.m_21329_();
        this.m_21333_();
        if (!this.f_19853_.f_46443_) {
            int n = this.m_21234_();
            if (n > 0) {
                if (this.f_20914_ <= 0) {
                    this.f_20914_ = 20 * (30 - n);
                }
                --this.f_20914_;
                if (this.f_20914_ <= 0) {
                    this.m_21317_(n - 1);
                }
            }
            if ((\u00e2\u02dc\u0192 = this.m_21235_()) > 0) {
                if (this.f_20915_ <= 0) {
                    this.f_20915_ = 20 * (30 - \u00e2\u02dc\u0192);
                }
                --this.f_20915_;
                if (this.f_20915_ <= 0) {
                    this.m_21321_(\u00e2\u02dc\u0192 - 1);
                }
            }
            this.m_21315_();
            if (this.f_19797_ % 20 == 0) {
                this.m_21231_().m_19296_();
            }
            if (this.m_5803_() && !this.m_21334_()) {
                this.m_5796_();
            }
        }
        this.m_8107_();
        double d = this.m_20185_() - this.f_19854_;
        \u00e2\u02dc\u0192 = this.m_20189_() - this.f_19856_;
        float \u00e2\u02dc\u01922 = (float)(d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
        float \u00e2\u02dc\u01923 = this.f_20883_;
        float \u00e2\u02dc\u01924 = 0.0f;
        this.f_20892_ = this.f_20893_;
        float \u00e2\u02dc\u01925 = 0.0f;
        if (\u00e2\u02dc\u01922 > 0.0025000002f) {
            \u00e2\u02dc\u01925 = 1.0f;
            \u00e2\u02dc\u01924 = (float)Math.sqrt(\u00e2\u02dc\u01922) * 3.0f;
            float f = (float)Mth.m_14136_(\u00e2\u02dc\u0192, d) * 57.295776f - 90.0f;
            \u00e2\u02dc\u0192 = Mth.m_14154_(Mth.m_14177_(this.m_146908_()) - f);
            \u00e2\u02dc\u01923 = 95.0f < \u00e2\u02dc\u0192 && \u00e2\u02dc\u0192 < 265.0f ? f - 180.0f : f;
        }
        if (this.f_20921_ > 0.0f) {
            \u00e2\u02dc\u01923 = this.m_146908_();
        }
        if (!this.f_19861_) {
            \u00e2\u02dc\u01925 = 0.0f;
        }
        this.f_20893_ += (\u00e2\u02dc\u01925 - this.f_20893_) * 0.3f;
        this.f_19853_.m_46473_().m_6180_("headTurn");
        \u00e2\u02dc\u01924 = this.m_5632_(\u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("rangeChecks");
        while (this.m_146908_() - this.f_19859_ < -180.0f) {
            this.f_19859_ -= 360.0f;
        }
        while (this.m_146908_() - this.f_19859_ >= 180.0f) {
            this.f_19859_ += 360.0f;
        }
        while (this.f_20883_ - this.f_20884_ < -180.0f) {
            this.f_20884_ -= 360.0f;
        }
        while (this.f_20883_ - this.f_20884_ >= 180.0f) {
            this.f_20884_ += 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ < -180.0f) {
            this.f_19860_ -= 360.0f;
        }
        while (this.m_146909_() - this.f_19860_ >= 180.0f) {
            this.f_19860_ += 360.0f;
        }
        while (this.f_20885_ - this.f_20886_ < -180.0f) {
            this.f_20886_ -= 360.0f;
        }
        while (this.f_20885_ - this.f_20886_ >= 180.0f) {
            this.f_20886_ += 360.0f;
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_20894_ += \u00e2\u02dc\u01924;
        this.f_20937_ = this.m_21255_() ? ++this.f_20937_ : 0;
        if (this.m_5803_()) {
            this.m_146926_(0.0f);
        }
    }

    private void m_21315_() {
        Map<EquipmentSlot, ItemStack> map = this.m_21319_();
        if (map != null) {
            this.m_21091_(map);
            if (!map.isEmpty()) {
                this.m_21142_(map);
            }
        }
    }

    @Nullable
    private Map<EquipmentSlot, ItemStack> m_21319_() {
        EnumMap enumMap = null;
        block4: for (EquipmentSlot equipmentSlot2 : EquipmentSlot.values()) {
            ItemStack \u00e2\u02dc\u01922;
            switch (equipmentSlot2.m_20743_()) {
                case HAND: {
                    \u00e2\u02dc\u01922 = this.m_21244_(equipmentSlot2);
                    break;
                }
                case ARMOR: {
                    EquipmentSlot equipmentSlot2;
                    \u00e2\u02dc\u01922 = this.m_21198_(equipmentSlot2);
                    break;
                }
                default: {
                    continue block4;
                }
            }
            ItemStack itemStack = this.m_6844_(equipmentSlot2);
            if (ItemStack.m_41728_(itemStack, \u00e2\u02dc\u01922)) continue;
            if (enumMap == null) {
                enumMap = Maps.newEnumMap(EquipmentSlot.class);
            }
            enumMap.put(equipmentSlot2, itemStack);
            if (!\u00e2\u02dc\u01922.m_41619_()) {
                this.m_21204_().m_22161_(\u00e2\u02dc\u01922.m_41638_(equipmentSlot2));
            }
            if (itemStack.m_41619_()) continue;
            this.m_21204_().m_22178_(itemStack.m_41638_(equipmentSlot2));
        }
        return enumMap;
    }

    private void m_21091_(Map<EquipmentSlot, ItemStack> p_21092_) {
        ItemStack itemStack = p_21092_.get((Object)EquipmentSlot.MAINHAND);
        \u00e2\u02dc\u0192 = p_21092_.get((Object)EquipmentSlot.OFFHAND);
        if (itemStack != null && \u00e2\u02dc\u0192 != null && ItemStack.m_41728_(itemStack, this.m_21244_(EquipmentSlot.OFFHAND)) && ItemStack.m_41728_(\u00e2\u02dc\u0192, this.m_21244_(EquipmentSlot.MAINHAND))) {
            ((ServerLevel)this.f_19853_).m_7726_().m_8445_(this, new ClientboundEntityEventPacket(this, 55));
            p_21092_.remove((Object)EquipmentSlot.MAINHAND);
            p_21092_.remove((Object)EquipmentSlot.OFFHAND);
            this.m_21168_(EquipmentSlot.MAINHAND, itemStack.m_41777_());
            this.m_21168_(EquipmentSlot.OFFHAND, \u00e2\u02dc\u0192.m_41777_());
        }
    }

    private void m_21142_(Map<EquipmentSlot, ItemStack> p_21143_) {
        ArrayList arrayList = Lists.newArrayListWithCapacity((int)p_21143_.size());
        p_21143_.forEach((p_147204_, p_147205_) -> {
            ItemStack itemStack = p_147205_.m_41777_();
            arrayList.add(Pair.of((Object)p_147204_, (Object)itemStack));
            switch (p_147204_.m_20743_()) {
                case HAND: {
                    this.m_21168_((EquipmentSlot)((Object)p_147204_), itemStack);
                    break;
                }
                case ARMOR: {
                    this.m_21128_((EquipmentSlot)((Object)p_147204_), itemStack);
                }
            }
        });
        ((ServerLevel)this.f_19853_).m_7726_().m_8445_(this, new ClientboundSetEquipmentPacket(this.m_142049_(), arrayList));
    }

    private ItemStack m_21198_(EquipmentSlot p_21199_) {
        return this.f_20947_.get(p_21199_.m_20749_());
    }

    private void m_21128_(EquipmentSlot p_21129_, ItemStack p_21130_) {
        this.f_20947_.set(p_21129_.m_20749_(), p_21130_);
    }

    private ItemStack m_21244_(EquipmentSlot p_21245_) {
        return this.f_20946_.get(p_21245_.m_20749_());
    }

    private void m_21168_(EquipmentSlot p_21169_, ItemStack p_21170_) {
        this.f_20946_.set(p_21169_.m_20749_(), p_21170_);
    }

    protected float m_5632_(float p_21260_, float p_21261_) {
        float f = Mth.m_14177_(p_21260_ - this.f_20883_);
        this.f_20883_ += f * 0.3f;
        \u00e2\u02dc\u0192 = Mth.m_14177_(this.m_146908_() - this.f_20883_);
        boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 < -90.0f || \u00e2\u02dc\u0192 >= 90.0f;
        if (\u00e2\u02dc\u0192 < -75.0f) {
            \u00e2\u02dc\u0192 = -75.0f;
        }
        if (\u00e2\u02dc\u0192 >= 75.0f) {
            \u00e2\u02dc\u0192 = 75.0f;
        }
        this.f_20883_ = this.m_146908_() - \u00e2\u02dc\u0192;
        if (\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 > 2500.0f) {
            this.f_20883_ += \u00e2\u02dc\u0192 * 0.2f;
        }
        if (\u00e2\u02dc\u0192) {
            p_21261_ *= -1.0f;
        }
        return p_21261_;
    }

    public void m_8107_() {
        int \u00e2\u02dc\u01925;
        if (this.f_20954_ > 0) {
            --this.f_20954_;
        }
        if (this.m_6109_()) {
            this.f_20903_ = 0;
            this.m_20167_(this.m_20185_(), this.m_20186_(), this.m_20189_());
        }
        if (this.f_20903_ > 0) {
            double d = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
            \u00e2\u02dc\u0192 = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
            \u00e2\u02dc\u0192 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
            \u00e2\u02dc\u0192 = Mth.m_14175_(this.f_20907_ - (double)this.m_146908_());
            this.m_146922_(this.m_146908_() + (float)\u00e2\u02dc\u0192 / (float)this.f_20903_);
            this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
            --this.f_20903_;
            this.m_6034_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            this.m_19915_(this.m_146908_(), this.m_146909_());
        } else if (!this.m_6142_()) {
            this.m_20256_(this.m_20184_().m_82490_(0.98));
        }
        if (this.f_20934_ > 0) {
            this.f_20885_ = (float)((double)this.f_20885_ + Mth.m_14175_(this.f_20933_ - (double)this.f_20885_) / (double)this.f_20934_);
            --this.f_20934_;
        }
        Vec3 vec3 = this.m_20184_();
        double \u00e2\u02dc\u01922 = vec3.f_82479_;
        double \u00e2\u02dc\u01923 = vec3.f_82480_;
        double \u00e2\u02dc\u01924 = vec3.f_82481_;
        if (Math.abs(vec3.f_82479_) < 0.003) {
            \u00e2\u02dc\u01922 = 0.0;
        }
        if (Math.abs(vec3.f_82480_) < 0.003) {
            \u00e2\u02dc\u01923 = 0.0;
        }
        if (Math.abs(vec3.f_82481_) < 0.003) {
            \u00e2\u02dc\u01924 = 0.0;
        }
        this.m_20334_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924);
        this.f_19853_.m_46473_().m_6180_("ai");
        if (this.m_6107_()) {
            this.f_20899_ = false;
            this.f_20900_ = 0.0f;
            this.f_20902_ = 0.0f;
        } else if (this.m_6142_()) {
            this.f_19853_.m_46473_().m_6180_("newAi");
            this.m_6140_();
            this.f_19853_.m_46473_().m_7238_();
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("jump");
        if (this.f_20899_ && this.m_6129_()) {
            double d = this.m_20077_() ? this.m_20120_(FluidTags.f_13132_) : this.m_20120_(FluidTags.f_13131_);
            \u00e2\u02dc\u01925 = this.m_20069_() && d > 0.0 ? 1 : 0;
            \u00e2\u02dc\u0192 = this.m_20204_();
            if (\u00e2\u02dc\u01925 != 0 && (!this.f_19861_ || d > \u00e2\u02dc\u0192)) {
                this.m_6197_(FluidTags.f_13131_);
            } else if (this.m_20077_() && (!this.f_19861_ || d > \u00e2\u02dc\u0192)) {
                this.m_6197_(FluidTags.f_13132_);
            } else if ((this.f_19861_ || \u00e2\u02dc\u01925 != 0 && d <= \u00e2\u02dc\u0192) && this.f_20954_ == 0) {
                this.m_6135_();
                this.f_20954_ = 10;
            }
        } else {
            this.f_20954_ = 0;
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("travel");
        this.f_20900_ *= 0.98f;
        this.f_20902_ *= 0.98f;
        this.m_21323_();
        AABB aABB = this.m_142469_();
        this.m_7023_(new Vec3(this.f_20900_, this.f_20901_, this.f_20902_));
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("freezing");
        boolean \u00e2\u02dc\u01926 = this.m_6095_().m_20609_(EntityTypeTags.f_144295_);
        if (!this.f_19853_.f_46443_ && !this.m_21224_()) {
            \u00e2\u02dc\u01925 = this.m_146888_();
            if (this.f_146808_ && this.m_142079_()) {
                this.m_146917_(Math.min(this.m_146891_(), \u00e2\u02dc\u01925 + 1));
            } else {
                this.m_146917_(Math.max(0, \u00e2\u02dc\u01925 - 2));
            }
        }
        this.m_147225_();
        this.m_147226_();
        if (!this.f_19853_.f_46443_ && this.f_19797_ % 40 == 0 && this.m_146890_() && this.m_142079_()) {
            \u00e2\u02dc\u01925 = \u00e2\u02dc\u01926 ? 5 : 1;
            this.m_6469_(DamageSource.f_146701_, \u00e2\u02dc\u01925);
        }
        this.f_19853_.m_46473_().m_7238_();
        this.f_19853_.m_46473_().m_6180_("push");
        if (this.f_20938_ > 0) {
            --this.f_20938_;
            this.m_21071_(aABB, this.m_142469_());
        }
        this.m_6138_();
        this.f_19853_.m_46473_().m_7238_();
        if (!this.f_19853_.f_46443_ && this.m_6126_() && this.m_20071_()) {
            this.m_6469_(DamageSource.f_19312_, 1.0f);
        }
    }

    public boolean m_6126_() {
        return false;
    }

    private void m_21323_() {
        boolean bl = this.m_20291_(7);
        if (bl && !this.f_19861_ && !this.m_20159_() && !this.m_21023_(MobEffects.f_19620_)) {
            ItemStack itemStack = this.m_6844_(EquipmentSlot.CHEST);
            if (itemStack.m_150930_(Items.f_42741_) && ElytraItem.m_41140_(itemStack)) {
                bl = true;
                int \u00e2\u02dc\u01922 = this.f_20937_ + 1;
                if (!this.f_19853_.f_46443_ && \u00e2\u02dc\u01922 % 10 == 0) {
                    int n = \u00e2\u02dc\u01922 / 10;
                    if (n % 2 == 0) {
                        itemStack.m_41622_(1, this, p_147232_ -> p_147232_.m_21166_(EquipmentSlot.CHEST));
                    }
                    this.m_146850_(GameEvent.f_157807_);
                }
            } else {
                bl = false;
            }
        } else {
            bl = false;
        }
        if (!this.f_19853_.f_46443_) {
            this.m_20115_(7, bl);
        }
    }

    protected void m_6140_() {
    }

    protected void m_6138_() {
        List<Entity> list = this.f_19853_.m_6249_(this, this.m_142469_(), EntitySelector.m_20421_(this));
        if (!list.isEmpty()) {
            int n = this.f_19853_.m_46469_().m_46215_(GameRules.f_46149_);
            if (n > 0 && list.size() > n - 1 && this.f_19796_.nextInt(4) == 0) {
                \u00e2\u02dc\u0192 = 0;
                for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < list.size(); ++\u00e2\u02dc\u0192) {
                    if (list.get(\u00e2\u02dc\u0192).m_20159_()) continue;
                    ++\u00e2\u02dc\u0192;
                }
                if (\u00e2\u02dc\u0192 > n - 1) {
                    this.m_6469_(DamageSource.f_19311_, 6.0f);
                }
            }
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < list.size(); ++\u00e2\u02dc\u0192) {
                Entity entity = list.get(\u00e2\u02dc\u0192);
                this.m_7324_(entity);
            }
        }
    }

    protected void m_21071_(AABB p_21072_, AABB p_21073_) {
        AABB aABB = p_21072_.m_82367_(p_21073_);
        List<Entity> \u00e2\u02dc\u01922 = this.f_19853_.m_45933_(this, aABB);
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            for (int i = 0; i < \u00e2\u02dc\u01922.size(); ++i) {
                Entity entity = \u00e2\u02dc\u01922.get(i);
                if (!(entity instanceof LivingEntity)) continue;
                this.m_6727_((LivingEntity)entity);
                this.f_20938_ = 0;
                this.m_20256_(this.m_20184_().m_82490_(-0.2));
                break;
            }
        } else if (this.f_19862_) {
            this.f_20938_ = 0;
        }
        if (!this.f_19853_.f_46443_ && this.f_20938_ <= 0) {
            this.m_21155_(4, false);
        }
    }

    protected void m_7324_(Entity p_20971_) {
        p_20971_.m_7334_(this);
    }

    protected void m_6727_(LivingEntity p_21277_) {
    }

    public void m_21326_(int p_21327_) {
        this.f_20938_ = p_21327_;
        if (!this.f_19853_.f_46443_) {
            this.m_21155_(4, true);
        }
    }

    public boolean m_21209_() {
        return (this.f_19804_.m_135370_(f_20909_) & 4) != 0;
    }

    @Override
    public void m_8127_() {
        Entity entity = this.m_20202_();
        super.m_8127_();
        if (entity != null && entity != this.m_20202_() && !this.f_19853_.f_46443_) {
            this.m_21028_(entity);
        }
    }

    @Override
    public void m_6083_() {
        super.m_6083_();
        this.f_20892_ = this.f_20893_;
        this.f_20893_ = 0.0f;
        this.f_19789_ = 0.0f;
    }

    @Override
    public void m_6453_(double p_20977_, double p_20978_, double p_20979_, float p_20980_, float p_20981_, int p_20982_, boolean p_20983_) {
        this.f_20904_ = p_20977_;
        this.f_20905_ = p_20978_;
        this.f_20906_ = p_20979_;
        this.f_20907_ = p_20980_;
        this.f_20908_ = p_20981_;
        this.f_20903_ = p_20982_;
    }

    @Override
    public void m_6541_(float p_21005_, int p_21006_) {
        this.f_20933_ = p_21005_;
        this.f_20934_ = p_21006_;
    }

    public void m_6862_(boolean p_21314_) {
        this.f_20899_ = p_21314_;
    }

    public void m_21053_(ItemEntity p_21054_) {
        Player player;
        Player player2 = player = p_21054_.m_32057_() != null ? this.f_19853_.m_46003_(p_21054_.m_32057_()) : null;
        if (player instanceof ServerPlayer) {
            CriteriaTriggers.f_10564_.m_44363_((ServerPlayer)player, p_21054_.m_32055_(), this);
        }
    }

    public void m_7938_(Entity p_21030_, int p_21031_) {
        if (!p_21030_.m_146910_() && !this.f_19853_.f_46443_ && (p_21030_ instanceof ItemEntity || p_21030_ instanceof AbstractArrow || p_21030_ instanceof ExperienceOrb)) {
            ((ServerLevel)this.f_19853_).m_7726_().m_8445_(p_21030_, new ClientboundTakeItemEntityPacket(p_21030_.m_142049_(), this.m_142049_(), p_21031_));
        }
    }

    public boolean m_142582_(Entity p_147185_) {
        if (p_147185_.f_19853_ != this.f_19853_) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.m_20185_(), this.m_20188_(), this.m_20189_());
        \u00e2\u02dc\u0192 = new Vec3(p_147185_.m_20185_(), p_147185_.m_20188_(), p_147185_.m_20189_());
        if (\u00e2\u02dc\u0192.m_82554_(vec3) > 128.0) {
            return false;
        }
        return this.f_19853_.m_45547_(new ClipContext(vec3, \u00e2\u02dc\u0192, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this)).m_6662_() == HitResult.Type.MISS;
    }

    @Override
    public float m_5675_(float p_21286_) {
        if (p_21286_ == 1.0f) {
            return this.f_20885_;
        }
        return Mth.m_14179_(p_21286_, this.f_20886_, this.f_20885_);
    }

    public float m_21324_(float p_21325_) {
        float f = this.f_20921_ - this.f_20920_;
        if (f < 0.0f) {
            f += 1.0f;
        }
        return this.f_20920_ + f * p_21325_;
    }

    public boolean m_6142_() {
        return !this.f_19853_.f_46443_;
    }

    @Override
    public boolean m_6087_() {
        return !this.m_146910_();
    }

    @Override
    public boolean m_6094_() {
        return this.m_6084_() && !this.m_5833_() && !this.m_6147_();
    }

    @Override
    protected void m_5834_() {
        this.f_19864_ = this.f_19796_.nextDouble() >= this.m_21133_(Attributes.f_22278_);
    }

    @Override
    public float m_6080_() {
        return this.f_20885_;
    }

    @Override
    public void m_5616_(float p_21306_) {
        this.f_20885_ = p_21306_;
    }

    @Override
    public void m_5618_(float p_21309_) {
        this.f_20883_ = p_21309_;
    }

    @Override
    protected Vec3 m_7643_(Direction.Axis p_21085_, BlockUtil.FoundRectangle p_21086_) {
        return LivingEntity.m_21289_(super.m_7643_(p_21085_, p_21086_));
    }

    public static Vec3 m_21289_(Vec3 p_21290_) {
        return new Vec3(p_21290_.f_82479_, p_21290_.f_82480_, 0.0);
    }

    public float m_6103_() {
        return this.f_20955_;
    }

    public void m_7911_(float p_21328_) {
        if (p_21328_ < 0.0f) {
            p_21328_ = 0.0f;
        }
        this.f_20955_ = p_21328_;
    }

    public void m_8108_() {
    }

    public void m_8098_() {
    }

    protected void m_21210_() {
        this.f_20948_ = true;
    }

    public abstract HumanoidArm m_5737_();

    public boolean m_6117_() {
        return (this.f_19804_.m_135370_(f_20909_) & 1) > 0;
    }

    public InteractionHand m_7655_() {
        return (this.f_19804_.m_135370_(f_20909_) & 2) > 0 ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
    }

    private void m_21329_() {
        if (this.m_6117_()) {
            if (ItemStack.m_41758_(this.m_21120_(this.m_7655_()), this.f_20935_)) {
                this.f_20935_ = this.m_21120_(this.m_7655_());
                this.m_142106_(this.f_20935_);
            } else {
                this.m_5810_();
            }
        }
    }

    protected void m_142106_(ItemStack p_147201_) {
        p_147201_.m_41731_(this.f_19853_, this, this.m_21212_());
        if (this.m_21332_()) {
            this.m_21137_(p_147201_, 5);
        }
        if (--this.f_20936_ == 0 && !this.f_19853_.f_46443_ && !p_147201_.m_41781_()) {
            this.m_8095_();
        }
    }

    private boolean m_21332_() {
        int n = this.m_21212_();
        FoodProperties \u00e2\u02dc\u01922 = this.f_20935_.m_41720_().m_41473_();
        boolean \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922 != null && \u00e2\u02dc\u01922.m_38748_();
        return (\u00e2\u02dc\u01923 |= n <= this.f_20935_.m_41779_() - 7) && n % 4 == 0;
    }

    private void m_21333_() {
        this.f_20932_ = this.f_20931_;
        this.f_20931_ = this.m_6067_() ? Math.min(1.0f, this.f_20931_ + 0.09f) : Math.max(0.0f, this.f_20931_ - 0.09f);
    }

    protected void m_21155_(int p_21156_, boolean p_21157_) {
        int n = this.f_19804_.m_135370_(f_20909_).byteValue();
        n = p_21157_ ? (n |= p_21156_) : (n &= ~p_21156_);
        this.f_19804_.m_135381_(f_20909_, (byte)n);
    }

    public void m_6672_(InteractionHand p_21159_) {
        ItemStack itemStack = this.m_21120_(p_21159_);
        if (itemStack.m_41619_() || this.m_6117_()) {
            return;
        }
        this.f_20935_ = itemStack;
        this.f_20936_ = itemStack.m_41779_();
        if (!this.f_19853_.f_46443_) {
            this.m_21155_(1, true);
            this.m_21155_(2, p_21159_ == InteractionHand.OFF_HAND);
        }
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_21104_) {
        super.m_7350_(p_21104_);
        if (f_20942_.equals(p_21104_)) {
            if (this.f_19853_.f_46443_) {
                this.m_21257_().ifPresent(this::m_21080_);
            }
        } else if (f_20909_.equals(p_21104_) && this.f_19853_.f_46443_) {
            if (this.m_6117_() && this.f_20935_.m_41619_()) {
                this.f_20935_ = this.m_21120_(this.m_7655_());
                if (!this.f_20935_.m_41619_()) {
                    this.f_20936_ = this.f_20935_.m_41779_();
                }
            } else if (!this.m_6117_() && !this.f_20935_.m_41619_()) {
                this.f_20935_ = ItemStack.f_41583_;
                this.f_20936_ = 0;
            }
        }
    }

    @Override
    public void m_7618_(EntityAnchorArgument.Anchor p_21078_, Vec3 p_21079_) {
        super.m_7618_(p_21078_, p_21079_);
        this.f_20886_ = this.f_20885_;
        this.f_20884_ = this.f_20883_ = this.f_20885_;
    }

    protected void m_21137_(ItemStack p_21138_, int p_21139_) {
        if (p_21138_.m_41619_() || !this.m_6117_()) {
            return;
        }
        if (p_21138_.m_41780_() == UseAnim.DRINK) {
            this.m_5496_(this.m_7838_(p_21138_), 0.5f, this.f_19853_.f_46441_.nextFloat() * 0.1f + 0.9f);
        }
        if (p_21138_.m_41780_() == UseAnim.EAT) {
            this.m_21060_(p_21138_, p_21139_);
            this.m_5496_(this.m_7866_(p_21138_), 0.5f + 0.5f * (float)this.f_19796_.nextInt(2), (this.f_19796_.nextFloat() - this.f_19796_.nextFloat()) * 0.2f + 1.0f);
        }
    }

    private void m_21060_(ItemStack p_21061_, int p_21062_) {
        for (int i = 0; i < p_21062_; ++i) {
            Vec3 vec3 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, 0.0);
            vec3 = vec3.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            vec3 = vec3.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            double \u00e2\u02dc\u01922 = (double)(-this.f_19796_.nextFloat()) * 0.6 - 0.3;
            \u00e2\u02dc\u0192 = new Vec3(((double)this.f_19796_.nextFloat() - 0.5) * 0.3, \u00e2\u02dc\u01922, 0.6);
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_82496_(-this.m_146909_() * ((float)Math.PI / 180));
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_82524_(-this.m_146908_() * ((float)Math.PI / 180));
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_82520_(this.m_20185_(), this.m_20188_(), this.m_20189_());
            this.f_19853_.m_7106_(new ItemParticleOption(ParticleTypes.f_123752_, p_21061_), \u00e2\u02dc\u0192.f_82479_, \u00e2\u02dc\u0192.f_82480_, \u00e2\u02dc\u0192.f_82481_, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_);
        }
    }

    protected void m_8095_() {
        InteractionHand interactionHand = this.m_7655_();
        if (!this.f_20935_.equals(this.m_21120_(interactionHand))) {
            this.m_21253_();
            return;
        }
        if (!this.f_20935_.m_41619_() && this.m_6117_()) {
            this.m_21137_(this.f_20935_, 16);
            ItemStack itemStack = this.f_20935_.m_41671_(this.f_19853_, this);
            if (itemStack != this.f_20935_) {
                this.m_21008_(interactionHand, itemStack);
            }
            this.m_5810_();
        }
    }

    public ItemStack m_21211_() {
        return this.f_20935_;
    }

    public int m_21212_() {
        return this.f_20936_;
    }

    public int m_21252_() {
        if (this.m_6117_()) {
            return this.f_20935_.m_41779_() - this.m_21212_();
        }
        return 0;
    }

    public void m_21253_() {
        if (!this.f_20935_.m_41619_()) {
            this.f_20935_.m_41674_(this.f_19853_, this, this.m_21212_());
            if (this.f_20935_.m_41781_()) {
                this.m_21329_();
            }
        }
        this.m_5810_();
    }

    public void m_5810_() {
        if (!this.f_19853_.f_46443_) {
            this.m_21155_(1, false);
        }
        this.f_20935_ = ItemStack.f_41583_;
        this.f_20936_ = 0;
    }

    public boolean m_21254_() {
        if (!this.m_6117_() || this.f_20935_.m_41619_()) {
            return false;
        }
        Item item = this.f_20935_.m_41720_();
        if (item.m_6164_(this.f_20935_) != UseAnim.BLOCK) {
            return false;
        }
        return item.m_8105_(this.f_20935_) - this.f_20936_ >= 5;
    }

    public boolean m_5791_() {
        return this.m_6144_();
    }

    public boolean m_21255_() {
        return this.m_20291_(7);
    }

    @Override
    public boolean m_6067_() {
        return super.m_6067_() || !this.m_21255_() && this.m_20089_() == Pose.FALL_FLYING;
    }

    public int m_21256_() {
        return this.f_20937_;
    }

    public boolean m_20984_(double p_20985_, double p_20986_, double p_20987_, boolean p_20988_) {
        double d = this.m_20185_();
        \u00e2\u02dc\u0192 = this.m_20186_();
        \u00e2\u02dc\u0192 = this.m_20189_();
        \u00e2\u02dc\u0192 = p_20986_;
        boolean \u00e2\u02dc\u01922 = false;
        Level \u00e2\u02dc\u01923 = this.f_19853_;
        BlockPos \u00e2\u02dc\u01924 = new BlockPos(p_20985_, \u00e2\u02dc\u0192, p_20987_);
        if (\u00e2\u02dc\u01923.m_46805_(\u00e2\u02dc\u01924)) {
            boolean bl = false;
            while (!bl && \u00e2\u02dc\u01924.m_123342_() > \u00e2\u02dc\u01923.m_141937_()) {
                BlockPos blockPos = \u00e2\u02dc\u01924.m_7495_();
                BlockState \u00e2\u02dc\u01925 = \u00e2\u02dc\u01923.m_8055_(blockPos);
                if (\u00e2\u02dc\u01925.m_60767_().m_76334_()) {
                    bl = true;
                    continue;
                }
                \u00e2\u02dc\u0192 -= 1.0;
                \u00e2\u02dc\u01924 = blockPos;
            }
            if (bl) {
                this.m_6021_(p_20985_, \u00e2\u02dc\u0192, p_20987_);
                if (\u00e2\u02dc\u01923.m_45786_(this) && !\u00e2\u02dc\u01923.m_46855_(this.m_142469_())) {
                    \u00e2\u02dc\u01922 = true;
                }
            }
        }
        if (!\u00e2\u02dc\u01922) {
            this.m_6021_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            return false;
        }
        if (p_20988_) {
            \u00e2\u02dc\u01923.m_7605_(this, (byte)46);
        }
        if (this instanceof PathfinderMob) {
            ((PathfinderMob)this).m_21573_().m_26573_();
        }
        return true;
    }

    public boolean m_5801_() {
        return true;
    }

    public boolean m_5789_() {
        return true;
    }

    public void m_6818_(BlockPos p_21082_, boolean p_21083_) {
    }

    public boolean m_7066_(ItemStack p_21249_) {
        return false;
    }

    @Override
    public Packet<?> m_5654_() {
        return new ClientboundAddMobPacket(this);
    }

    @Override
    public EntityDimensions m_6972_(Pose p_21047_) {
        return p_21047_ == Pose.SLEEPING ? f_20910_ : super.m_6972_(p_21047_).m_20388_(this.m_6134_());
    }

    public ImmutableList<Pose> m_7431_() {
        return ImmutableList.of((Object)((Object)Pose.STANDING));
    }

    public AABB m_21270_(Pose p_21271_) {
        EntityDimensions entityDimensions = this.m_6972_(p_21271_);
        return new AABB(-entityDimensions.f_20377_ / 2.0f, 0.0, -entityDimensions.f_20377_ / 2.0f, entityDimensions.f_20377_ / 2.0f, entityDimensions.f_20378_, entityDimensions.f_20377_ / 2.0f);
    }

    public Optional<BlockPos> m_21257_() {
        return this.f_19804_.m_135370_(f_20942_);
    }

    public void m_21250_(BlockPos p_21251_) {
        this.f_19804_.m_135381_(f_20942_, Optional.of(p_21251_));
    }

    public void m_21258_() {
        this.f_19804_.m_135381_(f_20942_, Optional.empty());
    }

    public boolean m_5803_() {
        return this.m_21257_().isPresent();
    }

    public void m_5802_(BlockPos p_21141_) {
        BlockState blockState;
        if (this.m_20159_()) {
            this.m_8127_();
        }
        if ((blockState = this.f_19853_.m_8055_(p_21141_)).m_60734_() instanceof BedBlock) {
            this.f_19853_.m_7731_(p_21141_, (BlockState)blockState.m_61124_(BedBlock.f_49441_, true), 3);
        }
        this.m_20124_(Pose.SLEEPING);
        this.m_21080_(p_21141_);
        this.m_21250_(p_21141_);
        this.m_20256_(Vec3.f_82478_);
        this.f_19812_ = true;
    }

    private void m_21080_(BlockPos p_21081_) {
        this.m_6034_((double)p_21081_.m_123341_() + 0.5, (double)p_21081_.m_123342_() + 0.6875, (double)p_21081_.m_123343_() + 0.5);
    }

    private boolean m_21334_() {
        return this.m_21257_().map(p_147236_ -> this.f_19853_.m_8055_((BlockPos)p_147236_).m_60734_() instanceof BedBlock).orElse(false);
    }

    public void m_5796_() {
        this.m_21257_().filter(this.f_19853_::m_46805_).ifPresent(p_147228_ -> {
            BlockState blockState = this.f_19853_.m_8055_((BlockPos)p_147228_);
            if (blockState.m_60734_() instanceof BedBlock) {
                this.f_19853_.m_7731_((BlockPos)p_147228_, (BlockState)blockState.m_61124_(BedBlock.f_49441_, false), 3);
                Vec3 vec3 = BedBlock.m_49458_(this.m_6095_(), this.f_19853_, p_147228_, this.m_146908_()).orElseGet(() -> {
                    BlockPos blockPos = p_147228_.m_7494_();
                    return new Vec3((double)blockPos.m_123341_() + 0.5, (double)blockPos.m_123342_() + 0.1, (double)blockPos.m_123343_() + 0.5);
                });
                \u00e2\u02dc\u0192 = Vec3.m_82539_(p_147228_).m_82546_(vec3).m_82541_();
                float \u00e2\u02dc\u01922 = (float)Mth.m_14175_(Mth.m_14136_(\u00e2\u02dc\u0192.f_82481_, \u00e2\u02dc\u0192.f_82479_) * 57.2957763671875 - 90.0);
                this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
                this.m_146922_(\u00e2\u02dc\u01922);
                this.m_146926_(0.0f);
            }
        });
        Vec3 vec3 = this.m_20182_();
        this.m_20124_(Pose.STANDING);
        this.m_6034_(vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        this.m_21258_();
    }

    @Nullable
    public Direction m_21259_() {
        BlockPos blockPos = this.m_21257_().orElse(null);
        return blockPos != null ? BedBlock.m_49485_(this.f_19853_, blockPos) : null;
    }

    @Override
    public boolean m_5830_() {
        return !this.m_5803_() && super.m_5830_();
    }

    @Override
    protected final float m_6380_(Pose p_21049_, EntityDimensions p_21050_) {
        return p_21049_ == Pose.SLEEPING ? 0.2f : this.m_6431_(p_21049_, p_21050_);
    }

    protected float m_6431_(Pose p_21131_, EntityDimensions p_21132_) {
        return super.m_6380_(p_21131_, p_21132_);
    }

    public ItemStack m_6298_(ItemStack p_21272_) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_5584_(Level p_21067_, ItemStack p_21068_) {
        if (p_21068_.m_41614_()) {
            p_21067_.m_142346_(this, GameEvent.f_157806_, this.m_146901_());
            p_21067_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_7866_(p_21068_), SoundSource.NEUTRAL, 1.0f, 1.0f + (p_21067_.f_46441_.nextFloat() - p_21067_.f_46441_.nextFloat()) * 0.4f);
            this.m_21063_(p_21068_, p_21067_, this);
            if (!(this instanceof Player) || !((Player)this).m_150110_().f_35937_) {
                p_21068_.m_41774_(1);
            }
            this.m_146850_(GameEvent.f_157806_);
        }
        return p_21068_;
    }

    private void m_21063_(ItemStack p_21064_, Level p_21065_, LivingEntity p_21066_) {
        Item item = p_21064_.m_41720_();
        if (item.m_41472_()) {
            List<Pair<MobEffectInstance, Float>> list = item.m_41473_().m_38749_();
            for (Pair<MobEffectInstance, Float> pair : list) {
                if (p_21065_.f_46443_ || pair.getFirst() == null || !(p_21065_.f_46441_.nextFloat() < ((Float)pair.getSecond()).floatValue())) continue;
                p_21066_.m_7292_(new MobEffectInstance((MobEffectInstance)pair.getFirst()));
            }
        }
    }

    private static byte m_21266_(EquipmentSlot p_21267_) {
        switch (p_21267_) {
            case MAINHAND: {
                return 47;
            }
            case OFFHAND: {
                return 48;
            }
            case HEAD: {
                return 49;
            }
            case CHEST: {
                return 50;
            }
            case FEET: {
                return 52;
            }
            case LEGS: {
                return 51;
            }
        }
        return 47;
    }

    public void m_21166_(EquipmentSlot p_21167_) {
        this.f_19853_.m_7605_(this, LivingEntity.m_21266_(p_21167_));
    }

    public void m_21190_(InteractionHand p_21191_) {
        this.m_21166_(p_21191_ == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
    }

    @Override
    public AABB m_6921_() {
        if (this.m_6844_(EquipmentSlot.HEAD).m_150930_(Items.f_42683_)) {
            float f = 0.5f;
            return this.m_142469_().m_82377_(0.5, 0.5, 0.5);
        }
        return super.m_6921_();
    }

    public static EquipmentSlot m_147233_(ItemStack p_147234_) {
        Item item = p_147234_.m_41720_();
        if (p_147234_.m_150930_(Items.f_42047_) || item instanceof BlockItem && ((BlockItem)item).m_40614_() instanceof AbstractSkullBlock) {
            return EquipmentSlot.HEAD;
        }
        if (item instanceof ArmorItem) {
            return ((ArmorItem)item).m_40402_();
        }
        if (p_147234_.m_150930_(Items.f_42741_)) {
            return EquipmentSlot.CHEST;
        }
        if (p_147234_.m_150930_(Items.f_42740_)) {
            return EquipmentSlot.OFFHAND;
        }
        return EquipmentSlot.MAINHAND;
    }

    private static SlotAccess m_147195_(LivingEntity p_147196_, EquipmentSlot p_147197_) {
        if (p_147197_ == EquipmentSlot.HEAD || p_147197_ == EquipmentSlot.MAINHAND || p_147197_ == EquipmentSlot.OFFHAND) {
            return SlotAccess.m_147299_(p_147196_, p_147197_);
        }
        return SlotAccess.m_147302_(p_147196_, p_147197_, p_147222_ -> p_147222_.m_41619_() || Mob.m_147233_(p_147222_) == p_147197_);
    }

    @Nullable
    private static EquipmentSlot m_147211_(int p_147212_) {
        if (p_147212_ == 100 + EquipmentSlot.HEAD.m_20749_()) {
            return EquipmentSlot.HEAD;
        }
        if (p_147212_ == 100 + EquipmentSlot.CHEST.m_20749_()) {
            return EquipmentSlot.CHEST;
        }
        if (p_147212_ == 100 + EquipmentSlot.LEGS.m_20749_()) {
            return EquipmentSlot.LEGS;
        }
        if (p_147212_ == 100 + EquipmentSlot.FEET.m_20749_()) {
            return EquipmentSlot.FEET;
        }
        if (p_147212_ == 98) {
            return EquipmentSlot.MAINHAND;
        }
        if (p_147212_ == 99) {
            return EquipmentSlot.OFFHAND;
        }
        return null;
    }

    @Override
    public SlotAccess m_141942_(int p_147238_) {
        EquipmentSlot equipmentSlot = LivingEntity.m_147211_(p_147238_);
        if (equipmentSlot != null) {
            return LivingEntity.m_147195_(this, equipmentSlot);
        }
        return super.m_141942_(p_147238_);
    }

    @Override
    public boolean m_142079_() {
        if (this.m_5833_()) {
            return false;
        }
        boolean bl = !this.m_6844_(EquipmentSlot.HEAD).m_150922_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.CHEST).m_150922_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.LEGS).m_150922_(ItemTags.f_144320_) && !this.m_6844_(EquipmentSlot.FEET).m_150922_(ItemTags.f_144320_);
        return bl && super.m_142079_();
    }

    @Override
    public boolean m_142038_() {
        return !this.f_19853_.m_5776_() && this.m_21023_(MobEffects.f_19619_) || super.m_142038_();
    }

    public void m_142223_(ClientboundAddMobPacket p_147206_) {
        double d = p_147206_.m_131557_();
        \u00e2\u02dc\u0192 = p_147206_.m_131558_();
        \u00e2\u02dc\u0192 = p_147206_.m_131559_();
        float \u00e2\u02dc\u01922 = (float)(p_147206_.m_131563_() * 360) / 256.0f;
        float \u00e2\u02dc\u01923 = (float)(p_147206_.m_131564_() * 360) / 256.0f;
        this.m_20167_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
        this.f_20883_ = (float)(p_147206_.m_131565_() * 360) / 256.0f;
        this.f_20885_ = (float)(p_147206_.m_131565_() * 360) / 256.0f;
        this.m_20234_(p_147206_.m_131552_());
        this.m_20084_(p_147206_.m_131555_());
        this.m_19890_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
        this.m_20334_((float)p_147206_.m_131560_() / 8000.0f, (float)p_147206_.m_131561_() / 8000.0f, (float)p_147206_.m_131562_() / 8000.0f);
    }
}

