/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.WeighedRandom;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BlockPosTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class LongJumpToRandomPos<E extends Mob>
extends Behavior<E> {
    private static final int f_147623_ = 20;
    private static final int f_147624_ = 40;
    private static final int f_147625_ = 8;
    public static final int f_147622_ = 200;
    private final UniformInt f_147626_;
    private final int f_147627_;
    private final int f_147628_;
    private final float f_147629_;
    private final List<PossibleJump> f_147630_ = new ArrayList<PossibleJump>();
    private Optional<Vec3> f_147631_ = Optional.empty();
    private Optional<PossibleJump> f_147632_ = Optional.empty();
    private int f_147633_;
    private long f_147634_;
    private Function<E, SoundEvent> f_147635_;

    public LongJumpToRandomPos(UniformInt p_147637_, int p_147638_, int p_147639_, float p_147640_, Function<E, SoundEvent> p_147641_) {
        super((Map<MemoryModuleType<?>, MemoryStatus>)ImmutableMap.of(MemoryModuleType.f_26371_, (Object)((Object)MemoryStatus.REGISTERED), MemoryModuleType.f_148199_, (Object)((Object)MemoryStatus.VALUE_ABSENT), MemoryModuleType.f_148200_, (Object)((Object)MemoryStatus.VALUE_ABSENT)), 200);
        this.f_147626_ = p_147637_;
        this.f_147627_ = p_147638_;
        this.f_147628_ = p_147639_;
        this.f_147629_ = p_147640_;
        this.f_147635_ = p_147641_;
    }

    @Override
    protected boolean m_6114_(ServerLevel p_147650_, Mob p_147651_) {
        return p_147651_.m_20096_() && !p_147650_.m_8055_(p_147651_.m_142538_()).m_60713_(Blocks.f_50719_);
    }

    @Override
    protected boolean m_6737_(ServerLevel p_147653_, Mob p_147654_, long p_147655_) {
        boolean bl;
        boolean bl2 = bl = this.f_147631_.isPresent() && this.f_147631_.get().equals(p_147654_.m_20182_()) && this.f_147633_ > 0 && (this.f_147632_.isPresent() || !this.f_147630_.isEmpty());
        if (!bl && !p_147654_.m_6274_().m_21952_(MemoryModuleType.f_148200_).isPresent()) {
            p_147654_.m_6274_().m_21879_(MemoryModuleType.f_148199_, this.f_147626_.m_142270_(p_147653_.f_46441_) / 2);
        }
        return bl;
    }

    @Override
    protected void m_6735_(ServerLevel p_147676_, Mob p_147677_, long p_147678_) {
        this.f_147632_ = Optional.empty();
        this.f_147633_ = 20;
        this.f_147630_.clear();
        this.f_147631_ = Optional.of(p_147677_.m_20182_());
        BlockPos blockPos = p_147677_.m_142538_();
        int \u00e2\u02dc\u01922 = blockPos.m_123341_();
        int \u00e2\u02dc\u01923 = blockPos.m_123342_();
        int \u00e2\u02dc\u01924 = blockPos.m_123343_();
        Iterable<BlockPos> \u00e2\u02dc\u01925 = BlockPos.m_121976_(\u00e2\u02dc\u01922 - this.f_147628_, \u00e2\u02dc\u01923 - this.f_147627_, \u00e2\u02dc\u01924 - this.f_147628_, \u00e2\u02dc\u01922 + this.f_147628_, \u00e2\u02dc\u01923 + this.f_147627_, \u00e2\u02dc\u01924 + this.f_147628_);
        PathNavigation \u00e2\u02dc\u01926 = p_147677_.m_21573_();
        for (BlockPos blockPos2 : \u00e2\u02dc\u01925) {
            double d = blockPos2.m_123331_(blockPos);
            if (\u00e2\u02dc\u01922 == blockPos2.m_123341_() && \u00e2\u02dc\u01924 == blockPos2.m_123343_() || !\u00e2\u02dc\u01926.m_6342_(blockPos2) || p_147677_.m_21439_(WalkNodeEvaluator.m_77604_(p_147677_.f_19853_, blockPos2.m_122032_())) != 0.0f) continue;
            Optional<Vec3> \u00e2\u02dc\u01927 = this.m_147656_(p_147677_, Vec3.m_82512_(blockPos2));
            \u00e2\u02dc\u01927.ifPresent(p_147670_ -> this.f_147630_.add(new PossibleJump(new BlockPos(blockPos2), (Vec3)p_147670_, Mth.m_14165_(d))));
        }
    }

    @Override
    protected void m_6725_(ServerLevel p_147680_, E p_147681_, long p_147682_) {
        if (this.f_147632_.isPresent()) {
            if (p_147682_ - this.f_147634_ >= 40L) {
                ((Entity)p_147681_).m_146922_(((Mob)p_147681_).f_20883_);
                ((LivingEntity)p_147681_).m_147244_(true);
                Vec3 vec3 = this.f_147632_.get().m_147694_();
                double \u00e2\u02dc\u01922 = vec3.m_82553_();
                double \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922 + ((LivingEntity)p_147681_).m_182332_();
                ((Entity)p_147681_).m_20256_(vec3.m_82490_(\u00e2\u02dc\u01923 / \u00e2\u02dc\u01922));
                ((LivingEntity)p_147681_).m_6274_().m_21879_(MemoryModuleType.f_148200_, true);
                p_147680_.m_6269_(null, (Entity)p_147681_, this.f_147635_.apply(p_147681_), SoundSource.NEUTRAL, 1.0f, 1.0f);
            }
        } else {
            --this.f_147633_;
            Optional<PossibleJump> optional = WeighedRandom.m_145034_(p_147680_.f_46441_, this.f_147630_);
            if (optional.isPresent()) {
                this.f_147630_.remove(optional.get());
                ((LivingEntity)p_147681_).m_6274_().m_21879_(MemoryModuleType.f_26371_, new BlockPosTracker(optional.get().m_147693_()));
                PathNavigation pathNavigation = ((Mob)p_147681_).m_21573_();
                Path \u00e2\u02dc\u01924 = pathNavigation.m_148218_(optional.get().m_147693_(), 0, 8);
                if (\u00e2\u02dc\u01924 == null || !\u00e2\u02dc\u01924.m_77403_()) {
                    this.f_147632_ = optional;
                    this.f_147634_ = p_147682_;
                }
            }
        }
    }

    private Optional<Vec3> m_147656_(Mob p_147657_, Vec3 p_147658_) {
        Optional<Vec3> optional = Optional.empty();
        for (int i = 65; i < 85; i += 5) {
            Optional<Vec3> optional2 = this.m_147659_(p_147657_, p_147658_, i);
            if (optional.isPresent() && (!optional2.isPresent() || !(optional2.get().m_82556_() < optional.get().m_82556_()))) continue;
            optional = optional2;
        }
        return optional;
    }

    private Optional<Vec3> m_147659_(Mob p_147660_, Vec3 p_147661_, int p_147662_) {
        Vec3 vec3 = p_147660_.m_20182_();
        \u00e2\u02dc\u0192 = new Vec3(p_147661_.f_82479_ - vec3.f_82479_, 0.0, p_147661_.f_82481_ - vec3.f_82481_).m_82541_().m_82490_(0.5);
        p_147661_ = p_147661_.m_82546_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = p_147661_.m_82546_(vec3);
        float \u00e2\u02dc\u01922 = (float)p_147662_ * (float)Math.PI / 180.0f;
        double \u00e2\u02dc\u01923 = Math.atan2(\u00e2\u02dc\u0192.f_82481_, \u00e2\u02dc\u0192.f_82479_);
        double \u00e2\u02dc\u01924 = \u00e2\u02dc\u0192.m_82492_(0.0, \u00e2\u02dc\u0192.f_82480_, 0.0).m_82556_();
        double \u00e2\u02dc\u01925 = Math.sqrt(\u00e2\u02dc\u01924);
        double \u00e2\u02dc\u01926 = \u00e2\u02dc\u0192.f_82480_;
        double \u00e2\u02dc\u01927 = Math.sin(2.0f * \u00e2\u02dc\u01922);
        double \u00e2\u02dc\u01928 = 0.08;
        double \u00e2\u02dc\u01929 = Math.pow(Math.cos(\u00e2\u02dc\u01922), 2.0);
        double \u00e2\u02dc\u019210 = Math.sin(\u00e2\u02dc\u01922);
        double \u00e2\u02dc\u019211 = Math.cos(\u00e2\u02dc\u01922);
        double \u00e2\u02dc\u019212 = Math.sin(\u00e2\u02dc\u01923);
        double \u00e2\u02dc\u019213 = Math.cos(\u00e2\u02dc\u01923);
        double \u00e2\u02dc\u019214 = \u00e2\u02dc\u01924 * 0.08 / (\u00e2\u02dc\u01925 * \u00e2\u02dc\u01927 - 2.0 * \u00e2\u02dc\u01926 * \u00e2\u02dc\u01929);
        if (\u00e2\u02dc\u019214 < 0.0) {
            return Optional.empty();
        }
        double \u00e2\u02dc\u019215 = Math.sqrt(\u00e2\u02dc\u019214);
        if (\u00e2\u02dc\u019215 > (double)this.f_147629_) {
            return Optional.empty();
        }
        double \u00e2\u02dc\u019216 = \u00e2\u02dc\u019215 * \u00e2\u02dc\u019211;
        double \u00e2\u02dc\u019217 = \u00e2\u02dc\u019215 * \u00e2\u02dc\u019210;
        int \u00e2\u02dc\u019218 = Mth.m_14165_(\u00e2\u02dc\u01925 / \u00e2\u02dc\u019216) * 2;
        double \u00e2\u02dc\u019219 = 0.0;
        \u00e2\u02dc\u019221 = null;
        for (int i = 0; i < \u00e2\u02dc\u019218 - 1; ++i) {
            double d = \u00e2\u02dc\u019210 / \u00e2\u02dc\u019211 * (\u00e2\u02dc\u019219 += \u00e2\u02dc\u01925 / (double)\u00e2\u02dc\u019218) - Math.pow(\u00e2\u02dc\u019219, 2.0) * 0.08 / (2.0 * \u00e2\u02dc\u019214 * Math.pow(\u00e2\u02dc\u019211, 2.0));
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u019219 * \u00e2\u02dc\u019213;
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u019219 * \u00e2\u02dc\u019212;
            Vec3 \u00e2\u02dc\u019220 = new Vec3(vec3.f_82479_ + \u00e2\u02dc\u0192, vec3.f_82480_ + d, vec3.f_82481_ + \u00e2\u02dc\u0192);
            if (\u00e2\u02dc\u019221 != null && !this.m_147663_(p_147660_, \u00e2\u02dc\u019221, \u00e2\u02dc\u019220)) {
                return Optional.empty();
            }
            Vec3 \u00e2\u02dc\u019221 = \u00e2\u02dc\u019220;
        }
        return Optional.of(new Vec3(\u00e2\u02dc\u019216 * \u00e2\u02dc\u019213, \u00e2\u02dc\u019217, \u00e2\u02dc\u019216 * \u00e2\u02dc\u019212).m_82490_(0.95f));
    }

    private boolean m_147663_(Mob p_147664_, Vec3 p_147665_, Vec3 p_147666_) {
        EntityDimensions entityDimensions = p_147664_.m_6972_(Pose.LONG_JUMPING);
        Vec3 \u00e2\u02dc\u01922 = p_147666_.m_82546_(p_147665_);
        double \u00e2\u02dc\u01923 = Math.min(entityDimensions.f_20377_, entityDimensions.f_20378_);
        int \u00e2\u02dc\u01924 = Mth.m_14165_(\u00e2\u02dc\u01922.m_82553_() / \u00e2\u02dc\u01923);
        Vec3 \u00e2\u02dc\u01925 = \u00e2\u02dc\u01922.m_82541_();
        Vec3 \u00e2\u02dc\u01926 = p_147665_;
        for (int i = 0; i < \u00e2\u02dc\u01924; ++i) {
            \u00e2\u02dc\u01926 = i == \u00e2\u02dc\u01924 - 1 ? p_147666_ : \u00e2\u02dc\u01926.m_82549_(\u00e2\u02dc\u01925.m_82490_(\u00e2\u02dc\u01923 * (double)0.9f));
            AABB aABB = entityDimensions.m_20393_(\u00e2\u02dc\u01926);
            if (p_147664_.f_19853_.m_45756_(p_147664_, aABB)) continue;
            return false;
        }
        return true;
    }

    @Override
    protected /* synthetic */ boolean m_6737_(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        return this.m_6737_(serverLevel, (Mob)livingEntity, l);
    }

    @Override
    protected /* synthetic */ void m_6725_(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.m_6725_(serverLevel, (E)((Mob)livingEntity), l);
    }

    @Override
    protected /* synthetic */ void m_6735_(ServerLevel serverLevel, LivingEntity livingEntity, long l) {
        this.m_6735_(serverLevel, (Mob)livingEntity, l);
    }

    public static class PossibleJump
    extends WeighedRandom.WeighedRandomItem {
        private final BlockPos f_147687_;
        private final Vec3 f_147688_;

        public PossibleJump(BlockPos p_147690_, Vec3 p_147691_, int p_147692_) {
            super(p_147692_);
            this.f_147687_ = p_147690_;
            this.f_147688_ = p_147691_;
        }

        public BlockPos m_147693_() {
            return this.f_147687_;
        }

        public Vec3 m_147694_() {
            return this.f_147688_;
        }
    }
}

