/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.ai.util;

import com.google.common.annotations.VisibleForTesting;
import java.util.Random;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToDoubleFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.phys.Vec3;

public class RandomPos {
    private static final int f_148535_ = 10;

    public static BlockPos m_148549_(Random p_148550_, int p_148551_, int p_148552_) {
        int n = p_148550_.nextInt(2 * p_148551_ + 1) - p_148551_;
        \u00e2\u02dc\u0192 = p_148550_.nextInt(2 * p_148552_ + 1) - p_148552_;
        \u00e2\u02dc\u0192 = p_148550_.nextInt(2 * p_148551_ + 1) - p_148551_;
        return new BlockPos(n, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
    }

    @Nullable
    public static BlockPos m_148553_(Random p_148554_, int p_148555_, int p_148556_, int p_148557_, double p_148558_, double p_148559_, double p_148560_) {
        double d = Mth.m_14136_(p_148559_, p_148558_) - 1.5707963705062866;
        \u00e2\u02dc\u0192 = d + (double)(2.0f * p_148554_.nextFloat() - 1.0f) * p_148560_;
        \u00e2\u02dc\u0192 = Math.sqrt(p_148554_.nextDouble()) * (double)Mth.f_13994_ * (double)p_148555_;
        \u00e2\u02dc\u0192 = -\u00e2\u02dc\u0192 * Math.sin(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 * Math.cos(\u00e2\u02dc\u0192);
        if (Math.abs(\u00e2\u02dc\u0192) > (double)p_148555_ || Math.abs(\u00e2\u02dc\u0192) > (double)p_148555_) {
            return null;
        }
        int \u00e2\u02dc\u01922 = p_148554_.nextInt(2 * p_148556_ + 1) - p_148556_ + p_148557_;
        return new BlockPos(\u00e2\u02dc\u0192, (double)\u00e2\u02dc\u01922, \u00e2\u02dc\u0192);
    }

    @VisibleForTesting
    public static BlockPos m_148545_(BlockPos p_148546_, int p_148547_, Predicate<BlockPos> p_148548_) {
        if (p_148548_.test(p_148546_)) {
            BlockPos blockPos = p_148546_.m_7494_();
            while (blockPos.m_123342_() < p_148547_ && p_148548_.test(blockPos)) {
                blockPos = blockPos.m_7494_();
            }
            return blockPos;
        }
        return p_148546_;
    }

    @VisibleForTesting
    public static BlockPos m_26947_(BlockPos p_26948_, int p_26949_, int p_26950_, Predicate<BlockPos> p_26951_) {
        if (p_26949_ < 0) {
            throw new IllegalArgumentException("aboveSolidAmount was " + p_26949_ + ", expected >= 0");
        }
        if (p_26951_.test(p_26948_)) {
            BlockPos blockPos = p_26948_.m_7494_();
            while (blockPos.m_123342_() < p_26950_ && p_26951_.test(blockPos)) {
                blockPos = blockPos.m_7494_();
            }
            \u00e2\u02dc\u0192 = blockPos;
            while (\u00e2\u02dc\u0192.m_123342_() < p_26950_ && \u00e2\u02dc\u0192.m_123342_() - blockPos.m_123342_() < p_26949_ && !p_26951_.test(\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.m_7494_())) {
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
            }
            return \u00e2\u02dc\u0192;
        }
        return p_26948_;
    }

    @Nullable
    public static Vec3 m_148542_(PathfinderMob p_148543_, Supplier<BlockPos> p_148544_) {
        return RandomPos.m_148561_(p_148544_, p_148543_::m_21692_);
    }

    @Nullable
    public static Vec3 m_148561_(Supplier<BlockPos> p_148562_, ToDoubleFunction<BlockPos> p_148563_) {
        double \u00e2\u02dc\u01923 = Double.NEGATIVE_INFINITY;
        BlockPos \u00e2\u02dc\u01922 = null;
        for (int i = 0; i < 10; ++i) {
            BlockPos blockPos = p_148562_.get();
            if (blockPos == null || !((\u00e2\u02dc\u0192 = p_148563_.applyAsDouble(blockPos)) > \u00e2\u02dc\u01923)) continue;
            \u00e2\u02dc\u01923 = \u00e2\u02dc\u0192;
            \u00e2\u02dc\u01922 = blockPos;
        }
        return \u00e2\u02dc\u01922 != null ? Vec3.m_82539_(\u00e2\u02dc\u01922) : null;
    }

    public static BlockPos m_148537_(PathfinderMob p_148538_, int p_148539_, Random p_148540_, BlockPos p_148541_) {
        int \u00e2\u02dc\u01923;
        int \u00e2\u02dc\u01922 = p_148541_.m_123341_();
        \u00e2\u02dc\u01923 = p_148541_.m_123343_();
        if (p_148538_.m_21536_() && p_148539_ > 1) {
            BlockPos blockPos = p_148538_.m_21534_();
            \u00e2\u02dc\u01922 = p_148538_.m_20185_() > (double)blockPos.m_123341_() ? (\u00e2\u02dc\u01922 -= p_148540_.nextInt(p_148539_ / 2)) : (\u00e2\u02dc\u01922 += p_148540_.nextInt(p_148539_ / 2));
            \u00e2\u02dc\u01923 = p_148538_.m_20189_() > (double)blockPos.m_123343_() ? (\u00e2\u02dc\u01923 -= p_148540_.nextInt(p_148539_ / 2)) : (\u00e2\u02dc\u01923 += p_148540_.nextInt(p_148539_ / 2));
        }
        return new BlockPos((double)\u00e2\u02dc\u01922 + p_148538_.m_20185_(), (double)p_148541_.m_123342_() + p_148538_.m_20186_(), (double)\u00e2\u02dc\u01923 + p_148538_.m_20189_());
    }
}

