/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.boss.enderdragon;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddMobPacket;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.EntityDamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.boss.EnderDragonPart;
import net.minecraft.world.entity.boss.enderdragon.EndCrystal;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonPhaseInstance;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhase;
import net.minecraft.world.entity.boss.enderdragon.phases.EnderDragonPhaseManager;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.dimension.end.EndDragonFight;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.feature.EndPodiumFeature;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.pathfinder.BinaryHeap;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnderDragon
extends Mob
implements Enemy {
    private static final Logger f_31087_ = LogManager.getLogger();
    public static final EntityDataAccessor<Integer> f_31067_ = SynchedEntityData.m_135353_(EnderDragon.class, EntityDataSerializers.f_135028_);
    private static final TargetingConditions f_31088_ = TargetingConditions.m_148352_().m_26883_(64.0);
    private static final int f_149566_ = 200;
    private static final int f_149567_ = 400;
    private static final float f_149568_ = 0.25f;
    private static final String f_149569_ = "DragonDeathTime";
    private static final String f_149570_ = "DragonPhase";
    public final double[][] f_31092_ = new double[64][3];
    public int f_31093_ = -1;
    private final EnderDragonPart[] f_31089_;
    public final EnderDragonPart f_31080_;
    private final EnderDragonPart f_31090_;
    private final EnderDragonPart f_31091_;
    private final EnderDragonPart f_31068_;
    private final EnderDragonPart f_31069_;
    private final EnderDragonPart f_31070_;
    private final EnderDragonPart f_31071_;
    private final EnderDragonPart f_31072_;
    public float f_31081_;
    public float f_31082_;
    public boolean f_31083_;
    public int f_31084_;
    public float f_31085_;
    @Nullable
    public EndCrystal f_31086_;
    @Nullable
    private final EndDragonFight f_31073_;
    private final EnderDragonPhaseManager f_31074_;
    private int f_31075_ = 100;
    private int f_31076_;
    private final Node[] f_31077_ = new Node[24];
    private final int[] f_31078_ = new int[24];
    private final BinaryHeap f_31079_ = new BinaryHeap();

    public EnderDragon(EntityType<? extends EnderDragon> p_31096_, Level p_31097_) {
        super((EntityType<? extends Mob>)EntityType.f_20565_, p_31097_);
        this.f_31080_ = new EnderDragonPart(this, "head", 1.0f, 1.0f);
        this.f_31090_ = new EnderDragonPart(this, "neck", 3.0f, 3.0f);
        this.f_31091_ = new EnderDragonPart(this, "body", 5.0f, 3.0f);
        this.f_31068_ = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.f_31069_ = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.f_31070_ = new EnderDragonPart(this, "tail", 2.0f, 2.0f);
        this.f_31071_ = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.f_31072_ = new EnderDragonPart(this, "wing", 4.0f, 2.0f);
        this.f_31089_ = new EnderDragonPart[]{this.f_31080_, this.f_31090_, this.f_31091_, this.f_31068_, this.f_31069_, this.f_31070_, this.f_31071_, this.f_31072_};
        this.m_21153_(this.m_21233_());
        this.f_19794_ = true;
        this.f_19811_ = true;
        this.f_31073_ = p_31097_ instanceof ServerLevel ? ((ServerLevel)p_31097_).m_8586_() : null;
        this.f_31074_ = new EnderDragonPhaseManager(this);
    }

    public static AttributeSupplier.Builder m_31167_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 200.0);
    }

    @Override
    public boolean m_142039_() {
        float f = Mth.m_14089_(this.f_31082_ * ((float)Math.PI * 2));
        \u00e2\u02dc\u0192 = Mth.m_14089_(this.f_31081_ * ((float)Math.PI * 2));
        return \u00e2\u02dc\u0192 <= -0.3f && f >= -0.3f;
    }

    @Override
    public void m_142043_() {
        if (this.f_19853_.f_46443_ && !this.m_20067_()) {
            this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11893_, this.m_5720_(), 5.0f, 0.8f + this.f_19796_.nextFloat() * 0.3f, false);
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.m_20088_().m_135372_(f_31067_, EnderDragonPhase.f_31387_.m_31405_());
    }

    public double[] m_31101_(int p_31102_, float p_31103_) {
        if (this.m_21224_()) {
            p_31103_ = 0.0f;
        }
        p_31103_ = 1.0f - p_31103_;
        int n = this.f_31093_ - p_31102_ & 0x3F;
        \u00e2\u02dc\u0192 = this.f_31093_ - p_31102_ - 1 & 0x3F;
        double[] \u00e2\u02dc\u01922 = new double[3];
        double \u00e2\u02dc\u01923 = this.f_31092_[n][0];
        double \u00e2\u02dc\u01924 = Mth.m_14175_(this.f_31092_[\u00e2\u02dc\u0192][0] - \u00e2\u02dc\u01923);
        \u00e2\u02dc\u01922[0] = \u00e2\u02dc\u01923 + \u00e2\u02dc\u01924 * (double)p_31103_;
        \u00e2\u02dc\u01923 = this.f_31092_[n][1];
        \u00e2\u02dc\u01924 = this.f_31092_[\u00e2\u02dc\u0192][1] - \u00e2\u02dc\u01923;
        \u00e2\u02dc\u01922[1] = \u00e2\u02dc\u01923 + \u00e2\u02dc\u01924 * (double)p_31103_;
        \u00e2\u02dc\u01922[2] = Mth.m_14139_(p_31103_, this.f_31092_[n][2], this.f_31092_[\u00e2\u02dc\u0192][2]);
        return \u00e2\u02dc\u01922;
    }

    @Override
    public void m_8107_() {
        int n;
        float \u00e2\u02dc\u01928;
        float \u00e2\u02dc\u01927;
        float \u00e2\u02dc\u01926;
        Object \u00e2\u02dc\u01924;
        this.m_146874_();
        if (this.f_19853_.f_46443_) {
            this.m_21153_(this.m_21223_());
            if (!this.m_20067_() && !this.f_31074_.m_31415_().m_7080_() && --this.f_31075_ < 0) {
                this.f_19853_.m_7785_(this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11894_, this.m_5720_(), 2.5f, 0.8f + this.f_19796_.nextFloat() * 0.3f, false);
                this.f_31075_ = 200 + this.f_19796_.nextInt(200);
            }
        }
        this.f_31081_ = this.f_31082_;
        if (this.m_21224_()) {
            float f = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            \u00e2\u02dc\u0192 = (this.f_19796_.nextFloat() - 0.5f) * 4.0f;
            \u00e2\u02dc\u0192 = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            this.f_19853_.m_7106_(ParticleTypes.f_123813_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)\u00e2\u02dc\u0192, this.m_20189_() + (double)\u00e2\u02dc\u0192, 0.0, 0.0, 0.0);
            return;
        }
        this.m_31160_();
        Vec3 vec3 = this.m_20184_();
        float \u00e2\u02dc\u01922 = 0.2f / ((float)vec3.m_165924_() * 10.0f + 1.0f);
        this.f_31082_ = this.f_31074_.m_31415_().m_7080_() ? (this.f_31082_ += 0.1f) : (this.f_31083_ ? (this.f_31082_ += \u00e2\u02dc\u01922 * 0.5f) : (this.f_31082_ += (\u00e2\u02dc\u01922 *= (float)Math.pow(2.0, vec3.f_82480_))));
        this.m_146922_(Mth.m_14177_(this.m_146908_()));
        if (this.m_21525_()) {
            this.f_31082_ = 0.5f;
            return;
        }
        if (this.f_31093_ < 0) {
            for (int i = 0; i < this.f_31092_.length; ++i) {
                this.f_31092_[i][0] = this.m_146908_();
                this.f_31092_[i][1] = this.m_20186_();
            }
        }
        if (++this.f_31093_ == this.f_31092_.length) {
            this.f_31093_ = 0;
        }
        this.f_31092_[this.f_31093_][0] = this.m_146908_();
        this.f_31092_[this.f_31093_][1] = this.m_20186_();
        if (this.f_19853_.f_46443_) {
            if (this.f_20903_ > 0) {
                double d = this.m_20185_() + (this.f_20904_ - this.m_20185_()) / (double)this.f_20903_;
                d = this.m_20186_() + (this.f_20905_ - this.m_20186_()) / (double)this.f_20903_;
                \u00e2\u02dc\u0192 = this.m_20189_() + (this.f_20906_ - this.m_20189_()) / (double)this.f_20903_;
                \u00e2\u02dc\u0192 = Mth.m_14175_(this.f_20907_ - (double)this.m_146908_());
                this.m_146922_(this.m_146908_() + (float)\u00e2\u02dc\u0192 / (float)this.f_20903_);
                this.m_146926_(this.m_146909_() + (float)(this.f_20908_ - (double)this.m_146909_()) / (float)this.f_20903_);
                --this.f_20903_;
                this.m_6034_(d, d, \u00e2\u02dc\u0192);
                this.m_19915_(this.m_146908_(), this.m_146909_());
            }
            this.f_31074_.m_31415_().m_6991_();
        } else {
            DragonPhaseInstance dragonPhaseInstance = this.f_31074_.m_31415_();
            dragonPhaseInstance.m_6989_();
            if (this.f_31074_.m_31415_() != dragonPhaseInstance) {
                dragonPhaseInstance = this.f_31074_.m_31415_();
                dragonPhaseInstance.m_6989_();
            }
            if ((\u00e2\u02dc\u0192 = dragonPhaseInstance.m_5535_()) != null) {
                double d = \u00e2\u02dc\u0192.f_82479_ - this.m_20185_();
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.f_82480_ - this.m_20186_();
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192.f_82481_ - this.m_20189_();
                \u00e2\u02dc\u0192 = d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192;
                float \u00e2\u02dc\u01923 = dragonPhaseInstance.m_7072_();
                \u00e2\u02dc\u0192 = Math.sqrt(d * d + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
                if (\u00e2\u02dc\u0192 > 0.0) {
                    \u00e2\u02dc\u0192 = Mth.m_14008_(\u00e2\u02dc\u0192 / \u00e2\u02dc\u0192, -\u00e2\u02dc\u01923, \u00e2\u02dc\u01923);
                }
                this.m_20256_(this.m_20184_().m_82520_(0.0, \u00e2\u02dc\u0192 * 0.01, 0.0));
                this.m_146922_(Mth.m_14177_(this.m_146908_()));
                \u00e2\u02dc\u01924 = \u00e2\u02dc\u0192.m_82492_(this.m_20185_(), this.m_20186_(), this.m_20189_()).m_82541_();
                Vec3 \u00e2\u02dc\u01925 = new Vec3(Mth.m_14031_(this.m_146908_() * ((float)Math.PI / 180)), this.m_20184_().f_82480_, -Mth.m_14089_(this.m_146908_() * ((float)Math.PI / 180))).m_82541_();
                \u00e2\u02dc\u01926 = Math.max(((float)\u00e2\u02dc\u01925.m_82526_((Vec3)\u00e2\u02dc\u01924) + 0.5f) / 1.5f, 0.0f);
                if (Math.abs(d) > (double)1.0E-5f || Math.abs(\u00e2\u02dc\u0192) > (double)1.0E-5f) {
                    \u00e2\u02dc\u0192 = Mth.m_14008_(Mth.m_14175_(180.0 - Mth.m_14136_(d, \u00e2\u02dc\u0192) * 57.2957763671875 - (double)this.m_146908_()), -50.0, 50.0);
                    this.f_31085_ *= 0.8f;
                    this.f_31085_ = (float)((double)this.f_31085_ + \u00e2\u02dc\u0192 * (double)dragonPhaseInstance.m_7089_());
                    this.m_146922_(this.m_146908_() + this.f_31085_ * 0.1f);
                }
                \u00e2\u02dc\u01927 = (float)(2.0 / (\u00e2\u02dc\u0192 + 1.0));
                \u00e2\u02dc\u01928 = 0.06f;
                this.m_19920_(0.06f * (\u00e2\u02dc\u01926 * \u00e2\u02dc\u01927 + (1.0f - \u00e2\u02dc\u01927)), new Vec3(0.0, 0.0, -1.0));
                if (this.f_31083_) {
                    this.m_6478_(MoverType.SELF, this.m_20184_().m_82490_(0.8f));
                } else {
                    this.m_6478_(MoverType.SELF, this.m_20184_());
                }
                Vec3 \u00e2\u02dc\u01929 = this.m_20184_().m_82541_();
                \u00e2\u02dc\u0192 = 0.8 + 0.15 * (\u00e2\u02dc\u01929.m_82526_(\u00e2\u02dc\u01925) + 1.0) / 2.0;
                this.m_20256_(this.m_20184_().m_82542_(\u00e2\u02dc\u0192, 0.91f, \u00e2\u02dc\u0192));
            }
        }
        this.f_20883_ = this.m_146908_();
        Vec3[] vec3Array = new Vec3[this.f_31089_.length];
        for (int i = 0; i < this.f_31089_.length; ++i) {
            vec3Array[i] = new Vec3(this.f_31089_[i].m_20185_(), this.f_31089_[i].m_20186_(), this.f_31089_[i].m_20189_());
        }
        float f = (float)(this.m_31101_(5, 1.0f)[1] - this.m_31101_(10, 1.0f)[1]) * 10.0f * ((float)Math.PI / 180);
        \u00e2\u02dc\u0192 = Mth.m_14089_(f);
        \u00e2\u02dc\u0192 = Mth.m_14031_(f);
        \u00e2\u02dc\u0192 = this.m_146908_() * ((float)Math.PI / 180);
        \u00e2\u02dc\u0192 = Mth.m_14031_(\u00e2\u02dc\u0192);
        \u00e2\u02dc\u0192 = Mth.m_14089_(\u00e2\u02dc\u0192);
        this.m_31115_(this.f_31091_, \u00e2\u02dc\u0192 * 0.5f, 0.0, -\u00e2\u02dc\u0192 * 0.5f);
        this.m_31115_(this.f_31071_, \u00e2\u02dc\u0192 * 4.5f, 2.0, \u00e2\u02dc\u0192 * 4.5f);
        this.m_31115_(this.f_31072_, \u00e2\u02dc\u0192 * -4.5f, 2.0, \u00e2\u02dc\u0192 * -4.5f);
        if (!this.f_19853_.f_46443_ && this.f_20916_ == 0) {
            this.m_31131_(this.f_19853_.m_6249_(this, this.f_31071_.m_142469_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
            this.m_31131_(this.f_19853_.m_6249_(this, this.f_31072_.m_142469_().m_82377_(4.0, 2.0, 4.0).m_82386_(0.0, -2.0, 0.0), EntitySelector.f_20406_));
            this.m_31141_(this.f_19853_.m_6249_(this, this.f_31080_.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
            this.m_31141_(this.f_19853_.m_6249_(this, this.f_31090_.m_142469_().m_82400_(1.0), EntitySelector.f_20406_));
        }
        \u00e2\u02dc\u0192 = Mth.m_14031_(this.m_146908_() * ((float)Math.PI / 180) - this.f_31085_ * 0.01f);
        \u00e2\u02dc\u0192 = Mth.m_14089_(this.m_146908_() * ((float)Math.PI / 180) - this.f_31085_ * 0.01f);
        \u00e2\u02dc\u0192 = this.m_31159_();
        this.m_31115_(this.f_31080_, \u00e2\u02dc\u0192 * 6.5f * \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * 6.5f, -\u00e2\u02dc\u0192 * 6.5f * \u00e2\u02dc\u0192);
        this.m_31115_(this.f_31090_, \u00e2\u02dc\u0192 * 5.5f * \u00e2\u02dc\u0192, \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * 5.5f, -\u00e2\u02dc\u0192 * 5.5f * \u00e2\u02dc\u0192);
        double[] \u00e2\u02dc\u019210 = this.m_31101_(5, 1.0f);
        for (n = 0; n < 3; ++n) {
            EnderDragonPart enderDragonPart = null;
            if (n == 0) {
                enderDragonPart = this.f_31068_;
            }
            if (n == 1) {
                enderDragonPart = this.f_31069_;
            }
            if (n == 2) {
                enderDragonPart = this.f_31070_;
            }
            \u00e2\u02dc\u01924 = this.m_31101_(12 + n * 2, 1.0f);
            float \u00e2\u02dc\u019211 = this.m_146908_() * ((float)Math.PI / 180) + this.m_31164_((double)(\u00e2\u02dc\u01924[0] - \u00e2\u02dc\u019210[0])) * ((float)Math.PI / 180);
            \u00e2\u02dc\u01926 = Mth.m_14031_(\u00e2\u02dc\u019211);
            \u00e2\u02dc\u01927 = Mth.m_14089_(\u00e2\u02dc\u019211);
            \u00e2\u02dc\u01928 = 1.5f;
            float \u00e2\u02dc\u019212 = (float)(n + 1) * 2.0f;
            this.m_31115_(enderDragonPart, -(\u00e2\u02dc\u0192 * 1.5f + \u00e2\u02dc\u01926 * \u00e2\u02dc\u019212) * \u00e2\u02dc\u0192, (double)(\u00e2\u02dc\u01924[1] - \u00e2\u02dc\u019210[1] - (double)((\u00e2\u02dc\u019212 + 1.5f) * \u00e2\u02dc\u0192) + 1.5), (\u00e2\u02dc\u0192 * 1.5f + \u00e2\u02dc\u01927 * \u00e2\u02dc\u019212) * \u00e2\u02dc\u0192);
        }
        if (!this.f_19853_.f_46443_) {
            this.f_31083_ = this.m_31139_(this.f_31080_.m_142469_()) | this.m_31139_(this.f_31090_.m_142469_()) | this.m_31139_(this.f_31091_.m_142469_());
            if (this.f_31073_ != null) {
                this.f_31073_.m_64096_(this);
            }
        }
        for (n = 0; n < this.f_31089_.length; ++n) {
            this.f_31089_[n].f_19854_ = vec3Array[n].f_82479_;
            this.f_31089_[n].f_19855_ = vec3Array[n].f_82480_;
            this.f_31089_[n].f_19856_ = vec3Array[n].f_82481_;
            this.f_31089_[n].f_19790_ = vec3Array[n].f_82479_;
            this.f_31089_[n].f_19791_ = vec3Array[n].f_82480_;
            this.f_31089_[n].f_19792_ = vec3Array[n].f_82481_;
        }
    }

    private void m_31115_(EnderDragonPart p_31116_, double p_31117_, double p_31118_, double p_31119_) {
        p_31116_.m_6034_(this.m_20185_() + p_31117_, this.m_20186_() + p_31118_, this.m_20189_() + p_31119_);
    }

    private float m_31159_() {
        if (this.f_31074_.m_31415_().m_7080_()) {
            return -1.0f;
        }
        double[] dArray = this.m_31101_(5, 1.0f);
        \u00e2\u02dc\u0192 = this.m_31101_(0, 1.0f);
        return (float)(dArray[1] - \u00e2\u02dc\u0192[1]);
    }

    private void m_31160_() {
        if (this.f_31086_ != null) {
            if (this.f_31086_.m_146910_()) {
                this.f_31086_ = null;
            } else if (this.f_19797_ % 10 == 0 && this.m_21223_() < this.m_21233_()) {
                this.m_21153_(this.m_21223_() + 1.0f);
            }
        }
        if (this.f_19796_.nextInt(10) == 0) {
            List<EndCrystal> list = this.f_19853_.m_45976_(EndCrystal.class, this.m_142469_().m_82400_(32.0));
            EndCrystal \u00e2\u02dc\u01922 = null;
            double \u00e2\u02dc\u01923 = Double.MAX_VALUE;
            for (EndCrystal endCrystal : list) {
                double d = endCrystal.m_20280_(this);
                if (!(d < \u00e2\u02dc\u01923)) continue;
                \u00e2\u02dc\u01923 = d;
                \u00e2\u02dc\u01922 = endCrystal;
            }
            this.f_31086_ = \u00e2\u02dc\u01922;
        }
    }

    private void m_31131_(List<Entity> p_31132_) {
        double d = (this.f_31091_.m_142469_().f_82288_ + this.f_31091_.m_142469_().f_82291_) / 2.0;
        \u00e2\u02dc\u0192 = (this.f_31091_.m_142469_().f_82290_ + this.f_31091_.m_142469_().f_82293_) / 2.0;
        for (Entity entity : p_31132_) {
            if (!(entity instanceof LivingEntity)) continue;
            double d2 = entity.m_20185_() - d;
            \u00e2\u02dc\u0192 = entity.m_20189_() - \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = Math.max(d2 * d2 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192, 0.1);
            entity.m_5997_(d2 / \u00e2\u02dc\u0192 * 4.0, 0.2f, \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192 * 4.0);
            if (this.f_31074_.m_31415_().m_7080_() || ((LivingEntity)entity).m_21213_() >= entity.f_19797_ - 2) continue;
            entity.m_6469_(DamageSource.m_19370_(this), 5.0f);
            this.m_19970_(this, entity);
        }
    }

    private void m_31141_(List<Entity> p_31142_) {
        for (Entity entity : p_31142_) {
            if (!(entity instanceof LivingEntity)) continue;
            entity.m_6469_(DamageSource.m_19370_(this), 10.0f);
            this.m_19970_(this, entity);
        }
    }

    private float m_31164_(double p_31165_) {
        return (float)Mth.m_14175_(p_31165_);
    }

    private boolean m_31139_(AABB p_31140_) {
        int n = Mth.m_14107_(p_31140_.f_82288_);
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_31140_.f_82289_);
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_31140_.f_82290_);
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_31140_.f_82291_);
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_31140_.f_82292_);
        \u00e2\u02dc\u0192 = Mth.m_14107_(p_31140_.f_82293_);
        boolean \u00e2\u02dc\u01922 = false;
        boolean \u00e2\u02dc\u01923 = false;
        for (\u00e2\u02dc\u0192 = n; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u0192; \u00e2\u02dc\u0192 <= \u00e2\u02dc\u0192; ++\u00e2\u02dc\u0192) {
                    BlockPos blockPos = new BlockPos(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
                    BlockState \u00e2\u02dc\u01924 = this.f_19853_.m_8055_(blockPos);
                    if (\u00e2\u02dc\u01924.m_60795_() || \u00e2\u02dc\u01924.m_60767_() == Material.f_76309_) continue;
                    if (!this.f_19853_.m_46469_().m_46207_(GameRules.f_46132_) || \u00e2\u02dc\u01924.m_60620_(BlockTags.f_13069_)) {
                        \u00e2\u02dc\u01922 = true;
                        continue;
                    }
                    \u00e2\u02dc\u01923 = this.f_19853_.m_7471_(blockPos, false) || \u00e2\u02dc\u01923;
                }
            }
        }
        if (\u00e2\u02dc\u01923) {
            \u00e2\u02dc\u0192 = new BlockPos(n + this.f_19796_.nextInt(\u00e2\u02dc\u0192 - n + 1), \u00e2\u02dc\u0192 + this.f_19796_.nextInt(\u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 + 1), \u00e2\u02dc\u0192 + this.f_19796_.nextInt(\u00e2\u02dc\u0192 - \u00e2\u02dc\u0192 + 1));
            this.f_19853_.m_46796_(2008, \u00e2\u02dc\u0192, 0);
        }
        return \u00e2\u02dc\u01922;
    }

    public boolean m_31120_(EnderDragonPart p_31121_, DamageSource p_31122_, float p_31123_) {
        if (this.f_31074_.m_31415_().m_7309_() == EnderDragonPhase.f_31386_) {
            return false;
        }
        p_31123_ = this.f_31074_.m_31415_().m_7584_(p_31122_, p_31123_);
        if (p_31121_ != this.f_31080_) {
            p_31123_ = p_31123_ / 4.0f + Math.min(p_31123_, 1.0f);
        }
        if (p_31123_ < 0.01f) {
            return false;
        }
        if (p_31122_.m_7639_() instanceof Player || p_31122_.m_19372_()) {
            float f = this.m_21223_();
            this.m_31161_(p_31122_, p_31123_);
            if (this.m_21224_() && !this.f_31074_.m_31415_().m_7080_()) {
                this.m_21153_(1.0f);
                this.f_31074_.m_31416_(EnderDragonPhase.f_31386_);
            }
            if (this.f_31074_.m_31415_().m_7080_()) {
                this.f_31076_ = (int)((float)this.f_31076_ + (f - this.m_21223_()));
                if ((float)this.f_31076_ > 0.25f * this.m_21233_()) {
                    this.f_31076_ = 0;
                    this.f_31074_.m_31416_(EnderDragonPhase.f_31381_);
                }
            }
        }
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource p_31113_, float p_31114_) {
        if (p_31113_ instanceof EntityDamageSource && ((EntityDamageSource)p_31113_).m_19403_()) {
            this.m_31120_(this.f_31091_, p_31113_, p_31114_);
        }
        return false;
    }

    protected boolean m_31161_(DamageSource p_31162_, float p_31163_) {
        return super.m_6469_(p_31162_, p_31163_);
    }

    @Override
    public void m_6074_() {
        this.m_142687_(Entity.RemovalReason.KILLED);
        if (this.f_31073_ != null) {
            this.f_31073_.m_64096_(this);
            this.f_31073_.m_64085_(this);
        }
    }

    @Override
    protected void m_6153_() {
        if (this.f_31073_ != null) {
            this.f_31073_.m_64096_(this);
        }
        ++this.f_31084_;
        if (this.f_31084_ >= 180 && this.f_31084_ <= 200) {
            float f = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            \u00e2\u02dc\u0192 = (this.f_19796_.nextFloat() - 0.5f) * 4.0f;
            \u00e2\u02dc\u0192 = (this.f_19796_.nextFloat() - 0.5f) * 8.0f;
            this.f_19853_.m_7106_(ParticleTypes.f_123812_, this.m_20185_() + (double)f, this.m_20186_() + 2.0 + (double)\u00e2\u02dc\u0192, this.m_20189_() + (double)\u00e2\u02dc\u0192, 0.0, 0.0, 0.0);
        }
        boolean bl = this.f_19853_.m_46469_().m_46207_(GameRules.f_46135_);
        int \u00e2\u02dc\u01922 = 500;
        if (this.f_31073_ != null && !this.f_31073_.m_64099_()) {
            \u00e2\u02dc\u01922 = 12000;
        }
        if (this.f_19853_ instanceof ServerLevel) {
            if (this.f_31084_ > 150 && this.f_31084_ % 5 == 0 && bl) {
                ExperienceOrb.m_147082_((ServerLevel)this.f_19853_, this.m_20182_(), Mth.m_14143_((float)\u00e2\u02dc\u01922 * 0.08f));
            }
            if (this.f_31084_ == 1 && !this.m_20067_()) {
                this.f_19853_.m_6798_(1028, this.m_142538_(), 0);
            }
        }
        this.m_6478_(MoverType.SELF, new Vec3(0.0, 0.1f, 0.0));
        this.m_146922_(this.m_146908_() + 20.0f);
        this.f_20883_ = this.m_146908_();
        if (this.f_31084_ == 200 && this.f_19853_ instanceof ServerLevel) {
            if (bl) {
                ExperienceOrb.m_147082_((ServerLevel)this.f_19853_, this.m_20182_(), Mth.m_14143_((float)\u00e2\u02dc\u01922 * 0.2f));
            }
            if (this.f_31073_ != null) {
                this.f_31073_.m_64085_(this);
            }
            this.m_142687_(Entity.RemovalReason.KILLED);
        }
    }

    public int m_31155_() {
        if (this.f_31077_[0] == null) {
            for (int i = 0; i < 24; ++i) {
                \u00e2\u02dc\u0192 = 5;
                \u00e2\u02dc\u0192 = i;
                if (i < 12) {
                    \u00e2\u02dc\u0192 = Mth.m_14143_(60.0f * Mth.m_14089_(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)\u00e2\u02dc\u0192)));
                    \u00e2\u02dc\u0192 = Mth.m_14143_(60.0f * Mth.m_14031_(2.0f * ((float)(-Math.PI) + 0.2617994f * (float)\u00e2\u02dc\u0192)));
                } else if (i < 20) {
                    \u00e2\u02dc\u0192 = Mth.m_14143_(40.0f * Mth.m_14089_(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)(\u00e2\u02dc\u0192 -= 12))));
                    \u00e2\u02dc\u0192 = Mth.m_14143_(40.0f * Mth.m_14031_(2.0f * ((float)(-Math.PI) + 0.3926991f * (float)\u00e2\u02dc\u0192)));
                    \u00e2\u02dc\u0192 += 10;
                } else {
                    \u00e2\u02dc\u0192 = Mth.m_14143_(20.0f * Mth.m_14089_(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)(\u00e2\u02dc\u0192 -= 20))));
                    \u00e2\u02dc\u0192 = Mth.m_14143_(20.0f * Mth.m_14031_(2.0f * ((float)(-Math.PI) + 0.7853982f * (float)\u00e2\u02dc\u0192)));
                }
                \u00e2\u02dc\u0192 = Math.max(this.f_19853_.m_5736_() + 10, this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, new BlockPos(\u00e2\u02dc\u0192, 0, \u00e2\u02dc\u0192)).m_123342_() + \u00e2\u02dc\u0192);
                this.f_31077_[i] = new Node(\u00e2\u02dc\u0192, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
            }
            this.f_31078_[0] = 6146;
            this.f_31078_[1] = 8197;
            this.f_31078_[2] = 8202;
            this.f_31078_[3] = 16404;
            this.f_31078_[4] = 32808;
            this.f_31078_[5] = 32848;
            this.f_31078_[6] = 65696;
            this.f_31078_[7] = 131392;
            this.f_31078_[8] = 131712;
            this.f_31078_[9] = 263424;
            this.f_31078_[10] = 526848;
            this.f_31078_[11] = 525313;
            this.f_31078_[12] = 1581057;
            this.f_31078_[13] = 3166214;
            this.f_31078_[14] = 2138120;
            this.f_31078_[15] = 6373424;
            this.f_31078_[16] = 4358208;
            this.f_31078_[17] = 12910976;
            this.f_31078_[18] = 9044480;
            this.f_31078_[19] = 9706496;
            this.f_31078_[20] = 15216640;
            this.f_31078_[21] = 0xD0E000;
            this.f_31078_[22] = 11763712;
            this.f_31078_[23] = 0x7E0000;
        }
        return this.m_31170_(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public int m_31170_(double p_31171_, double p_31172_, double p_31173_) {
        float f = 10000.0f;
        int \u00e2\u02dc\u01922 = 0;
        Node \u00e2\u02dc\u01923 = new Node(Mth.m_14107_(p_31171_), Mth.m_14107_(p_31172_), Mth.m_14107_(p_31173_));
        int \u00e2\u02dc\u01924 = 0;
        if (this.f_31073_ == null || this.f_31073_.m_64098_() == 0) {
            \u00e2\u02dc\u01924 = 12;
        }
        for (int i = \u00e2\u02dc\u01924; i < 24; ++i) {
            if (this.f_31077_[i] == null || !((\u00e2\u02dc\u0192 = this.f_31077_[i].m_77299_(\u00e2\u02dc\u01923)) < f)) continue;
            f = \u00e2\u02dc\u0192;
            \u00e2\u02dc\u01922 = i;
        }
        return \u00e2\u02dc\u01922;
    }

    @Nullable
    public Path m_31104_(int p_31105_, int p_31106_, @Nullable Node p_31107_) {
        for (int i = 0; i < 24; ++i) {
            Node node = this.f_31077_[i];
            node.f_77279_ = false;
            node.f_77277_ = 0.0f;
            node.f_77275_ = 0.0f;
            node.f_77276_ = 0.0f;
            node.f_77278_ = null;
            node.f_77274_ = -1;
        }
        Node node = this.f_31077_[p_31105_];
        node = this.f_31077_[p_31106_];
        node.f_77275_ = 0.0f;
        node.f_77277_ = node.f_77276_ = node.m_77293_(node);
        this.f_31079_.m_77081_();
        this.f_31079_.m_77084_(node);
        \u00e2\u02dc\u0192 = node;
        int \u00e2\u02dc\u01922 = 0;
        if (this.f_31073_ == null || this.f_31073_.m_64098_() == 0) {
            \u00e2\u02dc\u01922 = 12;
        }
        while (!this.f_31079_.m_77092_()) {
            \u00e2\u02dc\u0192 = this.f_31079_.m_77091_();
            if (\u00e2\u02dc\u0192.equals(node)) {
                if (p_31107_ != null) {
                    p_31107_.f_77278_ = node;
                    node = p_31107_;
                }
                return this.m_31128_(node, node);
            }
            if (\u00e2\u02dc\u0192.m_77293_(node) < \u00e2\u02dc\u0192.m_77293_(node)) {
                \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192;
            }
            \u00e2\u02dc\u0192.f_77279_ = true;
            int n = 0;
            for (\u00e2\u02dc\u0192 = 0; \u00e2\u02dc\u0192 < 24; ++\u00e2\u02dc\u0192) {
                if (this.f_31077_[\u00e2\u02dc\u0192] != \u00e2\u02dc\u0192) continue;
                n = \u00e2\u02dc\u0192;
                break;
            }
            for (\u00e2\u02dc\u0192 = \u00e2\u02dc\u01922; \u00e2\u02dc\u0192 < 24; ++\u00e2\u02dc\u0192) {
                if ((this.f_31078_[n] & 1 << \u00e2\u02dc\u0192) <= 0) continue;
                Node node2 = this.f_31077_[\u00e2\u02dc\u0192];
                if (node2.f_77279_) continue;
                float \u00e2\u02dc\u01923 = \u00e2\u02dc\u0192.f_77275_ + \u00e2\u02dc\u0192.m_77293_(node2);
                if (node2.m_77303_() && !(\u00e2\u02dc\u01923 < node2.f_77275_)) continue;
                node2.f_77278_ = \u00e2\u02dc\u0192;
                node2.f_77275_ = \u00e2\u02dc\u01923;
                node2.f_77276_ = node2.m_77293_(node);
                if (node2.m_77303_()) {
                    this.f_31079_.m_77086_(node2, node2.f_77275_ + node2.f_77276_);
                    continue;
                }
                node2.f_77277_ = node2.f_77275_ + node2.f_77276_;
                this.f_31079_.m_77084_(node2);
            }
        }
        if (\u00e2\u02dc\u0192 == node) {
            return null;
        }
        f_31087_.debug("Failed to find path from {} to {}", (Object)p_31105_, (Object)p_31106_);
        if (p_31107_ != null) {
            p_31107_.f_77278_ = \u00e2\u02dc\u0192;
            \u00e2\u02dc\u0192 = p_31107_;
        }
        return this.m_31128_(node, \u00e2\u02dc\u0192);
    }

    private Path m_31128_(Node p_31129_, Node p_31130_) {
        ArrayList arrayList = Lists.newArrayList();
        Node \u00e2\u02dc\u01922 = p_31130_;
        arrayList.add(0, \u00e2\u02dc\u01922);
        while (\u00e2\u02dc\u01922.f_77278_ != null) {
            \u00e2\u02dc\u01922 = \u00e2\u02dc\u01922.f_77278_;
            arrayList.add(0, \u00e2\u02dc\u01922);
        }
        return new Path(arrayList, new BlockPos(p_31130_.f_77271_, p_31130_.f_77272_, p_31130_.f_77273_), true);
    }

    @Override
    public void m_7380_(CompoundTag p_31144_) {
        super.m_7380_(p_31144_);
        p_31144_.m_128405_(f_149570_, this.f_31074_.m_31415_().m_7309_().m_31405_());
        p_31144_.m_128405_(f_149569_, this.f_31084_);
    }

    @Override
    public void m_7378_(CompoundTag p_31134_) {
        super.m_7378_(p_31134_);
        if (p_31134_.m_128441_(f_149570_)) {
            this.f_31074_.m_31416_(EnderDragonPhase.m_31398_(p_31134_.m_128451_(f_149570_)));
        }
        if (p_31134_.m_128441_(f_149569_)) {
            this.f_31084_ = p_31134_.m_128451_(f_149569_);
        }
    }

    @Override
    public void m_6043_() {
    }

    public EnderDragonPart[] m_31156_() {
        return this.f_31089_;
    }

    @Override
    public boolean m_6087_() {
        return false;
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected SoundEvent m_7515_() {
        return SoundEvents.f_11890_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_31154_) {
        return SoundEvents.f_11895_;
    }

    @Override
    protected float m_6121_() {
        return 5.0f;
    }

    public float m_31108_(int p_31109_, double[] p_31110_, double[] p_31111_) {
        double \u00e2\u02dc\u01924;
        DragonPhaseInstance dragonPhaseInstance = this.f_31074_.m_31415_();
        EnderDragonPhase<? extends DragonPhaseInstance> \u00e2\u02dc\u01922 = dragonPhaseInstance.m_7309_();
        if (\u00e2\u02dc\u01922 == EnderDragonPhase.f_31380_ || \u00e2\u02dc\u01922 == EnderDragonPhase.f_31381_) {
            BlockPos blockPos = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
            double \u00e2\u02dc\u01923 = Math.max(Math.sqrt(blockPos.m_123309_(this.m_20182_(), true)) / 4.0, 1.0);
            \u00e2\u02dc\u01924 = (double)p_31109_ / \u00e2\u02dc\u01923;
        } else {
            \u00e2\u02dc\u01924 = dragonPhaseInstance.m_7080_() ? (double)p_31109_ : (p_31109_ == 6 ? 0.0 : p_31111_[1] - p_31110_[1]);
        }
        return (float)\u00e2\u02dc\u01924;
    }

    public Vec3 m_31174_(float p_31175_) {
        Vec3 \u00e2\u02dc\u01927;
        DragonPhaseInstance dragonPhaseInstance = this.f_31074_.m_31415_();
        EnderDragonPhase<? extends DragonPhaseInstance> \u00e2\u02dc\u01922 = dragonPhaseInstance.m_7309_();
        if (\u00e2\u02dc\u01922 == EnderDragonPhase.f_31380_ || \u00e2\u02dc\u01922 == EnderDragonPhase.f_31381_) {
            BlockPos blockPos = this.f_19853_.m_5452_(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, EndPodiumFeature.f_65714_);
            float \u00e2\u02dc\u01923 = Math.max((float)Math.sqrt(blockPos.m_123309_(this.m_20182_(), true)) / 4.0f, 1.0f);
            float \u00e2\u02dc\u01924 = 6.0f / \u00e2\u02dc\u01923;
            float \u00e2\u02dc\u01925 = this.m_146909_();
            float \u00e2\u02dc\u01926 = 1.5f;
            this.m_146926_(-\u00e2\u02dc\u01924 * 1.5f * 5.0f);
            \u00e2\u02dc\u01927 = this.m_20252_(p_31175_);
            this.m_146926_(\u00e2\u02dc\u01925);
        } else if (dragonPhaseInstance.m_7080_()) {
            float f = this.m_146909_();
            \u00e2\u02dc\u0192 = 1.5f;
            this.m_146926_(-45.0f);
            \u00e2\u02dc\u01927 = this.m_20252_(p_31175_);
            this.m_146926_(f);
        } else {
            \u00e2\u02dc\u01927 = this.m_20252_(p_31175_);
        }
        return \u00e2\u02dc\u01927;
    }

    public void m_31124_(EndCrystal p_31125_, BlockPos p_31126_, DamageSource p_31127_) {
        Player player = p_31127_.m_7639_() instanceof Player ? (Player)p_31127_.m_7639_() : this.f_19853_.m_45941_(f_31088_, p_31126_.m_123341_(), p_31126_.m_123342_(), p_31126_.m_123343_());
        if (p_31125_ == this.f_31086_) {
            this.m_31120_(this.f_31080_, DamageSource.m_19373_(player), 10.0f);
        }
        this.f_31074_.m_31415_().m_8059_(p_31125_, p_31126_, p_31127_, player);
    }

    @Override
    public void m_7350_(EntityDataAccessor<?> p_31136_) {
        if (f_31067_.equals(p_31136_) && this.f_19853_.f_46443_) {
            this.f_31074_.m_31416_(EnderDragonPhase.m_31398_(this.m_20088_().m_135370_(f_31067_)));
        }
        super.m_7350_(p_31136_);
    }

    public EnderDragonPhaseManager m_31157_() {
        return this.f_31074_;
    }

    @Nullable
    public EndDragonFight m_31158_() {
        return this.f_31073_;
    }

    @Override
    public boolean m_147207_(MobEffectInstance p_182394_, @Nullable Entity p_182395_) {
        return false;
    }

    @Override
    protected boolean m_7341_(Entity p_31169_) {
        return false;
    }

    @Override
    public boolean m_6072_() {
        return false;
    }

    @Override
    public void m_142223_(ClientboundAddMobPacket p_149572_) {
        super.m_142223_(p_149572_);
        EnderDragonPart[] enderDragonPartArray = this.m_31156_();
        for (int i = 0; i < enderDragonPartArray.length; ++i) {
            enderDragonPartArray[i].m_20234_(i + p_149572_.m_131552_());
        }
    }

    @Override
    public boolean m_6779_(LivingEntity p_149576_) {
        return p_149576_.m_142066_();
    }
}

