/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.npc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.DebugPackets;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ReputationEventHandler;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.VillagerGoalPackages;
import net.minecraft.world.entity.ai.gossip.GossipContainer;
import net.minecraft.world.entity.ai.gossip.GossipType;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.sensing.GolemSensor;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.ReputationEventType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Witch;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerData;
import net.minecraft.world.entity.npc.VillagerDataHolder;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.npc.VillagerType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.raid.Raid;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.entity.schedule.Schedule;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.apache.logging.log4j.Logger;

public class Villager
extends AbstractVillager
implements ReputationEventHandler,
VillagerDataHolder {
    private static final EntityDataAccessor<VillagerData> f_35371_ = SynchedEntityData.m_135353_(Villager.class, EntityDataSerializers.f_135043_);
    public static final int f_149997_ = 12;
    public static final Map<Item, Integer> f_35369_ = ImmutableMap.of((Object)Items.f_42406_, (Object)4, (Object)Items.f_42620_, (Object)1, (Object)Items.f_42619_, (Object)1, (Object)Items.f_42732_, (Object)1);
    private static final int f_149999_ = 2;
    private static final Set<Item> f_35372_ = ImmutableSet.of((Object)Items.f_42406_, (Object)Items.f_42620_, (Object)Items.f_42619_, (Object)Items.f_42405_, (Object)Items.f_42404_, (Object)Items.f_42732_, (Object[])new Item[]{Items.f_42733_});
    private static final int f_150000_ = 10;
    private static final int f_150001_ = 1200;
    private static final int f_150002_ = 24000;
    private static final int f_150003_ = 25;
    private static final int f_150004_ = 10;
    private static final int f_150005_ = 5;
    private static final long f_150006_ = 24000L;
    @VisibleForTesting
    public static final float f_149998_ = 0.5f;
    private int f_35373_;
    private boolean f_35374_;
    @Nullable
    private Player f_35375_;
    private boolean f_150007_;
    private byte f_35376_;
    private final GossipContainer f_35377_ = new GossipContainer();
    private long f_35378_;
    private long f_35361_;
    private int f_35362_;
    private long f_35363_;
    private int f_35364_;
    private long f_35365_;
    private boolean f_35366_;
    private static final ImmutableList<MemoryModuleType<?>> f_35367_ = ImmutableList.of(MemoryModuleType.f_26359_, MemoryModuleType.f_26360_, MemoryModuleType.f_26361_, MemoryModuleType.f_26362_, MemoryModuleType.f_148204_, MemoryModuleType.f_148205_, MemoryModuleType.f_26366_, MemoryModuleType.f_26367_, MemoryModuleType.f_26368_, MemoryModuleType.f_148206_, MemoryModuleType.f_26332_, MemoryModuleType.f_26370_, (Object[])new MemoryModuleType[]{MemoryModuleType.f_26371_, MemoryModuleType.f_26374_, MemoryModuleType.f_26375_, MemoryModuleType.f_26377_, MemoryModuleType.f_26379_, MemoryModuleType.f_26380_, MemoryModuleType.f_26381_, MemoryModuleType.f_26382_, MemoryModuleType.f_26323_, MemoryModuleType.f_26363_, MemoryModuleType.f_26324_, MemoryModuleType.f_26325_, MemoryModuleType.f_26326_, MemoryModuleType.f_26328_, MemoryModuleType.f_26329_, MemoryModuleType.f_26330_, MemoryModuleType.f_26327_});
    private static final ImmutableList<SensorType<? extends Sensor<? super Villager>>> f_35368_ = ImmutableList.of(SensorType.f_26811_, SensorType.f_26812_, SensorType.f_26810_, SensorType.f_26813_, SensorType.f_26814_, SensorType.f_26815_, SensorType.f_26816_, SensorType.f_26817_, SensorType.f_26818_);
    public static final Map<MemoryModuleType<GlobalPos>, BiPredicate<Villager, PoiType>> f_35370_ = ImmutableMap.of(MemoryModuleType.f_26359_, (p_35493_, p_35494_) -> p_35494_ == PoiType.f_27346_, MemoryModuleType.f_26360_, (p_35486_, p_35487_) -> p_35486_.m_7141_().m_35571_().m_35622_() == p_35487_, MemoryModuleType.f_26361_, (p_35469_, p_35470_) -> PoiType.f_27329_.test((PoiType)p_35470_), MemoryModuleType.f_26362_, (p_35434_, p_35435_) -> p_35435_ == PoiType.f_27347_);

    public Villager(EntityType<? extends Villager> p_35381_, Level p_35382_) {
        this(p_35381_, p_35382_, VillagerType.f_35821_);
    }

    public Villager(EntityType<? extends Villager> p_35384_, Level p_35385_, VillagerType p_35386_) {
        super((EntityType<? extends AbstractVillager>)p_35384_, p_35385_);
        ((GroundPathNavigation)this.m_21573_()).m_26477_(true);
        this.m_21573_().m_7008_(true);
        this.m_21553_(true);
        this.m_141967_(this.m_7141_().m_35567_(p_35386_).m_35565_(VillagerProfession.f_35585_));
    }

    public Brain<Villager> m_6274_() {
        return super.m_6274_();
    }

    protected Brain.Provider<Villager> m_5490_() {
        return Brain.m_21923_(f_35367_, f_35368_);
    }

    @Override
    protected Brain<?> m_8075_(Dynamic<?> p_35445_) {
        Brain<Villager> brain = this.m_5490_().m_22073_(p_35445_);
        this.m_35424_(brain);
        return brain;
    }

    public void m_35483_(ServerLevel p_35484_) {
        Brain<Villager> brain = this.m_6274_();
        brain.m_21933_(p_35484_, this);
        this.f_20939_ = brain.m_21973_();
        this.m_35424_(this.m_6274_());
    }

    private void m_35424_(Brain<Villager> p_35425_) {
        VillagerProfession villagerProfession = this.m_7141_().m_35571_();
        if (this.m_6162_()) {
            p_35425_.m_21912_(Schedule.f_38014_);
            p_35425_.m_21900_(Activity.f_37981_, VillagerGoalPackages.m_24583_(0.5f));
        } else {
            p_35425_.m_21912_(Schedule.f_38015_);
            p_35425_.m_21903_(Activity.f_37980_, (ImmutableList<Pair<Integer, Behavior<Villager>>>)VillagerGoalPackages.m_24589_(villagerProfession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.f_26360_, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
        }
        p_35425_.m_21900_(Activity.f_37978_, VillagerGoalPackages.m_24585_(villagerProfession, 0.5f));
        p_35425_.m_21903_(Activity.f_37983_, (ImmutableList<Pair<Integer, Behavior<Villager>>>)VillagerGoalPackages.m_24595_(villagerProfession, 0.5f), (Set<Pair<MemoryModuleType<?>, MemoryStatus>>)ImmutableSet.of((Object)Pair.of(MemoryModuleType.f_26362_, (Object)((Object)MemoryStatus.VALUE_PRESENT))));
        p_35425_.m_21900_(Activity.f_37982_, VillagerGoalPackages.m_24592_(villagerProfession, 0.5f));
        p_35425_.m_21900_(Activity.f_37979_, VillagerGoalPackages.m_24598_(villagerProfession, 0.5f));
        p_35425_.m_21900_(Activity.f_37984_, VillagerGoalPackages.m_24601_(villagerProfession, 0.5f));
        p_35425_.m_21900_(Activity.f_37986_, VillagerGoalPackages.m_24604_(villagerProfession, 0.5f));
        p_35425_.m_21900_(Activity.f_37985_, VillagerGoalPackages.m_24607_(villagerProfession, 0.5f));
        p_35425_.m_21900_(Activity.f_37987_, VillagerGoalPackages.m_24610_(villagerProfession, 0.5f));
        p_35425_.m_21930_((Set<Activity>)ImmutableSet.of((Object)Activity.f_37978_));
        p_35425_.m_21944_(Activity.f_37979_);
        p_35425_.m_21889_(Activity.f_37979_);
        p_35425_.m_21862_(this.f_19853_.m_46468_(), this.f_19853_.m_46467_());
    }

    @Override
    protected void m_142669_() {
        super.m_142669_();
        if (this.f_19853_ instanceof ServerLevel) {
            this.m_35483_((ServerLevel)this.f_19853_);
        }
    }

    public static AttributeSupplier.Builder m_35503_() {
        return Mob.m_21552_().m_22268_(Attributes.f_22279_, 0.5).m_22268_(Attributes.f_22277_, 48.0);
    }

    public boolean m_35504_() {
        return this.f_35366_;
    }

    @Override
    protected void m_8024_() {
        Raid raid;
        this.f_19853_.m_46473_().m_6180_("villagerBrain");
        this.m_6274_().m_21865_((ServerLevel)this.f_19853_, this);
        this.f_19853_.m_46473_().m_7238_();
        if (this.f_35366_) {
            this.f_35366_ = false;
        }
        if (!this.m_35306_() && this.f_35373_ > 0) {
            --this.f_35373_;
            if (this.f_35373_ <= 0) {
                if (this.f_35374_) {
                    this.m_35528_();
                    this.f_35374_ = false;
                }
                this.m_7292_(new MobEffectInstance(MobEffects.f_19605_, 200, 0));
            }
        }
        if (this.f_35375_ != null && this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8670_(ReputationEventType.f_26989_, this.f_35375_, this);
            this.f_19853_.m_7605_(this, (byte)14);
            this.f_35375_ = null;
        }
        if (!this.m_21525_() && this.f_19796_.nextInt(100) == 0 && (raid = ((ServerLevel)this.f_19853_).m_8832_(this.m_142538_())) != null && raid.m_37782_() && !raid.m_37706_()) {
            this.f_19853_.m_7605_(this, (byte)42);
        }
        if (this.m_7141_().m_35571_() == VillagerProfession.f_35585_ && this.m_35306_()) {
            this.m_7996_();
        }
        super.m_8024_();
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.m_35303_() > 0) {
            this.m_35319_(this.m_35303_() - 1);
        }
        this.m_35530_();
    }

    @Override
    public InteractionResult m_6071_(Player p_35472_, InteractionHand p_35473_) {
        ItemStack itemStack = p_35472_.m_21120_(p_35473_);
        if (!itemStack.m_150930_(Items.f_42601_) && this.m_6084_() && !this.m_35306_() && !this.m_5803_()) {
            if (this.m_6162_()) {
                this.m_35518_();
                return InteractionResult.m_19078_(this.f_19853_.f_46443_);
            }
            boolean bl = this.m_6616_().isEmpty();
            if (p_35473_ == InteractionHand.MAIN_HAND) {
                if (bl && !this.f_19853_.f_46443_) {
                    this.m_35518_();
                }
                p_35472_.m_36220_(Stats.f_12940_);
            }
            if (bl) {
                return InteractionResult.m_19078_(this.f_19853_.f_46443_);
            }
            if (!this.f_19853_.f_46443_ && !this.f_35261_.isEmpty()) {
                this.m_35536_(p_35472_);
            }
            return InteractionResult.m_19078_(this.f_19853_.f_46443_);
        }
        return super.m_6071_(p_35472_, p_35473_);
    }

    private void m_35518_() {
        this.m_35319_(40);
        if (!this.f_19853_.m_5776_()) {
            this.m_5496_(SoundEvents.f_12507_, this.m_6121_(), this.m_6100_());
        }
    }

    private void m_35536_(Player p_35537_) {
        this.m_35540_(p_35537_);
        this.m_7189_(p_35537_);
        this.m_45301_(p_35537_, this.m_5446_(), this.m_7141_().m_35576_());
    }

    @Override
    public void m_7189_(@Nullable Player p_35508_) {
        boolean bl = this.m_7962_() != null && p_35508_ == null;
        super.m_7189_(p_35508_);
        if (bl) {
            this.m_7996_();
        }
    }

    @Override
    protected void m_7996_() {
        super.m_7996_();
        this.m_35519_();
    }

    private void m_35519_() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45376_();
        }
    }

    @Override
    public boolean m_7862_() {
        return true;
    }

    public void m_35510_() {
        this.m_35523_();
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45372_();
        }
        this.f_35363_ = this.f_19853_.m_46467_();
        ++this.f_35364_;
    }

    private boolean m_35520_() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            if (!merchantOffer.m_45382_()) continue;
            return true;
        }
        return false;
    }

    private boolean m_35521_() {
        return this.f_35364_ == 0 || this.f_35364_ < 2 && this.f_19853_.m_46467_() > this.f_35363_ + 2400L;
    }

    public boolean m_35511_() {
        long l = this.f_35363_ + 12000L;
        \u00e2\u02dc\u0192 = this.f_19853_.m_46467_();
        boolean \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192 > l;
        \u00e2\u02dc\u0192 = this.f_19853_.m_46468_();
        if (this.f_35365_ > 0L) {
            \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 / 24000L;
            \u00e2\u02dc\u0192 = this.f_35365_ / 24000L;
            \u00e2\u02dc\u01922 |= \u00e2\u02dc\u0192 > \u00e2\u02dc\u0192;
        }
        this.f_35365_ = \u00e2\u02dc\u0192;
        if (\u00e2\u02dc\u01922) {
            this.f_35363_ = \u00e2\u02dc\u0192;
            this.m_35531_();
        }
        return this.m_35521_() && this.m_35520_();
    }

    private void m_35522_() {
        int n = 2 - this.f_35364_;
        if (n > 0) {
            for (MerchantOffer merchantOffer : this.m_6616_()) {
                merchantOffer.m_45372_();
            }
        }
        for (int i = 0; i < n; ++i) {
            this.m_35523_();
        }
    }

    private void m_35523_() {
        for (MerchantOffer merchantOffer : this.m_6616_()) {
            merchantOffer.m_45369_();
        }
    }

    private void m_35540_(Player p_35541_) {
        int n = this.m_35532_(p_35541_);
        if (n != 0) {
            for (MerchantOffer merchantOffer : this.m_6616_()) {
                merchantOffer.m_45353_(-Mth.m_14143_((float)n * merchantOffer.m_45378_()));
            }
        }
        if (p_35541_.m_21023_(MobEffects.f_19595_)) {
            MobEffectInstance mobEffectInstance = p_35541_.m_21124_(MobEffects.f_19595_);
            int \u00e2\u02dc\u01922 = mobEffectInstance.m_19564_();
            for (MerchantOffer merchantOffer : this.m_6616_()) {
                double d = 0.3 + 0.0625 * (double)\u00e2\u02dc\u01922;
                int \u00e2\u02dc\u01923 = (int)Math.floor(d * (double)merchantOffer.m_45352_().m_41613_());
                merchantOffer.m_45353_(-Math.max(\u00e2\u02dc\u01923, 1));
            }
        }
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(f_35371_, new VillagerData(VillagerType.f_35821_, VillagerProfession.f_35585_, 1));
    }

    @Override
    public void m_7380_(CompoundTag p_35481_) {
        super.m_7380_(p_35481_);
        VillagerData.f_35550_.encodeStart((DynamicOps)NbtOps.f_128958_, (Object)this.m_7141_()).resultOrPartial(arg_0 -> ((Logger)f_19849_).error(arg_0)).ifPresent(p_35454_ -> p_35481_.m_128365_("VillagerData", (Tag)p_35454_));
        p_35481_.m_128344_("FoodLevel", this.f_35376_);
        p_35481_.m_128365_("Gossips", (Tag)this.f_35377_.m_26179_(NbtOps.f_128958_).getValue());
        p_35481_.m_128405_("Xp", this.f_35362_);
        p_35481_.m_128356_("LastRestock", this.f_35363_);
        p_35481_.m_128356_("LastGossipDecay", this.f_35361_);
        p_35481_.m_128405_("RestocksToday", this.f_35364_);
        if (this.f_35366_) {
            p_35481_.m_128379_("AssignProfessionWhenSpawned", true);
        }
    }

    @Override
    public void m_7378_(CompoundTag p_35451_) {
        Object object;
        super.m_7378_(p_35451_);
        if (p_35451_.m_128425_("VillagerData", 10)) {
            object = VillagerData.f_35550_.parse(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_35451_.m_128423_("VillagerData")));
            object.resultOrPartial(arg_0 -> ((Logger)f_19849_).error(arg_0)).ifPresent(this::m_141967_);
        }
        if (p_35451_.m_128425_("Offers", 10)) {
            this.f_35261_ = new MerchantOffers(p_35451_.m_128469_("Offers"));
        }
        if (p_35451_.m_128425_("FoodLevel", 1)) {
            this.f_35376_ = p_35451_.m_128445_("FoodLevel");
        }
        object = p_35451_.m_128437_("Gossips", 10);
        this.f_35377_.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, object));
        if (p_35451_.m_128425_("Xp", 3)) {
            this.f_35362_ = p_35451_.m_128451_("Xp");
        }
        this.f_35363_ = p_35451_.m_128454_("LastRestock");
        this.f_35361_ = p_35451_.m_128454_("LastGossipDecay");
        this.m_21553_(true);
        if (this.f_19853_ instanceof ServerLevel) {
            this.m_35483_((ServerLevel)this.f_19853_);
        }
        this.f_35364_ = p_35451_.m_128451_("RestocksToday");
        if (p_35451_.m_128441_("AssignProfessionWhenSpawned")) {
            this.f_35366_ = p_35451_.m_128471_("AssignProfessionWhenSpawned");
        }
    }

    @Override
    public boolean m_6785_(double p_35535_) {
        return false;
    }

    @Override
    @Nullable
    protected SoundEvent m_7515_() {
        if (this.m_5803_()) {
            return null;
        }
        if (this.m_35306_()) {
            return SoundEvents.f_12508_;
        }
        return SoundEvents.f_12503_;
    }

    @Override
    protected SoundEvent m_7975_(DamageSource p_35498_) {
        return SoundEvents.f_12506_;
    }

    @Override
    protected SoundEvent m_5592_() {
        return SoundEvents.f_12505_;
    }

    public void m_35512_() {
        SoundEvent soundEvent = this.m_7141_().m_35571_().m_35625_();
        if (soundEvent != null) {
            this.m_5496_(soundEvent, this.m_6121_(), this.m_6100_());
        }
    }

    @Override
    public void m_141967_(VillagerData p_35437_) {
        VillagerData villagerData = this.m_7141_();
        if (villagerData.m_35571_() != p_35437_.m_35571_()) {
            this.f_35261_ = null;
        }
        this.f_19804_.m_135381_(f_35371_, p_35437_);
    }

    @Override
    public VillagerData m_7141_() {
        return this.f_19804_.m_135370_(f_35371_);
    }

    @Override
    protected void m_8058_(MerchantOffer p_35475_) {
        int n = 3 + this.f_19796_.nextInt(4);
        this.f_35362_ += p_35475_.m_45379_();
        this.f_35375_ = this.m_7962_();
        if (this.m_35527_()) {
            this.f_35373_ = 40;
            this.f_35374_ = true;
            n += 5;
        }
        if (p_35475_.m_45383_()) {
            this.f_19853_.m_7967_(new ExperienceOrb(this.f_19853_, this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), n));
        }
    }

    public void m_150015_(boolean p_150016_) {
        this.f_150007_ = p_150016_;
    }

    public boolean m_150014_() {
        return this.f_150007_;
    }

    @Override
    public void m_6703_(@Nullable LivingEntity p_35423_) {
        if (p_35423_ != null && this.f_19853_ instanceof ServerLevel) {
            ((ServerLevel)this.f_19853_).m_8670_(ReputationEventType.f_26987_, p_35423_, this);
            if (this.m_6084_() && p_35423_ instanceof Player) {
                this.f_19853_.m_7605_(this, (byte)13);
            }
        }
        super.m_6703_(p_35423_);
    }

    @Override
    public void m_6667_(DamageSource p_35419_) {
        f_19849_.info("Villager {} died, message: '{}'", (Object)this, (Object)p_35419_.m_6157_(this).getString());
        Entity entity = p_35419_.m_7639_();
        if (entity != null) {
            this.m_35420_(entity);
        }
        this.m_35524_();
        super.m_6667_(p_35419_);
    }

    private void m_35524_() {
        this.m_35428_(MemoryModuleType.f_26359_);
        this.m_35428_(MemoryModuleType.f_26360_);
        this.m_35428_(MemoryModuleType.f_26361_);
        this.m_35428_(MemoryModuleType.f_26362_);
    }

    private void m_35420_(Entity p_35421_) {
        if (!(this.f_19853_ instanceof ServerLevel)) {
            return;
        }
        Optional<List<LivingEntity>> optional = this.f_20939_.m_21952_(MemoryModuleType.f_148205_);
        if (!optional.isPresent()) {
            return;
        }
        ServerLevel \u00e2\u02dc\u01922 = (ServerLevel)this.f_19853_;
        optional.get().stream().filter(p_35539_ -> p_35539_ instanceof ReputationEventHandler).forEach(p_35407_ -> \u00e2\u02dc\u01922.m_8670_(ReputationEventType.f_26988_, p_35421_, (ReputationEventHandler)((Object)p_35407_)));
    }

    public void m_35428_(MemoryModuleType<GlobalPos> p_35429_) {
        if (!(this.f_19853_ instanceof ServerLevel)) {
            return;
        }
        MinecraftServer minecraftServer = ((ServerLevel)this.f_19853_).m_142572_();
        this.f_20939_.m_21952_(p_35429_).ifPresent(p_35460_ -> {
            ServerLevel serverLevel = minecraftServer.m_129880_(p_35460_.m_122640_());
            if (serverLevel == null) {
                return;
            }
            PoiManager \u00e2\u02dc\u01922 = serverLevel.m_8904_();
            Optional<PoiType> \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_27177_(p_35460_.m_122646_());
            BiPredicate<Villager, PoiType> \u00e2\u02dc\u01924 = f_35370_.get(p_35429_);
            if (\u00e2\u02dc\u01923.isPresent() && \u00e2\u02dc\u01924.test(this, \u00e2\u02dc\u01923.get())) {
                \u00e2\u02dc\u01922.m_27154_(p_35460_.m_122646_());
                DebugPackets.m_133719_(serverLevel, p_35460_.m_122646_());
            }
        });
    }

    @Override
    public boolean m_142668_() {
        return this.f_35376_ + this.m_35529_() >= 12 && this.m_146764_() == 0;
    }

    private boolean m_35525_() {
        return this.f_35376_ < 12;
    }

    private void m_35526_() {
        if (!this.m_35525_() || this.m_35529_() == 0) {
            return;
        }
        for (int i = 0; i < this.m_141944_().m_6643_(); ++i) {
            ItemStack itemStack = this.m_141944_().m_8020_(i);
            if (itemStack.m_41619_() || (\u00e2\u02dc\u0192 = f_35369_.get(itemStack.m_41720_())) == null) continue;
            for (int j = \u00e2\u02dc\u0192 = itemStack.m_41613_(); j > 0; --j) {
                this.f_35376_ = (byte)(this.f_35376_ + \u00e2\u02dc\u0192);
                this.m_141944_().m_7407_(i, 1);
                if (this.m_35525_()) continue;
                return;
            }
        }
    }

    public int m_35532_(Player p_35533_) {
        return this.f_35377_.m_26195_(p_35533_.m_142081_(), p_35427_ -> true);
    }

    private void m_35548_(int p_35549_) {
        this.f_35376_ = (byte)(this.f_35376_ - p_35549_);
    }

    public void m_35513_() {
        this.m_35526_();
        this.m_35548_(12);
    }

    public void m_35476_(MerchantOffers p_35477_) {
        this.f_35261_ = p_35477_;
    }

    private boolean m_35527_() {
        int n = this.m_7141_().m_35576_();
        return VillagerData.m_35582_(n) && this.f_35362_ >= VillagerData.m_35577_(n);
    }

    private void m_35528_() {
        this.m_141967_(this.m_7141_().m_35561_(this.m_7141_().m_35576_() + 1));
        this.m_7604_();
    }

    @Override
    protected Component m_5677_() {
        return new TranslatableComponent(this.m_6095_().m_20675_() + "." + Registry.f_122869_.m_7981_(this.m_7141_().m_35571_()).m_135815_());
    }

    @Override
    public void m_7822_(byte p_35391_) {
        if (p_35391_ == 12) {
            this.m_35287_(ParticleTypes.f_123750_);
        } else if (p_35391_ == 13) {
            this.m_35287_(ParticleTypes.f_123792_);
        } else if (p_35391_ == 14) {
            this.m_35287_(ParticleTypes.f_123748_);
        } else if (p_35391_ == 42) {
            this.m_35287_(ParticleTypes.f_123769_);
        } else {
            super.m_7822_(p_35391_);
        }
    }

    @Override
    @Nullable
    public SpawnGroupData m_6518_(ServerLevelAccessor p_35439_, DifficultyInstance p_35440_, MobSpawnType p_35441_, @Nullable SpawnGroupData p_35442_, @Nullable CompoundTag p_35443_) {
        if (p_35441_ == MobSpawnType.BREEDING) {
            this.m_141967_(this.m_7141_().m_35565_(VillagerProfession.f_35585_));
        }
        if (p_35441_ == MobSpawnType.COMMAND || p_35441_ == MobSpawnType.SPAWN_EGG || p_35441_ == MobSpawnType.SPAWNER || p_35441_ == MobSpawnType.DISPENSER) {
            this.m_141967_(this.m_7141_().m_35567_(VillagerType.m_35835_(p_35439_.m_45837_(this.m_142538_()))));
        }
        if (p_35441_ == MobSpawnType.STRUCTURE) {
            this.f_35366_ = true;
        }
        return super.m_6518_(p_35439_, p_35440_, p_35441_, p_35442_, p_35443_);
    }

    @Override
    public Villager m_142606_(ServerLevel p_150012_, AgeableMob p_150013_) {
        double d = this.f_19796_.nextDouble();
        VillagerType \u00e2\u02dc\u01922 = d < 0.5 ? VillagerType.m_35835_(p_150012_.m_45837_(this.m_142538_())) : (d < 0.75 ? this.m_7141_().m_35560_() : ((Villager)p_150013_).m_7141_().m_35560_());
        Villager \u00e2\u02dc\u01923 = new Villager(EntityType.f_20492_, p_150012_, \u00e2\u02dc\u01922);
        \u00e2\u02dc\u01923.m_6518_(p_150012_, p_150012_.m_6436_(\u00e2\u02dc\u01923.m_142538_()), MobSpawnType.BREEDING, null, null);
        return \u00e2\u02dc\u01923;
    }

    @Override
    public void m_8038_(ServerLevel p_35409_, LightningBolt p_35410_) {
        if (p_35409_.m_46791_() != Difficulty.PEACEFUL) {
            f_19849_.info("Villager {} was struck by lightning {}.", (Object)this, (Object)p_35410_);
            Witch witch = EntityType.f_20495_.m_20615_(p_35409_);
            witch.m_7678_(this.m_20185_(), this.m_20186_(), this.m_20189_(), this.m_146908_(), this.m_146909_());
            witch.m_6518_(p_35409_, p_35409_.m_6436_(witch.m_142538_()), MobSpawnType.CONVERSION, null, null);
            witch.m_21557_(this.m_21525_());
            if (this.m_8077_()) {
                witch.m_6593_(this.m_7770_());
                witch.m_20340_(this.m_20151_());
            }
            witch.m_21530_();
            p_35409_.m_47205_(witch);
            this.m_35524_();
            this.m_146870_();
        } else {
            super.m_8038_(p_35409_, p_35410_);
        }
    }

    @Override
    protected void m_7581_(ItemEntity p_35467_) {
        ItemStack itemStack = p_35467_.m_32055_();
        if (this.m_7243_(itemStack)) {
            SimpleContainer simpleContainer = this.m_141944_();
            boolean \u00e2\u02dc\u01922 = simpleContainer.m_19183_(itemStack);
            if (!\u00e2\u02dc\u01922) {
                return;
            }
            this.m_21053_(p_35467_);
            this.m_7938_(p_35467_, itemStack.m_41613_());
            ItemStack \u00e2\u02dc\u01923 = simpleContainer.m_19173_(itemStack);
            if (\u00e2\u02dc\u01923.m_41619_()) {
                p_35467_.m_146870_();
            } else {
                itemStack.m_41764_(\u00e2\u02dc\u01923.m_41613_());
            }
        }
    }

    @Override
    public boolean m_7243_(ItemStack p_35543_) {
        Item item = p_35543_.m_41720_();
        return (f_35372_.contains(item) || this.m_7141_().m_35571_().m_35623_().contains((Object)item)) && this.m_141944_().m_19183_(p_35543_);
    }

    public boolean m_35514_() {
        return this.m_35529_() >= 24;
    }

    public boolean m_35515_() {
        return this.m_35529_() < 12;
    }

    private int m_35529_() {
        SimpleContainer simpleContainer = this.m_141944_();
        return f_35369_.entrySet().stream().mapToInt(p_35417_ -> simpleContainer.m_18947_((Item)p_35417_.getKey()) * (Integer)p_35417_.getValue()).sum();
    }

    public boolean m_35516_() {
        return this.m_141944_().m_18949_((Set<Item>)ImmutableSet.of((Object)Items.f_42404_, (Object)Items.f_42620_, (Object)Items.f_42619_, (Object)Items.f_42733_));
    }

    @Override
    protected void m_7604_() {
        VillagerData villagerData = this.m_7141_();
        Int2ObjectMap<VillagerTrades.ItemListing[]> \u00e2\u02dc\u01922 = VillagerTrades.f_35627_.get(villagerData.m_35571_());
        if (\u00e2\u02dc\u01922 == null || \u00e2\u02dc\u01922.isEmpty()) {
            return;
        }
        VillagerTrades.ItemListing[] \u00e2\u02dc\u01923 = (VillagerTrades.ItemListing[])\u00e2\u02dc\u01922.get(villagerData.m_35576_());
        if (\u00e2\u02dc\u01923 == null) {
            return;
        }
        MerchantOffers \u00e2\u02dc\u01924 = this.m_6616_();
        this.m_35277_(\u00e2\u02dc\u01924, \u00e2\u02dc\u01923, 2);
    }

    public void m_35411_(ServerLevel p_35412_, Villager p_35413_, long p_35414_) {
        if (p_35414_ >= this.f_35378_ && p_35414_ < this.f_35378_ + 1200L || p_35414_ >= p_35413_.f_35378_ && p_35414_ < p_35413_.f_35378_ + 1200L) {
            return;
        }
        this.f_35377_.m_26163_(p_35413_.f_35377_, this.f_19796_, 10);
        this.f_35378_ = p_35414_;
        p_35413_.f_35378_ = p_35414_;
        this.m_35397_(p_35412_, p_35414_, 5);
    }

    private void m_35530_() {
        long l = this.f_19853_.m_46467_();
        if (this.f_35361_ == 0L) {
            this.f_35361_ = l;
            return;
        }
        if (l < this.f_35361_ + 24000L) {
            return;
        }
        this.f_35377_.m_26198_();
        this.f_35361_ = l;
    }

    public void m_35397_(ServerLevel p_35398_, long p_35399_, int p_35400_) {
        if (!this.m_35392_(p_35399_)) {
            return;
        }
        AABB aABB = this.m_142469_().m_82377_(10.0, 10.0, 10.0);
        List<Villager> \u00e2\u02dc\u01922 = p_35398_.m_45976_(Villager.class, aABB);
        List \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.stream().filter(p_35396_ -> p_35396_.m_35392_(p_35399_)).limit(5L).collect(Collectors.toList());
        if (\u00e2\u02dc\u01923.size() < p_35400_) {
            return;
        }
        IronGolem \u00e2\u02dc\u01924 = this.m_35490_(p_35398_);
        if (\u00e2\u02dc\u01924 == null) {
            return;
        }
        \u00e2\u02dc\u01922.forEach(GolemSensor::m_26649_);
    }

    public boolean m_35392_(long p_35393_) {
        if (!this.m_35461_(this.f_19853_.m_46467_())) {
            return false;
        }
        return !this.f_20939_.m_21874_(MemoryModuleType.f_26327_);
    }

    @Nullable
    private IronGolem m_35490_(ServerLevel p_35491_) {
        BlockPos blockPos = this.m_142538_();
        for (int i = 0; i < 10; ++i) {
            double d = p_35491_.f_46441_.nextInt(16) - 8;
            BlockPos \u00e2\u02dc\u01922 = this.m_35446_(blockPos, d, \u00e2\u02dc\u0192 = (double)(p_35491_.f_46441_.nextInt(16) - 8));
            if (\u00e2\u02dc\u01922 == null || (\u00e2\u02dc\u0192 = EntityType.f_20460_.m_20655_(p_35491_, null, null, null, \u00e2\u02dc\u01922, MobSpawnType.MOB_SUMMONED, false, false)) == null) continue;
            if (\u00e2\u02dc\u0192.m_5545_(p_35491_, MobSpawnType.MOB_SUMMONED) && \u00e2\u02dc\u0192.m_6914_(p_35491_)) {
                p_35491_.m_47205_(\u00e2\u02dc\u0192);
                return \u00e2\u02dc\u0192;
            }
            \u00e2\u02dc\u0192.m_146870_();
        }
        return null;
    }

    @Nullable
    private BlockPos m_35446_(BlockPos p_35447_, double p_35448_, double p_35449_) {
        int n = 6;
        BlockPos \u00e2\u02dc\u01922 = p_35447_.m_142022_(p_35448_, 6.0, p_35449_);
        BlockState \u00e2\u02dc\u01923 = this.f_19853_.m_8055_(\u00e2\u02dc\u01922);
        for (\u00e2\u02dc\u0192 = 6; \u00e2\u02dc\u0192 >= -6; --\u00e2\u02dc\u0192) {
            BlockPos blockPos = \u00e2\u02dc\u01922;
            BlockState \u00e2\u02dc\u01924 = \u00e2\u02dc\u01923;
            \u00e2\u02dc\u01922 = blockPos.m_7495_();
            \u00e2\u02dc\u01923 = this.f_19853_.m_8055_(\u00e2\u02dc\u01922);
            if (!\u00e2\u02dc\u01924.m_60795_() && !\u00e2\u02dc\u01924.m_60767_().m_76332_() || !\u00e2\u02dc\u01923.m_60767_().m_76337_()) continue;
            return blockPos;
        }
        return null;
    }

    @Override
    public void m_6814_(ReputationEventType p_35431_, Entity p_35432_) {
        if (p_35431_ == ReputationEventType.f_26985_) {
            this.f_35377_.m_26191_(p_35432_.m_142081_(), GossipType.MAJOR_POSITIVE, 20);
            this.f_35377_.m_26191_(p_35432_.m_142081_(), GossipType.MINOR_POSITIVE, 25);
        } else if (p_35431_ == ReputationEventType.f_26989_) {
            this.f_35377_.m_26191_(p_35432_.m_142081_(), GossipType.TRADING, 2);
        } else if (p_35431_ == ReputationEventType.f_26987_) {
            this.f_35377_.m_26191_(p_35432_.m_142081_(), GossipType.MINOR_NEGATIVE, 25);
        } else if (p_35431_ == ReputationEventType.f_26988_) {
            this.f_35377_.m_26191_(p_35432_.m_142081_(), GossipType.MAJOR_NEGATIVE, 25);
        }
    }

    @Override
    public int m_7809_() {
        return this.f_35362_;
    }

    public void m_35546_(int p_35547_) {
        this.f_35362_ = p_35547_;
    }

    private void m_35531_() {
        this.m_35522_();
        this.f_35364_ = 0;
    }

    public GossipContainer m_35517_() {
        return this.f_35377_;
    }

    public void m_35455_(Tag p_35456_) {
        this.f_35377_.m_26177_(new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)p_35456_));
    }

    @Override
    protected void m_8025_() {
        super.m_8025_();
        DebugPackets.m_133695_(this);
    }

    @Override
    public void m_5802_(BlockPos p_35479_) {
        super.m_5802_(p_35479_);
        this.f_20939_.m_21879_(MemoryModuleType.f_26328_, this.f_19853_.m_46467_());
        this.f_20939_.m_21936_(MemoryModuleType.f_26370_);
        this.f_20939_.m_21936_(MemoryModuleType.f_26326_);
    }

    @Override
    public void m_5796_() {
        super.m_5796_();
        this.f_20939_.m_21879_(MemoryModuleType.f_26329_, this.f_19853_.m_46467_());
    }

    private boolean m_35461_(long p_35462_) {
        Optional<Long> optional = this.f_20939_.m_21952_(MemoryModuleType.f_26328_);
        if (optional.isPresent()) {
            return p_35462_ - optional.get() < 24000L;
        }
        return false;
    }

    @Override
    public /* synthetic */ AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        return this.m_142606_(serverLevel, ageableMob);
    }
}

