/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.player;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportCategory;
import net.minecraft.ReportedException;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Nameable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;

public class Inventory
implements Container,
Nameable {
    public static final int f_150064_ = 5;
    public static final int f_150065_ = 36;
    private static final int f_150070_ = 9;
    public static final int f_150066_ = 40;
    public static final int f_150067_ = -1;
    public static final int[] f_150068_ = new int[]{0, 1, 2, 3};
    public static final int[] f_150069_ = new int[]{3};
    public final NonNullList<ItemStack> f_35974_ = NonNullList.m_122780_(36, ItemStack.f_41583_);
    public final NonNullList<ItemStack> f_35975_ = NonNullList.m_122780_(4, ItemStack.f_41583_);
    public final NonNullList<ItemStack> f_35976_ = NonNullList.m_122780_(1, ItemStack.f_41583_);
    private final List<NonNullList<ItemStack>> f_35979_ = ImmutableList.of(this.f_35974_, this.f_35975_, this.f_35976_);
    public int f_35977_;
    public final Player f_35978_;
    private int f_35981_;

    public Inventory(Player p_35983_) {
        this.f_35978_ = p_35983_;
    }

    public ItemStack m_36056_() {
        if (Inventory.m_36045_(this.f_35977_)) {
            return this.f_35974_.get(this.f_35977_);
        }
        return ItemStack.f_41583_;
    }

    public static int m_36059_() {
        return 9;
    }

    private boolean m_36014_(ItemStack p_36015_, ItemStack p_36016_) {
        return !p_36015_.m_41619_() && ItemStack.m_150942_(p_36015_, p_36016_) && p_36015_.m_41753_() && p_36015_.m_41613_() < p_36015_.m_41741_() && p_36015_.m_41613_() < this.m_6893_();
    }

    public int m_36062_() {
        for (int i = 0; i < this.f_35974_.size(); ++i) {
            if (!this.f_35974_.get(i).m_41619_()) continue;
            return i;
        }
        return -1;
    }

    public void m_36012_(ItemStack p_36013_) {
        int n = this.m_36030_(p_36013_);
        if (Inventory.m_36045_(n)) {
            this.f_35977_ = n;
            return;
        }
        if (n == -1) {
            this.f_35977_ = this.m_36065_();
            if (!this.f_35974_.get(this.f_35977_).m_41619_() && (\u00e2\u02dc\u0192 = this.m_36062_()) != -1) {
                this.f_35974_.set(\u00e2\u02dc\u0192, this.f_35974_.get(this.f_35977_));
            }
            this.f_35974_.set(this.f_35977_, p_36013_);
        } else {
            this.m_36038_(n);
        }
    }

    public void m_36038_(int p_36039_) {
        this.f_35977_ = this.m_36065_();
        ItemStack itemStack = this.f_35974_.get(this.f_35977_);
        this.f_35974_.set(this.f_35977_, this.f_35974_.get(p_36039_));
        this.f_35974_.set(p_36039_, itemStack);
    }

    public static boolean m_36045_(int p_36046_) {
        return p_36046_ >= 0 && p_36046_ < 9;
    }

    public int m_36030_(ItemStack p_36031_) {
        for (int i = 0; i < this.f_35974_.size(); ++i) {
            if (this.f_35974_.get(i).m_41619_() || !ItemStack.m_150942_(p_36031_, this.f_35974_.get(i))) continue;
            return i;
        }
        return -1;
    }

    public int m_36043_(ItemStack p_36044_) {
        for (int i = 0; i < this.f_35974_.size(); ++i) {
            ItemStack itemStack = this.f_35974_.get(i);
            if (this.f_35974_.get(i).m_41619_() || !ItemStack.m_150942_(p_36044_, this.f_35974_.get(i)) || this.f_35974_.get(i).m_41768_() || itemStack.m_41793_() || itemStack.m_41788_()) continue;
            return i;
        }
        return -1;
    }

    public int m_36065_() {
        int n;
        for (n = 0; n < 9; ++n) {
            \u00e2\u02dc\u0192 = (this.f_35977_ + n) % 9;
            if (!this.f_35974_.get(\u00e2\u02dc\u0192).m_41619_()) continue;
            return \u00e2\u02dc\u0192;
        }
        for (n = 0; n < 9; ++n) {
            \u00e2\u02dc\u0192 = (this.f_35977_ + n) % 9;
            if (this.f_35974_.get(\u00e2\u02dc\u0192).m_41793_()) continue;
            return \u00e2\u02dc\u0192;
        }
        return this.f_35977_;
    }

    public void m_35988_(double p_35989_) {
        if (p_35989_ > 0.0) {
            p_35989_ = 1.0;
        }
        if (p_35989_ < 0.0) {
            p_35989_ = -1.0;
        }
        this.f_35977_ = (int)((double)this.f_35977_ - p_35989_);
        while (this.f_35977_ < 0) {
            this.f_35977_ += 9;
        }
        while (this.f_35977_ >= 9) {
            this.f_35977_ -= 9;
        }
    }

    public int m_36022_(Predicate<ItemStack> p_36023_, int p_36024_, Container p_36025_) {
        int n = 0;
        boolean \u00e2\u02dc\u01922 = p_36024_ == 0;
        n += ContainerHelper.m_18956_(this, p_36023_, p_36024_ - n, \u00e2\u02dc\u01922);
        n += ContainerHelper.m_18956_(p_36025_, p_36023_, p_36024_ - n, \u00e2\u02dc\u01922);
        ItemStack \u00e2\u02dc\u01923 = this.f_35978_.f_36096_.m_142621_();
        n += ContainerHelper.m_18961_(\u00e2\u02dc\u01923, p_36023_, p_36024_ - n, \u00e2\u02dc\u01922);
        if (\u00e2\u02dc\u01923.m_41619_()) {
            this.f_35978_.f_36096_.m_142503_(ItemStack.f_41583_);
        }
        return n;
    }

    private int m_36066_(ItemStack p_36067_) {
        int n = this.m_36050_(p_36067_);
        if (n == -1) {
            n = this.m_36062_();
        }
        if (n == -1) {
            return p_36067_.m_41613_();
        }
        return this.m_36047_(n, p_36067_);
    }

    private int m_36047_(int p_36048_, ItemStack p_36049_) {
        int n;
        Item item = p_36049_.m_41720_();
        int \u00e2\u02dc\u01922 = p_36049_.m_41613_();
        ItemStack \u00e2\u02dc\u01923 = this.m_8020_(p_36048_);
        if (\u00e2\u02dc\u01923.m_41619_()) {
            \u00e2\u02dc\u01923 = new ItemStack(item, 0);
            if (p_36049_.m_41782_()) {
                \u00e2\u02dc\u01923.m_41751_(p_36049_.m_41783_().m_6426_());
            }
            this.m_6836_(p_36048_, \u00e2\u02dc\u01923);
        }
        if ((n = \u00e2\u02dc\u01922) > \u00e2\u02dc\u01923.m_41741_() - \u00e2\u02dc\u01923.m_41613_()) {
            n = \u00e2\u02dc\u01923.m_41741_() - \u00e2\u02dc\u01923.m_41613_();
        }
        if (n > this.m_6893_() - \u00e2\u02dc\u01923.m_41613_()) {
            n = this.m_6893_() - \u00e2\u02dc\u01923.m_41613_();
        }
        if (n == 0) {
            return \u00e2\u02dc\u01922;
        }
        \u00e2\u02dc\u01923.m_41769_(n);
        \u00e2\u02dc\u01923.m_41754_(5);
        return \u00e2\u02dc\u01922 -= n;
    }

    public int m_36050_(ItemStack p_36051_) {
        if (this.m_36014_(this.m_8020_(this.f_35977_), p_36051_)) {
            return this.f_35977_;
        }
        if (this.m_36014_(this.m_8020_(40), p_36051_)) {
            return 40;
        }
        for (int i = 0; i < this.f_35974_.size(); ++i) {
            if (!this.m_36014_(this.f_35974_.get(i), p_36051_)) continue;
            return i;
        }
        return -1;
    }

    public void m_36068_() {
        for (NonNullList<ItemStack> nonNullList : this.f_35979_) {
            for (int i = 0; i < nonNullList.size(); ++i) {
                if (nonNullList.get(i).m_41619_()) continue;
                nonNullList.get(i).m_41666_(this.f_35978_.f_19853_, this.f_35978_, i, this.f_35977_ == i);
            }
        }
    }

    public boolean m_36054_(ItemStack p_36055_) {
        return this.m_36040_(-1, p_36055_);
    }

    public boolean m_36040_(int p_36041_, ItemStack p_36042_) {
        if (p_36042_.m_41619_()) {
            return false;
        }
        try {
            if (!p_36042_.m_41768_()) {
                int n;
                do {
                    n = p_36042_.m_41613_();
                    if (p_36041_ == -1) {
                        p_36042_.m_41764_(this.m_36066_(p_36042_));
                        continue;
                    }
                    p_36042_.m_41764_(this.m_36047_(p_36041_, p_36042_));
                } while (!p_36042_.m_41619_() && p_36042_.m_41613_() < n);
                if (p_36042_.m_41613_() == n && this.f_35978_.m_150110_().f_35937_) {
                    p_36042_.m_41764_(0);
                    return true;
                }
                return p_36042_.m_41613_() < n;
            }
            if (p_36041_ == -1) {
                p_36041_ = this.m_36062_();
            }
            if (p_36041_ >= 0) {
                this.f_35974_.set(p_36041_, p_36042_.m_41777_());
                this.f_35974_.get(p_36041_).m_41754_(5);
                p_36042_.m_41764_(0);
                return true;
            }
            if (this.f_35978_.m_150110_().f_35937_) {
                p_36042_.m_41764_(0);
                return true;
            }
            return false;
        }
        catch (Throwable throwable) {
            CrashReport crashReport = CrashReport.m_127521_(throwable, "Adding item to inventory");
            CrashReportCategory \u00e2\u02dc\u01922 = crashReport.m_127514_("Item being added");
            \u00e2\u02dc\u01922.m_128159_("Item ID", Item.m_41393_(p_36042_.m_41720_()));
            \u00e2\u02dc\u01922.m_128159_("Item data", p_36042_.m_41773_());
            \u00e2\u02dc\u01922.m_128165_("Item name", () -> p_36042_.m_41786_().getString());
            throw new ReportedException(crashReport);
        }
    }

    public void m_150079_(ItemStack p_150080_) {
        this.m_150076_(p_150080_, true);
    }

    public void m_150076_(ItemStack p_150077_, boolean p_150078_) {
        while (!p_150077_.m_41619_()) {
            int n = this.m_36050_(p_150077_);
            if (n == -1) {
                n = this.m_36062_();
            }
            if (n == -1) {
                this.f_35978_.m_36176_(p_150077_, false);
                break;
            }
            \u00e2\u02dc\u0192 = p_150077_.m_41741_() - this.m_8020_(n).m_41613_();
            if (!this.m_36040_(n, p_150077_.m_41620_(\u00e2\u02dc\u0192)) || !p_150078_ || !(this.f_35978_ instanceof ServerPlayer)) continue;
            ((ServerPlayer)this.f_35978_).f_8906_.m_141995_(new ClientboundContainerSetSlotPacket(-2, 0, n, this.m_8020_(n)));
        }
    }

    @Override
    public ItemStack m_7407_(int p_35993_, int p_35994_) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.f_35979_) {
            if (p_35993_ < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            p_35993_ -= nonNullList2.size();
        }
        if (nonNullList != null && !((ItemStack)nonNullList.get(p_35993_)).m_41619_()) {
            return ContainerHelper.m_18969_(nonNullList, p_35993_, p_35994_);
        }
        return ItemStack.f_41583_;
    }

    public void m_36057_(ItemStack p_36058_) {
        block0: for (NonNullList<ItemStack> nonNullList : this.f_35979_) {
            for (int i = 0; i < nonNullList.size(); ++i) {
                if (nonNullList.get(i) != p_36058_) continue;
                nonNullList.set(i, ItemStack.f_41583_);
                continue block0;
            }
        }
    }

    @Override
    public ItemStack m_8016_(int p_36029_) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.f_35979_) {
            if (p_36029_ < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            p_36029_ -= nonNullList2.size();
        }
        if (nonNullList != null && !((ItemStack)nonNullList.get(p_36029_)).m_41619_()) {
            ItemStack itemStack = nonNullList.get(p_36029_);
            nonNullList.set(p_36029_, ItemStack.f_41583_);
            return itemStack;
        }
        return ItemStack.f_41583_;
    }

    @Override
    public void m_6836_(int p_35999_, ItemStack p_36000_) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.f_35979_) {
            if (p_35999_ < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            p_35999_ -= nonNullList2.size();
        }
        if (nonNullList != null) {
            nonNullList.set(p_35999_, p_36000_);
        }
    }

    public float m_36020_(BlockState p_36021_) {
        return this.f_35974_.get(this.f_35977_).m_41691_(p_36021_);
    }

    public ListTag m_36026_(ListTag p_36027_) {
        CompoundTag compoundTag;
        int n;
        for (n = 0; n < this.f_35974_.size(); ++n) {
            if (this.f_35974_.get(n).m_41619_()) continue;
            compoundTag = new CompoundTag();
            compoundTag.m_128344_("Slot", (byte)n);
            this.f_35974_.get(n).m_41739_(compoundTag);
            p_36027_.add(compoundTag);
        }
        for (n = 0; n < this.f_35975_.size(); ++n) {
            if (this.f_35975_.get(n).m_41619_()) continue;
            compoundTag = new CompoundTag();
            compoundTag.m_128344_("Slot", (byte)(n + 100));
            this.f_35975_.get(n).m_41739_(compoundTag);
            p_36027_.add(compoundTag);
        }
        for (n = 0; n < this.f_35976_.size(); ++n) {
            if (this.f_35976_.get(n).m_41619_()) continue;
            compoundTag = new CompoundTag();
            compoundTag.m_128344_("Slot", (byte)(n + 150));
            this.f_35976_.get(n).m_41739_(compoundTag);
            p_36027_.add(compoundTag);
        }
        return p_36027_;
    }

    public void m_36035_(ListTag p_36036_) {
        this.f_35974_.clear();
        this.f_35975_.clear();
        this.f_35976_.clear();
        for (int i = 0; i < p_36036_.size(); ++i) {
            CompoundTag compoundTag = p_36036_.m_128728_(i);
            int \u00e2\u02dc\u01922 = compoundTag.m_128445_("Slot") & 0xFF;
            ItemStack \u00e2\u02dc\u01923 = ItemStack.m_41712_(compoundTag);
            if (\u00e2\u02dc\u01923.m_41619_()) continue;
            if (\u00e2\u02dc\u01922 >= 0 && \u00e2\u02dc\u01922 < this.f_35974_.size()) {
                this.f_35974_.set(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923);
                continue;
            }
            if (\u00e2\u02dc\u01922 >= 100 && \u00e2\u02dc\u01922 < this.f_35975_.size() + 100) {
                this.f_35975_.set(\u00e2\u02dc\u01922 - 100, \u00e2\u02dc\u01923);
                continue;
            }
            if (\u00e2\u02dc\u01922 < 150 || \u00e2\u02dc\u01922 >= this.f_35976_.size() + 150) continue;
            this.f_35976_.set(\u00e2\u02dc\u01922 - 150, \u00e2\u02dc\u01923);
        }
    }

    @Override
    public int m_6643_() {
        return this.f_35974_.size() + this.f_35975_.size() + this.f_35976_.size();
    }

    @Override
    public boolean m_7983_() {
        for (ItemStack itemStack : this.f_35974_) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemStack : this.f_35975_) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        for (ItemStack itemStack : this.f_35976_) {
            if (itemStack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Override
    public ItemStack m_8020_(int p_35991_) {
        NonNullList<ItemStack> nonNullList = null;
        for (NonNullList<ItemStack> nonNullList2 : this.f_35979_) {
            if (p_35991_ < nonNullList2.size()) {
                nonNullList = nonNullList2;
                break;
            }
            p_35991_ -= nonNullList2.size();
        }
        return nonNullList == null ? ItemStack.f_41583_ : (ItemStack)nonNullList.get(p_35991_);
    }

    @Override
    public Component m_7755_() {
        return new TranslatableComponent("container.inventory");
    }

    public ItemStack m_36052_(int p_36053_) {
        return this.f_35975_.get(p_36053_);
    }

    public void m_150072_(DamageSource p_150073_, float p_150074_, int[] p_150075_) {
        if (p_150074_ <= 0.0f) {
            return;
        }
        if ((p_150074_ /= 4.0f) < 1.0f) {
            p_150074_ = 1.0f;
        }
        for (int n : p_150075_) {
            ItemStack itemStack = this.f_35975_.get(n);
            if (p_150073_.m_19384_() && itemStack.m_41720_().m_41475_() || !(itemStack.m_41720_() instanceof ArmorItem)) continue;
            itemStack.m_41622_((int)p_150074_, this.f_35978_, p_35997_ -> p_35997_.m_21166_(EquipmentSlot.m_20744_(EquipmentSlot.Type.ARMOR, n)));
        }
    }

    public void m_36071_() {
        for (List list : this.f_35979_) {
            for (int i = 0; i < list.size(); ++i) {
                ItemStack itemStack = (ItemStack)list.get(i);
                if (itemStack.m_41619_()) continue;
                this.f_35978_.m_7197_(itemStack, true, false);
                list.set(i, ItemStack.f_41583_);
            }
        }
    }

    @Override
    public void m_6596_() {
        ++this.f_35981_;
    }

    public int m_36072_() {
        return this.f_35981_;
    }

    @Override
    public boolean m_6542_(Player p_36009_) {
        if (this.f_35978_.m_146910_()) {
            return false;
        }
        return !(p_36009_.m_20280_(this.f_35978_) > 64.0);
    }

    public boolean m_36063_(ItemStack p_36064_) {
        for (List list : this.f_35979_) {
            for (ItemStack itemStack : list) {
                if (itemStack.m_41619_() || !itemStack.m_41656_(p_36064_)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean m_36001_(Tag<Item> p_36002_) {
        for (List list : this.f_35979_) {
            for (ItemStack itemStack : list) {
                if (itemStack.m_41619_() || !itemStack.m_150922_(p_36002_)) continue;
                return true;
            }
        }
        return false;
    }

    public void m_36006_(Inventory p_36007_) {
        for (int i = 0; i < this.m_6643_(); ++i) {
            this.m_6836_(i, p_36007_.m_8020_(i));
        }
        this.f_35977_ = p_36007_.f_35977_;
    }

    @Override
    public void m_6211_() {
        for (List list : this.f_35979_) {
            list.clear();
        }
    }

    public void m_36010_(StackedContents p_36011_) {
        for (ItemStack itemStack : this.f_35974_) {
            p_36011_.m_36466_(itemStack);
        }
    }

    public ItemStack m_182403_(boolean p_182404_) {
        ItemStack itemStack = this.m_36056_();
        if (itemStack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        return this.m_7407_(this.f_35977_, p_182404_ ? itemStack.m_41613_() : 1);
    }
}

