/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class FireworkRocketEntity
extends Projectile
implements ItemSupplier {
    private static final EntityDataAccessor<ItemStack> f_37019_ = SynchedEntityData.m_135353_(FireworkRocketEntity.class, EntityDataSerializers.f_135033_);
    private static final EntityDataAccessor<OptionalInt> f_37020_ = SynchedEntityData.m_135353_(FireworkRocketEntity.class, EntityDataSerializers.f_135044_);
    private static final EntityDataAccessor<Boolean> f_37021_ = SynchedEntityData.m_135353_(FireworkRocketEntity.class, EntityDataSerializers.f_135035_);
    private int f_37022_;
    private int f_37023_;
    @Nullable
    private LivingEntity f_37024_;

    public FireworkRocketEntity(EntityType<? extends FireworkRocketEntity> p_37027_, Level p_37028_) {
        super((EntityType<? extends Projectile>)p_37027_, p_37028_);
    }

    public FireworkRocketEntity(Level p_37030_, double p_37031_, double p_37032_, double p_37033_, ItemStack p_37034_) {
        super((EntityType<? extends Projectile>)EntityType.f_20451_, p_37030_);
        this.f_37022_ = 0;
        this.m_6034_(p_37031_, p_37032_, p_37033_);
        int n = 1;
        if (!p_37034_.m_41619_() && p_37034_.m_41782_()) {
            this.f_19804_.m_135381_(f_37019_, p_37034_.m_41777_());
            n += p_37034_.m_41698_("Fireworks").m_128445_("Flight");
        }
        this.m_20334_(this.f_19796_.nextGaussian() * 0.001, 0.05, this.f_19796_.nextGaussian() * 0.001);
        this.f_37023_ = 10 * n + this.f_19796_.nextInt(6) + this.f_19796_.nextInt(7);
    }

    public FireworkRocketEntity(Level p_37036_, @Nullable Entity p_37037_, double p_37038_, double p_37039_, double p_37040_, ItemStack p_37041_) {
        this(p_37036_, p_37038_, p_37039_, p_37040_, p_37041_);
        this.m_5602_(p_37037_);
    }

    public FireworkRocketEntity(Level p_37058_, ItemStack p_37059_, LivingEntity p_37060_) {
        this(p_37058_, p_37060_, p_37060_.m_20185_(), p_37060_.m_20186_(), p_37060_.m_20189_(), p_37059_);
        this.f_19804_.m_135381_(f_37020_, OptionalInt.of(p_37060_.m_142049_()));
        this.f_37024_ = p_37060_;
    }

    public FireworkRocketEntity(Level p_37043_, ItemStack p_37044_, double p_37045_, double p_37046_, double p_37047_, boolean p_37048_) {
        this(p_37043_, p_37045_, p_37046_, p_37047_, p_37044_);
        this.f_19804_.m_135381_(f_37021_, p_37048_);
    }

    public FireworkRocketEntity(Level p_37050_, ItemStack p_37051_, Entity p_37052_, double p_37053_, double p_37054_, double p_37055_, boolean p_37056_) {
        this(p_37050_, p_37051_, p_37053_, p_37054_, p_37055_, p_37056_);
        this.m_5602_(p_37052_);
    }

    @Override
    protected void m_8097_() {
        this.f_19804_.m_135372_(f_37019_, ItemStack.f_41583_);
        this.f_19804_.m_135372_(f_37020_, OptionalInt.empty());
        this.f_19804_.m_135372_(f_37021_, false);
    }

    @Override
    public boolean m_6783_(double p_37065_) {
        return p_37065_ < 4096.0 && !this.m_37088_();
    }

    @Override
    public boolean m_6000_(double p_37083_, double p_37084_, double p_37085_) {
        return super.m_6000_(p_37083_, p_37084_, p_37085_) && !this.m_37088_();
    }

    @Override
    public void m_8119_() {
        Object object;
        super.m_8119_();
        if (this.m_37088_()) {
            if (this.f_37024_ == null) {
                this.f_19804_.m_135370_(f_37020_).ifPresent(p_37067_ -> {
                    Entity entity = this.f_19853_.m_6815_(p_37067_);
                    if (entity instanceof LivingEntity) {
                        this.f_37024_ = (LivingEntity)entity;
                    }
                });
            }
            if (this.f_37024_ != null) {
                if (this.f_37024_.m_21255_()) {
                    object = this.f_37024_.m_20154_();
                    double \u00e2\u02dc\u01922 = 1.5;
                    double \u00e2\u02dc\u01923 = 0.1;
                    Vec3 \u00e2\u02dc\u01924 = this.f_37024_.m_20184_();
                    this.f_37024_.m_20256_(\u00e2\u02dc\u01924.m_82520_(((Vec3)object).f_82479_ * 0.1 + (((Vec3)object).f_82479_ * 1.5 - \u00e2\u02dc\u01924.f_82479_) * 0.5, ((Vec3)object).f_82480_ * 0.1 + (((Vec3)object).f_82480_ * 1.5 - \u00e2\u02dc\u01924.f_82480_) * 0.5, ((Vec3)object).f_82481_ * 0.1 + (((Vec3)object).f_82481_ * 1.5 - \u00e2\u02dc\u01924.f_82481_) * 0.5));
                }
                this.m_6034_(this.f_37024_.m_20185_(), this.f_37024_.m_20186_(), this.f_37024_.m_20189_());
                this.m_20256_(this.f_37024_.m_20184_());
            }
        } else {
            if (!this.m_37079_()) {
                double d = this.f_19862_ ? 1.0 : 1.15;
                this.m_20256_(this.m_20184_().m_82542_(d, 1.0, d).m_82520_(0.0, 0.04, 0.0));
            }
            object = this.m_20184_();
            this.m_6478_(MoverType.SELF, (Vec3)object);
            this.m_20256_((Vec3)object);
        }
        object = ProjectileUtil.m_37294_(this, this::m_5603_);
        if (!this.f_19794_) {
            this.m_6532_((HitResult)object);
            this.f_19812_ = true;
        }
        this.m_37283_();
        if (this.f_37022_ == 0 && !this.m_20067_()) {
            this.f_19853_.m_6263_(null, this.m_20185_(), this.m_20186_(), this.m_20189_(), SoundEvents.f_11932_, SoundSource.AMBIENT, 3.0f, 1.0f);
        }
        ++this.f_37022_;
        if (this.f_19853_.f_46443_ && this.f_37022_ % 2 < 2) {
            this.f_19853_.m_7106_(ParticleTypes.f_123815_, this.m_20185_(), this.m_20186_() - 0.3, this.m_20189_(), this.f_19796_.nextGaussian() * 0.05, -this.m_20184_().f_82480_ * 0.5, this.f_19796_.nextGaussian() * 0.05);
        }
        if (!this.f_19853_.f_46443_ && this.f_37022_ > this.f_37023_) {
            this.m_37080_();
        }
    }

    private void m_37080_() {
        this.f_19853_.m_7605_(this, (byte)17);
        this.m_146852_(GameEvent.f_157812_, this.m_37282_());
        this.m_37087_();
        this.m_146870_();
    }

    @Override
    protected void m_5790_(EntityHitResult p_37071_) {
        super.m_5790_(p_37071_);
        if (this.f_19853_.f_46443_) {
            return;
        }
        this.m_37080_();
    }

    @Override
    protected void m_8060_(BlockHitResult p_37069_) {
        BlockPos blockPos = new BlockPos(p_37069_.m_82425_());
        this.f_19853_.m_8055_(blockPos).m_60682_(this.f_19853_, blockPos, this);
        if (!this.f_19853_.m_5776_() && this.m_37086_()) {
            this.m_37080_();
        }
        super.m_8060_(p_37069_);
    }

    private boolean m_37086_() {
        ItemStack itemStack = this.f_19804_.m_135370_(f_37019_);
        CompoundTag \u00e2\u02dc\u01922 = itemStack.m_41619_() ? null : itemStack.m_41737_("Fireworks");
        ListTag \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922 != null ? \u00e2\u02dc\u01922.m_128437_("Explosions", 10) : null;
        return \u00e2\u02dc\u01923 != null && !\u00e2\u02dc\u01923.isEmpty();
    }

    private void m_37087_() {
        float f = 0.0f;
        ItemStack \u00e2\u02dc\u01922 = this.f_19804_.m_135370_(f_37019_);
        CompoundTag \u00e2\u02dc\u01923 = \u00e2\u02dc\u01922.m_41619_() ? null : \u00e2\u02dc\u01922.m_41737_("Fireworks");
        ListTag listTag = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01923 != null ? \u00e2\u02dc\u01923.m_128437_("Explosions", 10) : null;
        if (\u00e2\u02dc\u0192 != null && !\u00e2\u02dc\u0192.isEmpty()) {
            f = 5.0f + (float)(\u00e2\u02dc\u0192.size() * 2);
        }
        if (f > 0.0f) {
            if (this.f_37024_ != null) {
                this.f_37024_.m_6469_(DamageSource.m_19352_(this, this.m_37282_()), 5.0f + (float)(\u00e2\u02dc\u0192.size() * 2));
            }
            double d = 5.0;
            Vec3 \u00e2\u02dc\u01924 = this.m_20182_();
            List<LivingEntity> \u00e2\u02dc\u01925 = this.f_19853_.m_45976_(LivingEntity.class, this.m_142469_().m_82400_(5.0));
            for (LivingEntity livingEntity : \u00e2\u02dc\u01925) {
                if (livingEntity == this.f_37024_ || this.m_20280_(livingEntity) > 25.0) continue;
                boolean \u00e2\u02dc\u01927 = false;
                for (int i = 0; i < 2; ++i) {
                    Vec3 vec3 = new Vec3(livingEntity.m_20185_(), livingEntity.m_20227_(0.5 * (double)i), livingEntity.m_20189_());
                    BlockHitResult \u00e2\u02dc\u01926 = this.f_19853_.m_45547_(new ClipContext(\u00e2\u02dc\u01924, vec3, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, this));
                    if (((HitResult)\u00e2\u02dc\u01926).m_6662_() != HitResult.Type.MISS) continue;
                    \u00e2\u02dc\u01927 = true;
                    break;
                }
                if (!\u00e2\u02dc\u01927) continue;
                float f2 = f * (float)Math.sqrt((5.0 - (double)this.m_20270_(livingEntity)) / 5.0);
                livingEntity.m_6469_(DamageSource.m_19352_(this, this.m_37282_()), f2);
            }
        }
    }

    private boolean m_37088_() {
        return this.f_19804_.m_135370_(f_37020_).isPresent();
    }

    public boolean m_37079_() {
        return this.f_19804_.m_135370_(f_37021_);
    }

    @Override
    public void m_7822_(byte p_37063_) {
        if (p_37063_ == 17 && this.f_19853_.f_46443_) {
            if (!this.m_37086_()) {
                for (int i = 0; i < this.f_19796_.nextInt(3) + 2; ++i) {
                    this.f_19853_.m_7106_(ParticleTypes.f_123759_, this.m_20185_(), this.m_20186_(), this.m_20189_(), this.f_19796_.nextGaussian() * 0.05, 0.005, this.f_19796_.nextGaussian() * 0.05);
                }
            } else {
                ItemStack itemStack = this.f_19804_.m_135370_(f_37019_);
                CompoundTag \u00e2\u02dc\u01922 = itemStack.m_41619_() ? null : itemStack.m_41737_("Fireworks");
                Vec3 \u00e2\u02dc\u01923 = this.m_20184_();
                this.f_19853_.m_7228_(this.m_20185_(), this.m_20186_(), this.m_20189_(), \u00e2\u02dc\u01923.f_82479_, \u00e2\u02dc\u01923.f_82480_, \u00e2\u02dc\u01923.f_82481_, \u00e2\u02dc\u01922);
            }
        }
        super.m_7822_(p_37063_);
    }

    @Override
    public void m_7380_(CompoundTag p_37075_) {
        super.m_7380_(p_37075_);
        p_37075_.m_128405_("Life", this.f_37022_);
        p_37075_.m_128405_("LifeTime", this.f_37023_);
        ItemStack itemStack = this.f_19804_.m_135370_(f_37019_);
        if (!itemStack.m_41619_()) {
            p_37075_.m_128365_("FireworksItem", itemStack.m_41739_(new CompoundTag()));
        }
        p_37075_.m_128379_("ShotAtAngle", this.f_19804_.m_135370_(f_37021_));
    }

    @Override
    public void m_7378_(CompoundTag p_37073_) {
        super.m_7378_(p_37073_);
        this.f_37022_ = p_37073_.m_128451_("Life");
        this.f_37023_ = p_37073_.m_128451_("LifeTime");
        ItemStack itemStack = ItemStack.m_41712_(p_37073_.m_128469_("FireworksItem"));
        if (!itemStack.m_41619_()) {
            this.f_19804_.m_135381_(f_37019_, itemStack);
        }
        if (p_37073_.m_128441_("ShotAtAngle")) {
            this.f_19804_.m_135381_(f_37021_, p_37073_.m_128471_("ShotAtAngle"));
        }
    }

    @Override
    public ItemStack m_7846_() {
        ItemStack itemStack = this.f_19804_.m_135370_(f_37019_);
        return itemStack.m_41619_() ? new ItemStack(Items.f_42688_) : itemStack;
    }

    @Override
    public boolean m_6097_() {
        return false;
    }
}

