/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundAddEntityPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class ShulkerBullet
extends Projectile {
    private static final double f_150183_ = 0.15;
    @Nullable
    private Entity f_37312_;
    @Nullable
    private Direction f_37313_;
    private int f_37314_;
    private double f_37315_;
    private double f_37316_;
    private double f_37317_;
    @Nullable
    private UUID f_37311_;

    public ShulkerBullet(EntityType<? extends ShulkerBullet> p_37319_, Level p_37320_) {
        super((EntityType<? extends Projectile>)p_37319_, p_37320_);
        this.f_19794_ = true;
    }

    public ShulkerBullet(Level p_37330_, LivingEntity p_37331_, Entity p_37332_, Direction.Axis p_37333_) {
        this((EntityType<? extends ShulkerBullet>)EntityType.f_20522_, p_37330_);
        this.m_5602_(p_37331_);
        BlockPos blockPos = p_37331_.m_142538_();
        double \u00e2\u02dc\u01922 = (double)blockPos.m_123341_() + 0.5;
        double \u00e2\u02dc\u01923 = (double)blockPos.m_123342_() + 0.5;
        double \u00e2\u02dc\u01924 = (double)blockPos.m_123343_() + 0.5;
        this.m_7678_(\u00e2\u02dc\u01922, \u00e2\u02dc\u01923, \u00e2\u02dc\u01924, this.m_146908_(), this.m_146909_());
        this.f_37312_ = p_37332_;
        this.f_37313_ = Direction.UP;
        this.m_37348_(p_37333_);
    }

    @Override
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    @Override
    protected void m_7380_(CompoundTag p_37357_) {
        super.m_7380_(p_37357_);
        if (this.f_37312_ != null) {
            p_37357_.m_128362_("Target", this.f_37312_.m_142081_());
        }
        if (this.f_37313_ != null) {
            p_37357_.m_128405_("Dir", this.f_37313_.m_122411_());
        }
        p_37357_.m_128405_("Steps", this.f_37314_);
        p_37357_.m_128347_("TXD", this.f_37315_);
        p_37357_.m_128347_("TYD", this.f_37316_);
        p_37357_.m_128347_("TZD", this.f_37317_);
    }

    @Override
    protected void m_7378_(CompoundTag p_37353_) {
        super.m_7378_(p_37353_);
        this.f_37314_ = p_37353_.m_128451_("Steps");
        this.f_37315_ = p_37353_.m_128459_("TXD");
        this.f_37316_ = p_37353_.m_128459_("TYD");
        this.f_37317_ = p_37353_.m_128459_("TZD");
        if (p_37353_.m_128425_("Dir", 99)) {
            this.f_37313_ = Direction.m_122376_(p_37353_.m_128451_("Dir"));
        }
        if (p_37353_.m_128403_("Target")) {
            this.f_37311_ = p_37353_.m_128342_("Target");
        }
    }

    @Override
    protected void m_8097_() {
    }

    @Nullable
    private Direction m_150186_() {
        return this.f_37313_;
    }

    private void m_37350_(@Nullable Direction p_37351_) {
        this.f_37313_ = p_37351_;
    }

    private void m_37348_(@Nullable Direction.Axis p_37349_) {
        double d;
        BlockPos \u00e2\u02dc\u01922;
        double d2 = 0.5;
        if (this.f_37312_ == null) {
            \u00e2\u02dc\u01922 = this.m_142538_().m_7495_();
        } else {
            d2 = (double)this.f_37312_.m_20206_() * 0.5;
            \u00e2\u02dc\u01922 = new BlockPos(this.f_37312_.m_20185_(), this.f_37312_.m_20186_() + d2, this.f_37312_.m_20189_());
        }
        d = (double)\u00e2\u02dc\u01922.m_123341_() + 0.5;
        \u00e2\u02dc\u0192 = (double)\u00e2\u02dc\u01922.m_123342_() + d2;
        \u00e2\u02dc\u0192 = (double)\u00e2\u02dc\u01922.m_123343_() + 0.5;
        Direction \u00e2\u02dc\u01924 = null;
        if (!\u00e2\u02dc\u01922.m_123306_(this.m_20182_(), 2.0)) {
            BlockPos blockPos = this.m_142538_();
            ArrayList \u00e2\u02dc\u01923 = Lists.newArrayList();
            if (p_37349_ != Direction.Axis.X) {
                if (blockPos.m_123341_() < \u00e2\u02dc\u01922.m_123341_() && this.f_19853_.m_46859_(blockPos.m_142126_())) {
                    \u00e2\u02dc\u01923.add(Direction.EAST);
                } else if (blockPos.m_123341_() > \u00e2\u02dc\u01922.m_123341_() && this.f_19853_.m_46859_(blockPos.m_142125_())) {
                    \u00e2\u02dc\u01923.add(Direction.WEST);
                }
            }
            if (p_37349_ != Direction.Axis.Y) {
                if (blockPos.m_123342_() < \u00e2\u02dc\u01922.m_123342_() && this.f_19853_.m_46859_(blockPos.m_7494_())) {
                    \u00e2\u02dc\u01923.add(Direction.UP);
                } else if (blockPos.m_123342_() > \u00e2\u02dc\u01922.m_123342_() && this.f_19853_.m_46859_(blockPos.m_7495_())) {
                    \u00e2\u02dc\u01923.add(Direction.DOWN);
                }
            }
            if (p_37349_ != Direction.Axis.Z) {
                if (blockPos.m_123343_() < \u00e2\u02dc\u01922.m_123343_() && this.f_19853_.m_46859_(blockPos.m_142128_())) {
                    \u00e2\u02dc\u01923.add(Direction.SOUTH);
                } else if (blockPos.m_123343_() > \u00e2\u02dc\u01922.m_123343_() && this.f_19853_.m_46859_(blockPos.m_142127_())) {
                    \u00e2\u02dc\u01923.add(Direction.NORTH);
                }
            }
            \u00e2\u02dc\u01924 = Direction.m_122404_(this.f_19796_);
            if (\u00e2\u02dc\u01923.isEmpty()) {
                for (int i = 5; !this.f_19853_.m_46859_(blockPos.m_142300_(\u00e2\u02dc\u01924)) && i > 0; --i) {
                    \u00e2\u02dc\u01924 = Direction.m_122404_(this.f_19796_);
                }
            } else {
                \u00e2\u02dc\u01924 = (Direction)\u00e2\u02dc\u01923.get(this.f_19796_.nextInt(\u00e2\u02dc\u01923.size()));
            }
            d = this.m_20185_() + (double)\u00e2\u02dc\u01924.m_122429_();
            \u00e2\u02dc\u0192 = this.m_20186_() + (double)\u00e2\u02dc\u01924.m_122430_();
            \u00e2\u02dc\u0192 = this.m_20189_() + (double)\u00e2\u02dc\u01924.m_122431_();
        }
        this.m_37350_(\u00e2\u02dc\u01924);
        \u00e2\u02dc\u0192 = d - this.m_20185_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - this.m_20186_();
        \u00e2\u02dc\u0192 = \u00e2\u02dc\u0192 - this.m_20189_();
        \u00e2\u02dc\u0192 = Math.sqrt(\u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192 + \u00e2\u02dc\u0192 * \u00e2\u02dc\u0192);
        if (\u00e2\u02dc\u0192 == 0.0) {
            this.f_37315_ = 0.0;
            this.f_37316_ = 0.0;
            this.f_37317_ = 0.0;
        } else {
            this.f_37315_ = \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192 * 0.15;
            this.f_37316_ = \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192 * 0.15;
            this.f_37317_ = \u00e2\u02dc\u0192 / \u00e2\u02dc\u0192 * 0.15;
        }
        this.f_19812_ = true;
        this.f_37314_ = 10 + this.f_19796_.nextInt(5) * 10;
    }

    @Override
    public void m_6043_() {
        if (this.f_19853_.m_46791_() == Difficulty.PEACEFUL) {
            this.m_146870_();
        }
    }

    @Override
    public void m_8119_() {
        Object object;
        super.m_8119_();
        if (!this.f_19853_.f_46443_) {
            if (this.f_37312_ == null && this.f_37311_ != null) {
                this.f_37312_ = ((ServerLevel)this.f_19853_).m_8791_(this.f_37311_);
                if (this.f_37312_ == null) {
                    this.f_37311_ = null;
                }
            }
            if (!(this.f_37312_ == null || !this.f_37312_.m_6084_() || this.f_37312_ instanceof Player && this.f_37312_.m_5833_())) {
                this.f_37315_ = Mth.m_14008_(this.f_37315_ * 1.025, -1.0, 1.0);
                this.f_37316_ = Mth.m_14008_(this.f_37316_ * 1.025, -1.0, 1.0);
                this.f_37317_ = Mth.m_14008_(this.f_37317_ * 1.025, -1.0, 1.0);
                object = this.m_20184_();
                this.m_20256_(((Vec3)object).m_82520_((this.f_37315_ - ((Vec3)object).f_82479_) * 0.2, (this.f_37316_ - ((Vec3)object).f_82480_) * 0.2, (this.f_37317_ - ((Vec3)object).f_82481_) * 0.2));
            } else if (!this.m_20068_()) {
                this.m_20256_(this.m_20184_().m_82520_(0.0, -0.04, 0.0));
            }
            object = ProjectileUtil.m_37294_(this, this::m_5603_);
            if (((HitResult)object).m_6662_() != HitResult.Type.MISS) {
                this.m_6532_((HitResult)object);
            }
        }
        this.m_20101_();
        object = this.m_20184_();
        this.m_6034_(this.m_20185_() + ((Vec3)object).f_82479_, this.m_20186_() + ((Vec3)object).f_82480_, this.m_20189_() + ((Vec3)object).f_82481_);
        ProjectileUtil.m_37284_(this, 0.5f);
        if (this.f_19853_.f_46443_) {
            this.f_19853_.m_7106_(ParticleTypes.f_123810_, this.m_20185_() - ((Vec3)object).f_82479_, this.m_20186_() - ((Vec3)object).f_82480_ + 0.15, this.m_20189_() - ((Vec3)object).f_82481_, 0.0, 0.0, 0.0);
        } else if (this.f_37312_ != null && !this.f_37312_.m_146910_()) {
            if (this.f_37314_ > 0) {
                --this.f_37314_;
                if (this.f_37314_ == 0) {
                    this.m_37348_(this.f_37313_ == null ? null : this.f_37313_.m_122434_());
                }
            }
            if (this.f_37313_ != null) {
                BlockPos blockPos = this.m_142538_();
                Direction.Axis \u00e2\u02dc\u01922 = this.f_37313_.m_122434_();
                if (this.f_19853_.m_46575_(blockPos.m_142300_(this.f_37313_), this)) {
                    this.m_37348_(\u00e2\u02dc\u01922);
                } else {
                    \u00e2\u02dc\u0192 = this.f_37312_.m_142538_();
                    if (\u00e2\u02dc\u01922 == Direction.Axis.X && blockPos.m_123341_() == \u00e2\u02dc\u0192.m_123341_() || \u00e2\u02dc\u01922 == Direction.Axis.Z && blockPos.m_123343_() == \u00e2\u02dc\u0192.m_123343_() || \u00e2\u02dc\u01922 == Direction.Axis.Y && blockPos.m_123342_() == \u00e2\u02dc\u0192.m_123342_()) {
                        this.m_37348_(\u00e2\u02dc\u01922);
                    }
                }
            }
        }
    }

    @Override
    protected boolean m_5603_(Entity p_37341_) {
        return super.m_5603_(p_37341_) && !p_37341_.f_19794_;
    }

    @Override
    public boolean m_6060_() {
        return false;
    }

    @Override
    public boolean m_6783_(double p_37336_) {
        return p_37336_ < 16384.0;
    }

    @Override
    public float m_6073_() {
        return 1.0f;
    }

    @Override
    protected void m_5790_(EntityHitResult p_37345_) {
        super.m_5790_(p_37345_);
        Entity entity = p_37345_.m_82443_();
        \u00e2\u02dc\u0192 = this.m_37282_();
        LivingEntity \u00e2\u02dc\u01922 = \u00e2\u02dc\u0192 instanceof LivingEntity ? (LivingEntity)\u00e2\u02dc\u0192 : null;
        boolean \u00e2\u02dc\u01923 = entity.m_6469_(DamageSource.m_19340_(this, \u00e2\u02dc\u01922).m_19366_(), 4.0f);
        if (\u00e2\u02dc\u01923) {
            this.m_19970_(\u00e2\u02dc\u01922, entity);
            if (entity instanceof LivingEntity) {
                ((LivingEntity)entity).m_147207_(new MobEffectInstance(MobEffects.f_19620_, 200), (Entity)MoreObjects.firstNonNull((Object)\u00e2\u02dc\u0192, (Object)this));
            }
        }
    }

    @Override
    protected void m_8060_(BlockHitResult p_37343_) {
        super.m_8060_(p_37343_);
        ((ServerLevel)this.f_19853_).m_8767_(ParticleTypes.f_123813_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 2, 0.2, 0.2, 0.2, 0.0);
        this.m_5496_(SoundEvents.f_12410_, 1.0f, 1.0f);
    }

    @Override
    protected void m_6532_(HitResult p_37347_) {
        super.m_6532_(p_37347_);
        this.m_146870_();
    }

    @Override
    public boolean m_6087_() {
        return true;
    }

    @Override
    public boolean m_6469_(DamageSource p_37338_, float p_37339_) {
        if (!this.f_19853_.f_46443_) {
            this.m_5496_(SoundEvents.f_12411_, 1.0f, 1.0f);
            ((ServerLevel)this.f_19853_).m_8767_(ParticleTypes.f_123797_, this.m_20185_(), this.m_20186_(), this.m_20189_(), 15, 0.2, 0.2, 0.2, 0.0);
            this.m_146870_();
        }
        return true;
    }

    @Override
    public void m_141965_(ClientboundAddEntityPacket p_150185_) {
        super.m_141965_(p_150185_);
        double d = p_150185_.m_131503_();
        \u00e2\u02dc\u0192 = p_150185_.m_131504_();
        \u00e2\u02dc\u0192 = p_150185_.m_131505_();
        this.m_20334_(d, \u00e2\u02dc\u0192, \u00e2\u02dc\u0192);
    }
}

