/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.entity.projectile;

import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.axolotl.Axolotl;
import net.minecraft.world.entity.projectile.ItemSupplier;
import net.minecraft.world.entity.projectile.ThrowableItemProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AbstractCandleBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class ThrownPotion
extends ThrowableItemProjectile
implements ItemSupplier {
    public static final double f_150190_ = 4.0;
    private static final double f_150191_ = 16.0;
    public static final Predicate<LivingEntity> f_37524_ = LivingEntity::m_6126_;

    public ThrownPotion(EntityType<? extends ThrownPotion> p_37527_, Level p_37528_) {
        super((EntityType<? extends ThrowableItemProjectile>)p_37527_, p_37528_);
    }

    public ThrownPotion(Level p_37535_, LivingEntity p_37536_) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.f_20486_, p_37536_, p_37535_);
    }

    public ThrownPotion(Level p_37530_, double p_37531_, double p_37532_, double p_37533_) {
        super((EntityType<? extends ThrowableItemProjectile>)EntityType.f_20486_, p_37531_, p_37532_, p_37533_, p_37530_);
    }

    @Override
    protected Item m_7881_() {
        return Items.f_42736_;
    }

    @Override
    protected float m_7139_() {
        return 0.05f;
    }

    @Override
    protected void m_8060_(BlockHitResult p_37541_) {
        super.m_8060_(p_37541_);
        if (this.f_19853_.f_46443_) {
            return;
        }
        ItemStack itemStack = this.m_7846_();
        Potion \u00e2\u02dc\u01922 = PotionUtils.m_43579_(itemStack);
        List<MobEffectInstance> \u00e2\u02dc\u01923 = PotionUtils.m_43547_(itemStack);
        boolean \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922 == Potions.f_43599_ && \u00e2\u02dc\u01923.isEmpty();
        Direction \u00e2\u02dc\u01925 = p_37541_.m_82434_();
        BlockPos \u00e2\u02dc\u01926 = p_37541_.m_82425_();
        BlockPos \u00e2\u02dc\u01927 = \u00e2\u02dc\u01926.m_142300_(\u00e2\u02dc\u01925);
        if (\u00e2\u02dc\u01924) {
            this.m_150192_(\u00e2\u02dc\u01927);
            this.m_150192_(\u00e2\u02dc\u01927.m_142300_(\u00e2\u02dc\u01925.m_122424_()));
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                this.m_150192_(\u00e2\u02dc\u01927.m_142300_(direction));
            }
        }
    }

    @Override
    protected void m_6532_(HitResult p_37543_) {
        super.m_6532_(p_37543_);
        if (this.f_19853_.f_46443_) {
            return;
        }
        ItemStack itemStack = this.m_7846_();
        Potion \u00e2\u02dc\u01922 = PotionUtils.m_43579_(itemStack);
        List<MobEffectInstance> \u00e2\u02dc\u01923 = PotionUtils.m_43547_(itemStack);
        boolean bl = \u00e2\u02dc\u0192 = \u00e2\u02dc\u01922 == Potions.f_43599_ && \u00e2\u02dc\u01923.isEmpty();
        if (\u00e2\u02dc\u0192) {
            this.m_37552_();
        } else if (!\u00e2\u02dc\u01923.isEmpty()) {
            if (this.m_37553_()) {
                this.m_37537_(itemStack, \u00e2\u02dc\u01922);
            } else {
                this.m_37547_(\u00e2\u02dc\u01923, p_37543_.m_6662_() == HitResult.Type.ENTITY ? ((EntityHitResult)p_37543_).m_82443_() : null);
            }
        }
        int \u00e2\u02dc\u01924 = \u00e2\u02dc\u01922.m_43491_() ? 2007 : 2002;
        this.f_19853_.m_46796_(\u00e2\u02dc\u01924, this.m_142538_(), PotionUtils.m_43575_(itemStack));
        this.m_146870_();
    }

    private void m_37552_() {
        AABB aABB = this.m_142469_().m_82377_(4.0, 2.0, 4.0);
        List<LivingEntity> \u00e2\u02dc\u01922 = this.f_19853_.m_6443_(LivingEntity.class, aABB, f_37524_);
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            for (LivingEntity livingEntity : \u00e2\u02dc\u01922) {
                double d = this.m_20280_(livingEntity);
                if (!(d < 16.0) || !livingEntity.m_6126_()) continue;
                livingEntity.m_6469_(DamageSource.m_19367_(livingEntity, this.m_37282_()), 1.0f);
            }
        }
        List<Axolotl> \u00e2\u02dc\u01923 = this.f_19853_.m_45976_(Axolotl.class, aABB);
        for (Axolotl axolotl : \u00e2\u02dc\u01923) {
            axolotl.m_149177_();
        }
    }

    private void m_37547_(List<MobEffectInstance> p_37548_, @Nullable Entity p_37549_) {
        AABB aABB = this.m_142469_().m_82377_(4.0, 2.0, 4.0);
        List<LivingEntity> \u00e2\u02dc\u01922 = this.f_19853_.m_45976_(LivingEntity.class, aABB);
        if (!\u00e2\u02dc\u01922.isEmpty()) {
            Entity entity = this.m_150173_();
            for (LivingEntity livingEntity : \u00e2\u02dc\u01922) {
                if (!livingEntity.m_5801_() || !((\u00e2\u02dc\u0192 = this.m_20280_(livingEntity)) < 16.0)) continue;
                double d = 1.0 - Math.sqrt(\u00e2\u02dc\u0192) / 4.0;
                if (livingEntity == p_37549_) {
                    d = 1.0;
                }
                for (MobEffectInstance mobEffectInstance : p_37548_) {
                    MobEffect mobEffect = mobEffectInstance.m_19544_();
                    if (mobEffect.m_8093_()) {
                        mobEffect.m_19461_(this, this.m_37282_(), livingEntity, mobEffectInstance.m_19564_(), d);
                        continue;
                    }
                    int \u00e2\u02dc\u01923 = (int)(d * (double)mobEffectInstance.m_19557_() + 0.5);
                    if (\u00e2\u02dc\u01923 <= 20) continue;
                    livingEntity.m_147207_(new MobEffectInstance(mobEffect, \u00e2\u02dc\u01923, mobEffectInstance.m_19564_(), mobEffectInstance.m_19571_(), mobEffectInstance.m_19572_()), entity);
                }
            }
        }
    }

    private void m_37537_(ItemStack p_37538_, Potion p_37539_) {
        AreaEffectCloud areaEffectCloud = new AreaEffectCloud(this.f_19853_, this.m_20185_(), this.m_20186_(), this.m_20189_());
        Entity \u00e2\u02dc\u01922 = this.m_37282_();
        if (\u00e2\u02dc\u01922 instanceof LivingEntity) {
            areaEffectCloud.m_19718_((LivingEntity)\u00e2\u02dc\u01922);
        }
        areaEffectCloud.m_19712_(3.0f);
        areaEffectCloud.m_19732_(-0.5f);
        areaEffectCloud.m_19740_(10);
        areaEffectCloud.m_19738_(-areaEffectCloud.m_19743_() / (float)areaEffectCloud.m_19748_());
        areaEffectCloud.m_19722_(p_37539_);
        for (MobEffectInstance mobEffectInstance : PotionUtils.m_43571_(p_37538_)) {
            areaEffectCloud.m_19716_(new MobEffectInstance(mobEffectInstance));
        }
        CompoundTag compoundTag = p_37538_.m_41783_();
        if (compoundTag != null && compoundTag.m_128425_("CustomPotionColor", 99)) {
            areaEffectCloud.m_19714_(compoundTag.m_128451_("CustomPotionColor"));
        }
        this.f_19853_.m_7967_(areaEffectCloud);
    }

    private boolean m_37553_() {
        return this.m_7846_().m_150930_(Items.f_42739_);
    }

    private void m_150192_(BlockPos p_150193_) {
        BlockState blockState = this.f_19853_.m_8055_(p_150193_);
        if (blockState.m_60620_(BlockTags.f_13076_)) {
            this.f_19853_.m_7471_(p_150193_, false);
        } else if (AbstractCandleBlock.m_151933_(blockState)) {
            AbstractCandleBlock.m_151899_(null, blockState, this.f_19853_, p_150193_);
        } else if (CampfireBlock.m_51319_(blockState)) {
            this.f_19853_.m_5898_(null, 1009, p_150193_, 0);
            CampfireBlock.m_152749_(this.m_37282_(), this.f_19853_, p_150193_, blockState);
            this.f_19853_.m_46597_(p_150193_, (BlockState)blockState.m_61124_(CampfireBlock.f_51227_, false));
        }
    }
}

